/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.snmp.SessionInfoCommString;
import org.eclipse.aperi.snmp.SnmpSession;
import org.eclipse.aperi.snmp.SnmpSocketException;
import org.eclipse.aperi.snmp.SnmpUnknownHostException;
import org.eclipse.aperi.snmp.SnmpV1API;
import org.eclipse.aperi.snmp.data.OctetString;

public class SnmpSessionFactory {
    public static final String versionLabel = "snmpVersion";
    public static final String readCommLabel = "readComm";
    public static final String writeCommLabel = "writeComm";
    public static final String retriesLabel = "retries";
    public static final String timeoutLabel = "timeout";
    public static final String portLabel = "port";
    public static final String pollingLabel = "polling";
    public static final String backupAddressesLabel = "backupAddresses";
    public static final String engineIdLabel = "engineId";
    public static final String userNameLabel = "userName";
    public static final String passwordLabel = "password";
    public static final String authKeyLabel = "authKey";
    public static final String privKeyLabel = "privKey";
    public static final String authProtoLabel = "authProto";
    public static final String privProtoLabel = "privProto";
    public static final String maxMsgSizeLabel = "maxMsgSize";
    public static final String PARAMETERS_FILE_NAME = "snmpParameters";
    private static Hashtable sessions = new Hashtable();

    protected static Hashtable getSessions() {
        return sessions;
    }

    public static void main(String[] args) {
        Map res = null;
        if (args.length != 1) {
            System.err.println("Usage: java SnmpSessionFactory <hostname>");
            return;
        }
        res = SnmpSessionFactory.getConfigInfo(args[0]);
        System.out.println(res.toString());
    }

    public static Map getConfigInfo(String hostname) {
        return SnmpV1API.getConfig().getConfigInfo(hostname);
    }

    public static SnmpSession makeSession(String hostname) throws SnmpSocketException, SnmpUnknownHostException, Exception {
        return (SnmpSession)SnmpSessionFactory.makeSession(hostname, -1, null, null, null, false);
    }

    public static SnmpSession makeSession(String hostname, int portNumber, String readCommunityName, String writeCommunityName) throws SnmpSocketException, SnmpUnknownHostException, Exception {
        return (SnmpSession)SnmpSessionFactory.makeSession(hostname, portNumber, readCommunityName, writeCommunityName, null, false);
    }

    public static SnmpSession makeSession(String hostname, int portNumber, String readCommunityName, String writeCommunityName, Object sessionUser) throws SnmpSocketException, SnmpUnknownHostException, Exception {
        return (SnmpSession)SnmpSessionFactory.makeSession(hostname, portNumber, readCommunityName, writeCommunityName, null, false);
    }

    public static Object makeSession(String hostname, int portNumber, String readCommunityName, String writeCommunityName, Object sessionUser, boolean returnKeyOnly) throws SnmpSocketException, SnmpUnknownHostException, Exception {
        String oldWrite;
        HashMap persist;
        SnmpSession session = null;
        try {
            persist = SnmpSessionFactory.getConfigInfo(hostname);
        }
        catch (Throwable t) {
            persist = new HashMap();
        }
        String val = null;
        String snmpVersion = (String)persist.get(versionLabel);
        String oldRead = (String)persist.get("readCommName");
        if (oldRead == null) {
            oldRead = "public";
        }
        if ((oldWrite = (String)persist.get("writeCommName")) == null) {
            oldWrite = "public";
        }
        int retries = (val = (String)persist.get(retriesLabel)) == null ? 3 : Integer.parseInt(val);
        val = (String)persist.get(timeoutLabel);
        int timeout = val == null ? 1000 : Integer.parseInt(val);
        val = (String)persist.get(portLabel);
        int port = val == null ? 161 : Integer.parseInt(val);
        String backupAddresses = (String)persist.get("backupAddrs");
        String readCommToUse = readCommunityName;
        String writeCommToUse = writeCommunityName;
        if (readCommunityName == null) {
            readCommToUse = readCommunityName = oldRead;
        }
        if (writeCommunityName == null) {
            writeCommToUse = writeCommunityName = oldWrite;
        }
        if (portNumber == -1) {
            portNumber = port;
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("SnmpSessionFactory: starting a session");
        }
        if (SnmpV1API.isTracing()) {
            SnmpV1API.trace("SnmpSessionFactory: starting a session -- V1");
        }
        StringBuffer keyBuf = new StringBuffer(hostname);
        keyBuf.append(retries);
        keyBuf.append(timeout);
        keyBuf.append(portNumber);
        keyBuf.append(readCommToUse.toString());
        keyBuf.append(writeCommToUse.toString());
        String key = keyBuf.toString();
        session = (SnmpSession)sessions.get(key);
        if (session != null) {
            ++session.useCount;
        } else {
            if (readCommToUse instanceof String && writeCommToUse instanceof String) {
                session = SnmpSession.open(hostname, readCommToUse, writeCommToUse, retries, timeout, portNumber);
            } else if (readCommToUse instanceof OctetString && writeCommToUse instanceof OctetString) {
                session = SnmpSession.open(hostname, (OctetString)((Object)readCommToUse), (OctetString)((Object)writeCommToUse), retries, timeout, portNumber);
            } else if (readCommToUse instanceof String && writeCommToUse instanceof OctetString) {
                session = SnmpSession.open(hostname, new OctetString(readCommToUse, true), (OctetString)((Object)writeCommToUse), retries, timeout, portNumber);
            } else if (readCommToUse instanceof OctetString && writeCommToUse instanceof String) {
                session = SnmpSession.open(hostname, (OctetString)((Object)readCommToUse), new OctetString(writeCommToUse, true), retries, timeout, portNumber);
            }
            ++session.useCount;
            sessions.put(key, session);
        }
        if (snmpVersion != null && "V2".equalsIgnoreCase(snmpVersion)) {
            session.setVersion(2);
        }
        if (backupAddresses != null) {
            session.addBackupAddresses(backupAddresses);
        }
        if (returnKeyOnly) {
            return key;
        }
        return session;
    }

    public static SnmpSession getSession(String id) {
        return (SnmpSession)sessions.get(id);
    }

    public static void closeSession(String id) {
        SnmpSession session = (SnmpSession)sessions.get(id);
        if (session != null) {
            --session.useCount;
            if (session.useCount <= 0) {
                session = (SnmpSession)sessions.remove(id);
                session.close();
            }
        }
    }

    public static void closeSession(SnmpSession sess) {
        String key = null;
        SnmpSession session = null;
        StringBuffer keyBuf = new StringBuffer(sess.primaryAddress);
        keyBuf.append(sess.retries);
        keyBuf.append(sess.timeout);
        keyBuf.append(sess.remotePort);
        keyBuf.append(((SessionInfoCommString)sess.securityInfo).get_getCommunityName());
        keyBuf.append(((SessionInfoCommString)sess.securityInfo).get_setCommunityName());
        key = keyBuf.toString();
        session = (SnmpSession)sessions.get(key);
        if (session != null) {
            --session.useCount;
            if (session.useCount <= 0) {
                session = (SnmpSession)sessions.remove(key);
            }
        }
        if (session != null && session.useCount <= 0) {
            session.close();
        }
    }
}

