/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import java.util.Observable;
import org.eclipse.aperi.snmp.BasicSnmpStats;
import org.eclipse.aperi.snmp.FullSnmpStats;

public class SnmpStatistics
extends Observable {
    private int numSends;
    private int numRecvs;
    private int numRetries;
    private int numTimeouts;
    private int numVbSent;
    private int numVbRecv;
    private int minRspTime = 10000000;
    private int maxRspTime;
    private long totalRspTime;
    private long lastUsed = System.currentTimeMillis();

    public final synchronized void incrSends(int numVarbinds) {
        ++this.numSends;
        this.numVbSent += numVarbinds;
        if (this.countObservers() > 0) {
            this.tellObservers();
        }
    }

    public final synchronized void incrReceives(int elapsedTime, int numVarBinds) {
        ++this.numRecvs;
        this.numVbRecv += numVarBinds;
        this.totalRspTime += (long)elapsedTime;
        if (elapsedTime < this.minRspTime) {
            this.minRspTime = elapsedTime;
        }
        if (elapsedTime > this.maxRspTime) {
            this.maxRspTime = elapsedTime;
        }
        if (this.countObservers() > 0) {
            this.tellObservers();
        }
    }

    private final synchronized void tellObservers() {
        this.setChanged();
        this.notifyObservers(new BasicSnmpStats(this.numSends, this.numRecvs));
        this.clearChanged();
    }

    public final synchronized void incrRetries() {
        ++this.numRetries;
    }

    public final synchronized void incrTimeouts() {
        ++this.numTimeouts;
    }

    public final synchronized void setLastUsed(long time) {
        this.lastUsed = time;
    }

    public final synchronized long getLastUsed() {
        return this.lastUsed;
    }

    public final synchronized FullSnmpStats getStats() {
        return new FullSnmpStats(this.numSends, this.numRecvs, this.numRetries, this.numTimeouts, this.numVbSent, this.numVbRecv, this.minRspTime, this.maxRspTime, this.totalRspTime);
    }
}

