/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.eclipse.aperi.snmp.data.IPAddress;
import org.eclipse.aperi.snmp.data.OctetString;

public class OID
implements Serializable,
Comparable {
    public long[] value;
    private int berLength = -1;

    public OID(int[] oidValue) {
        int oidlen = oidValue.length;
        this.value = new long[oidlen];
        for (int i = 0; i < oidlen; ++i) {
            this.value[i] = oidValue[i];
        }
    }

    public OID(long[] oidValue) {
        this(oidValue, false);
    }

    public OID(OID oid) {
        this.value = new long[oid.value.length];
        System.arraycopy(oid.value, 0, this.value, 0, oid.value.length);
    }

    public OID(int[] oidValue, int oidlen) {
        this.value = new long[oidlen];
        for (int i = 0; i < oidlen; ++i) {
            this.value[i] = oidValue[i];
        }
    }

    public OID(long[] oidValue, int oidlen) {
        this.value = new long[oidlen];
        System.arraycopy(oidValue, 0, this.value, 0, oidlen);
    }

    public OID(long[] oidValue, boolean doNotCopyArray) {
        if (doNotCopyArray) {
            this.value = oidValue;
        } else {
            this.value = new long[oidValue.length];
            System.arraycopy(oidValue, 0, this.value, 0, oidValue.length);
        }
    }

    public OID(String oidValue) {
        StringTokenizer strtok = new StringTokenizer(oidValue, ".");
        int numtokens = strtok.countTokens();
        this.value = new long[numtokens];
        for (int i = 0; i < numtokens; ++i) {
            this.value[i] = Long.parseLong(strtok.nextToken());
        }
    }

    public int getBERlength() {
        if (this.berLength == -1) {
            this.berLength = 1;
            int limit = this.value.length;
            for (int i = 2; i < limit; ++i) {
                long val = this.value[i];
                if (val < 0L) {
                    this.berLength += 9;
                    continue;
                }
                if (val < 128L) {
                    ++this.berLength;
                    continue;
                }
                if (val < 16384L) {
                    this.berLength += 2;
                    continue;
                }
                if (val < 0x200000L) {
                    this.berLength += 3;
                    continue;
                }
                if (val < 0x10000000L) {
                    this.berLength += 4;
                    continue;
                }
                if (val < 0x800000000L) {
                    this.berLength += 5;
                    continue;
                }
                if (val < 0x40000000000L) {
                    this.berLength += 6;
                    continue;
                }
                if (val < 0x2000000000000L) {
                    this.berLength += 7;
                    continue;
                }
                if (val < 0x100000000000000L) {
                    this.berLength += 8;
                    continue;
                }
                this.berLength += 9;
            }
            return this.berLength;
        }
        return this.berLength;
    }

    public OID concatenate(int suffix) {
        int limit = this.value.length;
        long[] newVals = new long[limit + 1];
        for (int i = 0; i < limit; ++i) {
            newVals[i] = this.value[i];
        }
        newVals[i] = suffix;
        OID newOID = new OID(newVals, true);
        return newOID;
    }

    public OID concatenate(long suffix) {
        int limit = this.value.length;
        long[] newVals = new long[limit + 1];
        for (int i = 0; i < limit; ++i) {
            newVals[i] = this.value[i];
        }
        newVals[i] = suffix;
        OID newOID = new OID(newVals, true);
        return newOID;
    }

    public OID concatenate(String suffix, boolean addLength) {
        int i;
        int limit = this.value.length;
        int limit2 = suffix.length();
        long[] newVals = addLength ? new long[limit + 1 + limit2] : new long[limit + limit2];
        for (i = 0; i < limit; ++i) {
            newVals[i] = this.value[i];
        }
        if (addLength) {
            newVals[i++] = limit2;
        }
        for (int j = 0; j < limit2; ++j) {
            newVals[i] = suffix.charAt(j);
            ++i;
        }
        OID newOID = new OID(newVals, true);
        return newOID;
    }

    public OID concatenate(OctetString suffix, boolean addLength) {
        int i;
        int limit = this.value.length;
        int limit2 = suffix.value.length;
        long[] newVals = addLength ? new long[limit + 1 + limit2] : new long[limit + limit2];
        for (i = 0; i < limit; ++i) {
            newVals[i] = this.value[i];
        }
        if (addLength) {
            newVals[i++] = limit2;
        }
        for (int j = 0; j < limit2; ++j) {
            newVals[i] = (long)suffix.value[j] & 0xFFL;
            ++i;
        }
        OID newOID = new OID(newVals, true);
        return newOID;
    }

    public OID concatenate(IPAddress suffix) {
        int i;
        int limit = this.value.length;
        byte[] bytes = suffix.getBytes();
        int limit2 = bytes.length;
        long[] newVals = new long[limit + limit2];
        for (i = 0; i < limit; ++i) {
            newVals[i] = this.value[i];
        }
        for (int j = 0; j < limit2; ++j) {
            newVals[i] = (long)bytes[j] & 0xFFL;
            ++i;
        }
        OID newOID = new OID(newVals, true);
        return newOID;
    }

    public OID concatenate(OID newOID) {
        return this.concatenate(newOID.value);
    }

    public OID concatenate(int[] suffix) {
        if (suffix == null) {
            return this;
        }
        int limit = this.value.length;
        int limit2 = suffix.length;
        long[] newVals = new long[limit + limit2];
        for (int i = 0; i < limit; ++i) {
            newVals[i] = this.value[i];
        }
        for (int j = 0; j < limit2; ++j) {
            newVals[i++] = suffix[j];
        }
        OID newOID = new OID(newVals, true);
        return newOID;
    }

    public OID concatenate(long[] suffix) {
        if (suffix == null) {
            return this;
        }
        int limit = this.value.length;
        int limit2 = suffix.length;
        long[] newVals = new long[limit + limit2];
        for (int i = 0; i < limit; ++i) {
            newVals[i] = this.value[i];
        }
        for (int j = 0; j < limit2; ++j) {
            newVals[i++] = suffix[j];
        }
        OID newOID = new OID(newVals, true);
        return newOID;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer(String.valueOf(this.value[0]));
        for (int i = 1; i < this.value.length; ++i) {
            strbuf.append(".");
            strbuf.append(this.value[i]);
        }
        return strbuf.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof OID) {
            OID other = (OID)object;
            boolean retval = true;
            if (this.value.length == other.value.length) {
                for (int i = this.value.length - 1; retval && i >= 0; --i) {
                    retval = this.value[i] == other.value[i];
                }
            } else {
                retval = false;
            }
            return retval;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        if (h == 0) {
            int off = 0;
            long[] val = this.value;
            int len = this.value.length;
            for (int i = 0; i < len; ++i) {
                long l = val[off++];
                int hi = (int)(l ^ l >>> 32);
                h = 31 * h + hi;
            }
        }
        return h;
    }

    public boolean startsWith(OID prefix) {
        boolean retval = true;
        if (prefix.value.length <= this.value.length) {
            int limit;
            for (int i = limit = prefix.value.length - 1; retval && i >= 0; --i) {
                retval = prefix.value[i] == this.value[i];
            }
        } else {
            retval = false;
        }
        return retval;
    }

    public int compareTo(Object o) {
        return this.compareTo((OID)o);
    }

    public int compareTo(OID other) {
        int thislen = this.value.length;
        int otherlen = other.value.length;
        int n = Math.min(thislen, otherlen);
        int idx = 0;
        while (n-- != 0) {
            long anotherVal;
            long thisVal = this.value[idx];
            if (thisVal < (anotherVal = other.value[idx++])) {
                return -1;
            }
            if (thisVal <= anotherVal) continue;
            return 1;
        }
        if (thislen < otherlen) {
            return -1;
        }
        if (thislen == otherlen) {
            return 0;
        }
        return 1;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.value.length);
        for (int i = 0; i < this.value.length; ++i) {
            out.writeLong(this.value[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.value = new long[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = in.readLong();
        }
        this.berLength = -1;
    }
}

