/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp;

import org.eclipse.aperi.snmp.PendingResponse;
import org.eclipse.aperi.snmp.SnmpPDU;
import org.eclipse.aperi.snmp.SnmpV1API;

class toobighandler
extends Thread {
    private SnmpPDU rspPDU;
    private PendingResponse pend;

    toobighandler(PendingResponse pend) {
        this.pend = pend;
        this.rspPDU = pend.session.decodeMessage(pend.pack.getData(), pend.pack.getLength());
    }

    public void run() {
        int numvarbinds = this.rspPDU.varBindListSize();
        if (numvarbinds >= 2) {
            int i;
            SnmpPDU secondPDU = this.pend.session.makePDU(this.rspPDU);
            for (i = numvarbinds / 2 - 1; i >= 0; --i) {
                secondPDU.removeVarBindAt(i);
            }
            for (i = numvarbinds - 1; i >= numvarbinds / 2; --i) {
                this.rspPDU.removeVarBindAt(i);
            }
            this.rspPDU = this.pend.session.send(this.rspPDU);
            if (this.rspPDU.errorStatus == 0) {
                secondPDU = this.pend.session.send(secondPDU);
                if (secondPDU.errorIndex != 0) {
                    secondPDU.errorIndex += this.rspPDU.varBindListSize();
                }
            }
            for (i = 0; i < secondPDU.varBindListSize(); ++i) {
                this.rspPDU.addVarBind(secondPDU.varBindAt(i));
            }
            if (this.rspPDU.errorStatus == 0) {
                this.rspPDU.errorStatus = secondPDU.errorStatus;
                this.rspPDU.errorIndex = secondPDU.errorIndex;
            }
            this.rspPDU.correlator = this.pend.correlator;
            this.pend.handleResponse(this.rspPDU);
            int elapsedTime = (int)(System.currentTimeMillis() - this.pend.sendTime);
            this.pend.session.stats.incrReceives(elapsedTime, this.rspPDU.varBindListSize());
            SnmpV1API.getSnmpStats().incrReceives(elapsedTime, this.rspPDU.varBindListSize());
            if (SnmpV1API.isTracing()) {
                SnmpV1API.trace("<== Response received thread = " + Thread.currentThread() + "\n" + this.rspPDU);
            }
        }
    }
}

