/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.eclipse.aperi.snmp.data.Hex;

public class DisplayHint
implements Serializable {
    private static final boolean debug = false;

    public static String stringFromHint(String hintStr, long intVal) {
        String outString = null;
        if (hintStr != null) {
            if (hintStr.length() == 1) {
                if (Character.toLowerCase(hintStr.charAt(0)) == 'x') {
                    outString = Long.toHexString(intVal);
                } else if (Character.toLowerCase(hintStr.charAt(0)) == 'd') {
                    outString = Long.toString(intVal);
                } else if (Character.toLowerCase(hintStr.charAt(0)) == 'o') {
                    outString = Long.toOctalString(intVal);
                } else if (Character.toLowerCase(hintStr.charAt(0)) == 'b') {
                    outString = Long.toBinaryString(intVal);
                }
            } else if (hintStr.length() > 0 && Character.toLowerCase(hintStr.charAt(0)) == 'd' && hintStr.charAt(1) == '-' && Character.isDigit(hintStr.charAt(2))) {
                double ten = 10.0;
                Integer nDPInt = new Integer(hintStr.substring(2));
                double numDecPlaces = nDPInt.doubleValue();
                Long fred = new Long(intVal);
                double tempDoub = fred.doubleValue();
                if (numDecPlaces >= 0.0) {
                    outString = Double.toString(tempDoub /= Math.pow(ten, numDecPlaces));
                }
            }
        }
        return outString;
    }

    public static String stringFromHint(String hintStr, byte[] oStrVal) {
        StringBuffer outStrBuf = new StringBuffer();
        int octetPos = 0;
        int repeatCount = 1;
        class SeqInfo {
            int seqPos = 0;
            boolean seqRepeat;
            int seqLength;
            char seqFormat;
            char seqDspSep;
            char seqRptSep;

            public boolean nextInfo(String myHintStr, boolean getNext) {
                int originalSeqPos = this.seqPos;
                boolean bGood = true;
                if (!getNext) {
                    this.seqPos = 0;
                }
                if (myHintStr.length() > this.seqPos) {
                    if (myHintStr.charAt(this.seqPos) == '*') {
                        this.seqRepeat = true;
                        ++this.seqPos;
                    } else {
                        this.seqRepeat = false;
                    }
                    if (Character.isDigit(myHintStr.charAt(this.seqPos))) {
                        int numStart = this.seqPos;
                        while (this.seqPos < myHintStr.length() && Character.isDigit(myHintStr.charAt(this.seqPos))) {
                            ++this.seqPos;
                        }
                        this.seqLength = Integer.parseInt(myHintStr.substring(numStart, this.seqPos));
                        if (this.seqPos < myHintStr.length()) {
                            this.seqFormat = myHintStr.charAt(this.seqPos);
                            switch (this.seqFormat) {
                                case 'A': 
                                case 'D': 
                                case 'O': 
                                case 'T': 
                                case 'X': 
                                case 'a': 
                                case 'd': 
                                case 'o': 
                                case 't': 
                                case 'x': {
                                    ++this.seqPos;
                                    break;
                                }
                                default: {
                                    this.seqPos = originalSeqPos;
                                    this.seqRepeat = false;
                                    this.seqLength = 0;
                                    this.seqFormat = (char)32;
                                    this.seqDspSep = '\u0000';
                                    this.seqRptSep = '\u0000';
                                    bGood = false;
                                }
                            }
                            if (this.seqPos < myHintStr.length() && this.seqPos > originalSeqPos) {
                                if (myHintStr.charAt(this.seqPos) != '*' && !Character.isDigit(myHintStr.charAt(this.seqPos))) {
                                    this.seqDspSep = myHintStr.charAt(this.seqPos);
                                    ++this.seqPos;
                                    if (this.seqRepeat && this.seqPos < myHintStr.length() && myHintStr.charAt(this.seqPos) != '*' && !Character.isDigit(myHintStr.charAt(this.seqPos))) {
                                        this.seqRptSep = myHintStr.charAt(this.seqPos);
                                        ++this.seqPos;
                                    } else {
                                        this.seqRptSep = '\u0000';
                                    }
                                } else {
                                    this.seqDspSep = '\u0000';
                                    this.seqRptSep = '\u0000';
                                }
                            }
                        } else {
                            this.seqPos = originalSeqPos;
                            this.seqRepeat = false;
                            this.seqLength = 0;
                            this.seqFormat = (char)32;
                            this.seqDspSep = '\u0000';
                            this.seqRptSep = '\u0000';
                            bGood = false;
                        }
                    } else {
                        this.seqPos = originalSeqPos;
                        this.seqRepeat = false;
                        this.seqLength = 0;
                        this.seqFormat = (char)32;
                        this.seqDspSep = '\u0000';
                        this.seqRptSep = '\u0000';
                        bGood = false;
                    }
                } else if (!getNext) {
                    this.seqPos = 0;
                    this.seqRepeat = false;
                    this.seqLength = 0;
                    this.seqFormat = (char)32;
                    this.seqDspSep = '\u0000';
                    this.seqRptSep = '\u0000';
                    bGood = false;
                }
                return bGood;
            }

            public SeqInfo(String myHintStr) {
                this.nextInfo(myHintStr, false);
            }

            public boolean isSeqRepeated() {
                return this.seqRepeat;
            }

            public int length() {
                return this.seqLength;
            }

            public boolean isSeqHex() {
                return this.seqFormat == 'x' || this.seqFormat == 'X';
            }

            public boolean isSeqDec() {
                return this.seqFormat == 'd' || this.seqFormat == 'D';
            }

            public boolean isSeqOct() {
                return this.seqFormat == 'o' || this.seqFormat == 'O';
            }

            public boolean isSeqUTF8() {
                return this.seqFormat == 't' || this.seqFormat == 'T';
            }

            public boolean isSeqAsc() {
                return this.seqFormat == 'a' || this.seqFormat == 'A';
            }

            public boolean isDisplaySepChar() {
                return this.seqDspSep != '\u0000';
            }

            public boolean isRepeatSepChar() {
                return this.seqRptSep != '\u0000';
            }

            public char displaySepChar() {
                return this.seqDspSep;
            }

            public char repeatSepChar() {
                return this.seqRptSep;
            }

            public boolean isThereMore(String myHintStr) {
                return myHintStr.length() > this.seqPos;
            }
        }
        SeqInfo mySeqInfo = new SeqInfo(hintStr);
        while (octetPos < oStrVal.length) {
            if (mySeqInfo.isSeqRepeated()) {
                repeatCount = oStrVal[octetPos];
                ++octetPos;
            }
            while (octetPos < oStrVal.length && repeatCount > 0) {
                int octetLen = octetPos + mySeqInfo.length() <= oStrVal.length ? mySeqInfo.length() : oStrVal.length - octetPos;
                if (mySeqInfo.isSeqHex()) {
                    String s = Hex.toString(oStrVal, octetPos, octetLen);
                    outStrBuf.append(s);
                } else if (mySeqInfo.isSeqDec()) {
                    String s = Hex.toUnsignedDec(oStrVal, octetPos, octetLen);
                    outStrBuf.append(s);
                } else if (mySeqInfo.isSeqOct()) {
                    String s = Hex.toString(oStrVal, octetPos, octetLen, 8);
                    outStrBuf.append(s);
                } else if (mySeqInfo.isSeqAsc()) {
                    int limit = octetPos + octetLen;
                    for (int i = octetPos; i < limit; ++i) {
                        outStrBuf.append((char)oStrVal[i]);
                    }
                } else if (mySeqInfo.isSeqUTF8()) {
                    int limit = octetPos + octetLen;
                    try {
                        outStrBuf.append(new String(oStrVal, octetPos, octetLen, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException uspExc) {
                        uspExc.printStackTrace();
                    }
                }
                if (mySeqInfo.isDisplaySepChar() && (octetPos += octetLen) < oStrVal.length && (!mySeqInfo.isThereMore(hintStr) || repeatCount >= 1)) {
                    outStrBuf.append(mySeqInfo.displaySepChar());
                }
                --repeatCount;
            }
            if (octetPos < oStrVal.length && mySeqInfo.isRepeatSepChar()) {
                outStrBuf.append(mySeqInfo.repeatSepChar());
            }
            repeatCount = 1;
            if (mySeqInfo.nextInfo(hintStr, true)) continue;
            octetPos = oStrVal.length;
        }
        return outStrBuf.toString();
    }

    public static void main(String[] args) {
        System.out.println("Valid Long test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: hex   of     0 = " + DisplayHint.stringFromHint("x", 0L));
        System.out.println(" 2: Hex   of  1234 = " + DisplayHint.stringFromHint("X", 1234L));
        System.out.println(" 3: Hex   of -1234 = " + DisplayHint.stringFromHint("X", -1234L));
        System.out.println(" 4: oct   of     0 = " + DisplayHint.stringFromHint("o", 0L));
        System.out.println(" 5: Oct   of  1234 = " + DisplayHint.stringFromHint("O", 1234L));
        System.out.println(" 6: Oct   of -1234 = " + DisplayHint.stringFromHint("O", -1234L));
        System.out.println(" 7: bin   of     0 = " + DisplayHint.stringFromHint("b", 0L));
        System.out.println(" 8: Bin   of  1234 = " + DisplayHint.stringFromHint("B", 1234L));
        System.out.println(" 9: Bin   of -1234 = " + DisplayHint.stringFromHint("B", -1234L));
        System.out.println("10: dec   of     0 = " + DisplayHint.stringFromHint("d", 0L));
        System.out.println("11: Dec   of  1234 = " + DisplayHint.stringFromHint("D", 1234L));
        System.out.println("12: Dec   of -1234 = " + DisplayHint.stringFromHint("D", -1234L));
        System.out.println("13: Dec.0 of  1234 = " + DisplayHint.stringFromHint("D-0", 1234L));
        System.out.println("14: Dec.1 of  1234 = " + DisplayHint.stringFromHint("D-1", 1234L));
        System.out.println("15: Dec.2 of  1234 = " + DisplayHint.stringFromHint("D-2", 1234L));
        System.out.println("16: Dec.3 of  1234 = " + DisplayHint.stringFromHint("D-3", 1234L));
        System.out.println("17: Dec.4 of  1234 = " + DisplayHint.stringFromHint("D-4", 1234L));
        System.out.println("18: Dec.5 of  1234 = " + DisplayHint.stringFromHint("D-5", 1234L));
        System.out.println("19: Dec.6 of  1234 = " + DisplayHint.stringFromHint("D-6", 1234L));
        System.out.println("20: Dec.0 of -1234 = " + DisplayHint.stringFromHint("D-0", -1234L));
        System.out.println("21: Dec.1 of -1234 = " + DisplayHint.stringFromHint("D-1", -1234L));
        System.out.println("22: Dec.2 of -1234 = " + DisplayHint.stringFromHint("D-2", -1234L));
        System.out.println("23: Dec.3 of -1234 = " + DisplayHint.stringFromHint("D-3", -1234L));
        System.out.println("24: Dec.4 of -1234 = " + DisplayHint.stringFromHint("D-4", -1234L));
        System.out.println("25: Dec.5 of -1234 = " + DisplayHint.stringFromHint("D-5", -1234L));
        System.out.println("26: Dec.6 of -1234 = " + DisplayHint.stringFromHint("D-6", -1234L));
        System.out.println(" ");
        System.out.println("Error Long test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: c     of     0 = " + DisplayHint.stringFromHint("c", 0L));
        System.out.println(" 2: C     of  1234 = " + DisplayHint.stringFromHint("C", 1234L));
        System.out.println(" 3: Null  of  1234 = " + DisplayHint.stringFromHint(null, 1234L));
        System.out.println(" 4: Empty of  1234 = " + DisplayHint.stringFromHint("", 1234L));
        System.out.println(" 5: d--   of     0 = " + DisplayHint.stringFromHint("d--", 0L));
        System.out.println(" 6: D--   of  1234 = " + DisplayHint.stringFromHint("D--", 1234L));
        System.out.println(" 7: d--2  of  1234 = " + DisplayHint.stringFromHint("D--2", 1234L));
        System.out.println(" 8: d+5   of  1234 = " + DisplayHint.stringFromHint("d+5", 1234L));
        System.out.println(" 9: d-a   of  1234 = " + DisplayHint.stringFromHint("d-a", 1234L));
        byte[] oString = new byte[]{3, 0, 0, 4, -46, 0, 0, 4, -46, 0, 0, 4, -46, 77, 121, 32, 110, 97, 109, 101, 32, 105, 115, 32, 72, 97, 110, 122, 44, 32, 117, 110, 100, 32, 109, 121, 32, 110, 97, 109, 101, 32, 105, 115, 32, 70, 114, 97, 110, 122, 46, 0, 0, 4, -46, 0, 0, 4, -46, 4, 0, 0, 4, -46, 0, 0, 4, -46};
        byte[] dateandtime = new byte[]{7, -49, 3, 24, 15, 58, 19, 0};
        System.out.println(" ");
        System.out.println("Valid OctetString DateAndTIme testcases:");
        System.out.println("===============================================");
        System.out.println(" 1: 2d-1d-1d,1d:1d:1d.1d,1a1d:1d= " + DisplayHint.stringFromHint("2d-1d-1d,1d:1d:1d.1d,1a1d:1d", dateandtime));
        System.out.println(" 2: 1x: = " + DisplayHint.stringFromHint("1x:", dateandtime));
        System.out.println(" 3: 2x: = " + DisplayHint.stringFromHint("2x:", dateandtime));
        System.out.println(" 4: 4x: = " + DisplayHint.stringFromHint("4x:", dateandtime));
        System.out.println(" ");
        System.out.println(" ");
        System.out.println("Valid OctetString test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: *4x,|38a|4x;4x;*4x,  = " + DisplayHint.stringFromHint("*4x,|38a|4x;4x;*4x,", oString));
        System.out.println(" 2: *4x,|38a|4x;4x;4x,   = " + DisplayHint.stringFromHint("*4x,|38a|4x;4x;4x,", oString));
        System.out.println(" 3: *4x,|38a|4x;4x;*4x,! = " + DisplayHint.stringFromHint("*4x,|38a|4x;4x;*4x,!", oString));
        System.out.println(" 4: *4x,38a4x4x*4x       = " + DisplayHint.stringFromHint("*4x,38a4x4x*4x", oString));
        System.out.println(" 5: *4x38a4x4x*4x        = " + DisplayHint.stringFromHint("*4x38a4x4x*4x", oString));
        System.out.println(" 6: 1x:                  = " + DisplayHint.stringFromHint("1x:", oString));
        System.out.println(" ");
        System.out.println("Error OctetString test cases:");
        System.out.println("===============================================");
        System.out.println(" 1: *12a,|*4x; = " + DisplayHint.stringFromHint("*12a,|*4x;", oString));
        System.out.println(" 1: 13x,|4a;  = " + DisplayHint.stringFromHint("13x,|4a;", oString));
    }
}

