/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.snmp.utils;

import org.eclipse.aperi.snmp.utils.Orderable;
import org.eclipse.aperi.snmp.utils.Wakeable;

public class Timer
implements Orderable {
    private long popTime;
    private Wakeable sleeper;
    private Object usrData;

    protected Timer(int msec_delay, Wakeable wakeMeUp, Object userData) {
        this.popTime = System.currentTimeMillis() + (long)msec_delay;
        this.sleeper = wakeMeUp;
        this.usrData = userData;
    }

    public long getPopTime() {
        return this.popTime;
    }

    public void wakeUp() {
        this.sleeper.wakeUp(this.usrData);
    }

    public int compare(Orderable other) {
        Timer that = (Timer)other;
        if (this.popTime < that.popTime) {
            return 0;
        }
        if (this.popTime == that.popTime) {
            return 1;
        }
        return 2;
    }

    public String toString() {
        StringBuffer b = new StringBuffer("Timer: poptime=");
        b.append(this.popTime);
        b.append(", sleeper=").append(this.sleeper.toString());
        if (this.usrData != null) {
            b.append(", userData=").append(this.usrData.toString());
        }
        return b.toString();
    }
}

