/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.discovery.resources.JobLoggingTMS;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.interfaces.ParameterException;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.tape.TapeActivator;
import org.eclipse.aperi.tape.TapeReportingService;
import org.eclipse.aperi.tape.api.resources.TapeManagerMsgs;
import org.eclipse.aperi.tape.collection.ProbeGenericTapeLibraryProcess;
import org.eclipse.aperi.tape.collection.TapeCIMProcessor;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProbeTapeLibraryProcess
extends ProbeGenericTapeLibraryProcess {
    public ProbeTapeLibraryProcess(String description, boolean mainProcess) {
        super(description, mainProcess, new String[]{"TAPELIBRARY", "COLLTYPE"}, new String[]{String.class.getName(), Integer.class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process(Request pDiscoverRequest, Map pParameters) throws ParameterException {
        ILogger mJobLogger = pDiscoverRequest.getJobLogger();
        if (mJobLogger != null) {
            mJobLogger.setMessageFile(TapeManagerMsgs.class.getName());
        }
        TapeCIMProcessor mProcessor = new TapeCIMProcessor(pDiscoverRequest.getScannerId());
        try {
            TapeReportingService mTapeReportingService = new TapeReportingService();
            String mOrigTapeLibID = (String)pParameters.get("TAPELIBRARY");
            HashMap mlibID = mTapeReportingService.getTapeLibraryAttributes(new String[]{mOrigTapeLibID}, new String[]{"TAPE_LIBRARY_ID", "CREATION_CLASS_NAME_ID", "NAME", "NAME_FORMAT"})[0];
            CIMOMSelector.TapeLibraryConnectionData mCimomInfo = null;
            try {
                mCimomInfo = CIMOMSelector.getSelector().getCimomForTapeLibrary(((Integer)mlibID.get("TAPE_LIBRARY_ID")).intValue());
            }
            catch (CIMOMSelector.NoCimomAvailableException e) {
                mJobLogger.message(IRecordType.TYPE_ERROR, (Object)this.getClass().getName(), "process", "HWNTM1517E", (Object)((Integer)mlibID.get("TAPE_LIBRARY_ID")).toString());
                Result result = new Result(1);
                if (mProcessor != null) {
                    mProcessor.end(pDiscoverRequest.getId());
                    mProcessor.shutdown();
                    mProcessor = null;
                }
                mJobLogger.setMessageFile(JobLoggingTMS.class.getName());
                return result;
            }
            CIMObjectPath mTlsCop = mCimomInfo.getTapeLibraryCop();
            String mLibraryType = mTlsCop.getKey("CreationClassName").getValue().toString();
            mLibraryType = mLibraryType.indexOf("3584") > 0 ? "3584" : (mLibraryType.indexOf("3494") > 0 ? "3494" : (mLibraryType.indexOf("3583") > 0 ? "3583" : (mLibraryType.indexOf("3582") > 0 ? "3582" : (mLibraryType.indexOf("3581") > 0 ? "3581" : "GENERIC_TAPE_LIBRARY"))));
            if (mLibraryType.equalsIgnoreCase("3494") || mLibraryType.equalsIgnoreCase("3581") || mLibraryType.equalsIgnoreCase("3582") || mLibraryType.equalsIgnoreCase("3583")) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "process", "Library is of type 3494, 3581, 3582 or 3583. nothing to probe for (" + mLibraryType + ")");
                }
                Result result = new Result(0);
                return result;
            }
            mProcessor.initializeForTapeLibraryType(mCimomInfo.getCapability().getSmisVersion(), mLibraryType, mCimomInfo.getCimom().getSoftwareLevel());
            String[] mCimom_TapeLibrary = new String[]{mCimomInfo.getCimom().getServiceUrl(), mCimomInfo.getCimom().getInteropSchemaNamespace(), mCimomInfo.getCimom().getUserId(), mCimomInfo.getCimom().getPassword()};
            pParameters.put("CIMOM", mCimom_TapeLibrary);
            pParameters = this.setTimeout(pDiscoverRequest, pParameters);
            CIMInstance mCIMTapeLibrary = new CIMInstance(mTlsCop);
            Hashtable<String, String> mTapLibDBKeys = new Hashtable<String, String>();
            mTapLibDBKeys.put("ref_toplevelsystem_id", mlibID.get("TAPE_LIBRARY_ID").toString());
            mTapLibDBKeys.put("ref_tape_library_id", mlibID.get("TAPE_LIBRARY_ID").toString());
            mTapLibDBKeys.put("ref_toplevelsystem_name", mlibID.get("NAME").toString());
            mTapLibDBKeys.put("ref_toplevelsystem_nameformat", mlibID.get("NAME_FORMAT").toString());
            mTapLibDBKeys.put("ref_toplevelsystem_cimom2namespaceid", new Integer(mCimomInfo.getCimNamespaceID()).toString());
            mProcessor.setDBReferences(mTapLibDBKeys);
            pParameters.put("IN_SYSTEM_" + COMPUTERSYSTEM, mCIMTapeLibrary);
            int mCollectionType = (Integer)pParameters.get("COLLTYPE");
            ArrayList<DiscoverStep> mSteps = new ArrayList<DiscoverStep>();
            if (mCollectionType == 2) {
                mSteps.add(new DiscoverStep("collectChassisFromComputerSystem", null, (CIMProcessor)mProcessor, (IProgressLogger)new ProgressLogger(mJobLogger, (String)mlibID.get("NAME"), "HWNTM2100I", "HWNTM2001I", "HWNTM2200I", "HWNTM2002E")));
            }
            if (mCollectionType == 3) {
                ProgressLogger bPLogger = new ProgressLogger(mJobLogger, (String)mlibID.get("NAME"), "HWNTM2101I", "HWNTM2001I", "HWNTM2201I", "HWNTM2002E");
                DiscoverStep bStep = mLibraryType.equalsIgnoreCase("3584") ? this.getStepCollectStorageMediaLocationsFrom3584ComputerSystem(mProcessor, bPLogger) : this.getStepCollectStorageMediaLocationsFromComputerSystem(mProcessor, bPLogger);
                mSteps.add(bStep);
            }
            mSteps.add(this.getStepCollectCartridgesFromComputerSystem(mProcessor, new ProgressLogger(mJobLogger, (String)mlibID.get("NAME"), "HWNTM2102I", "HWNTM2001I", "HWNTM2202I", "HWNTM2002E")));
            mSteps.add(this.getStepCollectDrivesFromComputerSystem(mProcessor, new ProgressLogger(mJobLogger, (String)mlibID.get("NAME"), "HWNTM2103I", "HWNTM2001I", "HWNTM2203I", "HWNTM2002E")));
            mSteps.add(this.getStepCollectChangerDeviceFromComputerSystem(mProcessor, new ProgressLogger(mJobLogger, (String)mlibID.get("NAME"), "HWNTM2104I", "HWNTM2001I", "HWNTM2204I", "HWNTM2002E")));
            mSteps.add(this.getStepCollectLimitedAccessPortFromComputerSystem(mProcessor, new ProgressLogger(mJobLogger, (String)mlibID.get("NAME"), "HWNTM2105I", "HWNTM2001I", "HWNTM2205I", "HWNTM2002E")));
            mSteps.add(new DiscoverStep("collectSoftwareIdentityFromComputerSystem", null, (CIMProcessor)mProcessor, (IProgressLogger)new ProgressLogger(mJobLogger, (String)mlibID.get("NAME"), "HWNTM2106I", "HWNTM2001I", "HWNTM2206I", "HWNTM2002E")));
            if (mCollectionType == 3) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "process", "Starting detailed probe of lib id " + mCimomInfo.getTapeLibraryId() + ", CreationClassName " + mLibraryType);
                }
                if (Configuration.debug) {
                    System.out.println("ProbeTapeLibraryProcess: starting detailed probe of lib id " + mCimomInfo.getTapeLibraryId());
                }
            } else {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)this.getClass().getName(), "process", "Starting basic probe of lib id " + mCimomInfo.getTapeLibraryId() + ", CreationClassName " + mLibraryType);
                }
                if (Configuration.debug) {
                    System.out.println("ProbeTapeLibraryProcess: starting basic probe of lib id " + mCimomInfo.getTapeLibraryId());
                }
            }
            String mRequestId = Integer.toString(pDiscoverRequest.getId());
            mProcessor.start(pDiscoverRequest.getId());
            boolean mStatus = this.processSteps(mSteps, pParameters, mRequestId, mJobLogger);
            pParameters.remove("CIMOM");
            pParameters.remove("IN_SYSTEM_" + COMPUTERSYSTEM);
            Result result = new Result(mStatus ? 0 : 1);
            return result;
        }
        finally {
            if (mProcessor != null) {
                mProcessor.end(pDiscoverRequest.getId());
                mProcessor.shutdown();
                mProcessor = null;
            }
            mJobLogger.setMessageFile(JobLoggingTMS.class.getName());
        }
    }

    private Map setTimeout(Request pDiscoverRequest, Map pParameters) {
        String mVal;
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)pDiscoverRequest, (Object)this, (String)"ProbeTapeLibraryProcess.setTimeout", (Object[])new Object[]{pParameters});
        long timeout = 0L;
        IConfigService configSvcProxy = (IConfigService)TapeActivator._serviceHelper.bindLocal("ConfigService");
        if (configSvcProxy != null && (mVal = configSvcProxy.getProperty("http.timeout", "CIM")) != null) {
            timeout = Long.parseLong(mVal);
        }
        pParameters = DiscoverUtils.setProbeTimeout((Map)pParameters, (long)timeout, (LogTraceHelper)mLTH);
        mLTH.exit(null);
        ILogger mJobLogger = pDiscoverRequest.getJobLogger();
        if (mJobLogger != null) {
            mJobLogger.setMessageFile(TapeManagerMsgs.class.getName());
        }
        return pParameters;
    }

    private DiscoverStep getStepCollectStorageMediaLocationsFrom3584ComputerSystem(TapeCIMProcessor pProcessor, ProgressLogger pLogger) {
        pLogger.enableHierarchicalMode();
        DiscoverStep collectChassisFromComputerSystemBasic = new DiscoverStep("collectChassisFromComputerSystem", "IN_SYSTEM_" + CHASSIS, (CIMProcessor)pProcessor, (IProgressLogger)pLogger);
        DiscoverStep collectMagazinesFromChassis = new DiscoverStep("collectMagazinesFromChassis", "IN_SYSTEM_" + MAGAZINE, (CIMProcessor)pProcessor, (IProgressLogger)new ProgressLogger.InnerProgressLogger(pLogger));
        collectChassisFromComputerSystemBasic.addNextStep((IStep)collectMagazinesFromChassis);
        return collectChassisFromComputerSystemBasic;
    }
}

