/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.tape.collection;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.TapeLibrary;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;

public class TapeCIMProcessor
extends CIMProcessor {
    public static final String MESSAGE_NAME = "aperi.logger.message.TapeManager";
    public static final String TRACE_NAME = "aperi.logger.trace.TapeManager";
    protected static String className = TapeCIMProcessor.class.getName();
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    protected String cSMISVersion;
    protected String cDeviceModel;
    protected String cInstrumentationVersion;
    protected Hashtable cDBReferences = null;
    private PersistenceInfo cObjectToPersist = null;
    private String cScannerId;

    public TapeCIMProcessor(String pScannerId) {
        this.cScannerId = pScannerId;
    }

    public void handleAssociation(JobInfo job, String association, String pContextCIMClassName, Hashtable entity1_properties, String pCIMClassNameToPersist, Hashtable pCIMPropertiesToPersist, Hashtable properties) {
        String methodName = "handleAssociation";
        Hashtable mNewDBReferences = null;
        TapeLibrary mLibrary = this.retrieveTapeLibrary(this.cDBReferences);
        if (mLibrary == null) {
            return;
        }
        short mNameFormatValue = mLibrary.getNameFormat();
        String mOriginalCIMClassName = (String)pCIMPropertiesToPersist.get("originalcimclassname");
        pCIMPropertiesToPersist.putAll(this.cDBReferences);
        if (!(this.cObjectToPersist == null || mOriginalCIMClassName.equalsIgnoreCase("CIM_FCPort") || mOriginalCIMClassName.equalsIgnoreCase("CIM_StorageMediaLocation") || mOriginalCIMClassName.equalsIgnoreCase("CIM_SCSIProtocolController") || mOriginalCIMClassName.equalsIgnoreCase("CIM_SoftwareIdentity"))) {
            this.cObjectToPersist.getPropertiesToPersist().put("SCSI", "true");
            this.cObjectToPersist.persistStoredObject(this.cDBReferences);
            this.cObjectToPersist = null;
        }
        if (mOriginalCIMClassName.equalsIgnoreCase("CIM_MediaAccessDevice") || mOriginalCIMClassName.equalsIgnoreCase("CIM_ChangerDevice")) {
            IDBAttributeMapper bMapper = MapperRouter.getMapperRouter().findMapper(pCIMClassNameToPersist, this.cSMISVersion, this.cDeviceModel, this.cInstrumentationVersion, null, mOriginalCIMClassName);
            this.cObjectToPersist = new PersistenceInfo(bMapper, pCIMPropertiesToPersist, this.getScanID(job));
        } else if (mOriginalCIMClassName.equalsIgnoreCase("CIM_SoftwareIdentity")) {
            if (pCIMClassNameToPersist.indexOf("TapeLibrarySoftwareIdentity") > 1) {
                IDBAttributeMapper mMapper = MapperRouter.getMapperRouter().findMapper(pCIMClassNameToPersist, this.cSMISVersion, this.cDeviceModel, this.cInstrumentationVersion, null, mOriginalCIMClassName);
                String mNameFormatOrigin = DBConstants.getKeyFromValue((String)"SMISName_Format", (String)(mNameFormatValue + ""));
                pCIMPropertiesToPersist.put("nameformat", mNameFormatOrigin);
                if (mMapper == null) {
                    traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "DB Mapper does not exist for " + pCIMClassNameToPersist + " or original class " + mOriginalCIMClassName);
                    if (Configuration.debug) {
                        System.out.println("DB Mapper does not exist for " + pCIMClassNameToPersist + " or original class " + mOriginalCIMClassName + " " + pCIMPropertiesToPersist);
                    }
                    return;
                }
                try {
                    MapperResult bResult = mMapper.persist(this.connection, pCIMPropertiesToPersist, this.getScanID(job));
                    mNewDBReferences = bResult.getKeyReferences();
                    this.cDBReferences.putAll(mNewDBReferences);
                    this.connection.commit();
                }
                catch (SQLException e) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    e.printStackTrace();
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException ignore) {
                    }
                }
                catch (Exception e) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    e.printStackTrace();
                }
            } else {
                this.cObjectToPersist.addVersionString(pCIMPropertiesToPersist);
            }
        } else {
            MapperResult bResult;
            if (mOriginalCIMClassName.equalsIgnoreCase("CIM_FCPort")) {
                try {
                    Hashtable mPersistHt = new Hashtable();
                    mPersistHt.putAll(this.cObjectToPersist.getPropertiesToPersist());
                    mPersistHt.putAll(this.cDBReferences);
                    bResult = this.cObjectToPersist.getRequiredMapper().persist(this.connection, mPersistHt, this.cObjectToPersist.cScanID);
                    mPersistHt = null;
                    mNewDBReferences = bResult.getKeyReferences();
                    this.cDBReferences.putAll(mNewDBReferences);
                    this.cDBReferences.remove("ref_node_id");
                    pCIMPropertiesToPersist.putAll(bResult.getKeyReferences());
                    this.connection.commit();
                }
                catch (Exception e) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                    e.printStackTrace();
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException ignore) {
                        // empty catch block
                    }
                }
            }
            if (mOriginalCIMClassName.equalsIgnoreCase("CIM_SCSIProtocolController")) {
                return;
            }
            IDBAttributeMapper mMapper = MapperRouter.getMapperRouter().findMapper(pCIMClassNameToPersist, this.cSMISVersion, this.cDeviceModel, this.cInstrumentationVersion, null, mOriginalCIMClassName);
            if (mMapper == null) {
                traceLogger.text(IRecordType.TYPE_WARN, (Object)className, methodName, "DB Mapper does not exist for " + pCIMClassNameToPersist + " or original class " + mOriginalCIMClassName);
                if (Configuration.debug) {
                    System.out.println("DB Mapper does not exist for " + pCIMClassNameToPersist + " or original class " + mOriginalCIMClassName + " " + pCIMPropertiesToPersist);
                }
                return;
            }
            try {
                bResult = mMapper.persist(this.connection, pCIMPropertiesToPersist, this.getScanID(job));
                mNewDBReferences = bResult.getKeyReferences();
                if (mNewDBReferences.get("ref_cartridge_tag") == null) {
                    this.cDBReferences.remove("ref_cartridge_tag");
                }
                this.cDBReferences.putAll(mNewDBReferences);
                this.connection.commit();
            }
            catch (SQLException e) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                e.printStackTrace();
                try {
                    this.connection.rollback();
                }
                catch (SQLException ignore) {}
            }
            catch (Exception e) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                e.printStackTrace();
            }
        }
    }

    protected String getScanID(JobInfo job) {
        String result = super.getScanID(job);
        if (result == null) {
            result = this.cScannerId;
        }
        return result;
    }

    public Hashtable getDBReferences() {
        return this.cDBReferences;
    }

    public void setDBReferences(Hashtable pHashtable) {
        this.cDBReferences = pHashtable;
    }

    public void initializeForTapeLibraryType(String pSMISVersion, String pDeviceModel, String pInstrumentationVersion) {
        this.cSMISVersion = pSMISVersion;
        this.cDeviceModel = pDeviceModel;
        this.cInstrumentationVersion = pInstrumentationVersion;
    }

    private TapeLibrary retrieveTapeLibrary(Hashtable pDBReferences) {
        TapeLibrary mLibrary = new TapeLibrary();
        mLibrary.setName((String)pDBReferences.get("ref_toplevelsystem_name"));
        mLibrary.setNameFormat(Short.parseShort((String)pDBReferences.get("ref_toplevelsystem_nameformat")));
        try {
            mLibrary.retrieve(this.connection);
        }
        catch (SQLException e1) {
            traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, "retrieveTapeLibrary", (Throwable)e1);
            e1.printStackTrace();
        }
        return mLibrary;
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
    }

    private class PersistenceInfo {
        private IDBAttributeMapper cRequiredMapper = null;
        private Hashtable cPropertiesToPersist = new Hashtable();
        private String cScanID = "";

        public PersistenceInfo(IDBAttributeMapper pDBAttributeMapper, Hashtable pPropertiesToPersist, String pScanID) {
            this.cRequiredMapper = pDBAttributeMapper;
            this.cPropertiesToPersist = pPropertiesToPersist;
            this.cScanID = pScanID;
        }

        public void addVersionString(Hashtable pHTcontainsVersionString) {
            String mVersion = (String)pHTcontainsVersionString.get("versionstring");
            if (mVersion != null) {
                this.cPropertiesToPersist.put("firmware_version", mVersion);
            }
        }

        public MapperResult persistStoredObject(Hashtable pReferences) {
            String methodName = "persistStoredObject";
            MapperResult mResult = null;
            try {
                this.cPropertiesToPersist.putAll(TapeCIMProcessor.this.cDBReferences);
                mResult = this.cRequiredMapper.persist(TapeCIMProcessor.this.connection, this.cPropertiesToPersist, ((TapeCIMProcessor)TapeCIMProcessor.this).cObjectToPersist.cScanID);
                TapeCIMProcessor.this.connection.commit();
            }
            catch (Exception e) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                e.printStackTrace();
                try {
                    TapeCIMProcessor.this.connection.rollback();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
            }
            return mResult;
        }

        public IDBAttributeMapper getRequiredMapper() {
            return this.cRequiredMapper;
        }

        public Hashtable getPropertiesToPersist() {
            return this.cPropertiesToPersist;
        }

        public String getScanID() {
            return this.cScanID;
        }
    }
}

