/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.agent.scanner;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.subagent.scanner.interfaces.IScanner;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.Zone;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneCapabilities;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneConstants;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneDefinition;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneMember;
import org.eclipse.aperi.sanmgmt.tsanm.zone.data.ZoneSet;
import org.eclipse.aperi.sanmgmt.tsanm.zone.interfaces.ZoneControlAgent;
import org.eclipse.aperi.sanmgmt.util.InterpResolver;

public class InbandZoneControl
extends ZoneControlAgent {
    static final String className = InbandZoneControl.class.getName();
    private boolean is_library_opened = false;
    private IScanner scanner = null;

    private static native int EstablishSession(String var0);

    private static native int CloseSession(int var0);

    private static native int SetCreateZoneSetBuffer(int var0, String var1, int var2, char[] var3);

    private static native int AddZoneToCreateZoneSetBuffer(int var0, char[] var1, String var2, int var3, int var4, char[][] var5, short[] var6);

    private static native int CreateZoneSetFromBuffer(int var0, char[] var1, int var2, int var3, String var4);

    private static native int DeleteZoneSet(int var0, String var1, String var2);

    private static native int DeactivateZoneSet(int var0, String var1, String var2);

    private static native int ActivateZoneSet(int var0, String var1, String var2);

    private static native int ping(String var0, int var1);

    private static native int OpenLibrary();

    private static native void CloseLibrary();

    private static native String GetCurrentZoningInfo(int var0);

    private static native int sendCommand(int var0, String var1, char[] var2, int var3, char[] var4, int var5);

    private static native int isFullZoneDBSupported(int var0);

    private static native int getDomainPortCapability(int var0);

    private static native int isCiscoADZSWorkaroundNeeded(int var0);

    private static native int AddZoneToZoneSet(int var0, String var1, String var2, String var3);

    private static native int AddMembersToRemoveZoneMembersBuffer(int var0, char[] var1, String var2, int var3, char[][] var4, short[] var5);

    private static native int RemoveMembersFromBuffer(int var0, char[] var1, int var2, String var3);

    private static native int isCNTRZMWorkaroundNeeded(int var0);

    private static native void GetSwitchVendorIds(int var0, String[] var1);

    private static native int CreateZoneAlias(int var0, String var1, int var2, char[][] var3, short[] var4);

    private static native int DeleteZoneAlias(int var0, String var1);

    private static native int AddZoneAliasToZone(int var0, String var1, String var2);

    private static native int AddZoneMemberToZoneAlias(int var0, String var1, String var2);

    private static native int AddZoneMemberDomainPortToZoneAlias(int var0, long var1, long var3, String var5);

    private static native int RemoveZoneAliasFromZone(int var0, String var1, String var2);

    private static native int RemoveZoneMemberFromZoneAlias(int var0, String var1, String var2);

    private static native int RemoveZoneMemberDomainPortFromZoneAlias(int var0, long var1, long var3, String var5);

    private static native int DeleteZoneMember(int var0, String var1);

    private static native int DeleteZoneMemberDomainPort(int var0, long var1, long var3);

    private static native int AddZoneToZoneSet(int var0, String var1, String var2);

    private static native int AddZoneMemberToZone(int var0, String var1, String var2);

    private static native int AddZoneMemberDomainPortToZone(int var0, long var1, long var3, String var5);

    private static native int RemoveZoneFromZoneSet(int var0, String var1, String var2);

    private static native int RemoveZoneMemberFromZone(int var0, String var1, String var2);

    private static native int RemoveZoneMemberDomainPortFromZone(int var0, long var1, long var3, String var5);

    private static native int ActivateTransaction(int var0);

    private static native int CommitTransaction(int var0);

    private static native int RollbackTransaction(int var0);

    private static native int DeleteZone(int var0, String var1);

    public InbandZoneControl() {
        String methodName = "InbandZoneControl";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_OBJ_CREATE, (Object)className, methodName);
        }
        this.is_library_opened = this.openLibraryGS3() == 0;
    }

    public ZoneCapabilities getCapabilities(String SAN) {
        String methodName = "getCapabilities";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        try {
            ZoneCapabilities capabilities = new ZoneCapabilities();
            capabilities.setSupportsNodeWWN(false);
            capabilities.setSupportsAliases(false);
            capabilities.setAllowsNumericNameStart(false);
            capabilities.setMaxMembersInAlias(-1);
            capabilities.setMaxMembersInZone(-1);
            capabilities.setMaxNameLength(64);
            capabilities.setMaxZones(-1);
            capabilities.setMaxZoneSets(-1);
            capabilities.setMaxZonesInSet(-1);
            capabilities.setSupportsEmptyZoneAliases(false);
            capabilities.setSupportsEmptyZones(true);
            capabilities.setSupportsEmptyZoneSets(false);
            capabilities.setMaxZoneAliases(0);
            capabilities.setMaxZoneMembers(-1);
            int domainportsupport = this.getDomainPortCapabilityGS3((Integer)this.SANtoHandle.get(SAN));
            if (domainportsupport == 1) {
                capabilities.setSupportsDomainPort(true);
            } else {
                capabilities.setSupportsDomainPort(false);
            }
            int fullzonedbsupport = this.isFullZoneDBSupportedGS3((Integer)this.SANtoHandle.get(SAN));
            if (fullzonedbsupport == 1) {
                capabilities.setSupportsFullZoneDB(true);
                capabilities.setSupportsFCID(true);
                capabilities.setZcAgentType(1);
            } else {
                capabilities.setMaxZoneSets(1);
                capabilities.setSupportsFullZoneDB(false);
                capabilities.setSupportsFCID(false);
                capabilities.setZcAgentType(2);
            }
            capabilities.setSupportsOrphanZoneAliases(false);
            capabilities.setSupportsOrphanZones(false);
            capabilities.setSupportsSpecialCharacters(true);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Capabilities of SAN " + SAN + " are " + capabilities.toString());
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return capabilities;
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            return null;
        }
    }

    public int ping(String san, String[] parameters) {
        String methodName = "ping";
        int err = 1111;
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        try {
            if (!this.is_library_opened) {
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return 221997;
            }
            int handle = (Integer)this.SANtoHandle.get(san);
            err = this.pingGS3(san, handle);
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Pinged SAN " + san + ". Return code " + err + ".");
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            err = 221111;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return err;
    }

    public int lock(String resource, String[] parameters) {
        int handle;
        String methodName;
        block8: {
            methodName = "lock";
            handle = -1;
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
                }
                if (!this.is_library_opened) {
                    if (traceLogger.isLogging()) {
                        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                    }
                    return 1;
                }
                handle = this.establishSessionGS3(resource);
                if (handle > 0 && this.SANtoHandle.get(resource) == null) {
                    this.SANtoHandle.put(resource, Integer.valueOf(Integer.toString(handle)));
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Locked resource: " + resource + ".");
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!traceLogger.isLogging()) break block8;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return handle > 0 ? 0 : 1;
    }

    public int startTransaction(String SAN) {
        String methodName = "startTransaction";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        this.activateOnCommit = false;
        try {
            if (!this.is_library_opened) {
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
                return 11997;
            }
            this.SANtoCommands.remove(SAN);
            this.SANtoCommands.put(SAN, new ArrayList());
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            return 11111;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return 0;
    }

    public int rollbackTransaction(String SAN) {
        int status = 0;
        String methodName = "rollbackTransaction";
        try {
            ArrayList cmdQueue;
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            }
            if ((cmdQueue = (ArrayList)this.SANtoCommands.remove(SAN)) != null) {
                cmdQueue.clear();
                this.SANtoCommands.put(SAN, cmdQueue);
            }
            Integer handleInt = (Integer)this.SANtoHandle.get(SAN);
            ZoneDefinition zDef = (ZoneDefinition)this.SANtoZoneDef.get(SAN);
            if (handleInt != null && zDef != null) {
                ZoneDefinition origZDef = (ZoneDefinition)this.SANtoZoneDef.get(SAN);
                ZoneDefinition badZDef = new ZoneDefinition();
                status = this.readCurrentZoneDefinition(SAN, badZDef);
                status = status == 0 ? this.sendCommandsToSwitch(SAN, origZDef, badZDef, 1) : 21999;
            }
        }
        catch (Exception e) {
            msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            status = 21111;
        }
        if (status != 0 && traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Failed to rollback transaction on SAN " + SAN + ".  Err = " + status);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int addZonesToZoneSet(int handle, String SAN, String zoneSetName, Zone[] zonesInSet) {
        int status = 0;
        String methodName = "addZonesToZoneSet";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        for (int i = 0; i < zonesInSet.length; ++i) {
            Zone zone = zonesInSet[i];
        }
        for (int zoneCount = 0; zoneCount < zonesInSet.length; ++zoneCount) {
            status = this.addZoneToZoneSetGS3(handle, zoneSetName, zonesInSet[zoneCount].getName(), SAN);
            if (status != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to add zone " + zonesInSet[zoneCount].getName() + " to ZoneSet " + zoneSetName + " on SAN " + SAN + ".  Err = " + status);
                }
                return status;
            }
            if (!traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Added zone " + zonesInSet[zoneCount].getName() + " to ZoneSet: " + zoneSetName + ", SAN: " + SAN);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int createZoneSet(String SAN, String zoneSetName, ZoneDefinition definition, Zone[] zonesInSet, boolean isActive) {
        int status = 0;
        String methodName = "createZoneSet";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int buffer_length = 0;
        for (int i = 0; i < zonesInSet.length; ++i) {
            Zone zone = zonesInSet[i];
            buffer_length += 72;
            ZoneMember[] members = definition.getMembers(zone);
            buffer_length += 12 * members.length;
        }
        buffer_length += 88;
        char[] response = new char[buffer_length /= 2];
        int handle = (Integer)this.SANtoHandle.get(SAN);
        int bufferIndex = this.setCreateZoneSetBufferGS3(handle, zoneSetName, zonesInSet.length, response);
        for (int zoneCount = 0; zoneCount < zonesInSet.length; ++zoneCount) {
            ZoneMember[] members = definition.getMembers(zonesInSet[zoneCount]);
            String[] memberNames = new String[members.length];
            short[] memberTypes = new short[members.length];
            for (int zoneMemberCount = 0; zoneMemberCount < members.length; ++zoneMemberCount) {
                memberNames[zoneMemberCount] = members[zoneMemberCount].getName();
                memberTypes[zoneMemberCount] = members[zoneMemberCount].getType();
            }
            bufferIndex = this.addZoneToCreateZoneSetBufferGS3(handle, SAN, response, zonesInSet[zoneCount].getName(), bufferIndex, members.length, memberNames, memberTypes);
        }
        int activeZoneSet = 0;
        if (isActive) {
            activeZoneSet = 1;
        }
        if ((status = this.createZoneSetFromBufferGS3(handle, response, activeZoneSet, bufferIndex, SAN)) != 0) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to create ZoneSet " + zoneSetName + " on SAN " + SAN + ".  Err = " + status);
            }
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrGS3CreateZoneSet", (Object)zoneSetName, (Object)SAN);
            return status;
        }
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "Created ZoneSet: " + zoneSetName + ", SAN: " + SAN);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    protected int sendCommandsToSwitch(String SAN, ZoneDefinition newZDef, ZoneDefinition oldZDef, int zone_db_code) {
        String methodName = "sendCommandsToSwitch";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        int handle = (Integer)this.SANtoHandle.get(SAN);
        status = this.checkIfNonStdMembersExist(oldZDef, SAN);
        if (status != 0) {
            return status;
        }
        HashMap likeZoneSetsMap = new HashMap();
        HashMap likeZonesMap = new HashMap();
        this.findSameZoneEntities(oldZDef, newZDef, likeZoneSetsMap, null, likeZonesMap);
        status = this.deactivateIfNecessary(oldZDef, newZDef, zone_db_code, SAN, handle);
        if (status == 0) {
            status = this.deleteUnneededZoneSets(oldZDef, newZDef, zone_db_code, SAN, handle);
        }
        if (status == 0) {
            status = this.createNewZoneSets(likeZoneSetsMap, newZDef, SAN);
        }
        if (status == 0) {
            status = this.ciscoADZSWorkaroundIfNecessary(likeZoneSetsMap, newZDef, SAN, handle);
        }
        if (status == 0) {
            status = this.CNTRZMWorkaroundIfNecessary(newZDef, oldZDef, SAN, handle, likeZonesMap);
        }
        if (status == 0) {
            status = this.activateIfNecessary(newZDef, zone_db_code, SAN, handle);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int checkIfNonStdMembersExist(ZoneDefinition oldZDef, String SAN) {
        String methodName = "checkIfNonStdMembersExist";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        ZoneMember[] oldMembers = oldZDef.getMembers();
        for (int oldMembersCount = 0; oldMembersCount < oldMembers.length; ++oldMembersCount) {
            if (oldMembers[oldMembersCount].getType() == 11 || oldMembers[oldMembersCount].getType() == 12 || oldMembers[oldMembersCount].getType() == 13 || oldMembers[oldMembersCount].getType() == 14) continue;
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to make changes to SAN " + SAN + "since old definition has a non-standard zone member type " + oldMembers[oldMembersCount].getType() + " for member " + oldMembers[oldMembersCount].getName());
            }
            msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrNonStandardZoneMembersPresent", (Object)SAN);
            return 281112;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int ciscoADZSWorkaroundIfNecessary(HashMap likeZoneSetsMap, ZoneDefinition newZDef, String SAN, int handle) {
        String methodName = "ciscoADZSWorkaroundIfNecessary";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        int isCiscoADZSWorkaroundNeeded = this.isCiscoADZSWorkaroundNeededGS3(handle);
        if (isCiscoADZSWorkaroundNeeded == 1) {
            ZoneSet[] zoneSets = newZDef.getZoneSets();
            for (int i = 0; i < zoneSets.length; ++i) {
                Zone[] zonesInSet = newZDef.getZones(zoneSets[i]);
                String[] zoneNames = new String[zonesInSet.length];
                for (int zoneCount = 0; zoneCount < zonesInSet.length; ++zoneCount) {
                    zoneNames[zoneCount] = zonesInSet[zoneCount].getName();
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Adding zones to zoneset " + zoneSets[i].getName() + " on SAN " + SAN + " due to the Cisco ADZS issue");
                }
                if ((status = this.addZonesToZoneSet(handle, SAN, zoneSets[i].getName(), zonesInSet)) == 0) continue;
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to add zonest to ZoneSet (Cisco ADZS workaround)" + zoneSets[i].getName() + " on SAN " + SAN + ".  Err = " + status);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrGS3CreateZoneSet", (Object)zoneSets[i].getName(), (Object)SAN);
                return status;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int CNTRZMWorkaroundIfNecessary(ZoneDefinition newZDef, ZoneDefinition oldZDef, String SAN, int handle, HashMap likeZonesMap) {
        String methodName = "CNTRZMWorkaroundIfNecessary";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        int isCNTRZMWorkaroundNeeded = this.isCNTRZMWorkaroundNeededGS3(handle);
        if (isCNTRZMWorkaroundNeeded == 1) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "CNT RZM workaround is needed on SAN " + SAN);
            }
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "CNT RZM workaround is not needed on SAN " + SAN);
        }
        if (isCNTRZMWorkaroundNeeded == 1) {
            Zone[] zones = newZDef.getZones();
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Number of zones in new definition is " + zones.length + " for SAN " + SAN);
            }
            for (int i = 0; i < zones.length; ++i) {
                String zoneName = zones[i].getName();
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Checking if any members need to be removed for zone " + zoneName + " for SAN " + SAN);
                }
                if (likeZonesMap.containsKey(zoneName)) {
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "zone " + zoneName + " in like zone map " + " for SAN " + SAN);
                    continue;
                }
                Zone oldDefZone = oldZDef.getZone(zoneName);
                if (oldDefZone == null) {
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "zone " + zoneName + " is not in old zone definition " + " for SAN " + SAN);
                    continue;
                }
                ZoneMember[] oldDefMembers = oldZDef.getMembers(oldDefZone);
                Zone newDefZone = newZDef.getZone(zoneName);
                ZoneMember[] newDefMembers = newZDef.getMembers(newDefZone);
                String[] tempNamesList = new String[oldDefMembers.length];
                short[] tempTypesList = new short[oldDefMembers.length];
                int numMembersInOldZDefOnly = 0;
                for (int oldDefMemberCount = 0; oldDefMemberCount < oldDefMembers.length; ++oldDefMemberCount) {
                    String oldDefMemberName = oldDefMembers[oldDefMemberCount].getName();
                    short oldDefMemberType = oldDefMembers[oldDefMemberCount].getType();
                    boolean memberInOldZDefOnly = true;
                    for (int newDefMemberCount = 0; newDefMemberCount < newDefMembers.length; ++newDefMemberCount) {
                        String newDefMemberName = newDefMembers[newDefMemberCount].getName();
                        short newDefMemberType = newDefMembers[newDefMemberCount].getType();
                        if (!oldDefMemberName.equals(newDefMemberName) || oldDefMemberType != newDefMemberType) continue;
                        memberInOldZDefOnly = false;
                        break;
                    }
                    if (!memberInOldZDefOnly) continue;
                    if (traceLogger.isLogging()) {
                        traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "zone " + zoneName + " member  " + oldDefMemberName + " is only in old def and needs to be removed " + " for SAN " + SAN);
                    }
                    tempNamesList[numMembersInOldZDefOnly] = oldDefMemberName;
                    tempTypesList[numMembersInOldZDefOnly] = oldDefMemberType;
                    ++numMembersInOldZDefOnly;
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " number of members to be removed for zone " + zoneName + "is " + numMembersInOldZDefOnly + " for SAN " + SAN);
                }
                String[] oldDefMembersRemoveList = new String[numMembersInOldZDefOnly];
                short[] oldDefMembersTypeRemoveList = new short[numMembersInOldZDefOnly];
                for (int k = 0; k < numMembersInOldZDefOnly; ++k) {
                    oldDefMembersRemoveList[k] = tempNamesList[k];
                    oldDefMembersTypeRemoveList[k] = tempTypesList[k];
                }
                if (numMembersInOldZDefOnly <= 0) continue;
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Removing members in old def for zone " + zoneName + " on SAN " + SAN + " due to the CNT RZM issue");
                }
                int buffer_length = 0;
                buffer_length += 84;
                buffer_length += 12 * numMembersInOldZDefOnly;
                char[] response = new char[buffer_length /= 2];
                int bufferIndex = this.AddMembersToRemoveZoneMembersBufferGS3(handle, SAN, response, zoneName, numMembersInOldZDefOnly, oldDefMembersRemoveList, oldDefMembersTypeRemoveList);
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, " buffer index in response buffer  for removing members in old def for zone " + zoneName + " on SAN " + SAN + " due to the CNT RZM issue" + " is " + bufferIndex);
                }
                if ((status = this.RemoveMembersFromBufferGS3(handle, response, bufferIndex, SAN)) == 0) continue;
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to remove members for zone (CNT RZM workaround)" + zoneName + " on SAN " + SAN + ".  Err = " + status);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrGS3CreateZoneSet", (Object)zoneName, (Object)SAN);
                return status;
            }
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "No CNT RZM workaround needed on SAN " + SAN);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int activateIfNecessary(ZoneDefinition newZDef, int zone_db_code, String SAN, int handle) {
        boolean has_active_zset;
        String methodName = "activateIfNecessary";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        boolean apply_active = zone_db_code == 2 || zone_db_code == 1;
        ZoneSet newActiveZSet = newZDef.getActiveZoneSet();
        boolean bl = has_active_zset = newActiveZSet != null && newActiveZSet.getName() != null;
        if (has_active_zset && this.getCapabilities(SAN).isSupportsFullZoneDB() && apply_active && status == 0) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "activating zoneset " + newActiveZSet.getName() + " on SAN " + SAN + " since there is new active zoneset in new def or active zoneset needs to be reactivated");
            }
            if ((status = this.activateZoneSetGS3(handle, newActiveZSet.getName(), SAN)) != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to activate ZoneSet" + newActiveZSet.getName() + " on SAN " + SAN + ".  Err = " + status);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrGS3activateZoneSet", (Object)newActiveZSet.getName(), (Object)SAN);
                return status;
            }
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "will not activate zoneset  on SAN " + SAN + " since zone_db_code is " + zone_db_code + " and there is possibly no active zoneset in new def " + " or full zone db is not supported by SAN ");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int createNewZoneSets(HashMap likeZoneSetsMap, ZoneDefinition newZDef, String SAN) {
        String methodName = "createNewZoneSets";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        ZoneSet[] zoneSets = newZDef.getZoneSets();
        for (int i = 0; i < zoneSets.length; ++i) {
            if (likeZoneSetsMap.get(zoneSets[i].getName()) == null && status == 0) {
                Zone[] zonesInSet = newZDef.getZones(zoneSets[i]);
                String[] zoneNames = new String[zonesInSet.length];
                for (int zoneCount = 0; zoneCount < zonesInSet.length; ++zoneCount) {
                    zoneNames[zoneCount] = zonesInSet[zoneCount].getName();
                }
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Creating zoneset " + zoneSets[i].getName() + " on SAN " + SAN + " since it exists in new def");
                }
                if ((status = this.createZoneSet(SAN, zoneSets[i].getName(), newZDef, zonesInSet, false)) == 0) continue;
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to create ZoneSet" + zoneSets[i].getName() + " on SAN " + SAN + ".  Err = " + status);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrGS3CreateZoneSet", (Object)zoneSets[i].getName(), (Object)SAN);
                return status;
            }
            if (!traceLogger.isLogging()) continue;
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "zoneset " + zoneSets[i].getName() + " on SAN " + SAN + " exists in likeZoneSetsMap will not be created");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int deleteUnneededZoneSets(ZoneDefinition oldZDef, ZoneDefinition newZDef, int zone_db_code, String SAN, int handle) {
        String methodName = "deleteUnneededZoneSets";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        if (this.getCapabilities(SAN).isSupportsFullZoneDB()) {
            ZoneSet[] oldZoneSets = oldZDef.getZoneSets();
            for (int i = 0; i < oldZoneSets.length; ++i) {
                if (newZDef.getZoneSet(oldZoneSets[i].getName()) != null || status != 0) continue;
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Deleting zoneset " + oldZoneSets[i].getName() + " on SAN " + SAN + " since it is not in new def");
                }
                if ((status = this.deleteZoneSetGS3(handle, oldZoneSets[i].getName(), SAN)) == 0) continue;
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to delete ZoneSet" + oldZoneSets[i].getName() + " on SAN " + SAN + ".  Err = " + status);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrGS3DeleteZoneSet", (Object)oldZoneSets[i].getName(), (Object)SAN);
                return status;
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int deactivateIfNecessary(ZoneDefinition oldZDef, ZoneDefinition newZDef, int zone_db_code, String SAN, int handle) {
        String methodName = "deactivateIfNecessary";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int status = 0;
        boolean apply_active = zone_db_code == 2 || zone_db_code == 1;
        ZoneSet oldActiveZSet = oldZDef.getActiveZoneSet();
        ZoneSet newActiveZSet = newZDef.getActiveZoneSet();
        if (oldActiveZSet != null && newActiveZSet == null && apply_active) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "Deactivating zoneset " + oldActiveZSet.getName() + " on SAN " + SAN + " since there is no active zoneset in new def");
            }
            if ((status = this.deactivateZoneSetGS3(handle, oldActiveZSet.getName(), SAN)) != 0) {
                if (traceLogger.isLogging()) {
                    traceLogger.text(IRecordType.TYPE_ERR, (Object)this, methodName, "Unable to deactivate ZoneSet" + oldActiveZSet.getName() + " on SAN " + SAN + ".  Err = " + status);
                }
                msgLogger.message(IRecordType.TYPE_ERR, (Object)this, methodName, "ZoneControl_ErrGS3DeactivateZoneSet", (Object)oldActiveZSet.getName(), (Object)SAN);
                return status;
            }
        } else if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)this, methodName, "No zoneset needs to be deactivated  on SAN " + SAN + " since active zoneset exists in new def or no active zoneset in old def " + " full zone db cap is " + this.getCapabilities(SAN).isSupportsFullZoneDB() + " zone_db_code is " + zone_db_code);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int getGS3Err(int nativeerr) {
        int err = nativeerr;
        err = err == -4 ? Math.abs(err) + 100 : Math.abs(err);
        return err;
    }

    public void finalize() {
        block4: {
            String methodName = "finalize";
            try {
                if (traceLogger.isLogging()) {
                    traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
                }
                this.closeLibraryGS3();
                this.is_library_opened = false;
                if (traceLogger.isLogging()) {
                    traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
                }
            }
            catch (Exception e) {
                msgLogger.exception(IRecordType.TYPE_ERR, (Object)this, methodName, (Throwable)e);
                if (!traceLogger.isLogging()) break block4;
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
    }

    private int establishSessionGS3(String san) {
        String methodName = "establishSessionGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "san = " + san);
        }
        int handle = InbandZoneControl.EstablishSession(san);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return handle;
    }

    protected int closeSessionNative(int handle) {
        int status;
        String methodName = "closeSessionNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((status = InbandZoneControl.CloseSession(handle)) != 0) {
            status = this.getGS3Err(status) + 240000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int setCreateZoneSetBufferGS3(int handle, String zoneSetName, int numZones, char[] response) {
        String methodName = "setCreateZoneSetBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneSetName = " + zoneSetName + ". numZones = " + numZones);
        }
        int bufferIndex = InbandZoneControl.SetCreateZoneSetBuffer(handle, zoneSetName, numZones, response);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return bufferIndex;
    }

    private int addZoneToCreateZoneSetBufferGS3(int handle, String SAN, char[] response, String zoneName, int bufferIndex, int numMembers, String[] memberNames, short[] membersType) {
        String methodName = "addZoneToCreateZoneSetBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneName = " + zoneName + ". bufferIndex " + bufferIndex + ". numMembers = " + numMembers);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "ZoneMembers: ");
            if (memberNames.length == membersType.length) {
                for (int i = 0; i < memberNames.length; ++i) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, memberNames[i] + " , " + membersType[i]);
                }
            }
        }
        char[][] memberNamesArray = new char[memberNames.length][this.getCapabilities(SAN).getMaxNameLength()];
        for (int i = 0; i < memberNames.length; ++i) {
            char[] name = new char[this.getCapabilities(SAN).getMaxNameLength()];
            name = memberNames[i].toCharArray();
            for (int j = 0; j < memberNames[i].length(); ++j) {
                memberNamesArray[i][j] = name[j];
            }
            memberNamesArray[i][j] = '\u0000';
        }
        bufferIndex = InbandZoneControl.AddZoneToCreateZoneSetBuffer(handle, response, zoneName, bufferIndex, numMembers, memberNamesArray, membersType);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return bufferIndex;
    }

    private int createZoneSetFromBufferGS3(int handle, char[] response, int activateZoneSet, int bufferIndex, String SAN) {
        int status;
        String methodName = "createZoneSetFromBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "activateZoneSet = " + activateZoneSet + ". bufferIndex " + bufferIndex);
        }
        if ((status = InbandZoneControl.CreateZoneSetFromBuffer(handle, response, activateZoneSet, bufferIndex, SAN)) != 0) {
            status = this.getGS3Err(status) + 40000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int deleteZoneSetGS3(int handle, String zoneSetName, String SAN) {
        int status;
        String methodName = "deleteZoneSetGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneSetName = " + zoneSetName);
        }
        if ((status = InbandZoneControl.DeleteZoneSet(handle, zoneSetName, SAN)) != 0) {
            status = this.getGS3Err(status) + 180000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int deactivateZoneSetGS3(int handle, String zoneSetName, String SAN) {
        int status;
        String methodName = "deactivateZoneSetGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneSetName = " + zoneSetName);
        }
        if ((status = InbandZoneControl.DeactivateZoneSet(handle, zoneSetName, SAN)) != 0) {
            status = this.getGS3Err(status) + 210000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int activateZoneSetGS3(int handle, String zoneSetName, String SAN) {
        int status;
        String methodName = "activateZoneSetGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneSetName = " + zoneSetName);
        }
        if ((status = InbandZoneControl.ActivateZoneSet(handle, zoneSetName, SAN)) != 0) {
            status = this.getGS3Err(status) + 200000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int pingGS3(String san, int handle) {
        int status;
        String methodName = "pingGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "san = " + san);
        }
        if ((status = InbandZoneControl.ping(san, handle)) != 0) {
            status = this.getGS3Err(status) + 220000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int openLibraryGS3() {
        String methodName = "openLibraryGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        int ret = InbandZoneControl.OpenLibrary();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return ret;
    }

    private void closeLibraryGS3() {
        String methodName = "closeLibraryGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        InbandZoneControl.CloseLibrary();
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    protected String getCurrentZoningInfoNative(int fabHandle) {
        String methodName = "getCurrentZoningInfoNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        String currentZoningInfo = InbandZoneControl.GetCurrentZoningInfo(fabHandle);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return currentZoningInfo;
    }

    private int isFullZoneDBSupportedGS3(int handle) {
        int isSupported;
        String methodName = "isFullZoneSupportedGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((isSupported = InbandZoneControl.isFullZoneDBSupported(handle)) == 0 || isSupported == 1) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return isSupported;
        }
        return 261111;
    }

    private void getSwitchVendorIdsGS3(int handle, String[] vendorIds) {
        String methodName = "getSwitchVendorIdsGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        InbandZoneControl.GetSwitchVendorIds(handle, vendorIds);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    private int getDomainPortCapabilityGS3(int handle) {
        int domainportsupport;
        String methodName = "getDomainPortCapabilityGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((domainportsupport = InbandZoneControl.getDomainPortCapability(handle)) == 0 || domainportsupport == 1) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return domainportsupport;
        }
        return 261111;
    }

    private int isCiscoADZSWorkaroundNeededGS3(int handle) {
        int ciscoAdzsWorkaroundNeeded;
        String methodName = "isCiscoADZSWorkaroundNeededGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((ciscoAdzsWorkaroundNeeded = InbandZoneControl.isCiscoADZSWorkaroundNeeded(handle)) == 1 || ciscoAdzsWorkaroundNeeded == 0) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return ciscoAdzsWorkaroundNeeded;
        }
        return 81111;
    }

    private int addZoneToZoneSetGS3(int handle, String zoneSetName, String zoneName, String SAN) {
        int status;
        String methodName = "addZoneToZoneSetGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneName = " + zoneName + "zoneSetName = " + zoneSetName);
        }
        if ((status = InbandZoneControl.AddZoneToZoneSet(handle, zoneSetName, zoneName, SAN)) != 0) {
            status = this.getGS3Err(status) + 80000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int AddMembersToRemoveZoneMembersBufferGS3(int handle, String SAN, char[] response, String zoneName, int numMembers, String[] memberNames, short[] membersType) {
        String methodName = "AddMembersToRemoveZoneMembersBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "zoneName = " + zoneName + ". numMembers = " + numMembers);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "ZoneMembers: ");
            if (memberNames.length == membersType.length) {
                for (int i = 0; i < memberNames.length; ++i) {
                    traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, memberNames[i] + " , " + membersType[i]);
                }
            }
        }
        char[][] memberNamesArray = new char[memberNames.length][this.getCapabilities(SAN).getMaxNameLength()];
        for (int i = 0; i < memberNames.length; ++i) {
            char[] name = new char[this.getCapabilities(SAN).getMaxNameLength()];
            name = memberNames[i].toCharArray();
            for (int j = 0; j < memberNames[i].length(); ++j) {
                memberNamesArray[i][j] = name[j];
            }
            memberNamesArray[i][j] = '\u0000';
        }
        int bufferIndex = InbandZoneControl.AddMembersToRemoveZoneMembersBuffer(handle, response, zoneName, numMembers, memberNamesArray, membersType);
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return bufferIndex;
    }

    private int RemoveMembersFromBufferGS3(int handle, char[] response, int bufferIndex, String SAN) {
        int status;
        String methodName = "RemoveMembersFromBufferGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
            traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)className, methodName, "bufferIndex " + bufferIndex);
        }
        if ((status = InbandZoneControl.RemoveMembersFromBuffer(handle, response, bufferIndex, SAN)) != 0) {
            status = this.getGS3Err(status) + 40000;
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return status;
    }

    private int isCNTRZMWorkaroundNeededGS3(int handle) {
        int CNTRZMWorkaroundNeeded;
        String methodName = "isCNTRZMWorkaroundNeededGS3";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if ((CNTRZMWorkaroundNeeded = InbandZoneControl.isCNTRZMWorkaroundNeeded(handle)) == 1 || CNTRZMWorkaroundNeeded == 0) {
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return CNTRZMWorkaroundNeeded;
        }
        return 81111;
    }

    protected int activateTransactionNative(int handle) {
        String methodName = "activateTransactionNative";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_API, (Object)className, methodName);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return 15500;
    }

    public boolean shutdown() {
        return true;
    }

    static {
        msgLogger = ZoneConstants.zcAgentMsgLogger;
        traceLogger = ZoneConstants.zcAgentTraceLogger;
        String osName = System.getProperty("os.name");
        String libraryName = null;
        libraryName = InterpResolver.isWindows((String)osName) ? "sniahbaapi" : "hbaapi";
        if (!InterpResolver.isAIX((String)osName)) {
            System.loadLibrary(libraryName);
        }
        System.loadLibrary("GS3ZoneControl");
    }
}

