/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.Nas.gui.admin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.Nas.gui.admin.NasAgentPanel;
import org.eclipse.aperi.TStorm.common.NasFilesystem;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasAgentDDI
extends DataDisplayInfo
implements GuiRequestor,
ActionListener {
    private boolean dataRetrieved = false;
    private NasFilesystem[] dataArray;
    private NasFilesystem[] updateArray;
    private ListNode treeList;
    private NameList[] windowsAgents;
    private boolean closing;
    private static final int VISIBLE_DELETE_COUNT = 3;

    public NasAgentDDI() {
        this.setDescription(MessageLog.getMessageNoID("NAG0012L"));
        this.displayInScrollPane = false;
        this.helpID = "asco60";
    }

    public void reDisplay() {
        if (!this.dataRetrieved) {
            Request request = new Request();
            GuiRequest.nasFsList(request);
            GuiClient.doRequest(this, request);
            return;
        }
        if (this.panel == null) {
            this.buildEditor();
        }
        this.showAndAddListeners();
    }

    private void buildEditor() {
        this.panel = new NasAgentPanel(this, this.dataArray, this.treeList, this.windowsAgents);
    }

    private void showAndAddListeners() {
        this.show();
        String s = MessageLog.getMessageNoID("ADG0302L");
        guiMain.setSaveActionEnabled(true, false);
        guiMain.setSaveActionToolTip(s);
        guiMain.addSaveActionListener(this);
    }

    public void losingFocus() {
        guiMain.setSaveActionEnabled(false, false);
        guiMain.setSaveActionToolTip(null);
        guiMain.removeSaveActionListener(this);
    }

    public boolean isEditable() {
        return true;
    }

    public boolean changesPending() {
        if (this.dataArray != null) {
            for (int i = 0; i < this.dataArray.length; ++i) {
                NasFilesystem node = this.dataArray[i];
                if (node.nflRepoAgentID == node.nflAgentID) continue;
                return true;
            }
        }
        return false;
    }

    public void saveAndClose() {
        this.closing = true;
        this.save();
    }

    private void save() {
        if (this.dataArray == null) {
            return;
        }
        HashMap<MutableInteger, NasFilesystem> deleteMap = new HashMap<MutableInteger, NasFilesystem>();
        MutableInteger key = new MutableInteger();
        NasFilesystem updateList = null;
        for (int i = 0; i < this.dataArray.length; ++i) {
            NasFilesystem node = this.dataArray[i];
            if (node.nflRepoAgentID == node.nflAgentID) continue;
            node.nflDeleteFiler = false;
            node.nflNext = updateList;
            updateList = node;
            if (node.nflAgentID != 0) continue;
            key.value = node.nflComputerID;
            if (deleteMap.get(key) != null) continue;
            deleteMap.put(key, node);
            key = new MutableInteger();
        }
        if (updateList != null) {
            String[] deletes;
            this.updateArray = (NasFilesystem[])Packer.pack(updateList);
            if (!deleteMap.isEmpty() && (deletes = this.getFilerDeletes(deleteMap, key)) != null && !this.showConfirmDialog(deletes)) {
                return;
            }
            Arrays.sort(this.updateArray, new ComputerComparator());
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.nas.NasGuiAgentHndlr";
            request.requestData = this.updateArray;
            request.flags = (byte)4;
            GuiClient.doRequest(this, request);
        }
    }

    private String[] getFilerDeletes(HashMap deleteMap, MutableInteger key) {
        for (int i = 0; i < this.dataArray.length; ++i) {
            NasFilesystem node = this.dataArray[i];
            if (node.nflAgentID == 0) continue;
            key.value = node.nflComputerID;
            deleteMap.remove(key);
        }
        if (deleteMap.isEmpty()) {
            return null;
        }
        String[] deletes = new String[deleteMap.size()];
        int index = 0;
        for (NasFilesystem node : deleteMap.values()) {
            node.nflDeleteFiler = true;
            deletes[index++] = node.nflServerName;
        }
        return deletes;
    }

    private boolean showConfirmDialog(String[] deletes) {
        String title = MessageLog.getMessageNoID("GUI0045L");
        String question = MessageLog.getMessageNoID("GUI0261L", null);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 10));
        Color background = panel.getBackground();
        JTextArea text = new JTextArea();
        text.setEditable(false);
        text.setBackground(background);
        text.setText(question);
        text.setFont(text.getFont().deriveFont(1));
        panel.add((Component)text, "North");
        JList<String> list = new JList<String>(deletes);
        list.setBackground(background);
        list.setVisibleRowCount(3);
        JComponent c = deletes.length > 3 ? new JScrollPane(list) : list;
        panel.add(c, "Center");
        int response = JOptionPane.showConfirmDialog(guiMain.getFrame(), panel, title, 0);
        return response == 0;
    }

    public void handleResponse(short status, Response response) {
        boolean wasClosing = this.closing;
        this.closing = false;
        if (status > 4) {
            return;
        }
        if (wasClosing) {
            this.remove();
            return;
        }
        this.massageData((Object[])response.responseData);
        this.buildEditor();
        if (!this.dataRetrieved) {
            this.dataRetrieved = true;
            this.showAndAddListeners();
            return;
        }
        this.currentPanelReplaced();
        this.updateArray = null;
    }

    private void massageData(Object[] array) {
        this.dataArray = (NasFilesystem[])array[0];
        this.treeList = null;
        this.windowsAgents = null;
        int count = this.dataArray == null ? 0 : this.dataArray.length;
        if (count > 0) {
            int i;
            String[] buffer = new String[3];
            for (i = 0; i < count; ++i) {
                NasFilesystem node = this.dataArray[i];
                GComputer computer = GuiUtil.getComputer(node.nflComputerID);
                node.nflOsType = computer.gcOsType;
                node.nflManufacturer = computer.gcManufacturer;
                if (computer.gcManufacturer.toLowerCase().equals("unknown")) {
                    node.nflManufacturer = MessageLog.getMessageNoID("STG1020L");
                }
                if (computer.gcOsType == 8) {
                    node.nflNasBox = false;
                    NasFiler.parseNetWareName(computer.gcTSName, buffer);
                    node.nflServerName = buffer[0];
                    node.nflDomainName = buffer[1];
                    node.nflTreeName = buffer[2];
                } else {
                    node.nflNasBox = true;
                    node.nflServerName = computer.gcTSName;
                    node.nflTreeName = " ";
                }
                if (node.nflAgentID <= 0) continue;
                node.nflRepoAgentID = node.nflAgentID;
                node.nflAgentName = GuiUtil.getComputer((int)node.nflAgentID).gcTSName;
            }
            Arrays.sort(this.dataArray, new TableComparator());
            this.windowsAgents = (NameList[])array[2];
            for (i = 0; i < this.windowsAgents.length; ++i) {
                this.windowsAgents[i].nlName = GuiUtil.getComputer((int)this.windowsAgents[i].nlID2).gcTSName;
            }
            NameListComparator Sorter2 = new NameListComparator();
            Arrays.sort(this.windowsAgents, Sorter2);
            this.buildAgents((NameList[])array[1], Sorter2);
        }
    }

    private void buildAgents(NameList[] agents, NameListComparator Sorter2) {
        NasFilesystem fsNode;
        if (agents != null && agents.length > 0) {
            int agentCount;
            NameList netAgentList = null;
            NameList nasAgentList = null;
            NameList workNode = null;
            NameList netPrevNode = null;
            NameList nasPrevNode = null;
            for (int i = 0; i < agents.length; ++i) {
                workNode = agents[i];
                if (workNode.nlID3 == 68) {
                    if (nasAgentList == null) {
                        nasAgentList = workNode;
                    } else {
                        nasPrevNode.nlNext = workNode;
                    }
                    nasPrevNode = workNode;
                    continue;
                }
                if (netAgentList == null) {
                    netAgentList = workNode;
                } else {
                    netPrevNode.nlNext = workNode;
                }
                netPrevNode = workNode;
            }
            if (nasPrevNode != null) {
                nasPrevNode.nlNext = null;
            }
            if (netPrevNode != null) {
                netPrevNode.nlNext = null;
            }
            NameList agentNode = netAgentList;
            while (agentNode != null) {
                agentCount = 0;
                workNode = agentNode;
                while (agentNode != null && agentNode.nlID == workNode.nlID) {
                    ++agentCount;
                    agentNode = agentNode.nlNext;
                }
                ListNode listNode = new ListNode();
                listNode.next = this.treeList;
                this.treeList = listNode;
                listNode.ID = workNode.nlID;
                listNode.name = workNode.nlName;
                NameList[] agentArray = new NameList[agentCount];
                listNode.agentArray = agentArray;
                for (int i = 0; i < agentArray.length; ++i) {
                    workNode.nlName = GuiUtil.getComputer((int)workNode.nlID2).gcTSName;
                    agentArray[i] = workNode;
                    workNode = workNode.nlNext;
                }
                Arrays.sort(agentArray, Sorter2);
            }
            fsNode = null;
            agentNode = nasAgentList;
            while (agentNode != null) {
                int index;
                agentCount = 0;
                workNode = agentNode;
                while (agentNode != null && agentNode.nlID == workNode.nlID) {
                    ++agentCount;
                    agentNode = agentNode.nlNext;
                }
                for (index = 0; index < this.dataArray.length; ++index) {
                    if (this.dataArray[index].nflFsID != workNode.nlID) continue;
                    fsNode = this.dataArray[index];
                    break;
                }
                if (index >= this.dataArray.length) continue;
                NameList[] agentArray = fsNode.nflSeenFromWindows ? new NameList[agentCount + this.windowsAgents.length] : new NameList[agentCount];
                fsNode.nflAgentArray = agentArray;
                for (int i = 0; i < agentCount; ++i) {
                    workNode.nlName = GuiUtil.getComputer((int)workNode.nlID2).gcTSName;
                    agentArray[i] = workNode;
                    workNode = workNode.nlNext;
                }
                if (fsNode.nflSeenFromWindows) {
                    System.arraycopy(this.windowsAgents, 0, agentArray, agentCount, this.windowsAgents.length);
                }
                Arrays.sort(agentArray, Sorter2);
            }
        }
        for (int k = 0; k < this.dataArray.length; ++k) {
            fsNode = this.dataArray[k];
            if (!fsNode.nflSeenFromWindows || fsNode.nflAgentArray != null) continue;
            fsNode.nflAgentArray = this.windowsAgents;
        }
    }

    public void actionPerformed(ActionEvent event) {
        this.save();
    }

    class ListNode {
        public ListNode next;
        public int ID;
        public String name;
        public NameList[] agentArray;

        ListNode() {
        }
    }

    private class NameListComparator
    implements Comparator {
        private NameListComparator() {
        }

        public int compare(Object o1, Object o2) {
            NameList n1 = (NameList)o1;
            NameList n2 = (NameList)o2;
            return n1.toString().compareTo(n2.toString());
        }
    }

    private class ComputerComparator
    implements Comparator {
        private ComputerComparator() {
        }

        public int compare(Object o1, Object o2) {
            NasFilesystem nfs1 = (NasFilesystem)o1;
            NasFilesystem nfs2 = (NasFilesystem)o2;
            int result = nfs1.nflComputerID - nfs2.nflComputerID;
            if (result == 0) {
                result = nfs1.nflAgentID - nfs2.nflAgentID;
            }
            return result;
        }
    }

    private class TableComparator
    implements Comparator {
        private TableComparator() {
        }

        public int compare(Object o1, Object o2) {
            NasFilesystem r1 = (NasFilesystem)o1;
            NasFilesystem r2 = (NasFilesystem)o2;
            int x = Util.compareStrings(r1.nflServerName, r2.nflServerName);
            if (x != 0) {
                return x;
            }
            x = Util.compareStrings(r1.nflDomainName, r2.nflDomainName);
            if (x != 0) {
                return x;
            }
            x = Util.compareStrings(r1.nflTreeName, r2.nflTreeName);
            if (x != 0) {
                return x;
            }
            return Util.compareStrings(r1.nflFsName, r2.nflFsName);
        }
    }
}

