/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.Nas.gui.admin;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.eclipse.aperi.Nas.gui.admin.NasAgentDDI;
import org.eclipse.aperi.TStorm.common.NasFilesystem;
import org.eclipse.aperi.TStorm.gui.PrimitiveConditionEditor;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BlackLabel;
import org.eclipse.aperi.gui.DataDisplayInfo;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.Help;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.xmsg.MessageLog;

public class NasAgentPanel
extends JPanel
implements ActionListener {
    private MegaTable table = new MegaTable();
    private NasFilesystem[] dataArray;
    private NasFilesystem[] selectedFsArray;
    private NasAgentDDI.ListNode treeList;
    private NameList[] dummyArray;
    private NameList[] windowsAgents;
    private String actionCommand;
    private JButton editButton1;
    private JButton editButton2;
    private JButton okButton;
    private JButton cancelButton;
    private JDialog editDialog;
    private JLabel serverLabel;
    private JLabel domainLabel;
    private JLabel treeLabel;
    private JLabel nameLabel;
    private JLabel agentLabel;
    private JLabel serverField;
    private JLabel domainField;
    private JLabel treeField;
    private JLabel nameField;
    private TComboBox agentBox;
    private JLabel waitLabel1;
    private boolean dblClick;
    private boolean setAll;
    static final byte FOUND = 0;
    static final byte NOT_FOUND = 1;
    private DataDisplayInfo ddi;
    private TableMouseListener mouseListener;
    static final String EDIT1 = MessageLog.getMessageNoID("NAG0013L");
    static final String EDIT2 = MessageLog.getMessageNoID("NAG0014L");
    static final String SAVE = MessageLog.getMessageNoID("GUI0113L");
    static final String CANCEL = MessageLog.getMessageNoID("GUI0114L");
    static final String SERVER = MessageLog.getMessageNoID("NAG0015L");
    static final String DOMAIN = MessageLog.getMessageNoID("NAG0016L");
    static final String TREE = MessageLog.getMessageNoID("NAG0002L");
    static final String NAME = MessageLog.getMessageNoID("STG5003L");
    static final String AGENT = MessageLog.getMessageNoID("NAG0045L");
    static final String NONE = MessageLog.getMessageNoID("NAG0032L");
    static final String[] colNames = new String[]{SERVER, DOMAIN, TREE, NAME, AGENT};
    static final int SERVER_COL = 0;
    static final int DOMAIN_COL = 1;
    static final int TREE_COL = 2;
    static final int NAME_COL = 3;
    static final int AGENT_COL = 4;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public NasAgentPanel(DataDisplayInfo ddi, NasFilesystem[] dataArray, NasAgentDDI.ListNode treeList, NameList[] windowsAgents) {
        this.ddi = ddi;
        this.dataArray = dataArray;
        this.windowsAgents = windowsAgents;
        this.treeList = treeList;
        this.setLayout(new BorderLayout());
        this.dummyArray = new NameList[1];
        this.dummyArray[0] = new NameList();
        this.dummyArray[0].nlName = NONE;
        this.dummyArray[0].nlID = -1;
        this.mouseListener = new TableMouseListener();
        this.editButton1 = new JButton(EDIT1);
        this.editButton1.setEnabled(false);
        this.editButton1.setActionCommand(EDIT1);
        this.editButton1.addActionListener(this);
        GuiUtil.setAccessible(this.editButton1, this.editButton1.getText(), this.editButton1.getText());
        this.editButton1.setToolTipText(Util.getString("TOOLTIP_BUTTON_AGENTROW"));
        this.editButton2 = new JButton(EDIT2);
        this.editButton2.setEnabled(false);
        this.editButton2.setActionCommand(EDIT2);
        this.editButton2.addActionListener(this);
        GuiUtil.setAccessible(this.editButton2, this.editButton2.getText(), this.editButton2.getText());
        this.editButton2.setToolTipText(Util.getString("TOOLTIP_BUTTON_AGENTALL"));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.editButton1);
        buttonPanel.add(this.editButton2);
        this.add((Component)buttonPanel, "North");
        if (dataArray == null || dataArray.length == 0) {
            JPanel nonePanel = new JPanel();
            nonePanel.add(new JLabel(MessageLog.getMessageNoID("STG0020M")));
            this.add((Component)nonePanel, "Center");
        } else {
            this.table.setBaseTableModel(new TableModel());
            this.table.setMouseListener(this.mouseListener);
            this.add((Component)this.table, "Center");
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.updateDataArray();
            this.editDialog.dispose();
        } else if (source == this.cancelButton) {
            this.editDialog.dispose();
        } else {
            this.setAll = source != this.editButton1;
            this.editSelected();
        }
    }

    private void editSelected() {
        int[] selectedRows = this.table.getSelectedRows();
        int rowCount = selectedRows.length;
        if (this.setAll) {
            this.selectedFsArray = new NasFilesystem[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                this.selectedFsArray[i] = this.dataArray[selectedRows[i]];
            }
            this.editInstance();
        } else {
            this.selectedFsArray = new NasFilesystem[1];
            for (int i = 0; i < rowCount; ++i) {
                this.selectedFsArray[0] = this.dataArray[selectedRows[i]];
                this.editInstance();
            }
        }
        this.editButton1.setEnabled(false);
        this.editButton2.setEnabled(false);
    }

    private void editInstance() {
        NameList[] agentList;
        NasFilesystem editFS = this.selectedFsArray[0];
        this.editDialog = new JDialog(this.guiMain.getFrame(), true);
        this.editDialog.setTitle(MessageLog.getMessageNoID("NAG0020L"));
        if (this.okButton == null) {
            this.okButton = new JButton(SAVE);
            this.okButton.setActionCommand(SAVE);
            this.cancelButton = new JButton(CANCEL);
            this.cancelButton.setActionCommand(CANCEL);
            this.serverLabel = new BlackLabel(SERVER);
            this.domainLabel = new BlackLabel(DOMAIN);
            this.treeLabel = new BlackLabel(TREE);
            this.nameLabel = new BlackLabel(NAME);
            this.agentLabel = new BlackLabel(AGENT);
            this.waitLabel1 = new BlackLabel(" ");
            this.waitLabel1.setFont(BaseTree.plainFont);
            this.okButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
        }
        this.okButton.setEnabled(true);
        this.serverField = new JLabel(editFS.nflServerName);
        this.domainField = new JLabel(editFS.nflDomainName);
        this.treeField = new JLabel(editFS.nflTreeName);
        this.nameField = new JLabel(editFS.nflFsName);
        NameList[] treeAgentList = this.getTreeAgents();
        NameList[] nasAgentList = this.getNasAgents();
        if (treeAgentList != null && nasAgentList != null) {
            treeAgentList = this.mergeLists(treeAgentList, nasAgentList);
        }
        if ((agentList = treeAgentList != null ? treeAgentList : nasAgentList) == null) {
            this.waitLabel1.setText(MessageLog.getMessageNoID("NAG0007L"));
            this.agentBox = new TComboBox(this.dummyArray);
        } else {
            this.waitLabel1.setText(" ");
            Object[] comboBoxArray = new NameList[1 + agentList.length];
            comboBoxArray[0] = this.dummyArray[0];
            System.arraycopy(agentList, 0, comboBoxArray, 1, agentList.length);
            this.agentBox = new TComboBox(comboBoxArray);
            int index = 0;
            for (int i = 0; i < comboBoxArray.length; ++i) {
                if (((NameList)comboBoxArray[i]).nlID2 != editFS.nflAgentID) continue;
                index = i;
                break;
            }
            this.agentBox.setSelectedIndex(index);
        }
        GuiUtil.setAccessibleLabel(this.agentLabel, this.agentBox, "MNEMONIC_LABEL_AGENT", this.agentLabel.getText(), this.agentLabel.getText());
        JPanel editPanel = new JPanel();
        editPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.left = 8;
        gbc.insets.top = 4;
        gbc.insets.bottom = 4;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        JPanel textPanel = new JPanel(new GridBagLayout());
        Color background = textPanel.getBackground();
        JTextArea text = new JTextArea();
        text.setBackground(background);
        text.setEditable(false);
        text.setRows(3);
        text.setLineWrap(true);
        text.setWrapStyleWord(GuiUtil.wrapAtWords());
        text.setText(MessageLog.getMessageNoID("ADG0303L"));
        text.setFont(text.getFont().deriveFont(1));
        textPanel.add((Component)text, gbc);
        this.addSeparator(editPanel, gbc);
        this.addLabeledComponent(this.serverLabel, this.serverField, editPanel, gbc);
        this.addLabeledComponent(this.domainLabel, this.domainField, editPanel, gbc);
        this.addLabeledComponent(this.treeLabel, this.treeField, editPanel, gbc);
        this.addLabeledComponent(this.nameLabel, this.nameField, editPanel, gbc);
        this.addLabeledComponent(this.agentLabel, this.agentBox, editPanel, gbc);
        this.addSeparator(editPanel, gbc);
        gbc.insets.bottom = 0;
        editPanel.add((Component)this.waitLabel1, gbc);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        Container pane = this.editDialog.getContentPane();
        pane.add((Component)textPanel, "North");
        pane.add((Component)editPanel, "Center");
        pane.add((Component)buttonPanel, "South");
        Help.setHelpID(this.editDialog.getRootPane(), "asco65");
        this.editDialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(156, 0), 2);
        this.editDialog.getRootPane().registerKeyboardAction(Help.getDisplayHelpFromSource(), KeyStroke.getKeyStroke(112, 0), 2);
        this.editDialog.getRootPane().setDefaultButton(this.okButton);
        GuiUtil.centerDialog(this.editDialog);
        this.editDialog.pack();
        this.editDialog.show();
    }

    private void addLabeledComponent(JLabel label, JComponent component, JPanel editPanel, GridBagConstraints gbc) {
        gbc.gridwidth = 1;
        editPanel.add((Component)label, gbc);
        editPanel.add((Component)component, gbc);
        gbc.gridwidth = 0;
        editPanel.add(Box.createVerticalStrut(8), gbc);
    }

    private void addSeparator(JPanel editPanel, GridBagConstraints gbc) {
        Color separatorColor = this.getBackground();
        PrimitiveConditionEditor.HorizontalSeparator separator = new PrimitiveConditionEditor.HorizontalSeparator(separatorColor);
        gbc.gridwidth = 0;
        gbc.insets.right = 8;
        editPanel.add((Component)separator, gbc);
        gbc.insets.right = 0;
    }

    private NameList[] getTreeAgents() {
        NasFilesystem fsNode = null;
        NameList[] agentList = null;
        for (int firstTreeIX = 0; firstTreeIX < this.selectedFsArray.length; ++firstTreeIX) {
            if (this.selectedFsArray[firstTreeIX].nflAgentArray != null) continue;
            fsNode = this.selectedFsArray[firstTreeIX];
            break;
        }
        if (fsNode != null) {
            NasAgentDDI.ListNode treeNode = this.treeList;
            while (treeNode != null) {
                if (treeNode.name.equals(fsNode.nflTreeName)) {
                    agentList = treeNode.agentArray;
                    break;
                }
                treeNode = treeNode.next;
            }
            if (agentList != null && this.selectedFsArray.length > 1) {
                NameList matchNode;
                NameList agentHdr = null;
                for (int j = 0; j < agentList.length; ++j) {
                    agentList[j].nlState = 0;
                    agentList[j].nlNext = agentHdr;
                    agentHdr = agentList[j];
                }
                for (int k = firstTreeIX + 1; k < this.selectedFsArray.length; ++k) {
                    NasFilesystem restFS = this.selectedFsArray[k];
                    if (restFS.nflAgentArray != null) continue;
                    treeNode = this.treeList;
                    while (treeNode != null) {
                        if (treeNode.name.equals(restFS.nflTreeName)) {
                            NameList[] restArray = treeNode.agentArray;
                            matchNode = agentHdr;
                            while (matchNode != null) {
                                int restIX;
                                for (restIX = 0; restIX < restArray.length && restArray[restIX].nlID2 != matchNode.nlID2; ++restIX) {
                                }
                                if (restIX >= restArray.length) {
                                    matchNode.nlState = 1;
                                }
                                matchNode = matchNode.nlNext;
                            }
                            break;
                        }
                        treeNode = treeNode.next;
                    }
                    if (treeNode != null) continue;
                    agentList = null;
                    break;
                }
                if (agentList != null) {
                    int matchCount = 0;
                    int totalCount = 0;
                    matchNode = agentHdr;
                    while (matchNode != null) {
                        if (matchNode.nlState == 0) {
                            ++matchCount;
                        }
                        ++totalCount;
                        matchNode = matchNode.nlNext;
                    }
                    if (matchCount == 0) {
                        agentList = null;
                    } else if (matchCount != totalCount) {
                        agentList = new NameList[matchCount];
                        int matchIX = 0;
                        matchNode = agentHdr;
                        while (matchNode != null) {
                            if (matchNode.nlState == 0) {
                                agentList[matchIX] = matchNode;
                                ++matchIX;
                            }
                            matchNode = matchNode.nlNext;
                        }
                    }
                }
            }
        }
        return agentList;
    }

    private NameList[] getNasAgents() {
        NameList[] agentList = null;
        for (int firstNasIX = 0; firstNasIX < this.selectedFsArray.length; ++firstNasIX) {
            if (this.selectedFsArray[firstNasIX].nflAgentArray == null) continue;
            agentList = this.selectedFsArray[firstNasIX].nflAgentArray;
            break;
        }
        if (agentList != null && this.selectedFsArray.length > 1) {
            NameList matchNode;
            NameList agentHdr = null;
            for (int j = 0; j < agentList.length; ++j) {
                agentList[j].nlState = 0;
                agentList[j].nlNext = agentHdr;
                agentHdr = agentList[j];
            }
            for (int k = firstNasIX + 1; k < this.selectedFsArray.length; ++k) {
                NasFilesystem restFS = this.selectedFsArray[k];
                if (restFS.nflAgentArray == null) continue;
                NameList[] restArray = restFS.nflAgentArray;
                matchNode = agentHdr;
                while (matchNode != null) {
                    int restIX;
                    for (restIX = 0; restIX < restArray.length && restArray[restIX].nlID2 != matchNode.nlID2; ++restIX) {
                    }
                    if (restIX >= restArray.length) {
                        matchNode.nlState = 1;
                    }
                    matchNode = matchNode.nlNext;
                }
            }
            if (agentList != null) {
                int matchCount = 0;
                int totalCount = 0;
                matchNode = agentHdr;
                while (matchNode != null) {
                    if (matchNode.nlState == 0) {
                        ++matchCount;
                    }
                    ++totalCount;
                    matchNode = matchNode.nlNext;
                }
                if (matchCount == 0) {
                    agentList = null;
                } else if (matchCount != totalCount) {
                    agentList = new NameList[matchCount];
                    int matchIX = 0;
                    matchNode = agentHdr;
                    while (matchNode != null) {
                        if (matchNode.nlState == 0) {
                            agentList[matchIX] = matchNode;
                            ++matchIX;
                        }
                        matchNode = matchNode.nlNext;
                    }
                }
            }
        }
        return agentList;
    }

    private NameList[] mergeLists(NameList[] treeAgentList, NameList[] nasAgentList) {
        NameList[] mergedList = null;
        int count = 0;
        block0: for (int i = 0; i < treeAgentList.length; ++i) {
            treeAgentList[i].nlState = 1;
            for (int j = 0; j < nasAgentList.length; ++j) {
                if (nasAgentList[j].nlID2 != treeAgentList[i].nlID2) continue;
                treeAgentList[i].nlState = 0;
                ++count;
                continue block0;
            }
        }
        if (count > 0) {
            mergedList = new NameList[count];
            int m = 0;
            for (int k = 0; k < treeAgentList.length; ++k) {
                if (treeAgentList[k].nlState != 0) continue;
                mergedList[m] = treeAgentList[k];
                ++m;
            }
        }
        return mergedList;
    }

    private void updateDataArray() {
        NameList node = (NameList)this.agentBox.getSelectedItem();
        for (int i = 0; i < this.selectedFsArray.length; ++i) {
            this.selectedFsArray[i].nflAgentID = node.nlID2;
            this.selectedFsArray[i].nflAgentName = node.nlID2 > 0 ? node.nlName : "";
        }
    }

    static /* synthetic */ NasFilesystem[] access$602(NasAgentPanel x0, NasFilesystem[] x1) {
        x0.selectedFsArray = x1;
        return x1;
    }

    private class TableMouseListener
    extends TJCTableMouseAdapter {
        private TableMouseListener() {
        }

        public boolean select(int viewRow, int viewCol) {
            boolean selectIt = ((NasAgentPanel)NasAgentPanel.this).guiMain.getUserPrefs().administrator;
            if (NasAgentPanel.this.dblClick) {
                selectIt = NasAgentPanel.this.dblClick = false;
            }
            return selectIt;
        }

        public void selectionChanged(boolean state) {
            NasAgentPanel.this.editButton1.setEnabled(state);
            NasAgentPanel.this.editButton2.setEnabled(state);
        }

        public void doubleClick(int dataRow, int dataCol) {
            if (((NasAgentPanel)NasAgentPanel.this).guiMain.getUserPrefs().administrator) {
                NasAgentPanel.access$602(NasAgentPanel.this, new NasFilesystem[1]);
                ((NasAgentPanel)NasAgentPanel.this).selectedFsArray[0] = NasAgentPanel.this.dataArray[dataRow];
                NasAgentPanel.this.editInstance();
                NasAgentPanel.this.dblClick = true;
            }
        }
    }

    private class TableModel
    extends BaseTableModel {
        public TableModel() {
            this.columnNames = colNames;
            this.rowCount = NasAgentPanel.this.dataArray.length;
        }

        public Object getTableDataItem(int rowNum, int colNum) {
            String data = null;
            if (colNum == 0) {
                data = ((NasAgentPanel)NasAgentPanel.this).dataArray[rowNum].nflServerName;
            } else if (colNum == 1) {
                data = ((NasAgentPanel)NasAgentPanel.this).dataArray[rowNum].nflDomainName;
            } else if (colNum == 2) {
                data = ((NasAgentPanel)NasAgentPanel.this).dataArray[rowNum].nflTreeName;
            } else if (colNum == 3) {
                data = ((NasAgentPanel)NasAgentPanel.this).dataArray[rowNum].nflFsName;
            } else if (colNum == 4) {
                data = ((NasAgentPanel)NasAgentPanel.this).dataArray[rowNum].nflAgentName;
            }
            return data;
        }
    }
}

