/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.common;

import java.util.Date;
import java.util.HashMap;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ComputerList;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class LunWWNAdjuster
extends CustomReportDataAdjuster {
    static final String SUBSYSTEM = MessageLog.getMessageNoID("SAG0001L");
    static final String LUN_NAME = MessageLog.getMessageNoID("SAG0514L");
    static final String LUN_WWN = MessageLog.getMessageNoID("SAG0620L");
    static final String HBA_WWN = MessageLog.getMessageNoID("STG3902L");
    static final String HBA_HOST = MessageLog.getMessageNoID("STG3903L");
    static final String CAPACITY = MessageLog.getMessageNoID("SAG0010L");
    static final String SRM_AGENT = MessageLog.getMessageNoID("STG3904L");
    static final String SRM_NETWORK = MessageLog.getMessageNoID("STG3912L");
    static final String SRM_OSTYPE = MessageLog.getMessageNoID("STG3905L");
    static final String DISK_PATH = MessageLog.getMessageNoID("STG3906L");
    static final String DISK_CAP = MessageLog.getMessageNoID("STG3907L");
    static final String DISK_FREE = MessageLog.getMessageNoID("STG3908L");
    static final String WWN_MATCH = MessageLog.getMessageNoID("STG3911L");
    static final String FORMAT = MessageLog.getMessageNoID("SAG0033L");
    static final String MANUFACTURER = MessageLog.getMessageNoID("STG1105L");
    static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    static final String PROBE_TIME = MessageLog.getMessageNoID("STG1182L");
    private static final String UNKNOWN = MessageLog.getMessageNoID("GUI0129T");
    public static final String YES = MessageLog.getMessageNoID("GUI0121T");
    public static final String NO = MessageLog.getMessageNoID("GUI0122T");
    public static final String NA = MessageLog.getMessageNoID("STG0019T");
    public static final String FIXBLK = MessageLog.getMessageNoID("SAG0034L");
    public static final String ZSERIES = MessageLog.getMessageNoID("SAG0035L");
    private static final int SUBSYSTEM_COL = 0;
    private static final int LUN_NAME_COL = 1;
    private static final int LUN_WWN_COL = 2;
    private static final int HBA_WWN_COL = 3;
    private static final int HBA_HOST_COL = 4;
    private static final int CAPACITY_COL = 5;
    private int SRM_HOST_COL = 6;
    private int SRM_NETWORK_COL = 7;
    private int SRM_OSTYPE_COL = 8;
    private int DISK_PATH_COL = 9;
    private int DISK_CAP_COL = 10;
    private int DISK_FREE_COL = 11;
    private int WWN_MATCH_COL = 12;
    private int FORMAT_COL = 13;
    private int MANUFACTURER_COL = 14;
    private int MODEL_COL = 15;
    private int PROBE_TIME_COL = 16;
    public String[] colNames;
    public String[] colNames1 = new String[]{SUBSYSTEM, LUN_NAME, LUN_WWN, HBA_WWN, HBA_HOST, CAPACITY, SRM_AGENT, SRM_NETWORK, SRM_OSTYPE, DISK_PATH, DISK_CAP, DISK_FREE, WWN_MATCH, FORMAT, MANUFACTURER, MODEL, PROBE_TIME};
    public String[] colNames2 = new String[]{SUBSYSTEM, LUN_NAME, LUN_WWN, HBA_WWN, HBA_HOST, CAPACITY, FORMAT, MANUFACTURER, MODEL, PROBE_TIME};
    public String[] colNames3 = new String[]{SUBSYSTEM, LUN_NAME, LUN_WWN, HBA_WWN, HBA_HOST, CAPACITY, SRM_AGENT, SRM_NETWORK, SRM_OSTYPE, FORMAT, MANUFACTURER, MODEL, PROBE_TIME};
    private GuiReportReq grr;
    private Lun[] lunArray;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private int[] rendererArray;
    private ComputerList computerList;
    private int rowCount;
    public int frozenRows;
    public int totalRow;
    private boolean batch;
    private String helpID;
    private String[] osTypeNames = new String[28];

    public LunWWNAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.frozenColumns = 2;
        this.helpID = "ress35";
        if (grr.reportSubtype == 89) {
            this.colNames = this.colNames2;
            this.SRM_HOST_COL = -777;
            this.SRM_NETWORK_COL = -777;
            this.SRM_OSTYPE_COL = -777;
            this.DISK_PATH_COL = -777;
            this.DISK_CAP_COL = -777;
            this.DISK_FREE_COL = -777;
            this.WWN_MATCH_COL = -777;
            this.FORMAT_COL = 6;
            this.MANUFACTURER_COL = 7;
            this.MODEL_COL = 8;
            this.PROBE_TIME_COL = 9;
            this.helpID = "ress45";
        } else if (grr.reportSubtype == 90) {
            this.colNames = this.colNames3;
            this.SRM_HOST_COL = 6;
            this.SRM_NETWORK_COL = 7;
            this.SRM_OSTYPE_COL = 8;
            this.DISK_PATH_COL = -777;
            this.DISK_CAP_COL = -777;
            this.DISK_FREE_COL = -777;
            this.WWN_MATCH_COL = -777;
            this.FORMAT_COL = 9;
            this.MANUFACTURER_COL = 10;
            this.MODEL_COL = 11;
            this.PROBE_TIME_COL = 12;
            this.helpID = "ress50";
        } else {
            this.colNames = this.colNames1;
            this.SRM_HOST_COL = 6;
            this.SRM_NETWORK_COL = 7;
            this.SRM_OSTYPE_COL = 8;
            this.DISK_PATH_COL = 9;
            this.DISK_CAP_COL = 10;
            this.DISK_FREE_COL = 11;
            this.WWN_MATCH_COL = 12;
            this.FORMAT_COL = 13;
            this.MANUFACTURER_COL = 14;
            this.MODEL_COL = 15;
            this.PROBE_TIME_COL = 16;
            this.helpID = "ress35";
        }
        if (grr.reportSubtype == 18) {
            this.firstColumn = this.PROBE_TIME_COL;
        } else if (grr.reportSubtype == 78) {
            this.helpID = "ress40";
            this.firstColumn = 5;
        } else {
            this.firstColumn = 0;
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[this.PROBE_TIME_COL] = 1;
        this.rendererArray[5] = 7;
        if (this.DISK_CAP_COL > 0) {
            this.rendererArray[this.DISK_CAP_COL] = 7;
        }
        if (this.DISK_FREE_COL > 0) {
            this.rendererArray[this.DISK_FREE_COL] = 7;
        }
        this.colNames = this.getCustomizedColNames(this.colNames);
        for (int i = 0; i < 28; i = (int)((short)(i + 1))) {
            this.osTypeNames[i] = MessageLog.getMessageNoID(Constants.OSTYPES[i]);
        }
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.lunArray = (Lun[])dataArray;
        this.rowCount = this.lunArray.length;
        this.batch = batch;
        if (batch) {
            this.computerList = new ComputerList();
        }
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.mDate = new Date[this.rowCount];
        this.mLong = new MutableLong[this.rowCount];
        this.mInt = new MutableInteger[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            this.mDate[i] = new Date();
            this.mLong[i] = new MutableLong();
            this.mInt[i] = new MutableInteger();
        }
    }

    public void adjustData() {
        for (int i = 0; i < this.rowCount; ++i) {
            Lun lun = this.lunArray[i];
            lun.lunDiskCapacity *= 512L;
            lun.lunDiskFreespace *= 512L;
            LogicalDisk lDisk = lun.lunLogicalDisk;
            lDisk.ldCapacity *= 512L;
            if (lun.lunAgentID <= 0) continue;
            lun.lunGComputer = this.batch ? this.computerList.getComputer(lun.lunAgentID) : GuiUtil.getComputer(lun.lunAgentID);
        }
    }

    public void undo() {
        Lun lun = this.lunArray[0];
        lun.lunDiskCapacity /= 512L;
        lun.lunDiskFreespace /= 512L;
        LogicalDisk lDisk = lun.lunLogicalDisk;
        lDisk.ldCapacity /= 512L;
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        int[] format = new int[]{7, 8, 58, 9};
        int[] yesNo = new int[]{0, 1};
        colArray[this.FORMAT_COL].cdValidValue = format;
        if (this.SRM_OSTYPE_COL > -1) {
            colArray[this.SRM_OSTYPE_COL].cdValidValue = ColumnDescriptor.OS_TYPES_PLUS_UNKNOWN;
        }
        if (this.WWN_MATCH_COL > -1) {
            colArray[this.WWN_MATCH_COL].cdValidValue = yesNo;
        }
    }

    public int getNumberRows() {
        return this.lunArray.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public Object getArray() {
        return this.lunArray;
    }

    public Object getCellData(int row, int col) {
        if (row == 0 && this.bHasTotalRow && col != 0 && col != 5 && col != this.DISK_CAP_COL && col != this.DISK_FREE_COL) {
            return " ";
        }
        if (col == 0) {
            return this.lunArray[row].lunDaAlias;
        }
        if (col == 1) {
            int index;
            String lunName = this.lunArray[row].lunName;
            if (this.lunArray[row].lunOSType == 21 && (index = lunName.indexOf(":")) > 0) {
                lunName = lunName.substring(0, index);
            }
            return lunName;
        }
        if (col == 2) {
            String lunWWN = this.lunArray[row].lunWWN;
            if (Util.isEmpty(lunWWN)) {
                return UNKNOWN;
            }
            return lunWWN;
        }
        if (col == 3) {
            return this.lunArray[row].lunHBAWWN;
        }
        if (col == 4) {
            return this.lunArray[row].lunSSHost;
        }
        if (col == this.SRM_HOST_COL) {
            if (this.lunArray[row].lunAgentID < 1) {
                return " ";
            }
            return this.lunArray[row].lunGComputer.gcTSName;
        }
        if (col == this.SRM_NETWORK_COL) {
            if (this.lunArray[row].lunGComputer == null) {
                return " ";
            }
            return Util.getDotName(this.lunArray[row].lunGComputer.gcNetworkName, this.lunArray[row].lunGComputer.gcDomainName);
        }
        if (col == this.SRM_OSTYPE_COL) {
            return this.osTypeNames[this.lunArray[row].lunAgentOSType];
        }
        if (col == 5) {
            this.mLong[row].value = this.lunArray[row].lunLogicalDisk.ldCapacity;
            return this.mLong[row];
        }
        if (col == this.DISK_PATH_COL) {
            if (this.lunArray[row].lunDiskPath == null) {
                return " ";
            }
            return this.lunArray[row].lunDiskPath;
        }
        if (col == this.DISK_CAP_COL) {
            this.mLong[row].value = this.lunArray[row].lunDiskCapacity;
            return this.mLong[row];
        }
        if (col == this.DISK_FREE_COL) {
            this.mLong[row].value = this.lunArray[row].lunDiskFreespace;
            return this.mLong[row];
        }
        if (col == this.WWN_MATCH_COL) {
            return this.lunArray[row].lunLogicalDisk.ldIsSwap ? YES : NO;
        }
        if (col == this.FORMAT_COL) {
            if (this.lunArray[row].lunOSType != 12 && this.lunArray[row].lunOSType != 25 && this.lunArray[row].lunOSType != 27) {
                return UNKNOWN;
            }
            if (this.lunArray[row].lunOSType == 12) {
                if (this.lunArray[row].lunName.startsWith("1")) {
                    return FIXBLK;
                }
                return ZSERIES;
            }
            return LogicalDisk.FORMATS[this.lunArray[row].lunLogicalDisk.ldStorageType];
        }
        if (col == this.MANUFACTURER_COL) {
            if (this.lunArray[row].lunDaManufacturer.toLowerCase().equals("unknown")) {
                return MessageLog.getMessageNoID("STG1020L");
            }
            return this.lunArray[row].lunDaManufacturer;
        }
        if (col == this.MODEL_COL) {
            if (this.lunArray[row].lunOSType == 21) {
                return "2145";
            }
            return this.lunArray[row].lunDaModel;
        }
        if (col == this.PROBE_TIME_COL) {
            this.mDate[row].setTime(this.lunArray[row].lunProbeTime);
            return this.mDate[row];
        }
        return null;
    }

    private void addTotal() {
        Lun lun;
        long ldCapacity = 0L;
        long lDiskCapacity = 0L;
        long lDiskFree = 0L;
        HashMap<MutableInteger, Lun> map = new HashMap<MutableInteger, Lun>(100);
        MutableInteger key = new MutableInteger();
        Lun[] plusArray = new Lun[this.rowCount + 1];
        plusArray[0] = lun = new Lun();
        lun.lunLogicalDisk = new LogicalDisk();
        lun.lunDaAlias = MessageLog.getMessageNoID("STG4136L");
        for (int i = 0; i < this.rowCount; ++i) {
            key.value = this.lunArray[i].lunID;
            if (map.get(key) == null) {
                map.put(key, this.lunArray[i]);
                if (this.lunArray[i].lunLogicalDisk.ldCapacity > -1L) {
                    ldCapacity += this.lunArray[i].lunLogicalDisk.ldCapacity;
                }
                if (this.lunArray[i].lunDiskCapacity > -1L) {
                    lDiskCapacity += this.lunArray[i].lunDiskCapacity;
                }
                if (this.lunArray[i].lunDiskFreespace > -1L) {
                    lDiskFree += this.lunArray[i].lunDiskFreespace;
                }
            }
            plusArray[i + 1] = this.lunArray[i];
        }
        lun.lunLogicalDisk.ldCapacity = ldCapacity;
        lun.lunDiskCapacity = lDiskCapacity;
        lun.lunDiskFreespace = lDiskFree;
        this.lunArray = plusArray;
        this.bHasTotalRow = true;
        this.totalRow = 1;
        ++this.frozenRows;
        ++this.rowCount;
    }

    public String getHelpID() {
        return this.helpID;
    }
}

