/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import org.eclipse.aperi.TStorm.gui.BaseAlertLogTableData;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertLogTable;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.server.guireq.AlertLog;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskArrayAlertLogTableData
extends BaseAlertLogTableData {
    private static final int ACTIVE_COLUMN = 0;
    private static final int DISK_ARRAY_COLUMN = 1;
    private static final int COMPUTER_COLUMN = 2;
    private static final int DISK_COLUMN = 3;
    private static final int CONDITION_COLUMN = 4;
    private static final int FIRST_LOGGED_COLUMN = 5;
    private static final int LAST_LOGGED_COLUMN = 6;
    private static final int N_VIOLATIONS_COLUMN = 7;
    private static final int CREATOR_COLUMN = 8;
    private static final int NAME_COLUMN = 9;
    private static final int SCRIPT_NAME_COLUMN = 10;
    private static final int N_COLUMNS = 11;
    private static final String[] msgIDs = new String[]{null, "SAG0001L", "STG1102L", "STG1240L", "GUI2023L", "GUI2024L", "GUI2025L", "GUI2026L", "GUI2027L", "GUI2028L", "GUI2069L"};

    private static boolean isDiscoveryAlert(AlertLog record) {
        boolean result = false;
        switch (record.alAlertCondition) {
            case 64: 
            case 65: {
                result = true;
            }
        }
        return result;
    }

    private static boolean isDiskAlert(AlertLog record) {
        boolean result = false;
        switch (record.alAlertCondition) {
            case 5: 
            case 6: {
                result = true;
            }
        }
        return result;
    }

    public DiskArrayAlertLogTableData(AlertLogTable tbl, ExtAlertLog[] pArray) {
        super(tbl, pArray);
        this.columnNames = new String[11];
        this.columnNames[0] = " ";
        for (int i = 1; i < 11; ++i) {
            this.columnNames[i] = MessageLog.getMessageNoID(msgIDs[i]);
        }
    }

    public Object getTableDataItem(int row, int column) {
        ExtAlertLog record = this.array[row];
        Object result = null;
        switch (column) {
            case 0: {
                result = this.byteToObject(row, record.alState);
                break;
            }
            case 1: {
                if (DiskArrayAlertLogTableData.isDiskAlert(record)) {
                    result = record.alComputer;
                    break;
                }
                result = record.getAlObjectName();
                break;
            }
            case 2: {
                if (!DiskArrayAlertLogTableData.isDiscoveryAlert(record)) break;
                result = record.alComputer;
                break;
            }
            case 3: {
                if (!DiskArrayAlertLogTableData.isDiskAlert(record)) break;
                result = record.getAlObjectName();
                break;
            }
            case 4: {
                result = MessageLog.getMessageNoID(AlertConditionManager.getConditionMessageId(record.alAlertCondition));
                break;
            }
            case 5: {
                result = this.timestampToObject(row, record.alFirstAlertTime);
                break;
            }
            case 6: {
                result = this.timestampToObject(row, record.alLastAlertTime);
                break;
            }
            case 7: {
                result = this.intToObject(row, record.alAlertCount);
                break;
            }
            case 8: {
                result = record.alCreator;
                break;
            }
            case 9: {
                result = record.getAlName();
                break;
            }
            case 10: {
                if (Util.isEmpty(record.alScriptLogFile)) break;
                result = record.alScriptName;
            }
        }
        if (result == null) {
            result = AlertLogDDI.notApplicableText;
        }
        return result;
    }

    public void hideColumns(MegaTable table) {
    }

    public int getNumberColumns() {
        return 11;
    }

    public int[] getRenderers() {
        int[] rendererArray = new int[11];
        rendererArray[5] = 1;
        rendererArray[6] = 1;
        rendererArray[7] = 5;
        return rendererArray;
    }

    public int[] getHiddenColumns() {
        return null;
    }
}

