/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.eclipse.aperi.San.gui.ArraySiteTreeLabel;
import org.eclipse.aperi.San.gui.DiskArrayDDI;
import org.eclipse.aperi.San.gui.DiskGroupTreeLabel;
import org.eclipse.aperi.San.gui.LUNTreeLabel;
import org.eclipse.aperi.San.gui.LocalControllerTreeLabel;
import org.eclipse.aperi.San.gui.LocalDiskTreeLabel;
import org.eclipse.aperi.San.gui.RankTreeLabel;
import org.eclipse.aperi.San.gui.RemoteControllerTreeLabel;
import org.eclipse.aperi.San.gui.RemoteDiskTreeLabel;
import org.eclipse.aperi.San.gui.VolumeSpaceTreeLabel;
import org.eclipse.aperi.TStorm.gui.VolumeGroupTreeLabel;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AlertableTreeNode;

public class DiskArrayTreeNode
extends AlertableTreeNode {
    public DiskArrayTreeNode(NameList element) {
        super(element.nlID);
        this.setUserObject(element);
        this.reset();
    }

    protected NameList getNameList() {
        return (NameList)this.getUserObject();
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() > 0) {
            return;
        }
        NameList element = this.getNameList();
        if (Constants.hasDiskGroupInfo((short)element.nlID2)) {
            this.add(new DiskGroupTreeLabel(element));
        }
        if (Constants.hasArraySiteInfo((short)element.nlID2)) {
            this.add(new ArraySiteTreeLabel(element));
        }
        if (Constants.hasRankInfo((short)element.nlID2)) {
            this.add(new RankTreeLabel(element, -1));
        }
        if (Constants.hasStoragePoolInfo((short)element.nlID2)) {
            if (element.nlID2 == 21) {
                this.add(new VolumeGroupTreeLabel(element));
            } else {
                this.add(new VolumeSpaceTreeLabel(element, -1));
            }
        }
        if (element.nlID2 == 11) {
            this.add(new LocalControllerTreeLabel(element));
        }
        if (Constants.hasDiskInfo((short)element.nlID2)) {
            this.add(new LocalDiskTreeLabel(element, -1));
        }
        this.add(new LUNTreeLabel(element, -1, -1));
        if (element.nlID2 == 11) {
            this.add(new RemoteControllerTreeLabel(element));
            this.add(new RemoteDiskTreeLabel(element, -1));
        }
    }

    public void select(TreeSelectionEvent event) {
        new DiskArrayDDI(this, this.getNameList());
    }
}

