/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.San.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.San.gui.PerfAlertEditor;
import org.eclipse.aperi.San.gui.SubsystemAlertCreateOrEdit;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.SubsystemAlertSelector;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.gui.TTextField;

public class SubsystemAlertEditor
extends PerfAlertEditor
implements ActionListener {
    private SubsystemAlertCreateOrEdit daCOE;
    private SubsystemAlertSelector subsystemSelector;
    protected JCheckBox suppressCheckBox;
    protected TTextField suppressThresholdEntry;
    protected JLabel suppressThresholdPercent;
    protected static final String SUPPRESS_THRESHOLD_DEFAULT_VALUE = "80";
    protected int suppressThresholdValue = -1;

    public SubsystemAlertEditor(SubsystemAlertCreateOrEdit daCOE) {
        this.daCOE = daCOE;
    }

    public SubsystemAlertEditor(SubsystemAlertCreateOrEdit daCOE, AlertHeader alertHeader) {
        super(alertHeader);
        this.daCOE = daCOE;
    }

    protected void initAlert() {
        super.initAlert();
        this.alert.aldProductID = (short)3;
        this.alert.aldType = (short)20;
        this.alert.aldCondition = (short)64;
    }

    protected JPanel buildConditionPanel() {
        JPanel conditionPanel = super.buildConditionPanel();
        this.suppressCheckBox = new JCheckBox(Util.getString("DISK_SUPPRESS_ALERT_TEXT"));
        this.suppressThresholdEntry = TTextField.newTTextField(SUPPRESS_THRESHOLD_DEFAULT_VALUE, 2, true);
        this.suppressThresholdPercent = new JLabel(Util.getString("DISK_PERCENT"));
        GuiUtil.setAccessible(this.suppressCheckBox, Util.getString("DISK_SUPPRESS_ALERT_TEXT"), Util.getString("DISK_SUPPRESS_ALERT_TEXT"));
        GuiUtil.setAccessible(this.suppressThresholdEntry, Util.getString("DISK_SUPPRESS_ALERT_TEXT"), Util.getString("DISK_SUPPRESS_ALERT_TEXT"));
        GuiUtil.setAccessible(this.suppressThresholdPercent, Util.getString("DISK_PERCENT"), Util.getString("DISK_PERCENT"));
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 2;
        this.constraints.gridheight = 1;
        this.layout.setConstraints(this.suppressCheckBox, this.constraints);
        conditionPanel.add(this.suppressCheckBox);
        this.constraints.gridx = 2;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.layout.setConstraints(this.suppressThresholdEntry, this.constraints);
        conditionPanel.add(this.suppressThresholdEntry);
        this.constraints.gridx = 3;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.layout.setConstraints(this.suppressThresholdPercent, this.constraints);
        conditionPanel.add(this.suppressThresholdPercent);
        this.suppressCheckBox.setSelected(true);
        this.suppressCheckBox.addActionListener(this);
        this.suppressAlertEnabled(false);
        GuiUtil.completePanel(conditionPanel);
        this.setPanelSize(conditionPanel);
        return conditionPanel;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.suppressCheckBox) {
            this.suppressThresholdEntry.setEnabled(this.suppressCheckBox.isSelected());
        } else {
            super.actionPerformed(event);
        }
    }

    protected void initConditions() {
        this.oldConditions = new IntToString[30];
        this.oldConditions[0] = new IntToString(64, "ALR1114W");
        this.oldConditions[1] = new IntToString(67, "STG5503L");
        this.oldConditions[2] = new IntToString(68, "STG5504L");
        this.oldConditions[3] = new IntToString(5, "STG4005L");
        this.oldConditions[4] = new IntToString(6, "STG4006L");
        this.oldConditions[5] = new IntToString(65, "STG5505L");
        this.oldConditions[6] = new IntToString(140, Util.getString("FabricAlert_Subsystem_Status_Change_Offline"));
        this.oldConditions[7] = new IntToString(141, Util.getString("FabricAlert_Subsystem_Status_Change_Online"));
        this.oldConditions[8] = new IntToString(142, Util.getString("FabricAlert_Subsystem_Version_Change"));
        this.oldConditions[9] = new IntToString(123, Util.getString("FabricAlert_Subsystem_Property_Change"));
        this.oldConditions[10] = new IntToString(143, Util.getString("FabricAlert_Subsystem_Allocated_Capacity_Change"));
        this.oldConditions[11] = new IntToString(144, Util.getString("FabricAlert_Subsystem_Available_Capacity_Change"));
        this.oldConditions[12] = new IntToString(145, Util.getString("FabricAlert_Subsystem_Backend_Capacity_Change"));
        this.oldConditions[13] = new IntToString(146, Util.getString("FabricAlert_Subsystem_BackendController_Status_Change_Offline"));
        this.oldConditions[14] = new IntToString(147, Util.getString("FabricAlert_Subsystem_BackendController_Status_Change_Online"));
        this.oldConditions[15] = new IntToString(148, Util.getString("FabricAlert_Subsystem_Volume_Status_Change_Offline"));
        this.oldConditions[16] = new IntToString(149, Util.getString("FabricAlert_Subsystem_Volume_Status_Change_Online"));
        this.oldConditions[17] = new IntToString(150, Util.getString("FabricAlert_Subsystem_Volume_Capacity_Change"));
        this.oldConditions[18] = new IntToString(151, Util.getString("FabricAlert_Subsystem_Pool_Status_Change"));
        this.oldConditions[19] = new IntToString(152, Util.getString("FabricAlert_Subsystem_Pool_Discovered"));
        this.oldConditions[20] = new IntToString(153, Util.getString("FabricAlert_Subsystem_Pool_Status_Change_Offline"));
        this.oldConditions[21] = new IntToString(154, Util.getString("FabricAlert_Subsystem_Pool_Status_Change_Online"));
        this.oldConditions[22] = new IntToString(155, Util.getString("FabricAlert_Subsystem_Pool_Capacity_Change"));
        this.oldConditions[23] = new IntToString(156, Util.getString("FabricAlert_Subsystem_Pool_Available_Space_Change"));
        this.oldConditions[24] = new IntToString(137, Util.getString("FabricAlert_Endpoint_Node_Status_Change_Offline"));
        this.oldConditions[25] = new IntToString(138, Util.getString("FabricAlert_Endpoint_Node_Status_Change_Online"));
        this.oldConditions[26] = new IntToString(135, Util.getString("FabricAlert_Endpoint_Node_State_Change"));
        this.oldConditions[27] = new IntToString(136, Util.getString("FabricAlert_Endpoint_Node_Discovered"));
        this.oldConditions[28] = new IntToString(111, Util.getString("FabricAlert_Datapath_State_Change"));
        this.oldConditions[29] = new IntToString(112, Util.getString("FabricAlert_Datapath_Discovered"));
    }

    protected void setConditionData() {
        super.setConditionData();
        if (this.alert.aldAlertID > 0 && this.alert.aldAlertID <= 299) {
            this.conditionList.removeAllItems();
            this.conditionList.addItem(new IntToString(64, Util.getString("ALR1114W")));
        }
    }

    protected void conditionChange() {
        super.conditionChange();
        short condition = this.getConditionValue();
        if (condition == 64) {
            this.daCOE.tabbedPane.setEnabledAt(1, false);
        } else {
            this.daCOE.tabbedPane.setEnabledAt(1, true);
        }
    }

    protected void switchCard(int condition) {
        switch (condition) {
            case 5: 
            case 6: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 111: 
            case 112: 
            case 123: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                this.suppressAlertEnabled(false);
                this.actionPanelEnabled(true);
            }
        }
        this.oldAlertType = condition;
    }

    private void updateSubsystemList(boolean doPerfAlert) {
        this.subsystemSelector.setDoPerfAlert(doPerfAlert);
        this.subsystemSelector.resetSelector();
    }

    private void suppressAlertEnabled(boolean state) {
        this.suppressCheckBox.setEnabled(state);
        if (this.suppressCheckBox.isSelected() && state) {
            this.suppressThresholdEntry.setEnabled(true);
        } else {
            this.suppressThresholdEntry.setEnabled(false);
        }
        this.suppressThresholdPercent.setEnabled(state);
    }

    private void actionPanelEnabled(boolean state) {
        this.snmpTrap.setEnabled(state);
        this.tecTrap.setEnabled(state);
        this.loginNotification.setEnabled(state);
        if (this.loginNotification.isSelected()) {
            this.lLoginID.setEnabled(state);
            this.loginID.setEnabled(state);
        }
        if (Constants.isWindows(GuiClient.serverStatusResp.osType)) {
            this.osLog.setEnabled(state);
            if (this.osLog.isSelected()) {
                this.lLogLevel.setEnabled(state);
                this.logLevel.setEnabled(state);
            }
        } else {
            this.lLogFacility.setEnabled(state);
            this.logFacility.setEnabled(state);
        }
        this.runScript.setEnabled(state);
        if (this.runScript.isSelected()) {
            this.scriptSettings.setEnabled(state);
        }
        this.email.setEnabled(state);
    }

    public void setSelector(SubsystemAlertSelector subsystemSelector) {
        this.subsystemSelector = subsystemSelector;
    }

    protected void getConditionData() {
        switch (this.getConditionValue()) {
            case 5: 
            case 6: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 111: 
            case 112: 
            case 123: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: {
                super.getConditionData();
                this.alert.aldType = (short)20;
            }
        }
    }

    protected void validateConditionData() throws GeneralException {
        super.validateConditionData();
        if (this.suppressThresholdEntry.isEnabled() && (this.suppressThresholdValue < 0 || this.suppressThresholdValue > 99)) {
            this.throwException("STG4263E");
        }
    }
}

