/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespAgent;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentAdjuster
extends CustomReportDataAdjuster {
    private static final String TRELLISOFT_NAME = MessageLog.getMessageNoID("ADG0201L");
    private static final String STATE = MessageLog.getMessageNoID("ADG0295T");
    private static final String OS_TYPE = MessageLog.getMessageNoID("ADG0244L");
    private static final String VERSION = MessageLog.getMessageNoID("DBG0013L");
    private static final String PORT_NUMBER = MessageLog.getMessageNoID("ADG0121L");
    private static final String HOST_ADDRESS = MessageLog.getMessageNoID("ADG0204L");
    private static final String TIMESTAMP = MessageLog.getMessageNoID("ADG0205L");
    private static final String TIMEZONE = MessageLog.getMessageNoID("ADG0206L");
    private static final String CONNECTION_ERRORS = MessageLog.getMessageNoID("ADG0207L");
    private static final String CONSECUTIVE_ERRORS = MessageLog.getMessageNoID("ADG0208L");
    private static final String CPU_ARCHITECTURE = MessageLog.getMessageNoID("GEN0218T");
    public static final String AGENT_UP = MessageLog.getMessageNoID("STG5550L");
    public static final String AGENT_DOWN = MessageLog.getMessageNoID("STG5551L");
    public static final String AGENT_UNREACHABLE = MessageLog.getMessageNoID("STG5554L");
    public static final String AGENT_UPGRADE_NEEDED = MessageLog.getMessageNoID("STG5555L");
    public static final String AGENT_UPGRADING = MessageLog.getMessageNoID("STG5553L");
    public static final String AGENT_DEFECTED = MessageLog.getMessageNoID("STG5552L");
    public static final String AGENT_DELETED = MessageLog.getMessageNoID("DBG0550L");
    public String[] colNames = new String[]{TRELLISOFT_NAME, " ", " ", " ", PORT_NUMBER, HOST_ADDRESS, TIMESTAMP, TIMEZONE, CONNECTION_ERRORS, CONSECUTIVE_ERRORS, CPU_ARCHITECTURE};
    public static final int TRELLISOFT_NAME_COL = 0;
    public final int STATE_COL;
    public final int OS_TYPE_COL;
    public final int VERSION_COL;
    public static final int PORT_NUMBER_COL = 4;
    public static final int HOST_ADDRESS_COL = 5;
    public static final int TIMESTAMP_COL = 6;
    public static final int TIMEZONE_COL = 7;
    public static final int CONNECTION_ERRORS_COL = 8;
    public static final int CONSECUTIVE_ERRORS_COL = 9;
    public static final int CPU_ARCHITECTURE_COL = 10;
    private GuiReportReq grr;
    private RespAgent[] data;
    private Comparator sorter;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private int[] rendererArray;
    private boolean batch;
    private int rows;

    public AgentAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        switch (grr.reportSubtype) {
            case 86: {
                this.frozenColumns = 2;
                this.sorter = new StatusSorter();
                this.colNames[1] = STATE;
                this.colNames[2] = OS_TYPE;
                this.colNames[3] = VERSION;
                this.STATE_COL = 1;
                this.OS_TYPE_COL = 2;
                this.VERSION_COL = 3;
                break;
            }
            case 87: {
                this.frozenColumns = 2;
                this.sorter = new OsTypeSorter();
                this.colNames[1] = OS_TYPE;
                this.colNames[2] = STATE;
                this.colNames[3] = VERSION;
                this.STATE_COL = 2;
                this.OS_TYPE_COL = 1;
                this.VERSION_COL = 3;
                break;
            }
            default: {
                this.frozenColumns = 1;
                this.sorter = new NameSorter();
                this.colNames[1] = STATE;
                this.colNames[2] = OS_TYPE;
                this.colNames[3] = VERSION;
                this.STATE_COL = 1;
                this.OS_TYPE_COL = 2;
                this.VERSION_COL = 3;
            }
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[6] = 1;
        this.rendererArray[8] = 5;
        this.rendererArray[9] = 5;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
        Arrays.sort(this.data, 0, this.data.length, this.sorter);
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.data = (RespAgent[])dataArray;
        this.rows = this.data.length;
        this.mDate = new Date[this.rows];
        this.mInt = new MutableInteger[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.mDate[i] = new Date();
            this.mInt[i] = new MutableInteger();
        }
    }

    public void adjustData() {
        for (int i = 0; i < this.rows; ++i) {
            this.data[i].raDisplayState = this.data[i].raState == 1 ? AGENT_UP : (this.data[i].raState == 0 ? AGENT_DOWN : (this.data[i].raState == 4 ? AGENT_UNREACHABLE : (this.data[i].raState == 5 ? AGENT_UPGRADE_NEEDED : (this.data[i].raState == 3 ? AGENT_UPGRADING : (this.data[i].raState == 77 ? AGENT_DELETED : AGENT_DEFECTED)))));
            this.data[i].raDisplayOsType = MessageLog.getMessageNoID(Constants.OSTYPES[this.data[i].raOsType]);
            this.data[i].raDisplayCpuArchitecture = Constants.getCPUArchDisplayName(this.data[i].raCpuArchitecture);
        }
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        int[] qTypes = new int[]{52, 53, 54, 55, 56, 57};
        colArray[this.STATE_COL].cdValidValue = qTypes;
        colArray[this.OS_TYPE_COL].cdValidValue = ColumnDescriptor.OS_TYPES;
        colArray[10].cdValidValue = ColumnDescriptor.CPU_ARCHITECTURES;
    }

    public Object getArray() {
        return this.data;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public Object getCellData(int row, int col) {
        Object value = null;
        if (col == 0) {
            value = this.data[row].raTsName;
        } else if (col == this.STATE_COL) {
            value = this.data[row].raDisplayState;
        } else if (col == this.OS_TYPE_COL) {
            value = this.data[row].raDisplayOsType;
        } else if (col == this.VERSION_COL) {
            value = this.data[row].raProductVersions;
        } else if (col == 4) {
            value = Integer.toString(this.data[row].raPortNumber);
        } else if (col == 5) {
            value = this.data[row].raHostAddress;
        } else if (col == 6) {
            this.mDate[row].setTime(this.data[row].raTimestamp);
            value = Util.formatDateTime(this.mDate[row]);
        } else if (col == 7) {
            value = this.data[row].raTimezone;
        } else if (col == 8) {
            this.mInt[row].value = this.data[row].raConnectionErrors;
            value = this.mInt[row];
        } else if (col == 9) {
            this.mInt[row].value = this.data[row].raConsecutiveErrors;
            value = this.mInt[row];
        } else if (col == 10) {
            value = this.data[row].raDisplayCpuArchitecture;
        }
        return value;
    }

    private class NameSorter
    implements Comparator {
        private NameSorter() {
        }

        public int compare(Object o1, Object o2) {
            RespAgent r1 = (RespAgent)o1;
            RespAgent r2 = (RespAgent)o2;
            return r1.raTsName.compareTo(r2.raTsName);
        }
    }

    private class VersionSorter
    implements Comparator {
        private VersionSorter() {
        }

        public int compare(Object o1, Object o2) {
            RespAgent r1 = (RespAgent)o1;
            RespAgent r2 = (RespAgent)o2;
            int x = r1.raProductVersions.compareTo(r2.raProductVersions);
            if (x != 0) {
                return x;
            }
            return r1.raTsName.compareTo(r2.raTsName);
        }
    }

    private class OsTypeSorter
    implements Comparator {
        private OsTypeSorter() {
        }

        public int compare(Object o1, Object o2) {
            RespAgent r1 = (RespAgent)o1;
            RespAgent r2 = (RespAgent)o2;
            int x = r1.raDisplayOsType.compareTo(r2.raDisplayOsType);
            if (x != 0) {
                return x;
            }
            return r1.raTsName.compareTo(r2.raTsName);
        }
    }

    private class StatusSorter
    implements Comparator {
        private StatusSorter() {
        }

        public int compare(Object o1, Object o2) {
            RespAgent r1 = (RespAgent)o1;
            RespAgent r2 = (RespAgent)o2;
            int x = r1.raDisplayState.compareTo(r2.raDisplayState);
            if (x != 0) {
                return x;
            }
            return r1.raTsName.compareTo(r2.raTsName);
        }
    }
}

