/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.common.CompHist;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.Domain;
import org.eclipse.aperi.TStorm.common.EntityWWPN;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.common.LdapTree;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Rank;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.common.Group;
import org.eclipse.aperi.common.Packable;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.server.guireq.GComputer;

public class Computer
implements Serializable,
Packable,
Cloneable {
    static final long serialVersionUID = 2053146022022773667L;
    public Computer cmpNext;
    public int cmpID;
    public int cmpDomainID;
    public Domain cmpDomain;
    public int cmpGroupID;
    public Group cmpGroup;
    public Controller cmpController;
    public Cluster cmpCluster;
    public int cmpClusterID;
    public int cmpNodeHostedID;
    public transient Device cmpDevice;
    public transient LogicalDisk cmpLogicalDisk;
    public transient Export cmpExport;
    public transient LdapTree cmpLdapTree;
    public transient VolGroup cmpVolGroup;
    public transient EntityWWPN cmpEntityWWPN;
    public transient Rank cmpRank;
    public String cmpOSVersion;
    public String cmpProcessorType;
    public String cmpManufacturer;
    public String cmpModel;
    public String cmpSerialNumber;
    public int cmpRAM;
    public int cmpSwapSpace;
    public long cmpDiskCapacity;
    public long cmpDiskFreeSpace;
    public long cmpOwnedDiskCap;
    public long cmpOwnedDiskFreeSp;
    public int cmpNDisks;
    public int cmpNLogicalDisks;
    public long cmpLogicalDiskCapacity;
    public long cmpLogicalDiskAssignedCapacity;
    public long cmpZOSLogicalDiskCapacity;
    public long cmpFilesystemFreeSpace;
    public long cmpLastBootTime;
    public long cmpLastProbeTime;
    public short cmpOSType;
    public short cmpCPUArchitecture;
    public short cmpProcessorCount;
    public short cmpProcessorSpeed;
    public byte cmpProbeStatus;
    public long cmpDiscoveredTime;
    public CompHist cmpHistory;
    public long cmpVolGroupCapacity;
    public long cmpVolGroupFreespace;
    public long cmpDiskGroupFreeCap;
    public int cmpProbingCompID;
    public transient GComputer gComputer;
    public transient NasFiler cmpNasFiler;
    public transient boolean cmpNewVS;
    public transient int cmpParentID;
    public Device[] cmpPackedDevices;
    public LogicalDisk[] cmpPackedLogicalDisks;
    public Export[] cmpPackedExports;
    public LdapTree[] cmpPackedLdapTrees;
    public NasFiler[] cmpPackedNasFilers;
    public Controller[] cmpPackedControllers;
    public VolGroup[] cmpPackedVolGroups;
    public EntityWWPN[] cmpPackedEntityWWPNs;
    public Rank[] cmpPackedRanks;
    public static final byte IN_PROGRESS = 0;
    public static final byte FAILURE = 1;
    public static final byte SUCCESS = 2;

    public Computer() {
    }

    public Computer(boolean invalidate) {
        if (!invalidate) {
            return;
        }
        this.cmpRAM = -1;
        this.cmpSwapSpace = -1;
        this.cmpDiskCapacity = -1L;
        this.cmpDiskFreeSpace = -1L;
        this.cmpOwnedDiskCap = -1L;
        this.cmpOwnedDiskFreeSp = -1L;
        this.cmpProcessorCount = (short)-1;
        this.cmpProcessorSpeed = (short)-1;
        this.cmpProcessorType = this.cmpOSVersion = " ";
        this.cmpModel = this.cmpOSVersion;
        this.cmpSerialNumber = this.cmpOSVersion;
        this.cmpLogicalDiskAssignedCapacity = -1L;
        this.cmpZOSLogicalDiskCapacity = -1L;
    }

    public void pack() {
        Controller ctlr = this.cmpController;
        while (ctlr != null) {
            ctlr.ctlrPackedDevices = DevAccess.pack(ctlr.ctlrDevices);
            ctlr.ctlrDevices = null;
            ctlr = ctlr.ctlrNext;
        }
        this.cmpPackedControllers = (Controller[])Packer.pack(this.cmpController);
        this.cmpController = null;
        LogicalDisk ld = this.cmpLogicalDisk;
        while (ld != null) {
            ld.pack();
            if (ld.ldFilesystem != null) {
                ld.ldFilesystem.fsNext = null;
            }
            ld = ld.ldNext;
        }
        Device dev = this.cmpDevice;
        while (dev != null) {
            if (dev instanceof Disk) {
                ((Disk)dev).pack();
            }
            dev = dev.devNext;
        }
        this.cmpPackedLogicalDisks = LogicalDisk.packLDs(this.cmpLogicalDisk);
        this.cmpLogicalDisk = null;
        this.cmpPackedDevices = Device.pack(this.cmpDevice);
        this.cmpDevice = null;
        this.cmpPackedExports = Export.packExports(this.cmpExport);
        this.cmpExport = null;
        this.cmpPackedLdapTrees = LdapTree.pack(this.cmpLdapTree);
        this.cmpLdapTree = null;
        NasFiler filer = this.cmpNasFiler;
        while (filer != null) {
            filer.pack();
            filer = filer.nfNext;
        }
        this.cmpPackedNasFilers = (NasFiler[])Packer.pack(this.cmpNasFiler);
        this.cmpNasFiler = null;
        this.cmpPackedVolGroups = (VolGroup[])Packer.pack(this.cmpVolGroup);
        this.cmpVolGroup = null;
        this.cmpPackedRanks = (Rank[])Packer.pack(this.cmpRank);
        this.cmpRank = null;
        this.cmpPackedEntityWWPNs = (EntityWWPN[])Packer.pack(this.cmpEntityWWPN);
        this.cmpEntityWWPN = null;
    }

    public void unpack() {
        this.cmpLdapTree = LdapTree.unpack(this.cmpPackedLdapTrees);
        this.cmpPackedLdapTrees = null;
        this.cmpExport = Export.unpackExports(this.cmpPackedExports);
        this.cmpPackedExports = null;
        this.cmpDevice = Device.unpack(this.cmpPackedDevices);
        this.cmpPackedDevices = null;
        this.cmpLogicalDisk = LogicalDisk.unpackLDs(this.cmpPackedLogicalDisks);
        this.cmpPackedLogicalDisks = null;
        Device dev = this.cmpDevice;
        while (dev != null) {
            if (dev instanceof Disk) {
                ((Disk)dev).unpack();
            }
            dev = dev.devNext;
        }
        LogicalDisk ld = this.cmpLogicalDisk;
        while (ld != null) {
            ld.unpack();
            ld = ld.ldNext;
        }
        this.cmpController = (Controller)Packer.unpack(this.cmpPackedControllers);
        this.cmpPackedControllers = null;
        Controller ctlr = this.cmpController;
        while (ctlr != null) {
            ctlr.ctlrDevices = DevAccess.unpack(ctlr.ctlrPackedDevices);
            ctlr.ctlrPackedDevices = null;
            ctlr = ctlr.ctlrNext;
        }
        NasFiler filer = this.cmpNasFiler = (NasFiler)Packer.unpack(this.cmpPackedNasFilers);
        while (filer != null) {
            filer.unpack();
            filer = filer.nfNext;
        }
        this.cmpVolGroup = (VolGroup)Packer.unpack(this.cmpPackedVolGroups);
        this.cmpPackedVolGroups = null;
        this.cmpRank = (Rank)Packer.unpack(this.cmpPackedRanks);
        this.cmpPackedRanks = null;
        this.cmpEntityWWPN = (EntityWWPN)Packer.unpack(this.cmpPackedEntityWWPNs);
        this.cmpPackedEntityWWPNs = null;
    }

    public Packable getNext() {
        return this.cmpNext;
    }

    public void setNext(Packable next) {
        this.cmpNext = (Computer)next;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

