/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.Device;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.common.VolumeGroup;
import org.eclipse.aperi.xmsg.MessageLog;

public class Disk
extends Device {
    static final long serialVersionUID = -3536586598237348595L;
    public int dskSectorSize;
    public int dskSectorsPerAvgTrack;
    public int dskSectorsPerOuterTrack;
    public int dskSectorsPerInnerTrack;
    public int dskHeads;
    public int dskCylinders;
    public int dskLogicalBlockSize;
    public long dskCapacity;
    public int dskRPM;
    public int dskMinutesPoweredOn;
    public int dskSpareBlocks;
    public Share[] dskHostPaths;
    public boolean dskWriteProtected;
    public boolean dskWriteCacheEnabled;
    public boolean dskReadCacheDisabled;
    public boolean dskAutoWriteRealloc;
    public boolean dskAutoReadRealloc;
    public boolean dskNoErrorRecovery;
    public boolean dskFailurePredicted;
    public DiskHistory dskHistory;
    public byte dskIdentity = (byte)7;
    public static final byte SS_DISK = 0;
    public static final byte SVC_DISK_KNOWN_LUN = 1;
    public static final byte SVC_DISK_UNKNOWN_LUN = 2;
    public static final byte LOCAL_HARD_DISK = 3;
    public static final byte DISK_IDENTITY_UNKNOWN = 7;
    public transient Chunk dskChunk;
    public Chunk[] dskPackedChunks;
    public transient int dskChunkCount;
    public transient long myChunkCount;
    public static final byte USE_GLOBAL = 0;
    public static final byte LEAVE_ALONE = 1;
    public static final byte TURN_OFF = 2;
    public static final byte TURN_ON = 3;
    public static final String[] STATES = new String[]{MessageLog.getMessageNoID("GEN0116I"), MessageLog.getMessageNoID("GEN0117I"), MessageLog.getMessageNoID("GEN0118I"), MessageLog.getMessageNoID("GEN0119I")};
    public byte dskDesiredAWRE;
    public byte dskDesiredARRE;
    public byte dskDesiredNoErrRcvry;
    public int dskVolgroupID;
    public VolumeGroup dskVolgroup;
    public int dskLogicalDiskID;
    private boolean isSpare;

    public void pack() {
        if (this.dskPackedChunks == null || this.dskChunk != null) {
            this.dskPackedChunks = Chunk.packByDisk(this.dskChunk);
            this.dskChunk = null;
        }
    }

    public void unpack() {
        this.dskChunk = Chunk.unpackByDisk(this.dskPackedChunks);
        this.dskPackedChunks = null;
    }

    public void setSpare(boolean isSpare) {
        this.isSpare = isSpare;
    }

    public boolean isSpare() {
        return this.isSpare;
    }

    public void initUnknown() {
        this.dskSectorsPerAvgTrack = -1;
        this.dskSectorsPerOuterTrack = -1;
        this.dskSectorsPerInnerTrack = -1;
        this.dskHeads = -1;
        this.dskCylinders = -1;
        this.dskRPM = -1;
        this.dskMinutesPoweredOn = -1;
        this.dskSpareBlocks = -1;
        this.dskHistory = new DiskHistory();
        this.dskHistory.dkhPrimaryDefects = -1;
        this.dskHistory.dkhGrownDefects = -1;
        this.dskHistory.dkhRecoveredWriteErrors = -1;
        this.dskHistory.dkhUnrecoveredWriteErrors = -1;
        this.dskHistory.dkhBytesWritten = -1L;
        this.dskHistory.dkhRecoveredReadErrors = -1;
        this.dskHistory.dkhUnrecoveredReadErrors = -1;
        this.dskHistory.dkhBytesRead = -1L;
        this.dskHistory.dkhRecoveredVerifyErrors = -1;
        this.dskHistory.dkhUnrecoveredVerifyErrors = -1;
        this.dskHistory.dkhNonMediumErrors = -1;
        this.dskHistory.dkhTemperature = (short)-274;
        this.dskIdentity = (byte)7;
    }
}

