/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskAdjuster
extends CustomReportDataAdjuster {
    static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    static final String PATH = MessageLog.getMessageNoID("STG1219L");
    static final String IN_DISK_ARRAY = MessageLog.getMessageNoID("SAG0200L");
    static final String MANUF = MessageLog.getMessageNoID("STG1105L");
    static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    static final String RPM = MessageLog.getMessageNoID("STG1163L");
    static final String READ_CACHE = MessageLog.getMessageNoID("STG1196L");
    static final String WRITE_CACHE = MessageLog.getMessageNoID("STG1197L");
    static final String FAILURE = MessageLog.getMessageNoID("STG1173L");
    static final String PROBE_TIME = MessageLog.getMessageNoID("STG1182L");
    static final String DISCOVERED_TIME = MessageLog.getMessageNoID("STG1134L");
    static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    static final String UNALLOCATED = MessageLog.getMessageNoID("STG4131L");
    static final String DEFECTS_PRI = MessageLog.getMessageNoID("STG1174L");
    static final String DEFECTS_GROWN = MessageLog.getMessageNoID("STG1175L");
    static final String RECOVERED_ERR = MessageLog.getMessageNoID("STG1178L");
    static final String UNRECOVERED_ERR = MessageLog.getMessageNoID("STG1179L");
    static final String WRITE_BYTES = MessageLog.getMessageNoID("STG1204L");
    static final String READ_BYTES = MessageLog.getMessageNoID("STG1207L");
    static final String AWRE_CURR = MessageLog.getMessageNoID("STG1168L");
    static final String AWRE_NEXT = MessageLog.getMessageNoID("STG1245L");
    static final String ARRE_CURR = MessageLog.getMessageNoID("STG1169L");
    static final String ARRE_NEXT = MessageLog.getMessageNoID("STG1246L");
    static final String NER_CURR = MessageLog.getMessageNoID("STG1170L");
    static final String NER_NEXT = MessageLog.getMessageNoID("STG1247L");
    static final String UNKNOWN = MessageLog.getMessageNoID("STG1020L");
    static final String YES = MessageLog.getMessageNoID("GUI0121T");
    static final String NO = MessageLog.getMessageNoID("GUI0122T");
    static final String ON = MessageLog.getMessageNoID("GUI0123T");
    static final String OFF = MessageLog.getMessageNoID("GUI0124T");
    public String[] colNames = new String[]{COMPUTER, PATH, MANUF, MODEL, IN_DISK_ARRAY, RPM, READ_CACHE, WRITE_CACHE, FAILURE, PROBE_TIME, DISCOVERED_TIME, CAPACITY, UNALLOCATED, DEFECTS_PRI, DEFECTS_GROWN, RECOVERED_ERR, UNRECOVERED_ERR, WRITE_BYTES, READ_BYTES, AWRE_CURR, AWRE_NEXT, ARRE_CURR, ARRE_NEXT, NER_CURR, NER_NEXT};
    private static final int COMPUTER_COL = 0;
    private static final int PATH_COL = 1;
    private static final int MANUF_COL = 2;
    private static final int MODEL_COL = 3;
    private static final int IN_DISK_ARRAY_COL = 4;
    private static final int RPM_COL = 5;
    private static final int READ_CACHE_COL = 6;
    private static final int WRITE_CACHE_COL = 7;
    private static final int FAILURE_COL = 8;
    private static final int PROBE_TIME_COL = 9;
    private static final int DISCOVERED_TIME_COL = 10;
    private static final int CAPACITY_COL = 11;
    private static final int UNALLOCATED_COL = 12;
    private static final int DEFECTS_PRI_COL = 13;
    private static final int DEFECTS_GROWN_COL = 14;
    private static final int RECOVERED_ERR_COL = 15;
    private static final int UNRECOVERED_ERR_COL = 16;
    private static final int WRITE_BYTES_COL = 17;
    private static final int READ_BYTES_COL = 18;
    private static final int AWRE_CURR_COL = 19;
    private static final int AWRE_NEXT_COL = 20;
    private static final int ARRE_CURR_COL = 21;
    private static final int ARRE_NEXT_COL = 22;
    private static final int NER_CURR_COL = 23;
    private static final int NER_NEXT_COL = 24;
    private GuiReportReq grr;
    private Share[] shArray;
    public DevAccess[] daArray;
    public Disk[] dskArray;
    public DiskHistory[] dkhArray;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private int[] rendererArray;
    private boolean batch;
    public int frozenRows;
    private int rowCount;

    public DiskAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.frozenColumns = 2;
        switch (grr.reportSubtype) {
            case 39: {
                this.firstColumn = 12;
                break;
            }
            case 23: {
                this.firstColumn = 13;
                break;
            }
            case 24: {
                this.firstColumn = 14;
                break;
            }
            case 25: {
                this.firstColumn = 15;
                break;
            }
            case 26: {
                this.firstColumn = 16;
                break;
            }
            case 18: {
                this.firstColumn = 9;
                break;
            }
            case 37: {
                this.firstColumn = 10;
                break;
            }
            default: {
                this.firstColumn = 0;
            }
        }
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[5] = 5;
        this.rendererArray[13] = 5;
        this.rendererArray[14] = 5;
        this.rendererArray[15] = 5;
        this.rendererArray[16] = 5;
        this.rendererArray[9] = 1;
        this.rendererArray[10] = 1;
        this.rendererArray[11] = 7;
        this.rendererArray[12] = 7;
        this.rendererArray[17] = 7;
        this.rendererArray[18] = 7;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.shArray = (Share[])dataArray;
        this.rowCount = this.shArray.length;
        if (this.rowCount > 1) {
            this.addTotal();
        }
        this.daArray = new DevAccess[this.rowCount];
        this.dskArray = new Disk[this.rowCount];
        this.dkhArray = new DiskHistory[this.rowCount];
        this.mDate = new Date[this.rowCount];
        this.mLong = new MutableLong[this.rowCount];
        this.mInt = new MutableInteger[this.rowCount];
        for (int i = 0; i < this.rowCount; ++i) {
            this.mDate[i] = new Date();
            this.mLong[i] = new MutableLong();
            this.mInt[i] = new MutableInteger();
        }
    }

    public void adjustData() {
        for (int i = 0; i < this.rowCount; ++i) {
            Share sh = this.shArray[i];
            this.daArray[i] = (DevAccess)sh.shResource;
            this.dskArray[i] = (Disk)this.daArray[i].daDevice;
            this.dkhArray[i] = this.dskArray[i].dskHistory;
            this.dskArray[i].dskCapacity *= 512L;
            this.dkhArray[i].dkhFreeSpace *= 512L;
            if (this.batch || sh.shResourceType != 10) continue;
            sh.shComputerName = GuiUtil.getComputer((int)sh.shComputerID).gcTSName;
        }
    }

    public void undo() {
        this.dskArray[0].dskCapacity /= 512L;
        this.dkhArray[0].dkhFreeSpace /= 512L;
        Share sh = this.shArray[0];
        if (sh.shResourceType == 10) {
            sh.shComputerName = null;
        }
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        int[] yesNo = new int[]{0, 1};
        int[] onOff = new int[]{5, 6};
        colArray[19].cdValidValue = onOff;
        colArray[21].cdValidValue = onOff;
        colArray[23].cdValidValue = onOff;
        colArray[7].cdValidValue = onOff;
        colArray[8].cdValidValue = yesNo;
        colArray[6].cdValidValue = onOff;
        colArray[4].cdValidValue = yesNo;
        colArray[20].cdValidValue = ColumnDescriptor.DISK_STATES;
        colArray[22].cdValidValue = ColumnDescriptor.DISK_STATES;
        colArray[24].cdValidValue = ColumnDescriptor.DISK_STATES;
    }

    public Object getArray() {
        return this.shArray;
    }

    public int getNumberRows() {
        return this.shArray.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public Object getCellData(int row, int col) {
        switch (col) {
            case 0: {
                return this.shArray[row].shComputerName;
            }
            case 1: {
                return this.daArray[row].daPath;
            }
            case 2: {
                if ((this.dskArray[row].devFlags & 1) != 0 || this.dskArray[row].devManufacturer.compareTo(" ") == 0 || this.dskArray[row].devManufacturer.toLowerCase().equals("unknown")) {
                    return MessageLog.getMessageNoID("STG1020L");
                }
                return this.dskArray[row].devManufacturer;
            }
            case 3: {
                if (this.dskArray[row].devModel.compareTo(" ") == 0) {
                    return UNKNOWN;
                }
                return this.dskArray[row].devModel;
            }
            case 4: {
                return this.bHasTotalRow && row == 0 ? "" : (this.shArray[row].shResourceType == 10 ? NO : YES);
            }
            case 5: {
                this.mInt[row].value = this.dskArray[row].dskRPM;
                return this.mInt[row];
            }
            case 6: {
                return this.bHasTotalRow && row == 0 ? "" : (this.dskArray[row].dskReadCacheDisabled ? OFF : ON);
            }
            case 7: {
                return this.bHasTotalRow && row == 0 ? "" : (this.dskArray[row].dskWriteCacheEnabled ? ON : OFF);
            }
            case 8: {
                return this.bHasTotalRow && row == 0 ? "" : (this.dskArray[row].dskFailurePredicted ? YES : NO);
            }
            case 9: {
                this.mDate[row].setTime(this.dkhArray[row].dkhTimestamp);
                return this.mDate[row];
            }
            case 10: {
                this.mDate[row].setTime(this.dskArray[row].devDiscoveredTime);
                return this.mDate[row];
            }
            case 11: {
                this.mLong[row].value = this.dskArray[row].dskCapacity;
                return this.mLong[row];
            }
            case 12: {
                this.mLong[row].value = this.dkhArray[row].dkhFreeSpace;
                return this.mLong[row];
            }
            case 13: {
                this.mInt[row].value = this.dkhArray[row].dkhPrimaryDefects;
                return this.mInt[row];
            }
            case 14: {
                this.mInt[row].value = this.dkhArray[row].dkhGrownDefects;
                return this.mInt[row];
            }
            case 15: {
                int rw = this.dkhArray[row].dkhRecoveredWriteErrors < 0 ? 0 : this.dkhArray[row].dkhRecoveredWriteErrors;
                int rr = this.dkhArray[row].dkhRecoveredReadErrors < 0 ? 0 : this.dkhArray[row].dkhRecoveredReadErrors;
                int rv = this.dkhArray[row].dkhRecoveredVerifyErrors < 0 ? 0 : this.dkhArray[row].dkhRecoveredVerifyErrors;
                this.mInt[row].value = rw + rr + rv;
                return this.mInt[row];
            }
            case 16: {
                int uw = this.dkhArray[row].dkhUnrecoveredWriteErrors < 0 ? 0 : this.dkhArray[row].dkhUnrecoveredWriteErrors;
                int ur = this.dkhArray[row].dkhUnrecoveredReadErrors < 0 ? 0 : this.dkhArray[row].dkhUnrecoveredReadErrors;
                int uv = this.dkhArray[row].dkhUnrecoveredVerifyErrors < 0 ? 0 : this.dkhArray[row].dkhUnrecoveredVerifyErrors;
                this.mInt[row].value = uw + ur + uv;
                return this.mInt[row];
            }
            case 17: {
                this.mLong[row].value = this.dkhArray[row].dkhBytesWritten;
                return this.mLong[row];
            }
            case 18: {
                this.mLong[row].value = this.dkhArray[row].dkhBytesRead;
                return this.mLong[row];
            }
            case 19: {
                return this.bHasTotalRow && row == 0 ? "" : (this.dskArray[row].dskAutoWriteRealloc ? ON : OFF);
            }
            case 20: {
                return this.bHasTotalRow && row == 0 ? "" : Disk.STATES[this.dskArray[row].dskDesiredAWRE];
            }
            case 21: {
                return this.bHasTotalRow && row == 0 ? "" : (this.dskArray[row].dskAutoReadRealloc ? ON : OFF);
            }
            case 22: {
                return this.bHasTotalRow && row == 0 ? "" : Disk.STATES[this.dskArray[row].dskDesiredARRE];
            }
            case 23: {
                return this.bHasTotalRow && row == 0 ? "" : (this.dskArray[row].dskNoErrorRecovery ? ON : OFF);
            }
            case 24: {
                return this.bHasTotalRow && row == 0 ? "" : Disk.STATES[this.dskArray[row].dskDesiredNoErrRcvry];
            }
        }
        return null;
    }

    private void addTotal() {
        Share shTotal;
        this.bHasTotalRow = true;
        Share[] plusArray = new Share[this.rowCount + 1];
        plusArray[0] = shTotal = new Share();
        DevAccess daTotal = new DevAccess();
        Disk dskTotal = new Disk();
        DiskHistory dkhTotal = new DiskHistory();
        shTotal.shResource = daTotal;
        daTotal.daDevice = dskTotal;
        dskTotal.dskHistory = dkhTotal;
        shTotal.shComputerName = MessageLog.getMessageNoID("STG4136L");
        daTotal.daPath = "";
        dskTotal.devManufacturer = "";
        dskTotal.devModel = "";
        dkhTotal.dkhPrimaryDefects = -1;
        dkhTotal.dkhGrownDefects = -1;
        dkhTotal.dkhBytesWritten = -1L;
        dkhTotal.dkhBytesRead = -1L;
        int rpmCount = 0;
        for (int ix = 0; ix < this.rowCount; ++ix) {
            Share shRow = this.shArray[ix];
            Disk dskRow = (Disk)((DevAccess)shRow.shResource).daDevice;
            DiskHistory dkhRow = dskRow.dskHistory;
            if (dskRow.dskRPM > 0) {
                dskTotal.dskRPM += dskRow.dskRPM;
                ++rpmCount;
            }
            if (dskRow.dskCapacity > 0L) {
                dskTotal.dskCapacity += dskRow.dskCapacity;
            }
            if (dkhRow.dkhFreeSpace > 0L) {
                dkhTotal.dkhFreeSpace += dkhRow.dkhFreeSpace;
            }
            if (dkhRow.dkhPrimaryDefects > 0) {
                dkhTotal.dkhPrimaryDefects += dkhRow.dkhPrimaryDefects;
            }
            if (dkhRow.dkhGrownDefects > 0) {
                dkhTotal.dkhGrownDefects += dkhRow.dkhGrownDefects;
            }
            if (dkhRow.dkhRecoveredWriteErrors > 0) {
                dkhTotal.dkhRecoveredWriteErrors += dkhRow.dkhRecoveredWriteErrors;
            }
            if (dkhRow.dkhRecoveredReadErrors > 0) {
                dkhTotal.dkhRecoveredReadErrors += dkhRow.dkhRecoveredReadErrors;
            }
            if (dkhRow.dkhRecoveredVerifyErrors > 0) {
                dkhTotal.dkhRecoveredVerifyErrors += dkhRow.dkhRecoveredVerifyErrors;
            }
            if (dkhRow.dkhUnrecoveredWriteErrors > 0) {
                dkhTotal.dkhUnrecoveredWriteErrors += dkhRow.dkhUnrecoveredWriteErrors;
            }
            if (dkhRow.dkhUnrecoveredReadErrors > 0) {
                dkhTotal.dkhUnrecoveredReadErrors += dkhRow.dkhUnrecoveredReadErrors;
            }
            if (dkhRow.dkhUnrecoveredVerifyErrors > 0) {
                dkhTotal.dkhUnrecoveredVerifyErrors += dkhRow.dkhUnrecoveredVerifyErrors;
            }
            if (dkhRow.dkhBytesWritten > 0L) {
                dkhTotal.dkhBytesWritten += dkhRow.dkhBytesWritten;
            }
            if (dkhRow.dkhBytesRead > 0L) {
                dkhTotal.dkhBytesRead += dkhRow.dkhBytesRead;
            }
            plusArray[ix + 1] = this.shArray[ix];
        }
        dskTotal.dskRPM = rpmCount > 0 ? (dskTotal.dskRPM /= rpmCount) : -1;
        if (dkhTotal.dkhPrimaryDefects >= 0) {
            ++dkhTotal.dkhPrimaryDefects;
        }
        if (dkhTotal.dkhGrownDefects >= 0) {
            ++dkhTotal.dkhGrownDefects;
        }
        if (dkhTotal.dkhBytesWritten >= 0L) {
            ++dkhTotal.dkhBytesWritten;
        }
        if (dkhTotal.dkhBytesRead >= 0L) {
            ++dkhTotal.dkhBytesRead;
        }
        this.shArray = plusArray;
        this.frozenRows = 1;
        ++this.rowCount;
    }
}

