/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ComputerList;
import org.eclipse.aperi.TStorm.common.ComputersAdjuster;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.DiskAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskCapacityAdjuster
extends CustomReportDataAdjuster {
    private static final String PATH = MessageLog.getMessageNoID("STG1219L");
    private static final String DOMAIN = MessageLog.getMessageNoID("STG1104L");
    private static final String CREATOR = MessageLog.getMessageNoID("STG0021L");
    private static final String GROUP = MessageLog.getMessageNoID("STG1103L");
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String CLUSTER = MessageLog.getMessageNoID("STG1136L");
    private static final String OSTYPE = MessageLog.getMessageNoID("STG1108L");
    private static final String NETWORKADDR = MessageLog.getMessageNoID("STG1281L");
    private static final String IPADDRESS = MessageLog.getMessageNoID("STG1280L");
    private static final String TIMEZONE = MessageLog.getMessageNoID("STG1282L");
    private static final String NAME = MessageLog.getMessageNoID("STG0023T");
    private static final String NUM_DISKS = MessageLog.getMessageNoID("STG6057L");
    private static final String DISK_CAP = MessageLog.getMessageNoID("STG1115L");
    private static final String DISK_FREESP = MessageLog.getMessageNoID("SAG0047I");
    private static final String LUNS = MessageLog.getMessageNoID("STG6058L");
    private static final String LUN_CAP = MessageLog.getMessageNoID("STG6059L");
    public static final String OVERHEAD = MessageLog.getMessageNoID("STG6054L");
    private static final String CACHE = MessageLog.getMessageNoID("STG6056L");
    private static final String FIRMWARE = MessageLog.getMessageNoID("STG1146L");
    private static final String TOTAL = MessageLog.getMessageNoID("STG5073L");
    private static final String OWNED = MessageLog.getMessageNoID("STG6000L");
    private static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    public static final String UNALLOCATED = MessageLog.getMessageNoID("STG4131L");
    private static final String UNALLOC = MessageLog.getMessageNoID("STG6001L");
    private static final String SPACE = MessageLog.getMessageNoID("STG6002L");
    private static final String MANUF = MessageLog.getMessageNoID("STG1105L");
    private static final String MODEL = MessageLog.getMessageNoID("STG1106L");
    private static final String PRIDEF = MessageLog.getMessageNoID("STG1174L");
    private static final String GROWNDEF = MessageLog.getMessageNoID("STG1175L");
    private static final String SERIAL = MessageLog.getMessageNoID("STG1107L");
    private static final String UNKNOWN = MessageLog.getMessageNoID("STG1020L");
    private static final String NETWORK = MessageLog.getMessageNoID("STG5048L");
    public static final String USED_SPACE = MessageLog.getMessageNoID("STG2005L");
    public static final String FREE_SPACE = MessageLog.getMessageNoID("STG2006L");
    public static final String RAW_CAPACITY = MessageLog.getMessageNoID("STG5521L");
    public static final String UNKNOWN_LCAP = MessageLog.getMessageNoID("STG5522L");
    public static final String NOT_APPLICABLE = MessageLog.getMessageNoID("STG0019T");
    private static final String IN_DISK_ARRAY = MessageLog.getMessageNoID("SAG0200L");
    private static final String USEABLE = MessageLog.getMessageNoID("STG6080L");
    private static final String ASSIGNED = MessageLog.getMessageNoID("STG6081L");
    private static final String UNASSIGNED = MessageLog.getMessageNoID("STG6082L");
    private static final String VS_CAP = MessageLog.getMessageNoID("SAG0048I");
    private static final String VS_FREESP = MessageLog.getMessageNoID("SAG0049I");
    private static final String VS_OVERHEAD = MessageLog.getMessageNoID("SAG0050I");
    private static final String DG_UFCAP = MessageLog.getMessageNoID("SAG0051I");
    private static final String STORSUBASSIGNEDCAPACITY = MessageLog.getMessageNoID("STG7559L");
    private static final String STORSUBUNASSIGNEDCAPACITY = MessageLog.getMessageNoID("STG7560L");
    private static final String STORSUBFORMATTEDDFRESPACE = MessageLog.getMessageNoID("STG7561L");
    private static final String ZOSLUNCAPACITY = MessageLog.getMessageNoID("STG7562L");
    private static final String OPENSYSLUNCAPACITY = MessageLog.getMessageNoID("STG7563L");
    private static String TOTAL_TC;
    private static String TOTAL_TF;
    private static String OWNED_OC;
    private static String OWNED_OF;
    private static String CAPACITY_TC;
    private static String CAPACITY_OC;
    private static String UNALLOCATED_TF;
    private static String UNALLOCATED_OF;
    private static String SPACE_TF;
    private static String SPACE_OF;
    private static String CPU;
    private static String ARCHITECTURE;
    public String[] colNames;
    private String[] colNames1 = new String[]{" ", " ", CAPACITY, UNALLOCATED};
    private String[] compColNames1 = new String[]{" ", " ", CAPACITY_TC, UNALLOCATED_TF};
    private String[] dskColNames = new String[]{" ", " ", CAPACITY, UNALLOCATED, IN_DISK_ARRAY, MANUF, MODEL, SERIAL, PRIDEF, GROWNDEF};
    private String[] colNames2 = new String[]{" ", " ", TOTAL, TOTAL, OWNED, OWNED};
    private String[] compColNames2 = new String[]{" ", " ", TOTAL_TC + " " + CAPACITY_TC, TOTAL_TF + " " + UNALLOCATED_TF + " " + SPACE_TF, OWNED_OC + " " + CAPACITY_OC, OWNED_OF + " " + UNALLOCATED_OF + " " + SPACE_OF};
    private static String[] compColNames;
    private static String[] clusterColNames;
    private String[] netColNames = new String[]{" ", " ", CAPACITY, USED_SPACE, FREE_SPACE, RAW_CAPACITY, OVERHEAD, UNALLOCATED, UNKNOWN_LCAP};
    private String[] subColNames = new String[]{" ", NAME, DISK_CAP, DISK_FREESP, NUM_DISKS, LUNS, LUN_CAP, USEABLE, ASSIGNED, UNASSIGNED, OVERHEAD, VS_CAP, VS_FREESP, VS_OVERHEAD, DG_UFCAP, CACHE, MANUF, MODEL, SERIAL, FIRMWARE, STORSUBASSIGNEDCAPACITY, STORSUBUNASSIGNEDCAPACITY, STORSUBFORMATTEDDFRESPACE, ZOSLUNCAPACITY, OPENSYSLUNCAPACITY};
    public static final int QUAL_COL = 0;
    private static final int NAME_COL = 1;
    private static final int CAPACITY_COL = 2;
    private static final int UNALLOCATED_COL = 3;
    private static final int OWNEDCAP_COL = 4;
    private static final int OWNEDFREESP_COL = 5;
    private static final int OSTYPE_COL = 6;
    private static final int NETWORKADDR_COL = 7;
    private static final int IPADDRESS_COL = 8;
    private static final int TIMEZONE_COL = 9;
    private static final int CPU_ARCH_COL = 10;
    private static final int COMPUTER_COL = 0;
    private static final int IN_ARRAY_COL = 4;
    private static final int MFR_COL = 5;
    private static final int MODEL_COL = 6;
    private static final int SERIAL_NUM_COL = 7;
    private static final int PRI_DEF_COL = 8;
    private static final int GROWN_DEF_COL = 9;
    private static final int USED_SPACE_COL = 3;
    private static final int FREE_SPACE_COL = 4;
    private static final int RAW_CAPACITY_COL = 5;
    private static final int OVERHEAD_COL = 6;
    private static final int NET_UNALLOCATED_COL = 7;
    private static final int UNKNOWN_COL = 8;
    public static final int SQUAL_COL = 0;
    private static final int SNAME_COL = 1;
    private static final int SCAPACITY_COL = 2;
    private static final int SFREESP_COL = 3;
    private static final int SDISKS_COL = 4;
    private static final int SLUNS_COL = 5;
    private static final int SLUNCAP_COL = 6;
    private static final int SUSEABLE_COL = 7;
    private static final int SASSIGNED_COL = 8;
    private static final int SUNASSIGNED_COL = 9;
    private static final int SOVERHEAD_COL = 10;
    private static final int SVSCAPACITY_COL = 11;
    private static final int SVSFREESPACE_COL = 12;
    private static final int SVOVERHEAD_COL = 13;
    private static final int SUFDGCAP_COL = 14;
    private static final int SCACHE_COL = 15;
    private static final int SMANUF_COL = 16;
    private static final int SMODEL_COL = 17;
    private static final int SSERIAL_COL = 18;
    private static final int SFIRM_COL = 19;
    private static final int STORSUBASSIGNEDCAPACITY_COL = 20;
    private static final int STORSUBUNASSIGNEDCAPACITY_COL = 21;
    private static final int STORSUBFORMATTEDDFRESPACE_COL = 22;
    private static final int ZOSLUNCAPACITY_COL = 23;
    private static final int OPENSYSLUNCAPACITY_COL = 24;
    private GuiReportReq grr;
    private RespFSspace[] data;
    private MutableLong[] mLong;
    private MutableInteger[] mInt;
    private GComputer[] gcomputer;
    private ComputerList computerList;
    private int[] rendererArray;
    private int rows;
    public int frozenRows;
    public int frozenLabels;
    public int totalRow;
    public static final int FROZEN_LABEL_ROWS = 0;
    public static final int FROZEN_ROWS = 2;
    public static final int FROZEN_COLUMNS = 2;
    private boolean batch;
    private ColumnPopulator populator;

    public DiskCapacityAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.populator = null;
        this.frozenColumns = 2;
        if (grr.reportSubtype == 77 || grr.reportType == 72) {
            this.populator = new BySubsystemPopulator();
            this.colNames = this.subColNames;
            this.frozenRows = 0;
            this.frozenLabels = 0;
            if (grr.reportSubtype == 78) {
                this.frozenColumns = 3;
            }
            this.rendererArray = new int[this.colNames.length];
            this.rendererArray[2] = 7;
            this.rendererArray[3] = 7;
            this.rendererArray[6] = 7;
            this.rendererArray[7] = 7;
            this.rendererArray[8] = 7;
            this.rendererArray[9] = 7;
            this.rendererArray[10] = 7;
            this.rendererArray[15] = 7;
            this.rendererArray[11] = 7;
            this.rendererArray[12] = 7;
            this.rendererArray[13] = 7;
            this.rendererArray[14] = 7;
            this.rendererArray[4] = 5;
            this.rendererArray[5] = 5;
            this.rendererArray[20] = 7;
            this.rendererArray[21] = 7;
            this.rendererArray[22] = 7;
            this.rendererArray[23] = 7;
            this.rendererArray[24] = 7;
        } else {
            this.colNames = this.colNames1;
            if (grr.reportSubtype == 12 || grr.reportSubtype == 82 || grr.reportSubtype == 13) {
                this.frozenRows = 0;
                this.frozenLabels = 0;
                this.colNames = this.compColNames1;
            } else {
                this.frozenRows = 0;
                this.frozenLabels = 0;
                this.frozenColumns = 0;
            }
            switch (grr.reportSubtype) {
                case 27: {
                    this.populator = new ByDiskPopulator();
                    this.colNames = this.dskColNames;
                    this.colNames[0] = COMPUTER;
                    this.colNames[1] = PATH;
                    break;
                }
                case 12: {
                    this.colNames = compColNames;
                    break;
                }
                case 13: {
                    this.colNames = this.compColNames2;
                    this.colNames[0] = CREATOR;
                    this.colNames[1] = GROUP;
                    break;
                }
                case 82: {
                    this.colNames = this.compColNames2;
                    this.colNames[0] = CREATOR;
                    this.colNames[1] = CLUSTER;
                    break;
                }
                case 14: {
                    this.colNames[1] = DOMAIN;
                    break;
                }
                case 15: {
                    this.populator = new NetworkWidePopulator();
                    this.colNames = this.netColNames;
                }
            }
            if (this.populator == null) {
                this.populator = new ByComputerPopulator();
            }
            this.rendererArray = new int[this.colNames.length];
            this.rendererArray[2] = 7;
            if (grr.reportSubtype != 15) {
                this.rendererArray[3] = 7;
            }
            if (grr.reportSubtype == 12 || grr.reportSubtype == 82 || grr.reportSubtype == 13) {
                this.rendererArray[4] = 7;
                this.rendererArray[5] = 7;
            } else if (grr.reportSubtype == 27) {
                this.rendererArray[8] = 5;
                this.rendererArray[9] = 5;
            } else if (grr.reportSubtype == 15) {
                this.rendererArray[3] = 7;
                this.rendererArray[4] = 7;
                this.rendererArray[5] = 7;
                this.rendererArray[6] = 7;
                this.rendererArray[7] = 7;
                this.rendererArray[8] = 7;
            }
        }
        if (grr.reportSubtype != 27 && grr.reportSubtype != 13) {
            if (grr.reportSubtype == 15) {
                this.hiddenColumns = new int[2];
                this.hiddenColumns[1] = 1;
            } else {
                this.hiddenColumns = new int[1];
            }
            this.hiddenColumns[0] = 0;
        }
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        if (this.grr.reportSubtype == 77) {
            Arrays.sort(dataArray, new SubSysSorter());
        } else {
            Arrays.sort(dataArray, new Sorter());
        }
        this.adjustInit(dataArray, batch);
        this.adjustData();
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.data = (RespFSspace[])dataArray;
        this.rows = this.data.length;
        if (this.grr.reportSubtype == 77 || this.grr.reportType == 72) {
            if (this.rows > 1) {
                this.addTotal();
            }
            int cnt = this.data.length;
            this.mLong = new MutableLong[cnt];
            this.mInt = new MutableInteger[cnt];
            for (int i = 0; i < cnt; ++i) {
                this.mLong[i] = new MutableLong();
                this.mInt[i] = new MutableInteger();
            }
        } else {
            if (this.grr.reportSubtype == 27 && this.rows > 1) {
                this.addTotal();
            }
            int cnt = this.data.length;
            this.mLong = new MutableLong[cnt];
            this.mInt = new MutableInteger[cnt];
            this.gcomputer = new GComputer[cnt];
            if (batch) {
                this.computerList = new ComputerList();
            }
            for (int i = 0; i < cnt; ++i) {
                this.mLong[i] = new MutableLong();
                this.mInt[i] = new MutableInteger();
            }
        }
    }

    public void adjustData() {
        if (this.grr.reportSubtype == 77 || this.grr.reportType == 72) {
            for (RespFSspace info : this.data) {
                info.creator = " ";
                info.capacity *= 512L;
                info.freeSpace *= 512L;
                info.lun_capacity *= 512L;
                info.fsFreeSpace *= 512L;
                info.fs_capacity *= 512L;
                info.vs_capacity *= 512L;
                info.vs_freespace *= 512L;
                info.dg_freecap *= 512L;
                info.overhead *= 512L;
                info.total_overhead *= 512L;
                info.disk_assigned_capacity *= 512L;
                info.disk_unassigned_capacity *= 512L;
                info.disk_total_formatted_free_space *= 512L;
                info.zos_lun_capacity *= 512L;
                info.open_sys_lun_capacity *= 512L;
            }
        } else {
            int cnt = this.data.length;
            for (int i = 0; i < cnt; ++i) {
                RespFSspace info = this.data[i];
                info.capacity *= 512L;
                info.freeSpace *= 512L;
                info.owned_capacity *= 512L;
                info.owned_freeSp *= 512L;
                if (i >= this.totalRow) {
                    if (this.grr.reportSubtype == 15) {
                        info.usedSpace *= 512L;
                        info.fsFreeSpace *= 512L;
                        info.fs_capacity *= 512L;
                        info.overhead *= 512L;
                        info.unallocated *= 512L;
                        info.unknown *= 512L;
                    }
                    if (this.batch) {
                        this.gcomputer[i] = this.computerList.getComputer(info.id);
                        continue;
                    }
                    switch (this.grr.reportSubtype) {
                        case 27: {
                            info.creator = GuiUtil.getComputer((int)info.id).gcTSName;
                            break;
                        }
                        case 12: {
                            this.gcomputer[i] = GuiUtil.getComputer(info.id);
                            info.setName(this.gcomputer[i].gcTSName);
                            break;
                        }
                        case 14: {
                            info.creator = " ";
                        }
                    }
                    continue;
                }
                if (this.grr.reportSubtype == 27 || this.grr.reportSubtype == 13 || this.grr.reportSubtype == 82) {
                    info.creator = MessageLog.getMessageNoID("STG4136L");
                    info.setName("");
                }
                this.gcomputer[i] = new GComputer();
            }
        }
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        if (this.grr.reportSubtype == 27) {
            ColumnDescriptor col = colArray[4];
            col.cdValidValue = new int[]{0, 1};
        } else if (this.grr.reportSubtype == 12) {
            ColumnDescriptor col = colArray[6];
            col.cdValidValue = ColumnDescriptor.OS_TYPES;
            col = colArray[10];
            col.cdValidValue = ColumnDescriptor.CPU_ARCHITECTURES;
        }
    }

    public Object getArray() {
        return this.data;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int getNumberFrozenRows() {
        if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 82 || this.grr.reportSubtype == 13) {
            return 0;
        }
        return 0;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        for (int i = 0; i < this.data.length; ++i) {
            RespFSspace dataRow = this.data[i];
            int objectID = dataRow.id;
            if (this.grr.reportSubtype == 27) {
                objectID = dataRow.fs_id;
            }
            HistChartProcessor.addLegend(this.grr, dataRow.creator, dataRow.getName(), objectID);
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] IDarray = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            RespFSspace dataRow = this.data[i];
            int objectID = dataRow.id;
            if (this.grr.reportSubtype == 27) {
                objectID = dataRow.fs_id;
            }
            IDarray[i] = objectID;
        }
        return IDarray;
    }

    public Object getCellData(int row, int col) {
        return this.populator.getCellData(row, col);
    }

    private void addTotal() {
        this.bHasTotalRow = true;
        RespFSspace[] plusArray = new RespFSspace[this.rows + 1];
        plusArray[0] = new RespFSspace();
        plusArray[0].setName(MessageLog.getMessageNoID("STG4136L"));
        plusArray[0].creator = " ";
        for (int ix = 0; ix < this.rows; ++ix) {
            if (this.data[ix].capacity > 0L) {
                plusArray[0].capacity += this.data[ix].capacity;
            }
            if (this.data[ix].freeSpace > 0L) {
                plusArray[0].freeSpace += this.data[ix].freeSpace;
            }
            if (this.data[ix].owned_capacity > 0L) {
                plusArray[0].owned_capacity += this.data[ix].owned_capacity;
            }
            if (this.data[ix].owned_freeSp > 0L) {
                plusArray[0].owned_freeSp += this.data[ix].owned_freeSp;
            }
            if (this.data[ix].primaryDefects > 0) {
                plusArray[0].primaryDefects += this.data[ix].primaryDefects;
            }
            if (this.data[ix].grownDefects > 0) {
                plusArray[0].grownDefects += this.data[ix].grownDefects;
            }
            if (this.data[ix].lun_capacity > 0L) {
                plusArray[0].lun_capacity += this.data[ix].lun_capacity;
            }
            if (this.data[ix].overhead > 0L && this.data[ix].osType != 21) {
                plusArray[0].overhead += this.data[ix].overhead;
            }
            if (this.data[ix].capacity > 0L && this.data[ix].osType != 21 && this.data[ix].osType != 26) {
                plusArray[0].total_overhead = this.data[ix].osType == 15 && this.data[ix].vs_capacity > 0L ? (plusArray[0].total_overhead += this.data[ix].vs_capacity - this.data[ix].vs_freespace - this.data[ix].lun_capacity) : (plusArray[0].total_overhead += this.data[ix].capacity - this.data[ix].dg_freecap - this.data[ix].vs_capacity);
            }
            if (this.data[ix].cache > 0L) {
                plusArray[0].cache += this.data[ix].cache;
            }
            if (this.data[ix].disks > 0) {
                plusArray[0].disks += this.data[ix].disks;
            }
            if (this.data[ix].luns > 0) {
                plusArray[0].luns += this.data[ix].luns;
            }
            if (this.data[ix].vs_capacity > 0L && this.data[ix].osType != 21) {
                plusArray[0].vs_capacity += this.data[ix].vs_capacity;
            }
            if (this.data[ix].vs_freespace > 0L && this.data[ix].osType != 21) {
                plusArray[0].vs_freespace += this.data[ix].vs_freespace;
            }
            if (this.data[ix].dg_freecap > 0L && this.data[ix].osType != 21) {
                plusArray[0].dg_freecap += this.data[ix].dg_freecap;
            }
            if (this.data[ix].fs_capacity > 0L) {
                plusArray[0].fs_capacity += this.data[ix].fs_capacity;
            }
            if (this.data[ix].fsFreeSpace > 0L) {
                plusArray[0].fsFreeSpace += this.data[ix].fsFreeSpace;
            }
            if (this.data[ix].disk_assigned_capacity > 0L && this.data[ix].osType != 21) {
                plusArray[0].disk_assigned_capacity += this.data[ix].disk_assigned_capacity;
            }
            if (this.data[ix].disk_unassigned_capacity > 0L && this.data[ix].osType != 21) {
                plusArray[0].disk_unassigned_capacity += this.data[ix].disk_unassigned_capacity;
            }
            if (this.data[ix].disk_total_formatted_free_space > 0L && this.data[ix].osType != 21) {
                plusArray[0].disk_total_formatted_free_space += this.data[ix].disk_total_formatted_free_space;
            }
            if (this.data[ix].zos_lun_capacity > 0L && this.data[ix].osType != 21) {
                plusArray[0].zos_lun_capacity += this.data[ix].zos_lun_capacity;
            }
            if (this.data[ix].open_sys_lun_capacity > 0L) {
                plusArray[0].open_sys_lun_capacity += this.data[ix].open_sys_lun_capacity;
            }
            plusArray[ix + 1] = this.data[ix];
        }
        this.data = plusArray;
        ++this.frozenRows;
        this.totalRow = 1;
        ++this.rows;
    }

    static {
        String[] twopieces = new String[2];
        String[] threepieces = new String[3];
        Util.breakIntoTwo(MessageLog.getMessageNoID("STG7012L"), twopieces);
        TOTAL_TC = twopieces[0];
        CAPACITY_TC = twopieces[1];
        Util.breakIntoThree(MessageLog.getMessageNoID("STG7013L"), threepieces);
        TOTAL_TF = threepieces[0];
        UNALLOCATED_TF = threepieces[1];
        SPACE_TF = threepieces[2];
        Util.breakIntoTwo(MessageLog.getMessageNoID("STG7014L"), twopieces);
        OWNED_OC = twopieces[0];
        CAPACITY_OC = twopieces[1];
        Util.breakIntoThree(MessageLog.getMessageNoID("STG7015L"), threepieces);
        OWNED_OF = threepieces[0];
        UNALLOCATED_OF = threepieces[1];
        SPACE_OF = threepieces[2];
        Util.breakIntoTwo(MessageLog.getMessageNoID("STG1038L"), twopieces);
        CPU = twopieces[0];
        ARCHITECTURE = twopieces[1];
        compColNames = new String[]{" ", COMPUTER, TOTAL_TC + " " + CAPACITY_TC, TOTAL_TF + " " + UNALLOCATED_TF + " " + SPACE_TF, OWNED_OC + " " + CAPACITY_OC, OWNED_OF + " " + UNALLOCATED_OF + " " + SPACE_OF, OSTYPE, NETWORKADDR, IPADDRESS, TIMEZONE, CPU};
        clusterColNames = new String[]{" ", CLUSTER, TOTAL_TC + " " + CAPACITY_TC, TOTAL_TF + " " + UNALLOCATED_TF + " " + SPACE_TF, OWNED_OC + " " + CAPACITY_OC, OWNED_OF + " " + UNALLOCATED_OF + " " + SPACE_OF, OSTYPE, NETWORKADDR, IPADDRESS, TIMEZONE};
    }

    private class SubSysSorter
    implements Comparator {
        private SubSysSorter() {
        }

        public int compare(Object o1, Object o2) {
            RespFSspace r1 = (RespFSspace)o1;
            RespFSspace r2 = (RespFSspace)o2;
            return -r1.getName().compareTo(r2.getName());
        }
    }

    private class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object o1, Object o2) {
            RespFSspace r1 = (RespFSspace)o1;
            RespFSspace r2 = (RespFSspace)o2;
            if (r1.capacity == r2.capacity) {
                return 0;
            }
            if (r1.capacity > r2.capacity) {
                return -1;
            }
            return 1;
        }
    }

    private class NetworkWidePopulator
    implements ColumnPopulator {
        private NetworkWidePopulator() {
        }

        public Object getCellData(int row, int column) {
            RespFSspace record = DiskCapacityAdjuster.this.data[row];
            Object result = null;
            switch (column) {
                case 1: {
                    result = NETWORK;
                    break;
                }
                case 2: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = record.capacity;
                    result = DiskCapacityAdjuster.this.mLong[row];
                    break;
                }
                case 3: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = record.usedSpace;
                    result = DiskCapacityAdjuster.this.mLong[row];
                    break;
                }
                case 4: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = record.fsFreeSpace;
                    result = DiskCapacityAdjuster.this.mLong[row];
                    break;
                }
                case 5: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = record.fs_capacity;
                    result = DiskCapacityAdjuster.this.mLong[row];
                    break;
                }
                case 6: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = record.overhead;
                    result = DiskCapacityAdjuster.this.mLong[row];
                    break;
                }
                case 7: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = record.unallocated;
                    result = DiskCapacityAdjuster.this.mLong[row];
                    break;
                }
                case 8: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = record.unknown;
                    result = DiskCapacityAdjuster.this.mLong[row];
                }
            }
            return result;
        }
    }

    private class BySubsystemPopulator
    implements ColumnPopulator {
        private BySubsystemPopulator() {
        }

        public Object getCellData(int row, int column) {
            switch (column) {
                case 1: {
                    return DiskCapacityAdjuster.this.data[row].getName();
                }
                case 4: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].disks;
                    return DiskCapacityAdjuster.this.mInt[row];
                }
                case 2: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 3: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].freeSpace;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 5: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].luns;
                    return DiskCapacityAdjuster.this.mInt[row];
                }
                case 6: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].lun_capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 7: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].fs_capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 8: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].fsFreeSpace;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 9: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].fs_capacity - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].fsFreeSpace;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 10: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].overhead;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 11: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].vs_capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 12: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].vs_freespace;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 13: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = DiskCapacityAdjuster.this.bHasTotalRow && row == 0 ? ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].total_overhead : (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 21 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 16 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 26 ? -1L : (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 15 ? ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].vs_capacity - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].vs_freespace - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].lun_capacity : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].capacity - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].dg_freecap - ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].vs_capacity));
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 14: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = DiskCapacityAdjuster.this.bHasTotalRow && row == 0 ? ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].dg_freecap : (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 12 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 25 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 27 || ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 15 ? ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].dg_freecap : -1L);
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 15: {
                    long bytes = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].cache;
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = bytes <<= 20;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 16: {
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].manufacturer == null) {
                        return " ";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].manufacturer.toLowerCase().equals("unknown")) {
                        return UNKNOWN;
                    }
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].manufacturer;
                }
                case 17: {
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].model == null) {
                        return " ";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].model.toLowerCase().equals("unknown")) {
                        return UNKNOWN;
                    }
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].model;
                }
                case 18: {
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].serialNumber == null) {
                        return " ";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].serialNumber.toLowerCase().equals("unknown")) {
                        return UNKNOWN;
                    }
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].serialNumber;
                }
                case 19: {
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].firmware == null) {
                        return " ";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].firmware.toLowerCase().equals("unknown")) {
                        return UNKNOWN;
                    }
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].firmware;
                }
                case 20: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].disk_assigned_capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 21: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].disk_unassigned_capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 22: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].disk_total_formatted_free_space;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 23: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].osType == 21 ? -1L : ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].zos_lun_capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 24: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].open_sys_lun_capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
            }
            return null;
        }
    }

    private class ByComputerPopulator
    implements ColumnPopulator {
        private ByComputerPopulator() {
        }

        public Object getCellData(int row, int col) {
            switch (col) {
                case 0: {
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].creator;
                }
                case 1: {
                    return DiskCapacityAdjuster.this.data[row].getName();
                }
                case 2: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 3: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].freeSpace;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 4: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].owned_capacity;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 5: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).data[row].owned_freeSp;
                    return DiskCapacityAdjuster.this.mLong[row];
                }
                case 6: {
                    if (row == 0 && DiskCapacityAdjuster.this.totalRow >= 1) {
                        return "";
                    }
                    if (((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[row].gcOsType == 0) {
                        return UNKNOWN;
                    }
                    return MessageLog.getMessageNoID(Constants.OSTYPES[((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[row].gcOsType]);
                }
                case 7: {
                    return Util.getDotName(((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[row].gcNetworkName, ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[row].gcDomainName);
                }
                case 8: {
                    return ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[row].gcIpAddress;
                }
                case 9: {
                    return Util.formatTimeZone(((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[row].gcTimezoneID);
                }
                case 10: {
                    if (row == 0 && DiskCapacityAdjuster.this.totalRow >= 1) {
                        return "";
                    }
                    return ComputersAdjuster.getCPUArchString(((DiskCapacityAdjuster)DiskCapacityAdjuster.this).gcomputer[row].gcCPUArchitecture);
                }
            }
            return null;
        }
    }

    private class ByDiskPopulator
    implements ColumnPopulator {
        private ByDiskPopulator() {
        }

        public Object getCellData(int row, int column) {
            RespFSspace record = DiskCapacityAdjuster.this.data[row];
            Object result = null;
            switch (column) {
                case 0: {
                    result = record.creator;
                    break;
                }
                case 1: {
                    result = record.getName();
                    break;
                }
                case 2: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = record.capacity;
                    result = DiskCapacityAdjuster.this.mLong[row];
                    break;
                }
                case 3: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mLong[row].value = record.freeSpace;
                    result = DiskCapacityAdjuster.this.mLong[row];
                    break;
                }
                case 5: {
                    result = record.manufacturer;
                    break;
                }
                case 6: {
                    if (row == 0 && DiskCapacityAdjuster.this.totalRow >= 1) {
                        result = "";
                        break;
                    }
                    if (Util.isEmpty(record.model)) {
                        result = UNKNOWN;
                        break;
                    }
                    result = record.model;
                    break;
                }
                case 4: {
                    if (row == 0 && DiskCapacityAdjuster.this.totalRow >= 1) {
                        result = "";
                        break;
                    }
                    if (record.directoryCount > 0L) {
                        result = DiskAdjuster.YES;
                        break;
                    }
                    result = DiskAdjuster.NO;
                    break;
                }
                case 7: {
                    result = record.serialNumber;
                    break;
                }
                case 8: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[row].value = record.primaryDefects;
                    result = DiskCapacityAdjuster.this.mInt[row];
                    break;
                }
                case 9: {
                    ((DiskCapacityAdjuster)DiskCapacityAdjuster.this).mInt[row].value = record.grownDefects;
                    result = DiskCapacityAdjuster.this.mInt[row];
                }
            }
            return result;
        }
    }

    private static interface ColumnPopulator {
        public Object getCellData(int var1, int var2);
    }
}

