/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Date;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskHistAdjuster
extends ReportDataAdjuster {
    static final String PRIMARY_DEFECTS = MessageLog.getMessageNoID("STG1200L");
    static final String GROWN_DEFECTS = MessageLog.getMessageNoID("STG1201L");
    static final String REC_WRITE_ERRS = MessageLog.getMessageNoID("STG1202L");
    static final String UNREC_WRITE_ERRS = MessageLog.getMessageNoID("STG1203L");
    static final String BYTES_WRITTEN = MessageLog.getMessageNoID("STG1204L");
    static final String REC_READ_ERRS = MessageLog.getMessageNoID("STG1205L");
    static final String UNREC_READ_ERRS = MessageLog.getMessageNoID("STG1206L");
    static final String BYTES_READ = MessageLog.getMessageNoID("STG1207L");
    static final String REC_VERIFY_ERRS = MessageLog.getMessageNoID("STG1208L");
    static final String UNREC_VERIFY_ERRS = MessageLog.getMessageNoID("STG1209L");
    static final String NON_MEDIUM_ERRS = MessageLog.getMessageNoID("STG1210L");
    static final String TIMESTAMP = MessageLog.getMessageNoID("STG1211L");
    static final String TEMP = MessageLog.getMessageNoID("STG1212L");
    static final String UNALLOCATED = MessageLog.getMessageNoID("STG4131L");
    static final String RECORD_TYPE = MessageLog.getMessageNoID("STG1214L");
    static final int TIMESTAMP_COL = 0;
    static final int RECORD_TYPE_COL = 1;
    static final int BYTES_WRITTEN_COL = 2;
    static final int BYTES_READ_COL = 3;
    static final int GROWN_DEFECTS_COL = 4;
    static final int REC_WRITE_ERRS_COL = 5;
    static final int UNREC_WRITE_ERRS_COL = 6;
    static final int REC_READ_ERRS_COL = 7;
    static final int UNREC_READ_ERRS_COL = 8;
    static final int REC_VERIFY_ERRS_COL = 9;
    static final int UNREC_VERIFY_ERRS_COL = 10;
    static final int NON_MEDIUM_ERRS_COL = 11;
    static final int UNALLOCATED_COL = 12;
    static final int PRIMARY_DEFECTS_COL = 13;
    static final int TEMP_COL = 14;
    public static final String[] colNames = new String[]{TIMESTAMP, RECORD_TYPE, BYTES_WRITTEN, BYTES_READ, GROWN_DEFECTS, REC_WRITE_ERRS, UNREC_WRITE_ERRS, REC_READ_ERRS, UNREC_READ_ERRS, REC_VERIFY_ERRS, UNREC_VERIFY_ERRS, NON_MEDIUM_ERRS, UNALLOCATED, PRIMARY_DEFECTS, TEMP};
    private DiskHistory[] histArray;
    private int[] rendererArray;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private short osType;

    public DiskHistAdjuster(short osType) {
        this.osType = osType;
    }

    public void adjust(Object[] dataArray, boolean unused) {
        this.histArray = (DiskHistory[])dataArray;
        int count = this.histArray.length;
        this.mDate = new Date[count];
        this.mInt = new MutableInteger[count];
        this.mLong = new MutableLong[count];
        for (int i = 0; i < count; ++i) {
            this.mDate[i] = new Date();
            this.mInt[i] = new MutableInteger();
            this.mLong[i] = new MutableLong();
            this.histArray[i].dkhFreeSpace *= 512L;
        }
        this.rendererArray = new int[colNames.length];
        this.rendererArray[0] = 1;
        this.rendererArray[2] = 7;
        this.rendererArray[3] = 7;
        this.rendererArray[4] = 5;
        this.rendererArray[5] = 5;
        this.rendererArray[6] = 5;
        this.rendererArray[7] = 5;
        this.rendererArray[8] = 5;
        this.rendererArray[9] = 5;
        this.rendererArray[10] = 5;
        this.rendererArray[11] = 5;
        this.rendererArray[12] = 7;
        this.rendererArray[13] = 5;
        this.rendererArray[14] = 5;
    }

    public String[] getLabels() {
        return colNames;
    }

    public int getNumberRows() {
        return this.histArray.length;
    }

    public int getNumberColumns() {
        return colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getArray() {
        return this.histArray;
    }

    public Object getCellData(int row, int col) {
        switch (col) {
            case 0: {
                this.mDate[row].setTime(this.histArray[row].dkhTimestamp);
                return this.mDate[row];
            }
            case 1: {
                return DiskHistory.TYPES[this.histArray[row].dkhType];
            }
            case 2: {
                this.mLong[row].value = this.histArray[row].dkhBytesWritten;
                return this.mLong[row];
            }
            case 3: {
                this.mLong[row].value = this.histArray[row].dkhBytesRead;
                return this.mLong[row];
            }
            case 4: {
                this.mInt[row].value = this.histArray[row].dkhGrownDefects;
                return this.mInt[row];
            }
            case 5: {
                this.mInt[row].value = this.histArray[row].dkhRecoveredWriteErrors;
                return this.mInt[row];
            }
            case 6: {
                this.mInt[row].value = this.histArray[row].dkhUnrecoveredWriteErrors;
                return this.mInt[row];
            }
            case 7: {
                this.mInt[row].value = this.histArray[row].dkhRecoveredReadErrors;
                return this.mInt[row];
            }
            case 8: {
                this.mInt[row].value = this.histArray[row].dkhUnrecoveredReadErrors;
                return this.mInt[row];
            }
            case 9: {
                this.mInt[row].value = this.histArray[row].dkhRecoveredVerifyErrors;
                return this.mInt[row];
            }
            case 10: {
                this.mInt[row].value = this.histArray[row].dkhUnrecoveredVerifyErrors;
                return this.mInt[row];
            }
            case 11: {
                this.mInt[row].value = this.histArray[row].dkhNonMediumErrors;
                return this.mInt[row];
            }
            case 12: {
                this.mLong[row].value = this.histArray[row].dkhFreeSpace;
                return this.mLong[row];
            }
            case 13: {
                this.mInt[row].value = this.histArray[row].dkhPrimaryDefects;
                return this.mInt[row];
            }
            case 14: {
                this.mInt[row].value = this.histArray[row].dkhTemperature;
                return this.mInt[row];
            }
        }
        return null;
    }

    public boolean hasTotalsRow() {
        return false;
    }
}

