/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.Export;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class ExportsAdjuster
extends CustomReportDataAdjuster {
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String EXPORT = MessageLog.getMessageNoID("STG1243L");
    private static final String PATH = MessageLog.getMessageNoID("STG1219L");
    private static final String PROTOCOL = MessageLog.getMessageNoID("STG1244L");
    private static final String DISCOVERED = MessageLog.getMessageNoID("STG1134L");
    public String[] columnNameList = new String[]{COMPUTER, EXPORT, PATH, PROTOCOL, DISCOVERED};
    private static final int COMPUTER_COL = 0;
    private static final int EXPORT_COL = 1;
    private static final int PATH_COL = 2;
    private static final int PROTOCOL_COL = 3;
    private static final int DISCOVERED_COL = 4;
    private Export[] exports;
    private Date[] discDate;
    private GuiReportReq grr;
    private int[] rendererArray;
    private boolean batch;

    public ExportsAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.rendererArray = new int[this.columnNameList.length];
        this.rendererArray[4] = 1;
        this.columnNameList = this.getCustomizedColNames(this.columnNameList);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
        if (this.grr.reportSubtype == 37) {
            Arrays.sort(this.exports, new Sorter());
        }
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.exports = (Export[])dataArray;
        int cnt = this.exports.length;
        this.discDate = new Date[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.discDate[i] = new Date();
        }
    }

    public void adjustData() {
        int cnt = this.exports.length;
        for (int i = 0; i < cnt; ++i) {
            if (this.batch) continue;
            this.exports[i].xpComputerName = GuiUtil.getComputer((int)this.exports[i].xpComputerID).gcTSName;
        }
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        colArray[3].cdValidValue = ColumnDescriptor.EXPORT_PROTOCOLS;
    }

    public int getNumberRows() {
        return this.exports.length;
    }

    public int getNumberColumns() {
        return this.columnNameList.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getCellData(int row, int col) {
        switch (col) {
            case 0: {
                return this.exports[row].xpComputerName;
            }
            case 1: {
                return this.exports[row].xpExportName;
            }
            case 2: {
                return this.exports[row].xpPath;
            }
            case 3: {
                return Export.PROTOCOL[this.exports[row].xpProtocol];
            }
            case 4: {
                this.discDate[row].setTime(this.exports[row].xpDiscoveredTime);
                return this.discDate[row];
            }
        }
        return null;
    }

    private class Sorter
    implements Comparator {
        private Sorter() {
        }

        public int compare(Object o1, Object o2) {
            Export r1 = (Export)o1;
            Export r2 = (Export)o2;
            if (r1.xpDiscoveredTime == r2.xpDiscoveredTime) {
                return 0;
            }
            if (r1.xpDiscoveredTime > r2.xpDiscoveredTime) {
                return -1;
            }
            return 1;
        }
    }
}

