/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.common.Encrypt;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;

public class FabricDiscoveryOptions {
    private String defaultCommunityStr;
    private int scanTimeout;
    private String scanTimeoutStr;
    private String userNameStr;
    private String passwordStr;

    public FabricDiscoveryOptions(String options) {
        int firstSeparator;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(FabricDiscoveryOptions.class.getName(), "FabricDiscoveryOptions", "options");
        }
        this.scanTimeout = 0;
        this.defaultCommunityStr = "";
        this.userNameStr = "";
        this.passwordStr = "";
        if (!Util.isEmpty(options) && (firstSeparator = options.indexOf(44)) != -1) {
            this.defaultCommunityStr = options.substring(0, firstSeparator);
            int secondSeparator = options.indexOf(44, firstSeparator + 1);
            if (secondSeparator != -1) {
                this.scanTimeoutStr = options.substring(firstSeparator + 1, secondSeparator);
                this.scanTimeout = Util.isEmpty(this.scanTimeoutStr) ? 0 : Integer.parseInt(this.scanTimeoutStr);
                int thirdSeparator = options.indexOf(44, secondSeparator + 1);
                if (thirdSeparator != -1) {
                    this.userNameStr = options.substring(secondSeparator + 1, thirdSeparator);
                    this.passwordStr = options.substring(thirdSeparator + 1, options.length());
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(FabricDiscoveryOptions.class.getName(), "FabricDiscoveryOptions");
        }
    }

    public void setScanTimeout(String timeout) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(FabricDiscoveryOptions.class.getName(), "setScanLimit", "limit");
        }
        this.scanTimeoutStr = timeout;
        this.scanTimeout = Util.isEmpty(timeout) ? 0 : Integer.parseInt(timeout);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(FabricDiscoveryOptions.class.getName(), "setScanTimeout");
        }
    }

    public int getScanTimeout() {
        return this.scanTimeout;
    }

    public String getScanTimeoutString() {
        return this.scanTimeoutStr;
    }

    public void setDefaultCommunity(String comm) {
        this.defaultCommunityStr = comm;
    }

    public String getDefaultCommunity() {
        return this.defaultCommunityStr;
    }

    public void setUserName(String name) {
        this.userNameStr = name;
    }

    public String getUserName() {
        return this.userNameStr;
    }

    public void setPassword(String pwd) {
        String encryptedPwd = "";
        String blank = "";
        if (!Util.isEmpty(pwd)) {
            try {
                encryptedPwd = Encrypt.encrypt(pwd);
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDiscoveryOptions.class.getName(), "setPassword", e);
                }
                this.passwordStr = blank;
            }
        }
        this.passwordStr = encryptedPwd;
    }

    public void setPasswordStr(String pwd) {
        this.passwordStr = pwd;
    }

    public String getPasword() {
        String decryptedPwd = "";
        String blank = "";
        if (!Util.isEmpty(this.passwordStr)) {
            try {
                decryptedPwd = Encrypt.decrypt(this.passwordStr);
            }
            catch (Exception e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception(FabricDiscoveryOptions.class.getName(), "getPassword", e);
                }
                return blank;
            }
        }
        return decryptedPwd;
    }

    public String getOptionsString() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(FabricDiscoveryOptions.class.getName(), "getOptionsString", "");
        }
        StringBuffer optionsString = new StringBuffer();
        optionsString.append(this.defaultCommunityStr + ',');
        if (this.scanTimeout != 0) {
            optionsString.append(this.scanTimeoutStr + ',');
        } else {
            optionsString.append(',');
        }
        optionsString.append(this.userNameStr + ',');
        optionsString.append(this.passwordStr);
        String traceResult = optionsString.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(FabricDiscoveryOptions.class.getName(), "getOptionsString", traceResult);
        }
        return traceResult;
    }
}

