/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.common.Util;

public class LdapTree
implements Serializable {
    static final long serialVersionUID = -9214883649970322355L;
    public transient LdapTree ltNext;
    public int ltTreeID;
    public int ltComputerID;
    private String ltName;
    public String ltLdapUser;
    public String ltPassword;
    public transient String ltComputerName;
    public transient boolean ltHasComputers;

    public static LdapTree[] pack(LdapTree head) {
        int count = 0;
        LdapTree ldap = head;
        while (ldap != null) {
            ++count;
            ldap = ldap.ltNext;
        }
        LdapTree[] result = new LdapTree[count];
        count = 0;
        while (head != null) {
            result[count] = head;
            ++count;
            ldap = head.ltNext;
            head.ltNext = null;
            head = ldap;
        }
        return result;
    }

    public static LdapTree unpack(LdapTree[] array) {
        LdapTree result;
        int count = 0;
        if (array != null) {
            count = array.length;
        }
        if (count == 0) {
            return null;
        }
        LdapTree prev = result = array[0];
        for (int i = 1; i < count; ++i) {
            LdapTree ldap;
            prev.ltNext = ldap = array[i];
            prev = ldap;
        }
        return result;
    }

    public String getLtName() {
        return Util.getTranslatedName(this.ltName);
    }

    public String getTrueLtName() {
        return this.ltName;
    }

    public void setLtName(String string) {
        this.ltName = string;
    }
}

