/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Calendar;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.common.TableCellStrings;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrintHtmlTable {
    DateFormat df = DateFormat.getDateTimeInstance();
    DecimalFormat d0Fmt = new DecimalFormat();
    static final String CREATED_BY = MessageLog.getMessageNoID("GEN0192L");
    static final String PRINTED_ON = MessageLog.getMessageNoID("GEN0193L");

    public void printHtml(ReportDataAdjuster adjuster, PrintWriter pWriter, int[] columnArray, String creator, String title, int[] rowMap) {
        boolean makeGray;
        int k;
        String data;
        int col;
        int k2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(PrintHtmlTable.class.getName(), "printHtml", "adjuster, pWriter, columnArray, creator, title, rowMap");
        }
        this.d0Fmt.setMaximumFractionDigits(2);
        PrintWriter writer = pWriter;
        StringBuffer buffer = new StringBuffer(25);
        int scale = adjuster.getScale();
        String suffix = adjuster.getSuffix();
        String[] labels1 = adjuster.getLabels();
        int numCols = labels1.length;
        int frozenRows = adjuster.getNumberFrozenRows();
        int spannedRows = adjuster.getNumberSpannedRows();
        int[] rendererArray = adjuster.getRenderers();
        int numRows = adjuster.getNumberRows() + frozenRows;
        int firstNonSpannedRow = 0;
        if (spannedRows > 0) {
            firstNonSpannedRow = spannedRows - 1;
        }
        this.printPrelude(writer, creator, title, columnArray.length * 100, true);
        if (spannedRows > 0) {
            int k3;
            int row;
            boolean[] spanners = new boolean[numCols];
            for (k2 = 0; k2 < columnArray.length; ++k2) {
                col = columnArray[k2];
                int nextCol = col + 1;
                if (nextCol >= labels1.length || labels1[nextCol].length() != 0) continue;
                spanners[col] = true;
                ++k2;
            }
            int span = frozenRows + 1;
            String markup = "      <th rowspan = \"" + span + "\" align=\"left\">";
            for (int k4 = 0; k4 < columnArray.length; ++k4) {
                col = columnArray[k4];
                if (spanners[col]) {
                    writer.print("      <th colspan=\"2\">");
                    writer.print(labels1[col]);
                    ++k4;
                } else {
                    writer.print(markup);
                    data = labels1[col];
                    for (int row2 = 0; row2 < frozenRows; ++row2) {
                        data = data + " " + (String)adjuster.getCellData(adjuster.getRowIndex(row2, rowMap), col);
                    }
                    writer.print(data);
                }
                writer.println("</th>");
            }
            writer.println("   </tr>");
            for (row = 0; row < spannedRows - 1; ++row) {
                writer.println("   <tr class=\"header\">");
                for (k3 = 0; k3 < columnArray.length; ++k3) {
                    col = columnArray[k3];
                    if (!spanners[col]) continue;
                    data = (String)adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                    writer.print("      <th colspan=\"2\">");
                    writer.print(data);
                    writer.println("</th>");
                    ++k3;
                }
                writer.println("   </tr>");
            }
            for (row = firstNonSpannedRow; row < frozenRows; ++row) {
                writer.println("   <tr class=\"header\">");
                for (k3 = 0; k3 < columnArray.length; ++k3) {
                    col = columnArray[k3];
                    if (!spanners[col]) continue;
                    data = (String)adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                    writer.print("      <th align=\"left\">");
                    writer.print(data);
                    writer.println("</th>");
                    col = columnArray[++k3];
                    data = (String)adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                    writer.print("      <th align=\"left\">");
                    writer.print(data);
                    writer.println("</th>");
                }
                writer.println("   </tr>");
            }
        } else if (frozenRows == 0) {
            for (k = 0; k < columnArray.length; ++k) {
                col = columnArray[k];
                writer.print("      <th align=\"left\">");
                writer.print(labels1[col]);
                writer.println("</th>");
            }
            writer.println("   </tr>");
        } else {
            for (k = 0; k < columnArray.length; ++k) {
                writer.print("      <th align=\"left\">");
                col = columnArray[k];
                data = labels1[col];
                for (int row = 0; row < frozenRows; ++row) {
                    data = data + " " + (String)adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                }
                writer.print(data);
                writer.println("</th>");
            }
            writer.println("   </tr>");
        }
        if (adjuster.hasTotalsRow()) {
            writer.println("   <tr class=\"totals\">");
            makeGray = true;
        } else {
            writer.println("   <tr>");
            makeGray = false;
        }
        for (int row = frozenRows; row < numRows; ++row) {
            if (row > frozenRows) {
                if (makeGray) {
                    writer.println("   <tr class=\"gray\">");
                } else {
                    writer.println("   <tr>");
                }
            }
            for (k2 = 0; k2 < columnArray.length; ++k2) {
                col = columnArray[k2];
                int rendererType = rendererArray[col];
                Object obj = adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                switch (rendererType) {
                    case 0: {
                        data = (String)obj;
                        break;
                    }
                    case 7: {
                        data = TableCellStrings.SpaceRenderer(obj);
                        break;
                    }
                    case 1: {
                        data = TableCellStrings.DateRenderer(obj, this.df);
                        break;
                    }
                    case 2: {
                        data = TableCellStrings.DecimalRenderer(scale, suffix, obj, buffer);
                        break;
                    }
                    case 5: {
                        data = TableCellStrings.NumberRenderer(obj, this.d0Fmt);
                        break;
                    }
                    case 4: {
                        data = TableCellStrings.MegabyteRenderer(obj, this.d0Fmt);
                        break;
                    }
                    case 6: {
                        data = TableCellStrings.PercentRenderer(obj, this.d0Fmt);
                        break;
                    }
                    case 3: {
                        data = TableCellStrings.DurationRenderer(obj, buffer);
                        break;
                    }
                    case 8: {
                        data = TableCellStrings.SpaceNoDecimalRenderer(obj);
                        break;
                    }
                    case 9: {
                        data = Util.formatHertz(((Number)obj).intValue());
                        break;
                    }
                    default: {
                        data = "-";
                    }
                }
                if (Util.isEmpty(data)) {
                    data = "-";
                }
                if (obj instanceof Number) {
                    writer.print("      <td align=\"right\">");
                } else {
                    writer.print("      <td>");
                }
                writer.print(data);
                writer.println("</td>");
            }
            makeGray = !makeGray;
            writer.println("   </tr>");
        }
        writer.println("</table>");
        writer.println(" ");
        writer.println("</body>");
        writer.println("</html>");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(PrintHtmlTable.class.getName(), "printHtml");
        }
    }

    public void printPrelude(PrintWriter writer, String creator, String title, int width, boolean needTable) {
        writer.println("<html>");
        writer.println("<head>");
        writer.print("<title>");
        writer.print(title);
        writer.println("</title>");
        writer.println(" ");
        writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />");
        writer.println("<style type=\"text/css\">");
        writer.println("   .title   { color: #000066  }");
        writer.println("   table.report { background-color: #FFFFFF   }");
        writer.println("   tr.header { background-color: #6666FF  }");
        writer.println("   tr.totals { background-color: #FFFF99 }");
        writer.println("   tr.gray   { background-color: #CCCCFF   }");
        writer.println("</style>");
        writer.println(" ");
        writer.println("</head>");
        writer.println("<body>");
        writer.println(" ");
        writer.print("<h2 class=\"title\">");
        writer.print(title);
        writer.println("</h2>");
        writer.println(" ");
        writer.print("<h4 class=\"title\">");
        writer.print(CREATED_BY);
        writer.print(" ");
        writer.print(creator);
        writer.print("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        writer.print(PRINTED_ON);
        writer.print(" ");
        writer.print(DateFormat.getDateTimeInstance(2, 2).format(Calendar.getInstance().getTime()));
        writer.println("</h4>");
        writer.println(" ");
        if (needTable) {
            writer.print("<table class=\"report\" border=\"0\" width=\"");
            writer.print(width);
            writer.println("\"  cellpadding=\"3\" cellspacing=\"2\">");
            writer.println("   <tr class=\"header\">");
        }
    }
}

