/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.awt.Color;
import java.text.DateFormat;
import java.text.DecimalFormat;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.common.PrintOptions;
import org.eclipse.aperi.common.TableCellStrings;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class PrintTable {
    private DateFormat df = DateFormat.getDateTimeInstance();
    private DecimalFormat d0Fmt = new DecimalFormat();
    static final Color HEADER_COLOR = Color.green;
    static final String CREATED_BY = MessageLog.getMessageNoID("GEN0192L");
    static final String PRINTED = MessageLog.getMessageNoID("GEN0193L");

    public void print(ReportDataAdjuster adjuster, PrintOptions options, int[] columnArray, int[] rowMap) {
        String data;
        int k;
        int row;
        int col;
        Object obj;
        int k2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(PrintTable.class.getName(), "print", "adjuster, options, columnArray");
        }
        this.d0Fmt.setMaximumFractionDigits(2);
        StringBuffer buffer = new StringBuffer(25);
        int scale = adjuster.getScale();
        String suffix = adjuster.getSuffix();
        String[] labels1 = adjuster.getLabels();
        int numCols = labels1.length;
        int frozenRows = adjuster.getNumberFrozenRows();
        int spannedRows = adjuster.getNumberSpannedRows();
        int[] rendererArray = adjuster.getRenderers();
        int numRows = adjuster.getNumberRows() + frozenRows;
        int firstNonSpannedRow = 0;
        if (spannedRows > 0) {
            firstNonSpannedRow = spannedRows - 1;
        }
        int fontSize = options.outFile == null ? 8 : 10;
        for (k2 = 0; k2 < columnArray.length; ++k2) {
            obj = adjuster.getCellData(frozenRows, columnArray[k2]);
            if (!(obj instanceof Number)) continue;
        }
        if (spannedRows > 0) {
            int k3;
            boolean[] spanners = new boolean[numCols];
            for (k3 = 0; k3 < columnArray.length; ++k3) {
                col = columnArray[k3];
                int nextCol = col + 1;
                if (nextCol >= labels1.length || labels1[nextCol].length() != 0) continue;
                spanners[col] = true;
                ++k3;
            }
            for (k3 = 0; k3 < columnArray.length; ++k3) {
                col = columnArray[k3];
                if (!spanners[col]) continue;
                ++k3;
            }
            for (row = 0; row < spannedRows - 1; ++row) {
                for (k = 0; k < columnArray.length; ++k) {
                    col = columnArray[k];
                    data = (String)adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                    if (!spanners[col]) continue;
                    ++k;
                }
            }
            for (row = firstNonSpannedRow; row < frozenRows; ++row) {
                for (k = 0; k < columnArray.length; ++k) {
                    col = columnArray[k];
                    data = (String)adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                }
            }
        } else {
            for (k2 = 0; k2 < columnArray.length; ++k2) {
                col = columnArray[k2];
            }
            if (frozenRows > 0) {
                for (int row2 = 0; row2 < frozenRows; ++row2) {
                    for (int k4 = 0; k4 < columnArray.length; ++k4) {
                        col = columnArray[k4];
                        data = (String)adjuster.getCellData(adjuster.getRowIndex(row2, rowMap), col);
                    }
                }
            }
        }
        int tableRow = 0;
        boolean makeGray = adjuster.hasTotalsRow();
        for (row = frozenRows; row < numRows; ++row) {
            for (k = 0; k < columnArray.length; ++k) {
                col = columnArray[k];
                int rendererType = rendererArray[col];
                obj = adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                data = rendererType == 0 ? (obj == null ? " " : (String)obj) : (rendererType == 7 ? TableCellStrings.SpaceRenderer(obj) : (rendererType == 1 ? TableCellStrings.DateRenderer(obj, this.df) : (rendererType == 2 ? TableCellStrings.DecimalRenderer(scale, suffix, obj, buffer) : (rendererType == 5 ? TableCellStrings.NumberRenderer(obj, this.d0Fmt) : (rendererType == 4 ? TableCellStrings.MegabyteRenderer(obj, this.d0Fmt) : (rendererType == 6 ? TableCellStrings.PercentRenderer(obj, this.d0Fmt) : (rendererType == 3 ? TableCellStrings.DurationRenderer(obj, buffer) : (rendererType == 8 ? TableCellStrings.SpaceNoDecimalRenderer(obj) : (rendererType == 9 ? Util.formatHertz(((Number)obj).intValue()) : " ")))))))));
                if (!(obj instanceof Number)) continue;
            }
            makeGray = !makeGray;
            ++tableRow;
        }
        if (adjuster.hasTotalsRow()) {
            // empty if block
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(PrintTable.class.getName(), "print");
        }
    }
}

