/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.FoundComputer;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.xmsg.MessageLog;

public class UnmanagedRptAdjuster
extends CustomReportDataAdjuster {
    private static final String NAME = MessageLog.getMessageNoID("STG5006L");
    private static final String DOMAIN = MessageLog.getMessageNoID("STG1104L");
    private static final String IP_ADDR = MessageLog.getMessageNoID("STG1280L");
    private static final String OS_TYPE = MessageLog.getMessageNoID("STG1108L");
    private static final String DISCOVERED = MessageLog.getMessageNoID("STG3199L");
    private static final String MISSING = MessageLog.getMessageNoID("STG3192L");
    public String[] colNames = new String[]{NAME, DOMAIN, IP_ADDR, OS_TYPE, DISCOVERED, MISSING};
    private static final int NAME_COL = 0;
    private static final int DOMAIN_COL = 1;
    private static final int IP_ADDR_COL = 2;
    private static final int OS_TYPE_COL = 3;
    private static final int DISCOVERED_COL = 4;
    private static final int MISSING_COL = 5;
    private GuiReportReq grr;
    private FoundComputer[] data;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private int[] rendererArray;
    private boolean batch;
    private int rows;

    public UnmanagedRptAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.frozenColumns = 1;
        this.rendererArray = new int[this.colNames.length];
        this.rendererArray[4] = 1;
        this.rendererArray[5] = 5;
        this.colNames = this.getCustomizedColNames(this.colNames);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
        Arrays.sort(this.data, 0, this.data.length, new ComputerSorter());
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.batch = batch;
        this.data = (FoundComputer[])dataArray;
        this.rows = this.data.length;
        this.mDate = new Date[this.rows];
        this.mInt = new MutableInteger[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            this.mDate[i] = new Date();
            this.mInt[i] = new MutableInteger();
        }
    }

    public void adjustData() {
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        colArray[3].cdValidValue = ColumnDescriptor.OS_TYPES_PLUS_UNKNOWN;
    }

    public int getNumberRows() {
        return this.data.length;
    }

    public int getNumberColumns() {
        return this.colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getArray() {
        return this.data;
    }

    public Object getCellData(int row, int col) {
        Object value = " ";
        switch (col) {
            case 0: {
                value = this.data[row].fcName;
                break;
            }
            case 1: {
                value = this.data[row].fcDomain;
                break;
            }
            case 2: {
                value = this.data[row].fcIPAddress;
                break;
            }
            case 3: {
                if (this.data[row].fcOSType >= Constants.OSTYPES.length || this.data[row].fcOSType == 0) {
                    value = MessageLog.getMessageNoID("STG1020L");
                    break;
                }
                value = MessageLog.getMessageNoID(Constants.OSTYPES[this.data[row].fcOSType]);
                break;
            }
            case 4: {
                this.mDate[row].setTime(this.data[row].fcWhenDiscovered);
                value = this.mDate[row];
                break;
            }
            case 5: {
                this.mInt[row].value = this.data[row].fcTimesMissing;
                value = this.mInt[row];
            }
        }
        return value;
    }

    private class ComputerSorter
    implements Comparator {
        private ComputerSorter() {
        }

        public int compare(Object o1, Object o2) {
            FoundComputer r1 = (FoundComputer)o1;
            FoundComputer r2 = (FoundComputer)o2;
            return r1.fcName.compareTo(r2.fcName);
        }
    }
}

