/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Date;
import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.HistChartProcessor;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespVolGroup;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolGroupAdjuster
extends CustomReportDataAdjuster {
    private static final String COMPUTER = MessageLog.getMessageNoID("STG1102L");
    private static final String DVNAME = MessageLog.getMessageNoID("STG6201L");
    private static final String TYPE = MessageLog.getMessageNoID("STG1132L");
    private static final String CAPACITY = MessageLog.getMessageNoID("STG1162L");
    private static final String FREESPACE = MessageLog.getMessageNoID("STG1184L");
    private static final String PCTFREE = MessageLog.getMessageNoID("STG2040L");
    private static final String NBRDISKS = MessageLog.getMessageNoID("STG6057L");
    private static final String NBRVOLUMES = MessageLog.getMessageNoID("STG6202L");
    private static final String PROBE_TIME = MessageLog.getMessageNoID("STG1119L");
    private static final String DISC_TIME = MessageLog.getMessageNoID("STG1134L");
    private static final String UNKNOWN = MessageLog.getMessageNoID("STG1020L");
    public String[] columnNameList = new String[]{COMPUTER, DVNAME, CAPACITY, FREESPACE, PCTFREE, TYPE, NBRDISKS, NBRVOLUMES, PROBE_TIME, DISC_TIME};
    private static final int COMPUTER_COL = 0;
    private static final int DVNAME_COL = 1;
    private static final int CAPACITY_COL = 2;
    private static final int FREESPACE_COL = 3;
    private static final int PCTFREE_COL = 4;
    private static final int TYPE_COL = 5;
    private static final int NBRDISKS_COL = 6;
    private static final int NBRVOLUMES_COL = 7;
    private static final int LAST_PROBE_COL = 8;
    private static final int DISC_TIME_COL = 9;
    public RespVolGroup[] volGroups;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private MutableShort[] mShort;
    private GuiReportReq grr;
    private int[] rendererArray;
    public int frozenRows = 0;

    public VolGroupAdjuster(GuiReportReq grr) {
        super(grr);
        this.grr = grr;
        this.frozenColumns = 2;
        switch (grr.reportSubtype) {
            case 80: {
                this.firstColumn = 0;
                break;
            }
            case 12: {
                this.firstColumn = 0;
                break;
            }
            case 78: {
                this.firstColumn = 2;
                break;
            }
            case 17: {
                this.firstColumn = 3;
                break;
            }
            case 18: {
                this.firstColumn = 8;
                break;
            }
            case 37: {
                this.firstColumn = 9;
            }
        }
        this.rendererArray = new int[this.columnNameList.length];
        this.rendererArray[2] = 7;
        this.rendererArray[3] = 7;
        this.rendererArray[4] = 6;
        this.rendererArray[6] = 5;
        this.rendererArray[7] = 5;
        this.rendererArray[8] = 1;
        this.rendererArray[9] = 1;
        this.columnNameList = this.getCustomizedColNames(this.columnNameList);
    }

    public void adjust(Object[] dataArray, boolean batch) {
        this.adjustInit(dataArray, batch);
        this.adjustData();
    }

    public void adjustInit(Object[] dataArray, boolean batch) {
        this.volGroups = (RespVolGroup[])dataArray;
        int cnt = this.volGroups.length;
        if (cnt > 1) {
            ++cnt;
        }
        this.mDate = new Date[cnt];
        this.mInt = new MutableInteger[cnt];
        this.mLong = new MutableLong[cnt];
        this.mShort = new MutableShort[cnt];
        for (int i = 0; i < cnt; ++i) {
            this.mDate[i] = new Date();
            this.mInt[i] = new MutableInteger();
            this.mLong[i] = new MutableLong();
            this.mShort[i] = new MutableShort();
        }
    }

    public void adjustData() {
        int cnt = this.volGroups.length;
        if (cnt > 1) {
            this.addTotal(++cnt);
        }
        for (int i = 0; i < cnt; ++i) {
            RespVolGroup volGroup = this.volGroups[i];
            volGroup.vgFreeSpace *= 512L;
            volGroup.vgTotalSpace *= 512L;
            volGroup.rvgPercent = volGroup.vgTotalSpace > 0L ? (short)(volGroup.vgFreeSpace * 100L / volGroup.vgTotalSpace) : (short)-1;
        }
    }

    public void undo() {
        RespVolGroup volGroup = this.volGroups[0];
        volGroup.vgFreeSpace /= 512L;
        volGroup.vgTotalSpace /= 512L;
    }

    protected void addValidValues(ColumnDescriptor[] colArray) {
        colArray[5].cdValidValue = ColumnDescriptor.VOLGROUP_TYPES;
    }

    public int getNumberRows() {
        return this.volGroups.length;
    }

    public int getNumberColumns() {
        return this.columnNameList.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getArray() {
        return this.volGroups;
    }

    public int getFirstColumn() {
        return this.firstColumn;
    }

    public Object getCellData(int row, int col) {
        switch (col) {
            case 1: {
                return this.volGroups[row].vgName;
            }
            case 0: {
                return this.volGroups[row].rvgComputerName;
            }
            case 5: {
                if (row == 0 && this.bHasTotalRow) {
                    return " ";
                }
                return this.volGroups[row].getType();
            }
            case 2: {
                this.mLong[row].value = this.volGroups[row].vgTotalSpace;
                return this.mLong[row];
            }
            case 3: {
                this.mLong[row].value = this.volGroups[row].vgFreeSpace;
                return this.mLong[row];
            }
            case 4: {
                this.mShort[row].value = this.volGroups[row].rvgPercent;
                return this.mShort[row];
            }
            case 6: {
                this.mInt[row].value = this.volGroups[row].vgDisks;
                return this.mInt[row];
            }
            case 7: {
                this.mInt[row].value = this.volGroups[row].vgVolumes;
                return this.mInt[row];
            }
            case 8: {
                this.mDate[row].setTime(this.volGroups[row].vgProbeTime);
                return this.mDate[row];
            }
            case 9: {
                this.mDate[row].setTime(this.volGroups[row].vgDiscoveredTime);
                return this.mDate[row];
            }
        }
        return null;
    }

    private void addTotal(int cnt) {
        this.bHasTotalRow = true;
        RespVolGroup[] plusArray = new RespVolGroup[cnt];
        plusArray[0] = new RespVolGroup();
        plusArray[0].rvgComputerName = MessageLog.getMessageNoID("STG4136L");
        plusArray[0].vgName = " ";
        plusArray[0].vgProbeTime = 86400000L;
        plusArray[0].vgDiscoveredTime = 86400000L;
        for (int ix = 0; ix < cnt - 1; ++ix) {
            if (this.volGroups[ix].vgTotalSpace > 0L) {
                plusArray[0].vgTotalSpace += this.volGroups[ix].vgTotalSpace;
            }
            if (this.volGroups[ix].vgFreeSpace > 0L) {
                plusArray[0].vgFreeSpace += this.volGroups[ix].vgFreeSpace;
            }
            if (this.volGroups[ix].vgDisks > 0) {
                plusArray[0].vgDisks += this.volGroups[ix].vgDisks;
            }
            if (this.volGroups[ix].vgVolumes > 0) {
                plusArray[0].vgVolumes += this.volGroups[ix].vgVolumes;
            }
            plusArray[ix + 1] = this.volGroups[ix];
        }
        this.volGroups = plusArray;
        ++this.frozenRows;
    }

    public int[] initHistoryLegend() {
        HistChartProcessor.initLegend(this.grr);
        for (int i = 0; i < this.volGroups.length; ++i) {
            RespVolGroup dataRow = this.volGroups[i];
            int objectID = dataRow.vgID;
            HistChartProcessor.addLegend(this.grr, dataRow.rvgComputerName, dataRow.vgName, objectID);
        }
        return null;
    }

    public int[] getSelectedIDs() {
        int[] IDarray = new int[this.volGroups.length];
        for (int i = 0; i < this.volGroups.length; ++i) {
            int objectID;
            RespVolGroup dataRow = this.volGroups[i];
            IDarray[i] = objectID = dataRow.vgID;
        }
        return IDarray;
    }
}

