/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.common.TableCellStrings;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class WriteReports {
    private static final String PRINTED_ON = MessageLog.getMessageNoID("GEN0193L");
    PrintWriter writer;
    DateFormat df = DateFormat.getDateTimeInstance(3, 3);
    DecimalFormat d0Fmt = new DecimalFormat();
    private static final DecimalFormat d2Fmt = new DecimalFormat("###0.00");
    static final String[] BLANKS = new String[]{null, " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          "};
    static final char[] CHARS = new char[]{' ', '/', '\\'};

    public void writeCSV(ReportDataAdjuster adjuster, PrintWriter pWriter, int[] columnArray, boolean includeHeaders, boolean includeTotals, int[] rowMap) {
        String data;
        int col;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(WriteReports.class.getName(), "writeCSV", "adjuster, pWriter, columnArray, includeHeaders, includeTotals, rowMap");
        }
        d2Fmt.setMaximumFractionDigits(2);
        this.writer = pWriter;
        String[] labels1 = adjuster.getLabels();
        int numCols = labels1.length;
        boolean bDoComma = false;
        int frozenRows = adjuster.getNumberFrozenRows();
        int numRows = adjuster.getNumberRows() + frozenRows;
        int[] rendererArray = adjuster.getRenderers();
        if (includeHeaders) {
            int spannedRows = adjuster.getNumberSpannedRows();
            boolean[] spanners = new boolean[numCols];
            String spannedColLabel = "";
            if (spannedRows > 0) {
                for (int k = 0; k < columnArray.length; ++k) {
                    col = columnArray[k];
                    int labelLength = labels1[col].length();
                    int nextCol = col + 1;
                    if (nextCol >= labels1.length || labels1[nextCol].length() != 0) continue;
                    spanners[col] = true;
                    ++k;
                }
            }
            boolean stillSpanning = false;
            for (int k = 0; k < columnArray.length; ++k) {
                if (k > 0) {
                    this.writer.print(",");
                }
                col = columnArray[k];
                boolean bSkipSpace = false;
                data = Util.getTranslatedName(labels1[col].trim());
                if (spanners[col]) {
                    stillSpanning = true;
                    spannedColLabel = data = data + Util.getString("COLON");
                }
                if (stillSpanning && data.length() == 0 && !spanners[col]) {
                    stillSpanning = true;
                    data = spannedColLabel;
                } else if (!spanners[col]) {
                    stillSpanning = false;
                }
                if (data.length() > 0) {
                    this.writer.print(data.trim());
                } else {
                    bSkipSpace = true;
                }
                for (int row = 0; row < frozenRows; ++row) {
                    data = Util.getTranslatedName(adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col).toString());
                    if (data.trim().length() <= 0) continue;
                    if (!bSkipSpace) {
                        data = " " + data;
                    }
                    bSkipSpace = false;
                    this.writer.print(data);
                }
            }
            this.writer.println();
        }
        if (!includeTotals && adjuster.hasTotalsRow()) {
            ++frozenRows;
        }
        for (int row = frozenRows; row < numRows; ++row) {
            for (int k = 0; k < columnArray.length; ++k) {
                if (k > 0) {
                    this.writer.print(",");
                }
                col = columnArray[k];
                Object cell = adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                if (cell == null) {
                    data = " ";
                } else if (Variables.spaceUnits != 0 && rendererArray[col] == 7) {
                    long bytes = ((Number)cell).longValue();
                    data = bytes == -2L || bytes == -1024L ? "" : (bytes < 0L ? MessageLog.getMessageNoID("STG0019T") : (Variables.spaceUnits == 1 ? Double.toString((double)bytes / 1024.0) : (Variables.spaceUnits == 2 ? Double.toString((double)bytes / 1048576.0) : (Variables.spaceUnits == 3 ? Double.toString((double)bytes / 1.073741824E9) : Double.toString((double)(bytes /= 0x100000L) / 1048576.0)))));
                } else if (cell instanceof Date) {
                    data = TableCellStrings.DateRenderer(cell, this.df);
                } else if (rendererArray[col] == 6) {
                    if (((Number)cell).longValue() == -2L) {
                        data = "";
                    } else if (((Number)cell).longValue() < 0L) {
                        data = "-1";
                    } else {
                        double d = ((Number)cell).doubleValue() / 100.0;
                        int scale = adjuster.getScale();
                        scale = 1;
                        if (cell == null) {
                            data = "";
                        } else if (((Number)cell).intValue() < 0) {
                            data = "-1";
                        } else {
                            StringBuffer buffer = new StringBuffer();
                            buffer.setLength(0);
                            buffer.append(((Number)cell).intValue() / scale);
                            buffer.append('.');
                            buffer.append(((Number)cell).intValue() % scale);
                            data = buffer.toString();
                        }
                    }
                } else if (rendererArray[col] == 2) {
                    if (((Number)cell).longValue() == -2L) {
                        data = "";
                    } else if (((Number)cell).longValue() < 0L) {
                        data = "-1";
                    } else {
                        int scale = adjuster.getScale();
                        if (scale == 0) {
                            scale = 1;
                        }
                        if (cell == null) {
                            data = "";
                        } else if (((Number)cell).intValue() < 0) {
                            data = "-1";
                        } else {
                            StringBuffer buffer = new StringBuffer();
                            buffer.setLength(0);
                            buffer.append(((Number)cell).intValue() / scale);
                            buffer.append('.');
                            buffer.append(((Number)cell).intValue() % scale);
                            data = buffer.toString();
                        }
                    }
                } else {
                    data = cell.toString();
                    if (!(cell instanceof Number)) {
                        data = WriteReports.adjustString(data);
                    } else if (((Number)cell).longValue() < 0L) {
                        data = "-1";
                    }
                }
                this.writer.print(data);
            }
            this.writer.println();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(WriteReports.class.getName(), "writeCSV");
        }
    }

    public static String adjustString(String data) {
        int position2 = data.indexOf(34);
        if (position2 >= 0) {
            StringBuffer buffer = new StringBuffer(200);
            int position1 = 0;
            while (position2 >= 0) {
                buffer.append(data.substring(position1, ++position2));
                buffer.append('\"');
                if (position2 > data.length()) break;
                position1 = position2;
                position2 = data.indexOf(34, position1);
            }
            if (position2 < 0) {
                buffer.append(data.substring(position1));
            }
            data = buffer.toString();
        }
        if ((position2 = data.indexOf(44)) >= 0) {
            data = "\"" + data + "\"";
        }
        try {
            double test = new Double(data);
            if (test < 0.0) {
                data = "-1";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    public void writeFormatted(ReportDataAdjuster adjuster, PrintWriter pWriter, int[] columnArray, int[] rowMap) {
        String data;
        int k;
        int row;
        int dataWidth;
        Object obj;
        int rendererType;
        int col;
        int k2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(WriteReports.class.getName(), "writeFormatted", "adjuster, pWriter, columnArray, rowMap");
        }
        this.writer = pWriter;
        this.writer.print(PRINTED_ON);
        this.writer.print(" ");
        this.writer.println(DateFormat.getDateTimeInstance(2, 2).format(new Date()));
        this.writer.println();
        this.d0Fmt.setMaximumFractionDigits(2);
        StringBuffer buffer = new StringBuffer(25);
        int scale = adjuster.getScale();
        String suffix = adjuster.getSuffix();
        String[] labels1 = adjuster.getLabels();
        int numCols = labels1.length;
        int frozenRows = adjuster.getNumberFrozenRows();
        int spannedRows = adjuster.getNumberSpannedRows();
        int[] colWidths = new int[numCols];
        int[] rendererArray = adjuster.getRenderers();
        int numRows = adjuster.getNumberRows() + frozenRows;
        int firstNonSpannedRow = 0;
        if (spannedRows > 0) {
            firstNonSpannedRow = spannedRows - 1;
        }
        for (k2 = 0; k2 < columnArray.length; ++k2) {
            col = columnArray[k2];
            rendererType = rendererArray[col];
            int maxWidth = 0;
            for (int row2 = frozenRows; row2 < numRows; ++row2) {
                obj = adjuster.getCellData(adjuster.getRowIndex(row2, rowMap), col);
                switch (rendererType) {
                    case 0: {
                        if (obj == null) {
                            dataWidth = 1;
                            break;
                        }
                        dataWidth = ((String)obj).length();
                        break;
                    }
                    case 7: {
                        dataWidth = TableCellStrings.SpaceRenderer(obj).length();
                        break;
                    }
                    case 1: {
                        dataWidth = TableCellStrings.DateRenderer(obj, this.df).length();
                        break;
                    }
                    case 2: {
                        dataWidth = TableCellStrings.DecimalRenderer(scale, suffix, obj, buffer).length();
                        break;
                    }
                    case 5: {
                        dataWidth = TableCellStrings.NumberRenderer(obj, this.d0Fmt).length();
                        break;
                    }
                    case 4: {
                        dataWidth = TableCellStrings.MegabyteRenderer(obj, this.d0Fmt).length();
                        break;
                    }
                    case 6: {
                        dataWidth = TableCellStrings.PercentRenderer(obj, this.d0Fmt).length();
                        break;
                    }
                    case 3: {
                        dataWidth = TableCellStrings.DurationRenderer(obj, buffer).length();
                        break;
                    }
                    case 8: {
                        dataWidth = TableCellStrings.SpaceNoDecimalRenderer(obj).length();
                        break;
                    }
                    case 9: {
                        dataWidth = Util.formatHertz(((Number)obj).intValue()).length();
                        break;
                    }
                    default: {
                        dataWidth = 1;
                    }
                }
                if (dataWidth <= maxWidth) continue;
                maxWidth = dataWidth;
            }
            colWidths[col] = maxWidth;
        }
        for (row = firstNonSpannedRow; row < frozenRows; ++row) {
            for (k = 0; k < columnArray.length; ++k) {
                col = columnArray[k];
                dataWidth = ((String)adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col)).length();
                if (dataWidth <= colWidths[col]) continue;
                colWidths[col] = dataWidth;
            }
        }
        if (spannedRows > 0) {
            int k3;
            int row3;
            int pairLength;
            int nextCol;
            int labelLength;
            int k4;
            boolean[] spanners = new boolean[numCols];
            for (k4 = 0; k4 < columnArray.length; ++k4) {
                col = columnArray[k4];
                labelLength = labels1[col].length();
                nextCol = col + 1;
                if (nextCol < labels1.length && labels1[nextCol].length() == 0) {
                    pairLength = colWidths[col] + colWidths[nextCol];
                    if (labelLength > pairLength) {
                        labelLength -= pairLength;
                        ++labelLength;
                        int n = col;
                        colWidths[n] = colWidths[n] + (labelLength /= 2);
                        int n2 = nextCol;
                        colWidths[n2] = colWidths[n2] + labelLength;
                    }
                    spanners[col] = true;
                    ++k4;
                    continue;
                }
                if (labelLength <= colWidths[col]) continue;
                colWidths[col] = labelLength;
            }
            for (row3 = 0; row3 < spannedRows - 1; ++row3) {
                for (k3 = 0; k3 < columnArray.length; ++k3) {
                    col = columnArray[k3];
                    labelLength = ((String)adjuster.getCellData(adjuster.getRowIndex(row3, rowMap), col)).length();
                    if (spanners[col]) {
                        nextCol = col + 1;
                        pairLength = colWidths[col] + colWidths[nextCol];
                        if (labelLength > pairLength) {
                            labelLength -= pairLength;
                            ++labelLength;
                            int n = col;
                            colWidths[n] = colWidths[n] + (labelLength /= 2);
                            int n3 = nextCol;
                            colWidths[n3] = colWidths[n3] + labelLength;
                        }
                        ++k3;
                        continue;
                    }
                    if (labelLength <= colWidths[col]) continue;
                    colWidths[col] = labelLength;
                }
            }
            this.writer.print('|');
            for (k4 = 0; k4 < columnArray.length; ++k4) {
                col = columnArray[k4];
                if (spanners[col]) {
                    this.center(labels1[col], colWidths[col] + colWidths[++col] + 1);
                    ++k4;
                } else {
                    this.writer.print(labels1[col]);
                    this.pad(colWidths[col] - labels1[col].length());
                }
                this.writer.print('|');
            }
            this.writer.println();
            for (row3 = 0; row3 < spannedRows - 1; ++row3) {
                this.writer.print('|');
                for (k3 = 0; k3 < columnArray.length; ++k3) {
                    col = columnArray[k3];
                    data = (String)adjuster.getCellData(adjuster.getRowIndex(row3, rowMap), col);
                    if (spanners[col]) {
                        this.center(data, colWidths[col] + colWidths[++col] + 1);
                        ++k3;
                    } else {
                        this.writer.print(data);
                        this.pad(colWidths[col] - data.length());
                    }
                    this.writer.print('|');
                }
                this.writer.println();
            }
            for (row3 = firstNonSpannedRow; row3 < frozenRows; ++row3) {
                this.writer.print('|');
                for (k3 = 0; k3 < columnArray.length; ++k3) {
                    col = columnArray[k3];
                    data = (String)adjuster.getCellData(adjuster.getRowIndex(row3, rowMap), col);
                    this.writer.print(data);
                    this.pad(colWidths[col] - data.length());
                    this.writer.print('|');
                }
                this.writer.println();
            }
        } else {
            for (k2 = 0; k2 < columnArray.length; ++k2) {
                col = columnArray[k2];
                if (labels1[col].length() <= colWidths[col]) continue;
                colWidths[col] = labels1[col].length();
            }
            this.writer.print('|');
            for (k2 = 0; k2 < columnArray.length; ++k2) {
                col = columnArray[k2];
                this.writer.print(labels1[col]);
                this.pad(colWidths[col] - labels1[col].length());
                this.writer.print('|');
            }
            this.writer.println();
            if (frozenRows > 0) {
                for (row = 0; row < frozenRows; ++row) {
                    this.writer.print('|');
                    for (k = 0; k < columnArray.length; ++k) {
                        col = columnArray[k];
                        data = (String)adjuster.getCellData(adjuster.getRowIndex(row, rowMap), col);
                        this.writer.print(data);
                        this.pad(colWidths[col] - data.length());
                        this.writer.print('|');
                    }
                    this.writer.println();
                }
            }
        }
        this.writer.print('|');
        int n = columnArray.length - 1;
        for (int k5 = 0; k5 < columnArray.length; ++k5) {
            col = columnArray[k5];
            for (int l = colWidths[col]; l > 0; --l) {
                this.writer.print("-");
            }
            if (k5 >= n) continue;
            this.writer.print('+');
        }
        this.writer.print('|');
        this.writer.println();
        for (int row4 = frozenRows; row4 < numRows; ++row4) {
            this.writer.print('|');
            for (int k6 = 0; k6 < columnArray.length; ++k6) {
                col = columnArray[k6];
                rendererType = rendererArray[col];
                obj = adjuster.getCellData(adjuster.getRowIndex(row4, rowMap), col);
                switch (rendererType) {
                    case 0: {
                        if (obj == null) {
                            data = " ";
                            break;
                        }
                        data = obj.toString();
                        break;
                    }
                    case 7: {
                        data = TableCellStrings.SpaceRenderer(obj);
                        break;
                    }
                    case 1: {
                        data = TableCellStrings.DateRenderer(obj, this.df);
                        break;
                    }
                    case 2: {
                        data = TableCellStrings.DecimalRenderer(scale, suffix, obj, buffer);
                        break;
                    }
                    case 5: {
                        data = TableCellStrings.NumberRenderer(obj, this.d0Fmt);
                        break;
                    }
                    case 4: {
                        data = TableCellStrings.MegabyteRenderer(obj, this.d0Fmt);
                        break;
                    }
                    case 6: {
                        data = TableCellStrings.PercentRenderer(obj, this.d0Fmt);
                        break;
                    }
                    case 3: {
                        data = TableCellStrings.DurationRenderer(obj, buffer);
                        break;
                    }
                    case 8: {
                        data = TableCellStrings.SpaceNoDecimalRenderer(obj);
                        break;
                    }
                    case 9: {
                        data = Util.formatHertz(((Number)obj).intValue());
                        break;
                    }
                    default: {
                        data = " ";
                    }
                }
                if (obj instanceof Number) {
                    this.pad(colWidths[col] - data.length());
                    this.writer.print(data);
                } else {
                    this.writer.print(data);
                    this.pad(colWidths[col] - data.length());
                }
                this.writer.print('|');
            }
            this.writer.println();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(WriteReports.class.getName(), "writeFormatted");
        }
    }

    public static String adjustFileName(String fileName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(WriteReports.class.getName(), "adjustFileName", "fileName");
        }
        StringBuffer buffer = new StringBuffer(300);
        for (int count = 0; count < CHARS.length; ++count) {
            int position1 = 0;
            int position2 = fileName.indexOf(CHARS[count]);
            while (position2 >= 0) {
                buffer.append(fileName.substring(position1, position2));
                position1 = position2 + 1;
                position2 = fileName.indexOf(CHARS[count], position1);
            }
            if (position1 < fileName.length()) {
                buffer.append(fileName.substring(position1));
            }
            fileName = buffer.toString();
            buffer.setLength(0);
        }
        String traceResult = fileName;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(WriteReports.class.getName(), "adjustFileName", traceResult);
        }
        return traceResult;
    }

    private void center(String data, int length) {
        int extra = (length -= data.length()) % 2;
        this.pad(length /= 2);
        this.writer.print(data);
        this.pad(length += extra);
    }

    private void pad(int length) {
        while (length > 10) {
            this.writer.print(BLANKS[10]);
            length -= 10;
        }
        if (length > 0) {
            this.writer.print(BLANKS[length]);
        }
    }
}

