/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.border.EmptyBorder;
import org.eclipse.aperi.TStorm.common.AgentAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.TStorm.server.guireq.RespAgent;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.admin.AdminTreeLabel;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.LogConfigDialog;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ComputerID;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class AgentTable
extends JPanel
implements GuiRequestor {
    private MegaTable table = new MegaTable();
    private RespAgent[] dataArray;
    private RespAgent[] processAgents;
    private RespAgent respAgent;
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private AgentAdjuster adjuster;
    private Request agentRequest;
    private LogConfigDialog lConfigDialog = null;
    private String actionCommand;
    private int[] rows;
    private int[] processIDs;
    private Response saveResponse;
    private TJCTableMouseAdapter myMouseListener = new SelectListener();
    private AgentModel agentModel;
    private static final String L_LOG = "ADG0017L";
    private static final String L_TRACING = "ADG0304L";
    private static final String L_CONFIG = "ADG0255L";
    private static final String L_SHUTDOWN = "ADG0006L";
    private static final String L_NORMAL = "ADG0007L";
    private static final String L_IMMEDIATE = "ADG0009L";
    private static final String L_ABORT = "ADG0011L";
    private static final String L_UNINSTALL = "ADG0262L";
    private static final String L_CHECK = "ADG0288L";
    private static final String L_ENABLE = "ADG0289L";
    private static final String L_DISABLE = "ADG0290L";
    private static final String L_SET_STATE = "xxx";
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public AgentTable(GuiReportReq grr, ReportingDDI ddi) {
        this.grr = grr;
        this.ddi = ddi;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.adjuster = new AgentAdjuster(grr);
    }

    public void handleResponse(short status, Response response) {
        this.setLayout(new BorderLayout());
        this.dataArray = status <= 4 ? (RespAgent[])response.responseData : null;
        if (this.dataArray == null) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            return;
        }
        int count = this.dataArray.length;
        this.adjuster.adjust(this.dataArray, false);
        this.dataArray = (RespAgent[])this.adjuster.getArray();
        this.table.setMouseListener(this.myMouseListener);
        this.agentModel = new AgentModel();
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setRowIcon(10, true);
        this.table.setBaseTableModel(this.agentModel);
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
    }

    static /* synthetic */ RespAgent[] access$602(AgentTable x0, RespAgent[] x1) {
        x0.processAgents = x1;
        return x1;
    }

    static /* synthetic */ int[] access$702(AgentTable x0, int[] x1) {
        x0.processIDs = x1;
        return x1;
    }

    private class MultiLineLabel
    extends JTextArea {
        public MultiLineLabel(String s) {
            super(s);
        }

        public void updateUI() {
            super.updateUI();
            this.setHighlighter(null);
            this.setEditable(false);
            LookAndFeel.installBorder(this, "Label.border");
            LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foregroung", "Label.font");
        }
    }

    public class SelectListener
    extends TJCTableMouseAdapter
    implements ActionListener,
    GuiRequestor {
        int[] rows;
        int rowCount;

        public void doubleClick(int dataRow, int dataCol) {
            AgentTable.this.respAgent = AgentTable.this.dataArray[dataRow];
            AgentTreeNode node = new AgentTreeNode(((AgentTable)AgentTable.this).respAgent.raTsName, ((AgentTable)AgentTable.this).respAgent.raComputerID, ((AgentTable)AgentTable.this).respAgent.raState);
            node.select(null);
        }

        public void showPopup(int dataRow, int dataCol, Component c, int x, int y) {
            boolean bLog = false;
            boolean bTracing = false;
            boolean bConfig = false;
            boolean bShutdown = false;
            boolean bNormal = false;
            boolean bImmediate = false;
            boolean bAbort = false;
            boolean bUninstall = false;
            boolean bCheck = false;
            boolean bEnable = false;
            boolean bDisable = false;
            boolean rowsSelected = AgentTable.this.table.rowsSelected();
            if (rowsSelected) {
                bCheck = true;
                this.rows = AgentTable.this.table.getSelectedRows();
                this.rowCount = this.rows.length;
                for (int r = 0; r < this.rowCount; ++r) {
                    AgentTable.this.respAgent = AgentTable.this.dataArray[this.rows[r]];
                    if (((AgentTable)AgentTable.this).respAgent.raState == 1) {
                        bLog = true;
                        bTracing = true;
                        bConfig = true;
                        bShutdown = true;
                        bNormal = true;
                        bImmediate = true;
                        bAbort = true;
                        bUninstall = true;
                        bDisable = true;
                        continue;
                    }
                    if (((AgentTable)AgentTable.this).respAgent.raState == 5) {
                        bLog = true;
                        bConfig = true;
                        bShutdown = true;
                        bNormal = true;
                        bImmediate = true;
                        bAbort = true;
                        bUninstall = true;
                        bDisable = true;
                        continue;
                    }
                    if (((AgentTable)AgentTable.this).respAgent.raState == 0) {
                        bUninstall = true;
                        bEnable = true;
                        continue;
                    }
                    if (((AgentTable)AgentTable.this).respAgent.raState != 4) continue;
                    bUninstall = true;
                    bDisable = true;
                }
                if (this.rowCount > 1) {
                    bLog = false;
                    bTracing = false;
                    bUninstall = false;
                }
            }
            if (!((AgentTable)AgentTable.this).guiMain.getUserPrefs().administrator) {
                bTracing = false;
                bConfig = false;
                bShutdown = false;
                bNormal = false;
                bImmediate = false;
                bAbort = false;
                bUninstall = false;
                bEnable = false;
                bDisable = false;
            }
            JPopupMenu menu = new JPopupMenu();
            JMenuItem mi = menu.add(MessageLog.getMessageNoID(AgentTable.L_LOG));
            mi.setActionCommand(AgentTable.L_LOG);
            mi.addActionListener(this);
            mi.setEnabled(bLog);
            mi = menu.add(MessageLog.getMessageNoID(AgentTable.L_TRACING));
            mi.setActionCommand(AgentTable.L_TRACING);
            mi.addActionListener(this);
            mi.setEnabled(bTracing);
            mi = menu.add(MessageLog.getMessageNoID(AgentTable.L_CONFIG));
            mi.setActionCommand(AgentTable.L_CONFIG);
            mi.addActionListener(this);
            mi.setEnabled(bConfig);
            mi = menu.add(MessageLog.getMessageNoID(AgentTable.L_CHECK));
            mi.setActionCommand(AgentTable.L_CHECK);
            mi.addActionListener(this);
            mi.setEnabled(bCheck);
            JMenu shutdown = new JMenu(MessageLog.getMessageNoID(AgentTable.L_SHUTDOWN));
            menu.add(shutdown);
            shutdown.setEnabled(bShutdown);
            mi = shutdown.add(MessageLog.getMessageNoID(AgentTable.L_NORMAL));
            mi.setActionCommand(AgentTable.L_NORMAL);
            mi.addActionListener(this);
            mi.setEnabled(bNormal);
            mi = shutdown.add(MessageLog.getMessageNoID(AgentTable.L_IMMEDIATE));
            mi.setActionCommand(AgentTable.L_IMMEDIATE);
            mi.addActionListener(this);
            mi.setEnabled(bImmediate);
            mi = shutdown.add(MessageLog.getMessageNoID(AgentTable.L_ABORT));
            mi.setActionCommand(AgentTable.L_ABORT);
            mi.addActionListener(this);
            mi.setEnabled(bAbort);
            mi = menu.add(MessageLog.getMessageNoID(AgentTable.L_ENABLE));
            mi.setActionCommand(AgentTable.L_ENABLE);
            mi.addActionListener(this);
            mi.setEnabled(bEnable);
            mi = menu.add(MessageLog.getMessageNoID(AgentTable.L_DISABLE));
            mi.setActionCommand(AgentTable.L_DISABLE);
            mi.addActionListener(this);
            mi.setEnabled(bDisable);
            mi = menu.add(MessageLog.getMessageNoID(AgentTable.L_UNINSTALL));
            mi.setActionCommand(AgentTable.L_UNINSTALL);
            mi.addActionListener(this);
            mi.setEnabled(bUninstall);
            menu.show(c, x, y);
            menu.requestFocus();
        }

        public void actionPerformed(ActionEvent e) {
            int i;
            AgentTable.this.actionCommand = e.getActionCommand();
            this.rows = AgentTable.this.table.getSelectedRows();
            AgentTable.this.respAgent = AgentTable.this.dataArray[this.rows[0]];
            AgentTable.access$602(AgentTable.this, new RespAgent[this.rows.length]);
            for (i = 0; i < AgentTable.this.processAgents.length; ++i) {
                ((AgentTable)AgentTable.this).processAgents[i] = AgentTable.this.dataArray[this.rows[i]];
            }
            AgentTable.access$702(AgentTable.this, new int[AgentTable.this.processAgents.length]);
            for (i = 0; i < AgentTable.this.processIDs.length; ++i) {
                ((AgentTable)AgentTable.this).processIDs[i] = ((AgentTable)AgentTable.this).processAgents[i].raComputerID;
            }
            if (AgentTable.this.actionCommand == AgentTable.L_LOG) {
                this.log();
            } else if (AgentTable.this.actionCommand == AgentTable.L_TRACING) {
                this.tracingConfig();
            } else if (AgentTable.this.actionCommand == AgentTable.L_CONFIG) {
                this.config();
            } else if (AgentTable.this.actionCommand == AgentTable.L_CHECK) {
                this.checkAgent();
            } else if (AgentTable.this.actionCommand == AgentTable.L_NORMAL) {
                this.stopAgent((byte)1);
            } else if (AgentTable.this.actionCommand == AgentTable.L_IMMEDIATE) {
                this.stopAgent((byte)2);
            } else if (AgentTable.this.actionCommand == AgentTable.L_ABORT) {
                this.stopAgent((byte)3);
            } else if (AgentTable.this.actionCommand == AgentTable.L_ENABLE) {
                this.enableAgent();
            } else if (AgentTable.this.actionCommand == AgentTable.L_DISABLE) {
                this.disableAgent();
            } else {
                this.uninstallAgent();
            }
        }

        private void log() {
            LogViewer lv = new LogViewer(((AgentTable)AgentTable.this).respAgent.raComputerID, ((AgentTable)AgentTable.this).ddi.treeNode, ((AgentTable)AgentTable.this).respAgent.raTsName, 0);
        }

        private void tracingConfig() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentGetTracingConfig(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID, "org.eclipse.aperi.agent.svp.AgentSvp");
            GuiClient.doRequest(this, AgentTable.this.agentRequest);
        }

        private void config() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentReadConfig(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID);
            this.processRequest(true);
        }

        private void checkAgent() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentStatus(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID);
            this.processRequest(true);
        }

        private void stopAgent(byte newState) {
            String STOP_YES;
            String STOP_NO;
            String STOP_WARNING;
            String STOP_TITLE;
            if (AgentTable.this.processAgents.length == 1) {
                STOP_TITLE = MessageLog.getMessageNoID("ADG0251T", ((AgentTable)AgentTable.this).respAgent.raTsName);
                STOP_WARNING = MessageLog.getMessageNoID("ADG0252T", ((AgentTable)AgentTable.this).respAgent.raTsName);
                STOP_NO = MessageLog.getMessageNoID("ADG0253L");
                STOP_YES = MessageLog.getMessageNoID("ADG0254L");
            } else {
                STOP_TITLE = MessageLog.getMessageNoID("STG5577T");
                STOP_WARNING = MessageLog.getMessageNoID("STG5578T");
                STOP_NO = MessageLog.getMessageNoID("STG5579L");
                STOP_YES = MessageLog.getMessageNoID("STG5580L");
            }
            Object[] options = new String[]{STOP_NO, STOP_YES};
            int answer = JOptionPane.showOptionDialog(AgentTable.this.guiMain.getFrame(), STOP_WARNING, STOP_TITLE, 0, 2, null, options, options[0]);
            if (answer == 1) {
                AgentTable.this.agentRequest = new Request();
                ServerRequest.agentStop(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID, newState);
                this.processRhetoricalRequest(true);
            }
        }

        private void enableAgent() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentState(AgentTable.this.agentRequest, new ComputerID(((AgentTable)AgentTable.this).respAgent.raComputerID), (byte)1);
            this.processRequest(false);
        }

        private void disableAgent() {
            AgentTable.this.agentRequest = new Request();
            ServerRequest.agentState(AgentTable.this.agentRequest, new ComputerID(((AgentTable)AgentTable.this).respAgent.raComputerID), (byte)0);
            this.processRequest(false);
        }

        private void uninstallAgent() {
            String UNINSTALL_TITLE = MessageLog.getMessageNoID("ADG0264T", ((AgentTable)AgentTable.this).respAgent.raTsName);
            String UNINSTALL_WARNING = MessageLog.getMessageNoID("ADG0265T", ((AgentTable)AgentTable.this).respAgent.raTsName);
            String UNINSTALL_NO = MessageLog.getMessageNoID("ADG0266L");
            String UNINSTALL_YES = MessageLog.getMessageNoID("ADG0267L");
            Object[] options = new String[]{UNINSTALL_NO, UNINSTALL_YES};
            int answer = JOptionPane.showOptionDialog(AgentTable.this.guiMain.getFrame(), UNINSTALL_WARNING, UNINSTALL_TITLE, 0, 2, null, options, options[0]);
            if (answer == 1) {
                AgentTable.this.agentRequest = new Request();
                byte productCode = 0;
                ServerRequest.uninstallAgent(AgentTable.this.agentRequest, ((AgentTable)AgentTable.this).respAgent.raComputerID, productCode);
                GuiClient.doRequest(this, AgentTable.this.agentRequest);
                ((AgentTable)AgentTable.this).respAgent.raState = (byte)77;
                AgentTable.this.adjuster.adjustData();
                AgentTable.this.agentModel.changeTable();
                if (AdminTreeLabel.agentTreeLabel != null) {
                    AdminTreeLabel.agentTreeLabel.refreshAgents();
                }
            }
        }

        private void processRhetoricalRequest(boolean ask) {
            if (this.promptUser(ask) == 1) {
                GuiClient.doRhetoricalRequest(AgentTable.this.agentRequest);
            }
        }

        private void processRequest(boolean ask) {
            if (this.promptUser(ask) == 1) {
                GuiClient.doRequest(this, AgentTable.this.agentRequest);
            }
        }

        private int promptUser(boolean ask) {
            int answer = 1;
            if (ask && AgentTable.this.processIDs.length > 4) {
                String PROCESS_TITLE = MessageLog.getMessageNoID("STG5573T");
                String PROCESS_WARNING = MessageLog.getMessageNoID("STG5574T");
                String PROCESS_NO = MessageLog.getMessageNoID("STG5575L");
                String PROCESS_YES = MessageLog.getMessageNoID("STG5576L");
                Object[] options = new String[]{PROCESS_NO, PROCESS_YES};
                answer = JOptionPane.showOptionDialog(AgentTable.this.guiMain.getFrame(), PROCESS_WARNING, PROCESS_TITLE, 0, 2, null, options, options[0]);
            }
            if (answer == 1) {
                Request childRequest = AgentTable.this.agentRequest;
                AgentTable.this.agentRequest = new Request();
                ServerRequest.agentCommand(AgentTable.this.agentRequest, childRequest, AgentTable.this.processIDs);
            }
            return answer;
        }

        public void handleResponse(short status, Response response) {
            if (AgentTable.this.actionCommand == AgentTable.L_CHECK) {
                this.fixTable(response);
                this.showMessages(response, true);
            } else if (AgentTable.this.actionCommand == AgentTable.L_ENABLE || AgentTable.this.actionCommand == AgentTable.L_DISABLE) {
                this.fixTable(response);
                this.showMessages(response, false);
            } else if (AgentTable.this.actionCommand == AgentTable.L_TRACING) {
                if (status != 0) {
                    JOptionPane.showMessageDialog(AgentTable.this.guiMain.getFrame(), MessageLog.getMessage("ADG0308E", ((AgentTable)AgentTable.this).respAgent.raTsName), MessageLog.getMessageNoID("ADG0307L"), 0);
                } else {
                    HashMap config = (HashMap)response.responseData;
                    if (AgentTable.this.lConfigDialog == null) {
                        String msg = MessageLog.getMessageNoID("ADG0310L", ((AgentTable)AgentTable.this).respAgent.raTsName);
                        AgentTable.this.lConfigDialog = new LogConfigDialog(msg, ((AgentTable)AgentTable.this).respAgent.raComputerID, ((AgentTable)AgentTable.this).respAgent.raTsName, "org.eclipse.aperi.agent.svp.AgentSvp");
                    }
                    AgentTable.this.lConfigDialog.setLocationRelativeTo(null);
                    AgentTable.this.lConfigDialog.show(config, "org.eclipse.aperi.agent.svp.AgentSvp");
                }
            } else if (AgentTable.this.actionCommand == AgentTable.L_NORMAL || AgentTable.this.actionCommand == AgentTable.L_SET_STATE) {
                for (int i = 0; i < AgentTable.this.processAgents.length; ++i) {
                    ((AgentTable)AgentTable.this).processAgents[i].raState = 0;
                }
                AgentTable.this.adjuster.adjustData();
                AgentTable.this.agentModel.changeTable();
                if (AdminTreeLabel.agentTreeLabel != null) {
                    AdminTreeLabel.agentTreeLabel.refreshAgents();
                }
                if (AgentTable.this.actionCommand == AgentTable.L_NORMAL) {
                    this.showMessages(response, false);
                } else {
                    this.showMessages(AgentTable.this.saveResponse, false);
                }
            } else if (AgentTable.this.actionCommand == AgentTable.L_IMMEDIATE || AgentTable.this.actionCommand == AgentTable.L_ABORT) {
                AgentTable.this.actionCommand = AgentTable.L_SET_STATE;
                AgentTable.this.saveResponse = response;
                AgentTable.this.agentRequest = new Request();
                ServerRequest.agentState(AgentTable.this.agentRequest, new ComputerID(((AgentTable)AgentTable.this).respAgent.raComputerID), (byte)0);
                this.processRequest(false);
            }
        }

        private void fixTable(Response response) {
            Object[] status = (Object[])response.responseData;
            byte[] states = (byte[])status[0];
            for (int i = 0; i < AgentTable.this.processAgents.length; ++i) {
                ((AgentTable)AgentTable.this).processAgents[i].raState = states[i];
            }
            AgentTable.this.adjuster.adjustData();
            AgentTable.this.agentModel.changeTable();
            if (AdminTreeLabel.agentTreeLabel != null) {
                AdminTreeLabel.agentTreeLabel.refreshAgents();
            }
        }

        private void showMessages(Response response, boolean check) {
            Object[] arrays = (Object[])response.responseData;
            String[] messages = (String[])arrays[1];
            int length = messages.length;
            StringBuffer buffer = new StringBuffer(length * 240);
            boolean show = false;
            for (int m = 0; m < length; ++m) {
                if (messages[m] != null) {
                    show = true;
                    if (check) {
                        buffer.append(MessageLog.getMessageNoID("ADG0201L"));
                        buffer.append(" ");
                        buffer.append(((AgentTable)AgentTable.this).processAgents[m].raTsName);
                        buffer.append(": ");
                    }
                    buffer.append(messages[m]);
                    buffer.append("\n\n");
                    continue;
                }
                if (!check) continue;
                show = true;
                buffer.append(MessageLog.getMessageNoID("ADG0294M", ((AgentTable)AgentTable.this).processAgents[m].raTsName));
                buffer.append("\n\n");
            }
            if (show) {
                String s = MessageLog.getMessageNoID("ADG0295T");
                MultiLineLabel mLabel = new MultiLineLabel(buffer.toString());
                JScrollPane scrollPane = new JScrollPane(mLabel);
                Dimension dim = mLabel.getPreferredSize();
                int w = dim.width + 8 + scrollPane.getVerticalScrollBar().getPreferredSize().width;
                int h = dim.height > 200 ? 200 : dim.height + 8;
                scrollPane.setPreferredSize(new Dimension(w, h));
                scrollPane.setViewportBorder(new EmptyBorder(2, 2, 2, 2));
                JOptionPane.showMessageDialog(AgentTable.this.guiMain.getFrame(), scrollPane, s, 1);
            }
        }
    }

    private class AgentModel
    extends BaseTableModel {
        public AgentModel() {
            this.columnNames = ((AgentTable)AgentTable.this).adjuster.colNames;
            this.rowCount = AgentTable.this.dataArray.length;
            this.commonAdjuster = AgentTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return AgentTable.this.adjuster.getCellData(row, AgentTable.this.adjuster.translateColumn(col));
        }

        public void changeTable() {
            this.fireTableDataChanged();
        }
    }
}

