/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.Cluster;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ClusterData
extends JPanel
implements GuiRequestor {
    private GridBagLayout gridBag = new GridBagLayout();
    private GridBagConstraints gbcFill_1 = new GridBagConstraints();
    private GridBagConstraints gbcFill_2 = new GridBagConstraints();
    private GridBagConstraints gbcLabel = new GridBagConstraints();
    private GridBagConstraints gbcLast = new GridBagConstraints();
    private JLabel title = new JLabel(MessageLog.getMessageNoID("STG1137L"));
    private JLabel lCluster = new JLabel(MessageLog.getMessageNoID("STG1136L") + "    ");
    private JLabel lGroup = new JLabel(MessageLog.getMessageNoID("STG1103L") + "    ");
    private JLabel lDomain = new JLabel(MessageLog.getMessageNoID("STG1104L") + "    ");
    private JLabel lIPaddress = new JLabel(MessageLog.getMessageNoID("STG1280L") + "    ");
    private JLabel lDiscovered = new JLabel(MessageLog.getMessageNoID("STG1134L") + "    ");
    private JLabel dCluster = new JLabel();
    private JLabel dGroup = new JLabel();
    private JLabel dDomain = new JLabel();
    private JLabel dIPaddress = new JLabel();
    private JLabel dDiscovered = new JLabel();
    private JLabel blank1 = new JLabel(" ");
    private JLabel blank2 = new JLabel(" ");
    private JLabel blank3 = new JLabel(" ");
    private JLabel blank4 = new JLabel(" ");
    private JLabel blank5 = new JLabel(" ");
    private JLabel filler1 = new JLabel(" ");
    private JLabel filler2 = new JLabel(" ");
    private JLabel filler3 = new JLabel("                  ");
    private final String NOT_APPLICABLE = MessageLog.getMessageNoID("STG0019T");
    private final String NOT_AVAILABLE = MessageLog.getMessageNoID("GEN0185T");

    public ClusterData(int clusterID) {
        Request request = new Request();
        GuiRequest.clusterInfo(request, clusterID);
        GuiClient.doRequest(this, request);
        this.setLayout(this.gridBag);
        this.gbcFill_1.gridheight = 35;
        this.gbcFill_1.weighty = 1.0;
        this.gbcFill_1.ipadx = 60;
        this.gbcFill_2.gridwidth = 2;
        this.gbcFill_2.weightx = 1.0;
        this.gbcLabel.anchor = 17;
        this.gbcLast.anchor = 17;
        this.gbcLast.gridwidth = 0;
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        Cluster c = (Cluster)response.responseData;
        if (c.clusterName != null) {
            this.dCluster.setText(c.clusterName);
        }
        if (c.domain_name != null) {
            this.dDomain.setText(c.domain_name);
        } else {
            this.dDomain.setText(this.NOT_APPLICABLE);
        }
        this.dDiscovered.setText(DateFormat.getDateTimeInstance().format(new Date(c.discovered_time)));
        if (c.IPAddress.charAt(0) == '0' && c.IPAddress.charAt(1) == '.') {
            this.dIPaddress.setText(this.NOT_AVAILABLE);
        } else {
            this.dIPaddress.setText(c.IPAddress);
        }
        this.add((Component)this.filler1, this.gbcFill_1);
        this.add((Component)this.filler2, this.gbcFill_2);
        this.add((Component)this.filler3, this.gbcLast);
        this.add((Component)this.title, this.gbcLast);
        this.add((Component)this.blank1, this.gbcLast);
        this.add((Component)this.lCluster, this.gbcLabel);
        this.add((Component)this.dCluster, this.gbcLast);
        this.add((Component)this.lDomain, this.gbcLabel);
        this.add((Component)this.dDomain, this.gbcLast);
        this.add((Component)this.blank2, this.gbcLast);
        this.add((Component)this.lIPaddress, this.gbcLabel);
        this.add((Component)this.dIPaddress, this.gbcLast);
        this.add((Component)this.lDiscovered, this.gbcLabel);
        this.add((Component)this.dDiscovered, this.gbcLast);
    }
}

