/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.ComputersAdjuster;
import org.eclipse.aperi.TStorm.gui.ComputerDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputersTable
extends JPanel
implements GuiRequestor {
    private MegaTable table = new MegaTable();
    private Computer[] computers;
    private GuiReportReq grr;
    private ComputersAdjuster adjuster;

    public ComputersTable(GuiReportReq grr) {
        this.grr = grr;
        GuiReportRequest request = new GuiReportRequest(grr);
        GuiClient.doRequest(this, request);
        this.adjuster = new ComputersAdjuster(grr);
    }

    public void handleResponse(short status, Response response) {
        this.setLayout(new BorderLayout());
        this.computers = status <= 4 ? (Computer[])response.responseData : null;
        int cnt = this.computers != null ? this.computers.length : 0;
        if (cnt == 0) {
            JLabel noDataLabel = new JLabel(MessageLog.getMessageNoID("STG0020M"));
            noDataLabel.setHorizontalAlignment(0);
            this.add((Component)noDataLabel, "Center");
            return;
        }
        this.adjuster.adjust(this.computers, false);
        this.computers = (Computer[])this.adjuster.getArray();
        this.table.setMouseListener(new selectListener());
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setCellRenderer(MutableInteger.class, TableCellRenderers.number);
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(Date.class, TableCellRenderers.date);
        this.table.setCellRenderer(ComputersAdjuster.ComputerHertz.class, TableCellRenderers.hertz);
        this.table.setRowIcon(10, true);
        this.table.setBaseTableModel(new ComputersTableModel());
        this.table.setAsFirstColumn(this.adjuster.getFirstColumn());
        if (this.adjuster.frozenRows > 0) {
            this.table.setFrozenRows(this.adjuster.frozenRows);
        }
        this.add((Component)this.table, "First");
    }

    public class selectListener
    extends TJCTableMouseAdapter {
        public boolean select(int viewRow, int viewCol) {
            return !ComputersTable.this.adjuster.hasTotalsRow() || viewRow != 0;
        }

        public void doubleClick(int dataRow, int dataCol) {
            if (!ComputersTable.this.adjuster.hasTotalsRow() || dataRow != 0) {
                new ComputerDDI(null, ((ComputersTable)ComputersTable.this).computers[dataRow].gComputer.gcComputerID, ((ComputersTable)ComputersTable.this).computers[dataRow].gComputer.gcTSName);
            }
        }
    }

    private class ComputersTableModel
    extends BaseTableModel {
        ComputersTableModel() {
            this.rowCount = ComputersTable.this.computers.length;
            this.columnNames = ((ComputersTable)ComputersTable.this).adjuster.columnNameList;
            this.commonAdjuster = ComputersTable.this.adjuster;
        }

        public Object getTableDataItem(int row, int col) {
            return ComputersTable.this.adjuster.getCellData(row, ComputersTable.this.adjuster.translateColumn(col));
        }
    }
}

