/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.San.gui.LUNTreeLabel;
import org.eclipse.aperi.TStorm.gui.DiskDDI;
import org.eclipse.aperi.TStorm.gui.LogicalVolumeTreeLabel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.AlertableTreeNode;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.server.guireq.AlertNameList;

public class DiskTreeNode
extends AlertableTreeNode {
    private NameList computer;
    private String path;

    public DiskTreeNode(NameList pComputer, int diskID, String pPath) {
        super(diskID);
        this.computer = pComputer;
        this.path = pPath;
        this.setUserObject(this.path);
        this.reset();
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.render(renderer, tree, sel, expanded, leaf, row, hasFocus);
        renderer.setIcon(IconFactory.getDiskIcon());
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            LogicalVolumeTreeLabel treeLabel = this.computer.nlInfo == 78 ? new LUNTreeLabel(this.computer, this.ID) : new LogicalVolumeTreeLabel(this.computer, this.ID);
            this.add(treeLabel);
        }
    }

    public void select(TreeSelectionEvent event) {
        new DiskDDI(this, this.ID, this.path, this.computer.nlID, this.computer.nlName, this.computer.nlInfo == 78, (short)this.computer.nlID2);
    }

    protected NameList getNameList() {
        NameList result;
        if (this.computer.nlInfo != 78) {
            result = new NameList();
        } else {
            AlertNameList nl = new AlertNameList();
            nl.nlProductID = (short)3;
            nl.nlSubProductID = 1;
            result = nl;
        }
        result.nlID = this.ID;
        result.nlInfo = (short)10;
        result.nlName = this.getUserObject().toString();
        return result;
    }
}

