/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.TStorm.gui.HistoryHelper;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiDelete;
import org.eclipse.aperi.gui.GuiRename;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class EditableObjectNode
extends BaseTreeNode
implements ActionListener,
GuiRequestor,
PopupMenuListener {
    public NameList element;
    public JPopupMenu menu;
    private EditableObjectLabel folder;
    private boolean hasKids;
    private HistoryHelper historyHelper;
    private static final String EDIT = "E";
    private static final String DELETE = "D";
    private static final String RENAME = "R";
    protected static final String HISTORY = "H";
    private static final String REFRESH = "F";
    private static final String UPDATE = "U";
    private static final String EXECUTE = "X";
    private int adminType = 5;

    public EditableObjectNode(NameList pElement, EditableObjectLabel pFolder, boolean pHasKids) {
        this(pElement, pFolder, pHasKids, 1);
    }

    public EditableObjectNode(NameList pElement, EditableObjectLabel pFolder, boolean pHasKids, int adminType) {
        this.adminType = adminType;
        this.element = pElement;
        this.folder = pFolder;
        this.hasKids = pHasKids;
        super.setUserObject(this.element);
        this.setAllowsChildren(pHasKids);
        this.historyHelper = new HistoryHelper(this, this.describeObject(), this.element.nlID);
    }

    public void setUserObject(Object obj) {
        if (obj instanceof NameList) {
            this.element = (NameList)obj;
            this.element.nlName = Util.getTranslatedName(this.element.nlName);
            this.historyHelper.description = this.describeObject();
        }
        super.setUserObject(obj);
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
        renderer.setIcon(NameListTreeCellRenderer.iconForObject(this.element));
        renderer.setFont(BaseTree.plainFont);
    }

    public String describeObject() {
        Object[] args = new Object[]{this.folder.objectLabel, this.element.nlName};
        return MessageLog.getMessageNoID("GUI0049L", args);
    }

    public void select(TreeSelectionEvent event) {
        CreateOrEditDDI.showEditor(this.folder.editorClass, this.element.nlName, this.element.nlID, this.folder.objectType, this.folder.resourceType, this.folder.qualifier, this);
    }

    protected void addMenuItem(JPopupMenu menu, String msgID, String cmd, boolean enabled, String resourceID) {
        String s = resourceID == null ? Util.getString(msgID) : Util.getString(resourceID);
        JMenuItem item = new JMenuItem(s);
        item.setName(s);
        item.setActionCommand(cmd);
        item.addActionListener(this);
        item.setEnabled(enabled);
        menu.add(item);
    }

    public JPopupMenu getPopupMenuForButtons() {
        return this.getPopupMenu();
    }

    public JPopupMenu getPopupMenu() {
        this.menu = new JPopupMenu();
        this.menu.addPopupMenuListener(this);
        boolean adminCapable = false;
        switch (this.adminType) {
            case 4: {
                adminCapable = this.capabilities.isAnyAdmin();
                break;
            }
            case 1: {
                adminCapable = this.capabilities.isDataAdmin();
                break;
            }
            case 2: {
                adminCapable = this.capabilities.isDiskAdmin();
                break;
            }
            case 3: {
                adminCapable = this.capabilities.isFabricAdmin();
                break;
            }
            case 5: {
                adminCapable = this.capabilities.isAperiAdmin();
                break;
            }
            case 6: {
                adminCapable = this.capabilities.isTapeAdmin();
            }
        }
        this.addMenuItem(this.menu, "GUI0106L", DELETE, this.element.nlID > 299 && adminCapable, null);
        this.addMenuItem(this.menu, "GUI0047L", RENAME, this.element.nlID > 299 && adminCapable, null);
        if (this.hasKids) {
            this.addMenuItem(this.menu, "", REFRESH, true, "REFRESH_JOB_LIST");
            this.addMenuItem(this.menu, "GUI0165L", UPDATE, true, "UPDATE_JOB_STATUS");
            this.addMenuItem(this.menu, "GUI0052L", HISTORY, true, null);
            this.addMenuItem(this.menu, "JSS1002L", EXECUTE, adminCapable, null);
        }
        return this.menu;
    }

    public void showPopupMenu(MouseEvent event) {
        this.menu = this.getPopupMenu();
        this.showPopupMenu(this.menu, event);
    }

    public void expand(TreeExpansionEvent event) {
        if (this.getChildCount() == 0) {
            this.historyHelper.sendRequest();
        }
    }

    public void handleResponse(short status, Response response) {
        if (status <= 4) {
            Object[] args = new Object[]{this.element.nlName, null};
            JSgcScheduleCreateWhenData.displayJobSubmittedMessage(args);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd == EDIT) {
            this.select(null);
        } else if (cmd == DELETE) {
            String sNetQuota;
            String sLabel = (String)this.folder.getUserObject();
            if (sLabel.equals(sNetQuota = Util.getString("NAG0033L"))) {
                String text = MessageLog.getMessageNoID("NAS0022E");
                JOptionPane.showMessageDialog(guiMain.getFrame(), text, "NAS0022E", 0);
                return;
            }
            if (!GuiUtil.confirmDelete(BaseTree.pBaseTree, this.describeObject())) {
                return;
            }
            GuiDelete deleter = new GuiDelete();
            deleter.delete(this.element);
        } else if (cmd == RENAME) {
            GuiRename renamer = new GuiRename(this.element, this.describeObject());
            renamer.rename();
        } else if (cmd == REFRESH) {
            this.historyHelper.sendRequest();
        } else if (cmd == UPDATE) {
            this.historyHelper.sendUpdateRequest();
        } else if (cmd == HISTORY) {
            this.historyHelper.makeRunDDI();
        } else if (cmd == EXECUTE) {
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.SchedulerSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.scheduler.SchRunNowHandler";
            request.requestData = this.element;
            GuiClient.doRequest(this, request);
        }
        guiMain.getBaseTree().requestFocus();
    }

    public void popupMenuCanceled(PopupMenuEvent pme) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent pme) {
        BaseTree.pBaseTree.setSelectionPath(BaseTree.selectedPath);
        BaseTree.pBaseTree.requestFocus();
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent pme) {
    }
}

