/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.JTabbedPane;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.AlertCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.FSAlertEditor;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.xmsg.MessageLog;

public class FSAlertCreateOrEdit
extends AlertCreateOrEdit {
    private FSSelector fsSelector;
    private static final int ALERT_TAB = 0;
    private static final int FILESYSTEM_TAB = 1;

    public FSAlertCreateOrEdit(CreateOrEditDDI pDdi) {
        super(pDdi);
    }

    protected void makeTabbedPane(AlertHeader fsAlert) {
        NameList[] array = new NameList[]{fsAlert.alertGroups2, fsAlert.alertElements2, fsAlert.alertGroups, fsAlert.alertElements, fsAlert.alertClusters};
        this.fsSelector = new FSSelector(array, fsAlert.allObjects, false, true);
        this.alertEditor = fsAlert.alert == null ? new FSAlertEditor() : new FSAlertEditor(fsAlert.alert);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setFont(BaseTree.boldFont);
        String title = MessageLog.getMessageNoID("STG4036L");
        this.tabbedPane.addTab(title, this.alertEditor.getComponent());
        title = MessageLog.getMessageNoID("STG1006L");
        this.tabbedPane.addTab(title, this.fsSelector.getComponent());
    }

    public CreateHeader getData() {
        AlertHeader fsAlert = (AlertHeader)super.getData();
        NameList[] array = this.fsSelector.getData();
        fsAlert.alertGroups2 = array[0];
        fsAlert.alertElements2 = array[1];
        fsAlert.alertGroups = array[2];
        fsAlert.alertElements = array[3];
        fsAlert.alertClusters = array[4];
        fsAlert.allObjects = this.fsSelector.allFSSelected;
        return fsAlert;
    }

    public void replace(CreateHeader newHeader) {
        super.replace(newHeader);
        AlertHeader fsAlert = (AlertHeader)newHeader;
        NameList[] array = new NameList[]{fsAlert.alertGroups2, fsAlert.alertElements2, fsAlert.alertGroups, fsAlert.alertElements, fsAlert.alertClusters};
        this.fsSelector.replace(array, fsAlert.allObjects);
    }

    public void changeOccurred(int changeType, NameList name) {
        if (changeType == 100) {
            this.fsSelector.invalidateGroups(name.nlInfo);
        }
        if (changeType != 1) {
            return;
        }
        if (name.nlInfo == 2) {
            this.fsSelector.addFSGroup(name);
        }
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return "alfile5";
            }
            case 1: {
                return "alfile10";
            }
        }
        return null;
    }
}

