/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.TStorm.gui.FSGroupSelectorHelper;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class FSGroupEditor
implements Runnable,
GuiRequestor,
ActionListener {
    private NameList selected;
    private Runnable callingObject;
    public TreeSelector selector;
    private ComputerTreeNode compAvailHead;
    private ComputerTreeNode compNode;
    private NameList currentFS;
    private NameList prevFS;
    private boolean hold;
    private FSGroupSelectorHelper gsh;
    private boolean forComputer;

    public FSGroupEditor(NameList pSelected, Runnable pCallingObject, boolean pForComputer) {
        this.selected = pSelected;
        this.callingObject = pCallingObject;
        this.forComputer = pForComputer;
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        Request request;
        if (this.forComputer) {
            request = EditableObjectLabel.makeRequest((short)1, (short)0, (short)0);
            GuiListReq glr = (GuiListReq)request.requestData;
            glr.includeUnmanaged = true;
        } else {
            request = new Request();
            GuiRequest.filesystemList(request, -1);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        NameList available = (NameList)response.responseData;
        this.gsh = new FSGroupSelectorHelper();
        this.selector = this.forComputer ? this.gsh.getComputerTreeSelector(available, this.selected, false) : this.gsh.getFSTreeSelector(available, this.selected, false);
        this.selector.setGroupByClusterButtonActionListener(this);
        this.callingObject.run();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() instanceof JCheckBox) {
            boolean byCluster = ((JCheckBox)ae.getSource()).isSelected();
            if (this.forComputer) {
                this.selector.replaceTrees(this.gsh.makeComputerTree(this.selector.getAvailableList(), byCluster), this.gsh.makeComputerTree(this.selector.getSelectedList(), byCluster));
            } else {
                this.selector.replaceTrees(this.gsh.makeFsTree(this.selector.getAvailableList(), byCluster), this.gsh.makeFsTree(this.selector.getSelectedList(), byCluster));
            }
        }
    }

    private static class ComputerTreeNode {
        public ComputerTreeNode next;
        public NameList computer;
        public NameList filesystems;

        private ComputerTreeNode() {
        }
    }
}

