/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class FabricGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private static boolean test = false;
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList fabricSelections;
    private NameList zoneSelections;
    private NameList zoneSetsSelections;
    public boolean allFabricsSelected;
    public boolean allZonesSelected;
    public boolean allZoneSetsSelected;
    private NameList rootName;
    private TreeSet fabricIncludeSet = new TreeSet();
    private TreeSet fabricExcludeSet = new TreeSet();
    private TreeSet zoneIncludeSet = new TreeSet();
    private TreeSet zoneExcludeSet = new TreeSet();
    private TreeSet zoneSetIncludeSet = new TreeSet();
    private TreeSet zoneSetExcludeSet = new TreeSet();
    private JTree expansionTree;
    private TreeSelectorNode sourceFabricZoneLabel;
    private TreeSelectorNode sourceFabricZoneSetLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    private boolean zoneExpanding;
    private boolean zonesetExpanding;
    private static final int ROOT_ID = -5;
    private static final int FABRIC_ID = -4;
    private static final int ZONE_ID = -3;
    private static final int ZONESET_ID = -2;
    private static final int ALL_FABRIC_ID = Integer.MAX_VALUE;
    private static final int ALL_ZONE_ID = 0x7FFFFFFE;
    private static final int ALL_ZONESET_ID = 0x7FFFFFFD;
    public static final int FABRIC_IX = 0;
    public static final int ZONE_IX = 1;
    public static final int ZONESET_IX = 2;
    private static final String FABRIC_LABEL = Util.getString("FabricAlert_FabricTabTitle");
    private static final String ZONE_LABEL = Util.getString("FabricAlert_FabricZoneLabel");
    private static final String ZONESET_LABEL = Util.getString("FabricAlert_FabricZoneSetLabel");
    private static final String ALL_FABRIC_LABEL = Util.getString("FabricAlert_AllFabricLabel");
    private static final String ALL_ZONE_LABEL = Util.getString("FabricAlert_AllZoneLabel");
    private static final String ALL_ZONESET_LABEL = Util.getString("FabricAlert_AllZoneSetLabel");

    public FabricGroupSelector(NameList pFabricSelections, NameList pZoneSelections, NameList pZoneSetsSelections, boolean pAllFabricsSelected, boolean pAllZonesSelected, boolean pAllZoneSetsSelected) {
        this.fabricSelections = pFabricSelections;
        this.zoneSelections = pZoneSelections;
        this.zoneSetsSelections = pZoneSetsSelections;
        this.allFabricsSelected = pAllFabricsSelected;
        this.allZonesSelected = pAllZonesSelected;
        this.allZoneSetsSelected = pAllZoneSetsSelected;
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList[] listHead = new NameList[5];
        NameList[] listTail = new NameList[5];
        NameList element = null;
        this.allFabricsSelected = false;
        this.allZonesSelected = false;
        this.allZoneSetsSelected = false;
        NameList selList = this.selector.getNameList();
        while (selList != null) {
            int ix = -999;
            if (selList.nlInfo == 114) {
                ix = 0;
            } else if (selList.nlInfo == 127) {
                ix = 1;
            } else if (selList.nlInfo == 126) {
                ix = 2;
            } else if (selList.nlInfo == 130) {
                this.allFabricsSelected = true;
            } else if (selList.nlInfo == 131) {
                this.allZonesSelected = true;
            } else if (selList.nlInfo == 132) {
                this.allZoneSetsSelected = true;
            }
            if (ix < 0) {
                selList = selList.nlNext;
                continue;
            }
            element = selList;
            selList = element.nlNext;
            element.nlNext = null;
            if (listTail[ix] == null) {
                listHead[ix] = element;
            } else {
                listTail[ix].nlNext = element;
            }
            listTail[ix] = element;
        }
        return listHead;
    }

    private void buildSourceTree() {
        TreeSelectorNode root = this.newRoot();
        this.addLabelNode(FABRIC_LABEL, -4, root);
        this.sourceFabricZoneLabel = this.addLabelNode(ZONE_LABEL, -3, root);
        this.sourceFabricZoneSetLabel = this.addLabelNode(ZONESET_LABEL, -2, root);
        this.sourceTree = new JTree(root, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode fabricLabel = null;
        TreeSelectorNode fabricExcludeLabel = null;
        TreeSelectorNode zoneLabel = null;
        Object zoneExcludeLabel = null;
        TreeSelectorNode zoneSetLabel = null;
        Object zoneSetExcludeLabel = null;
        TreeSelectorNode root = this.newRoot();
        this.fillSets(this.fabricSelections, this.fabricIncludeSet, this.fabricExcludeSet, true, false);
        if (this.allFabricsSelected || !this.fabricIncludeSet.isEmpty()) {
            fabricLabel = this.addLabelNode(FABRIC_LABEL, -4, root);
            if (this.allFabricsSelected) {
                this.addAllMembersNode(ALL_FABRIC_LABEL, Integer.MAX_VALUE, 130, fabricLabel, true);
            }
            this.addTreeSet(fabricLabel, this.fabricIncludeSet);
        }
        if (!this.fabricExcludeSet.isEmpty()) {
            fabricExcludeLabel = TreeSelector.makeExcludeRoot();
            root.add(fabricExcludeLabel);
            this.addTreeSet(fabricExcludeLabel, this.fabricExcludeSet);
        }
        this.fillSets(this.zoneSelections, this.zoneIncludeSet, this.zoneExcludeSet, true, false);
        if (!this.zoneIncludeSet.isEmpty() || this.allZonesSelected) {
            zoneLabel = this.addLabelNode(ZONE_LABEL, -3, root);
        }
        if (this.allZonesSelected) {
            this.addAllMembersNode(ALL_ZONE_LABEL, 0x7FFFFFFE, 131, zoneLabel, true);
        }
        this.addTreeSet(zoneLabel, this.zoneIncludeSet);
        this.fillSets(this.zoneSetsSelections, this.zoneSetIncludeSet, this.zoneSetExcludeSet, true, false);
        if (!this.zoneSetIncludeSet.isEmpty() || this.allZoneSetsSelected) {
            zoneSetLabel = this.addLabelNode(ZONESET_LABEL, -2, root);
        }
        if (this.allZoneSetsSelected) {
            this.addAllMembersNode(ALL_ZONESET_LABEL, 0x7FFFFFFD, 132, zoneSetLabel, true);
        }
        this.addTreeSet(zoneSetLabel, this.zoneSetIncludeSet);
        return root;
    }

    private void buildSelectedTree() {
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(root, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList pfabricSelections, NameList pzoneSelections, NameList pzoneSetsSelections, boolean pallFabricsSelected, boolean pallZonesSelected, boolean pallZoneSetsSelected) {
        this.fabricSelections = pfabricSelections;
        this.zoneSelections = pzoneSelections;
        this.zoneSetsSelections = pzoneSetsSelections;
        this.allFabricsSelected = pallFabricsSelected;
        this.allZonesSelected = pallZonesSelected;
        this.allZoneSetsSelected = pallZoneSetsSelected;
        this.fabricIncludeSet.clear();
        this.fabricExcludeSet.clear();
        this.zoneIncludeSet.clear();
        this.zoneExcludeSet.clear();
        this.zoneSetIncludeSet.clear();
        this.zoneSetExcludeSet.clear();
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        DefaultTreeModel model = new DefaultTreeModel(root, true);
        this.selectedTree.setModel(model);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList memberList, TreeSet includeSet, TreeSet excludeSet, boolean memberSelectable, boolean memberExcludeable) {
        boolean showClusterName = true;
        TreeSelectorNode member = null;
        while (memberList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            if (Constants.isVirtualServer(memberList.nlID2)) {
                memberList = memberList.nlNext;
                continue;
            }
            if ((memberList.nlState & 1) != 0) {
                set = excludeSet;
                selectable = false;
                excludeable = true;
            } else {
                set = includeSet;
                selectable = memberSelectable;
                excludeable = memberExcludeable;
            }
            if (this.zoneExpanding) {
                showClusterName = false;
            }
            member = new TreeSelectorNode(memberList, selectable, excludeable, false, false, null, showClusterName, true);
            if (this.zoneExpanding || this.zonesetExpanding) {
                member.setButtonFlag(false);
            }
            set.add(member);
            memberList = memberList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode parent, TreeSet set) {
        for (TreeSelectorNode child : set) {
            parent.add(child);
        }
    }

    public void invalidateGroups(short groupType) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, groupType);
    }

    public void addGroup(NameList name) {
        TreeSelectorNode sourceGroupLabel;
        if (name.nlID == -3) {
            sourceGroupLabel = this.sourceFabricZoneLabel;
        } else if (name.nlID == -2) {
            sourceGroupLabel = this.sourceFabricZoneSetLabel;
        } else {
            return;
        }
        if (!sourceGroupLabel.childrenFetched) {
            return;
        }
        NameList toAdd = (NameList)name.clone();
        TreeSelectorNode newNode = new TreeSelectorNode(toAdd, true, false, true, true, null);
        DefaultTreeModel model = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(model, sourceGroupLabel, newNode);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        this.zoneExpanding = false;
        this.zonesetExpanding = false;
        TreePath path = e.getPath();
        this.expansionNode = (TreeSelectorNode)path.getLastPathComponent();
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList name = this.expansionNode.getNameList();
        this.expansionTree = (JTree)e.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (name.nlID == -3) {
                this.sendRequest((short)127, -1);
            } else if (name.nlID == -4) {
                this.sendRequest((short)114, -1);
            } else if (name.nlID == -2) {
                this.sendRequest((short)126, -1);
            }
        } else if (name.nlInfo == 114) {
            this.sendRequest((short)114, name.nlID);
        } else if (name.nlInfo == 127) {
            this.zoneExpanding = true;
            this.sendRequest(name.nlInfo, name.nlID);
        } else if (name.nlInfo == 126) {
            this.sendRequest(name.nlInfo, name.nlID);
            this.zonesetExpanding = true;
        } else if (name.nlInfo == 130) {
            this.sendRequest((short)114, -1);
        } else if (name.nlInfo == 131) {
            this.sendRequest((short)127, -1);
        } else if (name.nlInfo == 132) {
            this.sendRequest((short)126, -1);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    protected GuiListReq makeListRequestData(short resourceType, int groupID) {
        GuiListReq requestData = new GuiListReq();
        if (resourceType == 99) {
            requestData.listRequested = 11;
        } else {
            if (resourceType == 101) {
                resourceType = (short)99;
            }
            requestData.listRequested = 10000 + resourceType;
            requestData.groupID = groupID;
        }
        return requestData;
    }

    protected GroupDefinition makeGroupRequestData(short resourceType, int groupID) {
        GroupDefinition requestData = new GroupDefinition();
        requestData.groupType = resourceType;
        requestData.ID = groupID;
        return requestData;
    }

    private void sendRequest(short resourceType, int groupID) {
        Request request;
        if (resourceType == 99) {
            GroupDefinition lData = this.makeGroupRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", lData);
        } else {
            GuiListReq gData = this.makeListRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", gData);
        }
        GuiClient.doRequest(this, request);
    }

    private NameList makeFakeData() {
        NameList nameList = null;
        NameList name = this.expansionNode.getNameList();
        if (name.nlID == -4) {
            NameList item = new NameList();
            item.nlName = "fabric1";
            item.nlInfo = (short)114;
            item.nlNext = nameList;
            nameList = item;
            item = new NameList();
            item.nlName = "fabric2";
            item.nlInfo = (short)114;
            item.nlNext = nameList;
            nameList = item;
        } else if (name.nlID == -3) {
            NameList item = new NameList();
            item.nlName = "zone1";
            item.nlInfo = (short)127;
            item.nlNext = nameList;
            nameList = item;
            item = new NameList();
            item.nlName = "zone2";
            item.nlInfo = (short)127;
            item.nlNext = nameList;
            nameList = item;
        } else if (name.nlID == -2) {
            NameList item = new NameList();
            item.nlName = "ZoneSet1";
            item.nlInfo = (short)126;
            item.nlNext = nameList;
            nameList = item;
            item = new NameList();
            item.nlName = "ZoneSet2";
            item.nlInfo = (short)126;
            item.nlNext = nameList;
            nameList = item;
        }
        return nameList;
    }

    public void handleResponse(short status, Response response) {
        NameList nameList = null;
        if (test) {
            nameList = this.makeFakeData();
        } else {
            if (status > 4) {
                return;
            }
            boolean showClusterName = true;
            Serializable obj = response.responseData;
            if (obj instanceof GroupDefinition) {
                GroupDefinition gdef = (GroupDefinition)response.responseData;
                nameList = gdef.members;
            } else {
                nameList = (NameList)response.responseData;
            }
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList == null) {
            NameList name = this.expansionNode.getNameList();
            if (this.expansionTree == this.sourceTree) {
                if (name.nlID == -3) {
                    this.addAllMembersNode(ALL_ZONE_LABEL, 0x7FFFFFFE, 131, this.expansionNode, false);
                } else if (name.nlID == -4) {
                    this.addAllMembersNode(ALL_FABRIC_LABEL, Integer.MAX_VALUE, 130, this.expansionNode, false);
                } else if (name.nlID == -2) {
                    this.addAllMembersNode(ALL_ZONESET_LABEL, 0x7FFFFFFD, 132, this.expansionNode, false);
                }
            }
        } else {
            boolean exclude;
            boolean select = this.expansionTree == this.sourceTree;
            boolean bl = exclude = !select;
            if (nameList.nlInfo == 114) {
                if (select) {
                    this.addAllMembersNode(ALL_FABRIC_LABEL, Integer.MAX_VALUE, 130, this.expansionNode, false);
                }
                this.fabricIncludeSet.clear();
                this.fillSets(nameList, this.fabricIncludeSet, this.fabricExcludeSet, select, exclude);
                this.addTreeSet(this.expansionNode, this.fabricIncludeSet);
            } else if (nameList.nlInfo == 127) {
                if (select) {
                    this.addAllMembersNode(ALL_ZONE_LABEL, 0x7FFFFFFE, 131, this.expansionNode, false);
                }
                this.zoneIncludeSet.clear();
                this.fillSets(nameList, this.zoneIncludeSet, this.zoneExcludeSet, select, exclude);
                this.addTreeSet(this.expansionNode, this.zoneIncludeSet);
            } else if (nameList.nlInfo == 126) {
                if (select) {
                    this.addAllMembersNode(ALL_ZONESET_LABEL, 0x7FFFFFFD, 132, this.expansionNode, false);
                }
                this.zoneSetIncludeSet.clear();
                this.fillSets(nameList, this.zoneSetIncludeSet, this.zoneSetExcludeSet, select, exclude);
                this.addTreeSet(this.expansionNode, this.zoneSetIncludeSet);
            }
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -5, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addLabelNode(String label, int id, TreeSelectorNode root) {
        NameList name = this.newNameList(label, id, -1);
        TreeSelectorNode labelNode = new TreeSelectorNode(name, false, false, true);
        labelNode.setButtonFlag(false);
        labelNode.setSortKey(id);
        root.add(labelNode);
        return labelNode;
    }

    private void addAllMembersNode(String label, int id, int resourceID, TreeSelectorNode root, boolean expandable) {
        NameList name = this.newNameList(label, id, resourceID);
        TreeSelectorNode node = new TreeSelectorNode(name, true, false, expandable, true, null);
        node.setSortKey(-1);
        root.add(node);
    }

    private NameList newNameList(String name, int id, int type) {
        NameList nameList = new NameList();
        nameList.nlName = name;
        nameList.nlID = id;
        nameList.nlInfo = (short)type;
        return nameList;
    }
}

