/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingObjectBuilder;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.gui.DateSelector;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.charting.AperiCustomizableChart;
import org.eclipse.aperi.request.BasicSocketClient;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class HistoryChart
implements GuiRequestor,
ReportingObjectBuilder,
ActionListener {
    public static final int DEFAULT_MAX_LINES = 10;
    protected String title = "";
    protected String sourceName = "";
    protected String[] seriesL;
    protected double[] xvalues;
    protected double[] yvalues;
    protected long currentTimeStamp = System.currentTimeMillis();
    protected double holeValue = Double.MIN_VALUE;
    protected ReportingDDI ddi;
    private GuiReportReq grr;
    private Request request;
    private AperiCustomizableChart chart;
    private JPanel panel = new JPanel(new BorderLayout());
    private JLabel error = new JLabel(MessageLog.getMessageNoID("STG0020M"));
    private String[] seriesLAll;
    private double[][] xValuesAll;
    private double[][] yValuesAll;
    private JButton generate = new JButton(MessageLog.getMessageNoID("STG1285T"));
    private String[] types = new String[]{Util.getString("BY_SCAN"), MessageLog.getMessageNoID("STG1194T"), MessageLog.getMessageNoID("STG1195T")};
    private TComboBox ctype = new TComboBox(this.types);
    private JCheckBox limit = new JCheckBox();
    private JLabel fromL = new JLabel(MessageLog.getMessageNoID("STG1284T"));
    private DateSelector from = new DateSelector();
    private JLabel toL = new JLabel(MessageLog.getMessageNoID("STG4083L"));
    private DateSelector to = new DateSelector();
    private boolean batch = false;
    private GuiChartSettingsReq gcsr = null;

    protected abstract boolean processResponse(Object var1, GuiReportReq var2);

    public Component batch(Object grr, GuiChartSettingsReq gcsr) {
        this.gcsr = gcsr;
        this.batch = true;
        return this.build(grr);
    }

    public Component build(Object grrIN) {
        Component comp;
        this.grr = (GuiReportReq)grrIN;
        if (this.batch) {
            comp = this.buildBatchReportChart();
        } else {
            this.request = new GuiReportRequest(this.grr);
            GuiClient.doRequest(this, this.request);
            comp = this.buildReportChartPanel();
        }
        return comp;
    }

    private Component buildBatchReportChart() {
        this.request = new GuiReportRequest(this.grr);
        Response response = null;
        try {
            response = BasicSocketClient.sendRequest(this.request, Variables.server, Variables.port);
        }
        catch (Exception e) {
            response = new Response(12, null);
            response.errorMessage = e.getMessage();
        }
        if (response == null || response.status > 4) {
            return null;
        }
        if (!this.processResponse(response.responseData, this.grr)) {
            return null;
        }
        this.handleResponse((short)0, null);
        return this.chart;
    }

    private Component buildReportChartPanel() {
        GuiUtil.setAccessible(this.generate, this.generate.getText(), this.generate.getText());
        GuiUtil.setAccessible(this.limit, this.fromL.getText(), this.fromL.getText());
        this.panel.add((Component)this.buildControlPanel(), "North");
        if (this.grr.startTime > 0L) {
            this.fromL.setEnabled(true);
            this.toL.setEnabled(true);
            this.from.setEnabled(true);
            this.from.setDate(this.grr.startTime);
            this.to.setEnabled(true);
            this.to.setDate(this.grr.endTime);
            this.limit.setSelected(true);
        } else {
            this.fromL.setEnabled(false);
            this.from.setEnabled(false);
            this.toL.setEnabled(false);
            this.to.setEnabled(false);
        }
        this.generate.addActionListener(this);
        this.limit.addActionListener(this);
        this.panel.revalidate();
        return this.panel;
    }

    private JPanel buildControlPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel controlPanel = new JPanel(new GridBagLayout());
        gbc.fill = 0;
        gbc.insets.top = 4;
        gbc.insets.left = 4;
        gbc.insets.bottom = 4;
        gbc.insets.right = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 21;
        gbc.gridx = 0;
        controlPanel.add((Component)this.ctype, gbc);
        ++gbc.gridx;
        gbc.anchor = 10;
        gbc.weightx = 1.0;
        controlPanel.add((Component)this.buildLimitDateRangePanel(), gbc);
        gbc.weightx = 0.0;
        ++gbc.gridx;
        gbc.anchor = 22;
        controlPanel.add((Component)this.generate, gbc);
        controlPanel.setBorder(GuiUtil.getBorder());
        return controlPanel;
    }

    private JPanel buildLimitDateRangePanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets.top = 4;
        gbc.insets.left = 4;
        gbc.insets.bottom = 4;
        gbc.insets.right = 4;
        gbc.gridwidth = 1;
        gbc.anchor = 16;
        gbc.weightx = 0.0;
        JPanel toFromPanel = new JPanel(new GridBagLayout());
        toFromPanel.setOpaque(false);
        toFromPanel.add((Component)this.limit, gbc);
        this.limit.setOpaque(false);
        toFromPanel.add((Component)this.fromL, gbc);
        gbc.gridwidth = 0;
        toFromPanel.add((Component)this.from, gbc);
        this.from.setOpaque(false);
        gbc.gridwidth = 1;
        gbc.gridx = 1;
        toFromPanel.add((Component)this.toL, gbc);
        gbc.gridx = -1;
        toFromPanel.add((Component)this.to, gbc);
        this.to.setOpaque(false);
        return toFromPanel;
    }

    public void handleResponse(short status, Response response) {
        if (!this.batch) {
            if (this.error != null) {
                this.panel.remove(this.error);
            }
            if (this.chart != null) {
                this.panel.remove(this.chart);
            }
            if (status > 4 || response.responseData == null) {
                this.panel.add((Component)this.error, "Center");
                return;
            }
        }
        if (!this.batch && !this.processResponse(response.responseData, this.grr)) {
            this.panel.add((Component)this.error, "Center");
            return;
        }
        this.fillOutArrays();
        ChartOptions defaults = new ChartOptions();
        defaults.chartType = 0;
        defaults.chartsPerView = 10;
        this.chart = new AperiCustomizableChart((int)this.grr.chartLabelType, 5, this.yValuesAll, this.xValuesAll, this.seriesLAll, defaults, this.grr);
        if (!this.batch) {
            this.panel.add((Component)this.chart, "Center");
        }
    }

    private void fillOutArrays() {
        int i;
        HashMap<String, ArrayList<Double>> xValues = new HashMap<String, ArrayList<Double>>();
        HashMap<String, ArrayList<Double>> yValues = new HashMap<String, ArrayList<Double>>();
        for (i = 0; i < this.seriesL.length; ++i) {
            ArrayList<Double> xal = (ArrayList<Double>)xValues.get(this.seriesL[i]);
            ArrayList<Double> yal = (ArrayList<Double>)yValues.get(this.seriesL[i]);
            if (xal == null) {
                xal = new ArrayList<Double>();
                xValues.put(this.seriesL[i], xal);
                yal = new ArrayList<Double>();
                yValues.put(this.seriesL[i], yal);
            }
            xal.add(new Double(this.xvalues[i]));
            yal.add(new Double(this.yvalues[i]));
        }
        this.seriesLAll = xValues.keySet().toArray(new String[xValues.size()]);
        this.xValuesAll = new double[xValues.size()][];
        this.yValuesAll = new double[xValues.size()][];
        for (i = 0; i < this.seriesLAll.length; ++i) {
            this.xValuesAll[i] = new double[((ArrayList)xValues.get(this.seriesLAll[i])).size()];
            this.yValuesAll[i] = new double[((ArrayList)yValues.get(this.seriesLAll[i])).size()];
            for (int j = 0; j < this.xValuesAll[i].length; ++j) {
                this.xValuesAll[i][j] = (Double)((ArrayList)xValues.get(this.seriesLAll[i])).get(j);
                this.yValuesAll[i][j] = (Double)((ArrayList)yValues.get(this.seriesLAll[i])).get(j);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.generate) {
            this.grr.histType = (byte)this.ctype.getSelectedIndex();
            if (this.limit.isSelected()) {
                this.grr.startTime = this.from.getStartOfDay();
                this.grr.endTime = this.to.getEndOfDay();
            } else {
                this.grr.startTime = 0L;
                this.grr.endTime = 0L;
            }
            GuiClient.doRequest(this, this.request);
        } else if (e.getSource() == this.limit) {
            this.fromL.setEnabled(this.limit.isSelected());
            this.from.setEnabled(this.limit.isSelected());
            this.toL.setEnabled(this.limit.isSelected());
            this.to.setEnabled(this.limit.isSelected());
        }
    }

    public void setXaxis(short xType) {
        this.ctype.setSelectedIndex(xType);
    }

    public Object[] getArrays() {
        Object[] result = new Object[4];
        result[1] = this.seriesL;
        result[2] = this.xvalues;
        result[3] = this.yvalues;
        return result;
    }

    public void regenerate(short inHistType) {
        this.grr.histType = (byte)inHistType;
        GuiClient.doRequest(this, this.request);
    }

    public void setDDI(ReportingDDI inDdi) {
        this.ddi = inDdi;
    }
}

