/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

class IPListEditor
extends EditableList {
    private JComponent panel;
    private NameList ips;
    private String desc;
    private static String invalidFormatTitle = MessageLog.getMessageNoID("GUI8214T");
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public IPListEditor(NameList plist, String descStr) {
        super(" ", null, 5);
        this.ips = plist;
        this.desc = descStr;
    }

    public JComponent getComponent() {
        while (this.ips != null) {
            this.addObject(this.ips.nlName);
            this.ips = this.ips.nlNext;
        }
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel label = new JLabel(this.desc);
        c.insets.top = 10;
        c.insets.left = 10;
        c.insets.bottom = 6;
        c.gridwidth = 0;
        c.anchor = 18;
        this.panel.add((Component)label, c);
        c.insets.top = 0;
        c.insets.left = 0;
        c.insets.bottom = 0;
        c.gridwidth = 0;
        c.weightx = 1.0;
        this.panel.add(Box.createHorizontalStrut(100), c);
        c.insets.left = 10;
        c.gridheight = 0;
        c.weightx = 0.0;
        c.weighty = 1.0;
        this.panel.add((Component)this, c);
        return this.panel;
    }

    public void addObject(Object o) {
        String s = o.toString().trim();
        int n = this.listModel.size();
        boolean going = true;
        while (going && n > 0) {
            String p;
            if (!(p = this.listModel.get(--n).toString()).equals(s)) continue;
            going = false;
        }
        if (going && this.simpleIPValidator(s)) {
            super.addObject(s);
        }
    }

    private boolean simpleIPValidator(String hostName) {
        String pattern;
        if (hostName.indexOf(46) != -1 && !hostName.matches(pattern = "^[\\w]+\\.[\\w]+\\.[\\w]+\\.[\\w].*$")) {
            String msg = MessageLog.getMessage("GUI8215E", hostName);
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), msg, invalidFormatTitle, 0);
            return false;
        }
        return true;
    }

    private static NameList makeNameList(Object o) {
        NameList result = new NameList();
        result.nlName = o.toString();
        return result;
    }

    public NameList getData() {
        NameList head = null;
        Object[] array = this.getElements();
        if (array != null && array.length > 0) {
            NameList last = head = IPListEditor.makeNameList(array[0]);
            for (int i = 1; i < array.length; ++i) {
                NameList element;
                last.nlNext = element = IPListEditor.makeNameList(array[i]);
                last = element;
            }
        }
        return head;
    }

    protected void actionAdd() {
        String ip = String.valueOf(this.editor.getObject());
        if (GuiUtil.isIPFormatValid(ip)) {
            this.addObject(ip);
        } else {
            String s = Util.getString("GUI8210E");
            String t = Util.getString("GUI8211T");
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), s, t, 1);
        }
    }
}

