/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.GridBagPanel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.UilLabelledComponentBean;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;

public class MaskEditor
implements ActionListener,
GuiRequestor {
    private JCheckBox allowExcludeMask;
    private JCheckBox allowIncludeMask;
    private UilLabelledComponentBean excludeLabel;
    private UilLabelledComponentBean includeLabel;
    private JTextField excludeTextField;
    private JTextField includeTextField;
    private String excludeMask;
    private String includeMask;
    private JButton viewResultsButton;
    private JDialog dialog;
    private static JButton ok;
    private static JButton cancel;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public MaskEditor() {
        this.setUpControls();
    }

    public MaskEditor(String excludeMask, String includeMask, boolean isIncludeMaskEnabled, boolean isExcludeMaskEnabled) {
        this.setUpControls();
        this.setExcludeMask(excludeMask);
        this.setIncludeMask(includeMask);
        this.excludeTextField.setText(excludeMask);
        this.includeTextField.setText(includeMask);
        this.allowExcludeMask.setSelected(isExcludeMaskEnabled);
        this.allowIncludeMask.setSelected(isIncludeMaskEnabled);
    }

    public void setExcludeMask(String excludeMask) {
        this.excludeMask = excludeMask;
    }

    public void setIncludeMask(String includeMask) {
        this.includeMask = includeMask;
    }

    public String getExcludeMask() {
        return this.excludeMask;
    }

    public String getIncludeMask() {
        return this.includeMask;
    }

    private void setUpControls() {
        this.excludeTextField = new JTextField(20);
        this.includeTextField = new JTextField(20);
        this.excludeLabel = new UilLabelledComponentBean("Exclude Mask", this.excludeTextField);
        this.includeLabel = new UilLabelledComponentBean("Include Mask", this.includeTextField);
        this.allowExcludeMask = new JCheckBox();
        this.allowExcludeMask.addActionListener(this);
        this.allowIncludeMask = new JCheckBox();
        this.allowIncludeMask.addActionListener(this);
        this.viewResultsButton = new JButton("View Mask Results");
        this.viewResultsButton.addActionListener(this);
    }

    public JPanel getComponent() {
        GridBagPanel panel = new GridBagPanel();
        panel.setDefaultAnchor(25);
        GridBagPanel p = new GridBagPanel(new Insets(0, 0, 0, 0));
        p.setDefaultAnchor(25);
        p.add((JComponent)this.allowIncludeMask, 0);
        p.add((JComponent)this.includeLabel, 0);
        GridBagPanel q = new GridBagPanel(new Insets(0, 0, 0, 0));
        q.setDefaultAnchor(25);
        q.add((JComponent)this.allowExcludeMask, 0);
        q.add((JComponent)this.excludeLabel, 0);
        panel.add((JComponent)p, 25, 0);
        panel.setDefaultAnchor(20);
        panel.add((JComponent)this.viewResultsButton, 1, 2, 0);
        panel.newRow();
        panel.add((JComponent)q, 25, 0);
        return panel;
    }

    private void submitRetrieve() {
        Request request = new Request();
        request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
        request.subType = "org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition";
        request.flags = (byte)5;
        request.userName = GuiUtil.getUserName();
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        NameList nl1 = new NameList();
        nl1.nlName = "dummy1.storage.sanjose.im.com";
        NameList nl2 = new NameList();
        nl2.nlName = "dummy2.storage.sanjose.im.com";
        NameList nl3 = new NameList();
        nl3.nlName = "dummy3.storage.sanjose.im.com";
        Vector<NameList> v = new Vector<NameList>();
        v.add(nl1);
        v.add(nl2);
        v.add(nl3);
        this.showList(v);
    }

    private void showList(Vector v) {
        Object name = null;
        for (int i = 0; i < v.size(); ++i) {
            System.out.println("Array contains: " + ((NameList)v.get((int)i)).nlName);
        }
        ok = new JButton("OK");
        ok.addActionListener(this);
        cancel = new JButton("Cancel");
        cancel.addActionListener(this);
        JList jl = new JList(v);
        jl.setVisible(true);
        this.dialog = new JDialog(this.guiMain.getFrame(), true);
        this.dialog.setTitle("Mask Results");
        URL url = null;
        try {
            url = new URL("itsrm//gui//images//icon.gif");
        }
        catch (MalformedURLException e) {
            System.out.println("Exception Caught: " + e);
        }
        Container con = this.dialog.getContentPane();
        con.setLayout(new BorderLayout());
        JScrollPane j = new JScrollPane(jl);
        con.add((Component)j, "Center");
        JPanel p = new JPanel();
        p.add(ok);
        p.add(cancel);
        JScrollPane jp = new JScrollPane(p);
        con.add((Component)jp, "South");
        Dimension screenSize = this.dialog.getToolkit().getScreenSize();
        int x = (screenSize.width - 400) / 2;
        int y = (screenSize.height - 200) / 2;
        this.dialog.setBounds(x, y, 400, 200);
        this.dialog.setSize(300, 300);
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == ok) {
            System.out.println("Ok Action");
            System.out.println("User has choosen to set this mask\n");
            if (this.dialog.isVisible()) {
                this.dialog.setVisible(false);
            }
        } else if (obj == cancel) {
            System.out.println("User has not choosen to set this mask\n");
            System.out.println("Cancel Action");
            if (this.dialog.isVisible()) {
                this.dialog.setVisible(false);
            }
        } else if (obj == this.viewResultsButton) {
            Response res = new Response(1, null, 0);
            this.handleResponse((short)1, res);
        }
    }
}

