/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.aperi.TStorm.gui.EditableObjectLabel;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class MultiPicker
implements GuiRequestor,
ListSelectionListener,
ActionListener,
MouseListener,
ObjectChangeListener {
    private static final String ADD = "A";
    private static final String DELETE = "D";
    private static final String NEW = "N";
    private static final String EDIT = "E";
    private static final int TITLE_PAD = 2;
    private int nLists;
    private JList availableList;
    private DefaultListModel availableModel;
    private short objectType;
    private short requestType;
    private Container panel;
    private JButton newButton;
    private Class editorClass;
    private String objectLabelID;
    private NameList rightClicked;
    private JPopupMenu popupMenu;
    public NameList available;
    private Runnable nextInChain;
    private Icon icon;
    public short qualifier;
    public short resourceType;
    public short includeType = (short)-1;
    private SelectedList[] selected;
    private NameList[] initiallySelected;

    private void possiblyRemove(NameList element, int index) {
        --element.nlID3;
        if (element.nlID3 <= 0) {
            this.availableModel.remove(index);
        }
    }

    private boolean addToModel(NameList toAdd, DefaultListModel model) {
        int i;
        Object[] contents = model.toArray();
        int x = 1;
        for (i = 0; x > 0 && i < contents.length; ++i) {
            NameList element = (NameList)contents[i];
            x = toAdd.nlName.compareTo(element.nlName);
        }
        if (x == 0) {
            return false;
        }
        if (x < 0) {
            --i;
        }
        model.add(i, toAdd);
        return true;
    }

    private void add(NameList toAdd) {
        if (toAdd.nlID3 <= 0) {
            this.addToModel(toAdd, this.availableModel);
        }
        ++toAdd.nlID3;
    }

    private void setIcon(JList list) {
        DefaultListCellRenderer renderer = (DefaultListCellRenderer)list.getCellRenderer();
        renderer.setIcon(this.icon);
    }

    public MultiPicker(short pObjectType, NameList[] pInitiallySelected, Class editorClass, String availableLabelId, String objectLabelId, String newObjectButtonLabelId, String[] selectionListTitleIds, Runnable pNextInChain, boolean editable) {
        Component bottomThing;
        int i;
        this.nextInChain = pNextInChain;
        this.objectType = this.requestType = pObjectType;
        this.qualifier = 0;
        this.resourceType = 0;
        NameList temp = new NameList();
        temp.nlInfo = this.objectType;
        this.icon = NameListTreeCellRenderer.iconForObject(temp);
        temp = null;
        this.initiallySelected = pInitiallySelected;
        this.editorClass = editorClass;
        this.objectLabelID = objectLabelId;
        this.nLists = this.initiallySelected.length;
        this.selected = new SelectedList[this.nLists];
        for (i = 0; i < this.nLists; ++i) {
            this.selected[i] = new SelectedList(selectionListTitleIds[i]);
        }
        this.availableModel = new DefaultListModel();
        this.availableList = new JList(this.availableModel);
        this.availableList.setSelectionMode(2);
        this.availableList.addListSelectionListener(this);
        if (editable) {
            this.availableList.addMouseListener(this);
        }
        this.setIcon(this.availableList);
        JScrollPane scrollPane = new JScrollPane(this.availableList);
        JPanel subPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        c.anchor = 17;
        c.insets.bottom = 2;
        String s = MessageLog.getMessageNoID(availableLabelId);
        JLabel label = new JLabel(s);
        GuiUtil.setAccessibleLabel(label, this.availableList, "", label.getText(), label.getText());
        Font font = label.getFont().deriveFont(1);
        label.setFont(font);
        subPanel.add((Component)label, c);
        c.gridheight = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.anchor = 10;
        c.fill = 1;
        c.insets.bottom = 0;
        subPanel.add((Component)scrollPane, c);
        this.panel = new JPanel(new GridBagLayout());
        c.gridwidth = 1;
        c.gridheight = this.nLists;
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.insets.left = 13;
        c.insets.top = 10;
        this.panel.add((Component)subPanel, c);
        c.gridwidth = 0;
        c.gridheight = 1;
        c.insets.right = 13;
        c.insets.left = 0;
        c.weighty = 1.0 / (double)this.nLists;
        for (i = 0; i < this.nLists; ++i) {
            this.panel.add(this.selected[i].getComponent(), c);
        }
        if (!editable) {
            c.insets.top = 0;
            bottomThing = Box.createVerticalStrut(1);
        } else {
            c.insets.top = 14;
            s = MessageLog.getMessageNoID(newObjectButtonLabelId);
            this.newButton = new JButton(s);
            GuiUtil.setAccessible(this.newButton, this.newButton.getText(), this.newButton.getText());
            this.newButton.setActionCommand(NEW);
            this.newButton.addActionListener(this);
            bottomThing = this.newButton;
        }
        c.gridheight = 0;
        c.insets.bottom = 11;
        c.insets.right = 47;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        this.panel.add(bottomThing, c);
        if (editable) {
            this.popupMenu = new JPopupMenu();
            s = MessageLog.getMessageNoID("GUI0105L");
            JMenuItem item = new JMenuItem(s);
            item.setActionCommand(EDIT);
            item.addActionListener(this);
            this.popupMenu.add(item);
        }
    }

    public MultiPicker(short pObjectType, NameList[] pInitiallySelected, Class editorClass, String availableLabelId, String objectLabelId, String newObjectButtonLabelId, String[] selectionListTitleIds) {
        this(pObjectType, pInitiallySelected, editorClass, availableLabelId, objectLabelId, newObjectButtonLabelId, selectionListTitleIds, null, true);
    }

    public Component getComponent() {
        Request request = EditableObjectLabel.makeRequest(this.requestType, this.resourceType, this.qualifier);
        GuiClient.doRequest(this, request);
        return this.panel;
    }

    public JButton getNewButton() {
        return this.newButton;
    }

    public NameList getData(int whichList, MutableInteger count) {
        DefaultListModel listModel = this.selected[whichList].model;
        int i = listModel.getSize();
        if (count != null) {
            count.value = i;
        }
        NameList result = null;
        while (i > 0) {
            NameList element = (NameList)listModel.getElementAt(--i);
            NameList cloan = (NameList)element.clone();
            cloan.nlNext = result;
            result = cloan;
        }
        return result;
    }

    public NameList getData(int whichList) {
        return this.getData(whichList, null);
    }

    private void moveOver(int whichList, NameList element) {
        NameList head = this.available;
        int index = 0;
        boolean going = true;
        while (going && head != null) {
            if (head.nlID3 > 0) {
                if (head.nlID == element.nlID) {
                    going = false;
                } else {
                    ++index;
                }
            }
            if (!going) continue;
            head = head.nlNext;
        }
        if (head != null) {
            this.possiblyRemove(head, index);
            this.selected[whichList].model.addElement(head);
        }
    }

    private void possiblyPopUp(MouseEvent event) {
        Point point;
        if (!event.isPopupTrigger() || this.popupMenu == null) {
            return;
        }
        int x = event.getX();
        int y = event.getY();
        JList list = (JList)event.getSource();
        int i = list.locationToIndex(point = new Point(x, y));
        if (i < 0) {
            return;
        }
        this.rightClicked = (NameList)list.getModel().getElementAt(i);
        this.popupMenu.show(list, x, y);
    }

    private void moveSelectedOver() {
        for (int i = 0; i < this.nLists; ++i) {
            NameList element = this.initiallySelected[i];
            while (element != null) {
                this.moveOver(i, element);
                element = element.nlNext;
            }
        }
    }

    public void replace(NameList[] pInitiallySelected) {
        this.initiallySelected = pInitiallySelected;
        for (int i = 0; i < this.nLists; ++i) {
            this.selected[i].clear();
        }
        this.moveSelectedOver();
    }

    public void setHeading(int which, String newText) {
        this.selected[which].heading.setText(newText);
    }

    public void actionPerformed(ActionEvent event) {
        int ID2;
        String creatorAndName;
        String command = event.getActionCommand();
        if (command == NEW) {
            creatorAndName = null;
            ID2 = 0;
        } else {
            creatorAndName = this.rightClicked.nlName;
            ID2 = this.rightClicked.nlID;
        }
        CreateOrEditDDI ddi = new CreateOrEditDDI();
        ddi.buildEditor(this.editorClass, creatorAndName, ID2, this.objectType);
    }

    public void valueChanged(ListSelectionEvent event) {
        boolean enabled = this.availableList.getSelectedIndex() >= 0;
        for (int i = 0; i < this.selected.length; ++i) {
            this.selected[i].addButton.setEnabled(enabled);
            if (!enabled) continue;
            ListSelectionModel sm = this.selected[i].list.getSelectionModel();
            sm.clearSelection();
        }
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        NameList element = this.available = GuiUtil.sortNameList((NameList)response.responseData);
        while (element != null) {
            this.availableModel.addElement(element);
            element.nlID3 = this.nLists;
            element = element.nlNext;
        }
        this.moveSelectedOver();
        if (this.nextInChain != null) {
            SwingUtilities.invokeLater(this.nextInChain);
            this.nextInChain = null;
        }
    }

    public void mouseEntered(MouseEvent event) {
    }

    public void mouseExited(MouseEvent event) {
    }

    public void mousePressed(MouseEvent event) {
        this.possiblyPopUp(event);
    }

    public void mouseReleased(MouseEvent event) {
        this.possiblyPopUp(event);
    }

    public void mouseClicked(MouseEvent event) {
    }

    public void changeOccurred(int changeType, NameList newElement) {
        if (changeType != 1) {
            return;
        }
        newElement = (NameList)newElement.clone();
        newElement.nlID3 = this.nLists;
        int x = 1;
        NameList prev = null;
        NameList element = this.available;
        while (element != null && (x = newElement.nlName.compareTo(element.nlName)) > 0) {
            prev = element;
            element = element.nlNext;
        }
        if (x == 0) {
            element.nlID = newElement.nlID;
            element.nlID2 = newElement.nlID2;
        } else {
            if (prev == null) {
                this.available = newElement;
            } else {
                prev.nlNext = newElement;
            }
            newElement.nlNext = element;
            this.addToModel(newElement, this.availableModel);
        }
    }

    private class SelectedList
    implements ActionListener,
    ListSelectionListener {
        public JButton addButton = new JButton(">>");
        private JButton delButton;
        public JList list;
        public DefaultListModel model;
        private Container panel;
        public JLabel heading;

        public SelectedList(String titleMsgID) {
            this.addButton.setEnabled(false);
            this.addButton.setActionCommand(MultiPicker.ADD);
            this.addButton.addActionListener(this);
            Font font = this.addButton.getFont().deriveFont(1);
            this.addButton.setFont(font);
            GuiUtil.setAccessible(this.addButton, Util.getString("NAME_ADD"), Util.getString("DESCRIPTION_ADD"));
            this.delButton = new JButton("<<");
            this.delButton.setEnabled(false);
            this.delButton.setActionCommand(MultiPicker.DELETE);
            this.delButton.addActionListener(this);
            this.delButton.setFont(font);
            GuiUtil.setAccessible(this.addButton, Util.getString("NAME_DELETE"), Util.getString("DESCRIPTION_DELETE"));
            JPanel subPanel = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets.bottom = 5;
            c.insets.top = 5;
            c.anchor = 15;
            c.gridwidth = 0;
            c.gridheight = 1;
            subPanel.add((Component)this.addButton, c);
            c.anchor = 11;
            c.gridheight = 0;
            subPanel.add((Component)this.delButton, c);
            this.panel = new JPanel(new GridBagLayout());
            c.insets.top = 0;
            c.insets.bottom = 0;
            c.insets.right = 10;
            c.insets.left = 10;
            c.fill = 3;
            c.anchor = 10;
            c.gridwidth = 1;
            this.panel.add((Component)subPanel, c);
            this.heading = new JLabel(MessageLog.getMessageNoID(titleMsgID));
            this.heading.setFont(font);
            subPanel = new JPanel(new GridBagLayout());
            c.insets.right = 0;
            c.insets.left = 0;
            c.gridwidth = 0;
            c.gridheight = 1;
            c.anchor = 17;
            c.fill = 0;
            c.insets.bottom = 2;
            subPanel.add((Component)this.heading, c);
            this.model = new DefaultListModel();
            this.list = new JList(this.model);
            this.list.setSelectionMode(2);
            this.list.addListSelectionListener(this);
            this.list.addMouseListener(MultiPicker.this);
            GuiUtil.setAccessibleLabel(this.heading, this.list, "", this.heading.getText(), this.heading.getText());
            MultiPicker.this.setIcon(this.list);
            JScrollPane scrollPane = new JScrollPane(this.list);
            c.insets.bottom = 0;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.gridheight = 0;
            c.anchor = 10;
            c.fill = 1;
            subPanel.add((Component)scrollPane, c);
            this.panel.add((Component)subPanel, c);
        }

        public Component getComponent() {
            return this.panel;
        }

        public void clear() {
            int n = this.model.getSize();
            while (n > 0) {
                NameList element = (NameList)this.model.remove(--n);
                MultiPicker.this.add(element);
            }
            this.valueChanged(null);
        }

        public void actionPerformed(ActionEvent event) {
            String command = event.getActionCommand();
            if (command == MultiPicker.ADD) {
                int[] indices = MultiPicker.this.availableList.getSelectedIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    int index = indices[i];
                    NameList element = (NameList)MultiPicker.this.availableModel.get(index);
                    if (!MultiPicker.this.addToModel(element, this.model)) continue;
                    MultiPicker.this.possiblyRemove(element, index);
                }
                MultiPicker.this.valueChanged(null);
            } else {
                int[] indices = this.list.getSelectedIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    int index = indices[i];
                    NameList element = (NameList)this.model.remove(index);
                    MultiPicker.this.add(element);
                }
                this.valueChanged(null);
            }
        }

        public void valueChanged(ListSelectionEvent event) {
            boolean enabled = this.list.getSelectedIndex() >= 0;
            this.delButton.setEnabled(enabled);
            if (enabled) {
                ListSelectionModel sm = MultiPicker.this.availableList.getSelectionModel();
                sm.clearSelection();
            }
        }
    }
}

