/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.gui.GroupSelector;
import org.eclipse.aperi.TStorm.gui.PingAlertEditor;
import org.eclipse.aperi.TStorm.gui.PingOptionsEditor;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.CreateHeaderPanel;
import org.eclipse.aperi.gui.CreateOrEdit;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.JSgcScheduleCreateWhenData;
import org.eclipse.aperi.gui.ObjectChangeListener;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class PingCreateOrEdit
implements CreateOrEdit,
ChangeListener,
GuiRequestor,
ObjectChangeListener {
    private static final int COMPUTERS_TAB = 0;
    private static final int SCHEDULE_TAB = 1;
    private static final int OPTIONS_TAB = 2;
    private static final int ALERT_TAB = 3;
    private CreateOrEditDDI DDI;
    private CreateHeaderPanel createHeaderPanel;
    private JTabbedPane tabs;
    private JSgcScheduleCreateWhenData scheduleEditor;
    private GroupSelector selector;
    private PingAlertEditor alertEditor;
    private PingOptionsEditor optionsEditor;

    public PingCreateOrEdit(CreateOrEditDDI pDDI) {
        this.DDI = pDDI;
        this.DDI.showEnabled = true;
        this.DDI.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        this.DDI.subType = "org.eclipse.aperi.server.handler.gui.GuiProbeHndlr";
    }

    public void build(int ID2) {
        if (ID2 > 0) {
            this.submitRetrieve(ID2);
        } else {
            this.makeNew();
        }
    }

    public void build(CreateHeader createHeader) {
        ProbePing ping = (ProbePing)createHeader;
        this.create(ping);
    }

    public CreateHeader getData() {
        this.scheduleEditor.getData();
        ProbePing ping = (ProbePing)this.createHeaderPanel.getData();
        NameList[] array = this.selector.getData();
        ping.pbComputers = array[0];
        ping.pbComputerGroups = array[1];
        ping.pbClusters = array[2];
        ping.pbAllComputers = this.selector.allMembersSelected;
        ping.pbAlert = this.alertEditor.getData();
        ping.arguments = this.optionsEditor.getData();
        return ping;
    }

    public void validate(CreateHeader newHeader) throws GeneralException {
        ProbePing ping = (ProbePing)newHeader;
        if (ping.isEmpty()) {
            String s = MessageLog.getMessageNoTS("STG4048E", null);
            this.DDI.exceptionTabIndex = 0;
            throw new GeneralException(s);
        }
        this.DDI.exceptionTabIndex = 1;
        this.scheduleEditor.validate(ping);
        this.DDI.exceptionTabIndex = 3;
        this.alertEditor.validateData();
    }

    private void submitRetrieve(int ID2) {
        ProbePing ping = new ProbePing(17);
        ping.ID = ID2;
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiProbeHndlr", ping);
        request.flags = (byte)4;
        GuiClient.doRequest(this, request);
    }

    private void makeNew() {
        ProbePing ping = new ProbePing(17);
        this.create(ping);
        this.DDI.oldCreateHeader = (CreateHeader)ping.clone();
        ((ProbePing)this.DDI.oldCreateHeader).pbAlert = this.alertEditor.getData();
    }

    private void create(ProbePing ping) {
        this.createHeaderPanel = new CreateHeaderPanel(ping, this, this.DDI);
        this.scheduleEditor = new JSgcScheduleCreateWhenData(17, this.DDI);
        JPanel whenPanel = this.scheduleEditor.build(ping);
        this.selector = new GroupSelector(1, ping.pbComputers, ping.pbComputerGroups, ping.pbClusters, ping.pbAllComputers, true, true);
        this.optionsEditor = new PingOptionsEditor(ping.arguments);
        this.alertEditor = ping.pbAlert == null ? new PingAlertEditor() : new PingAlertEditor(ping.pbAlert);
        this.tabs = new JTabbedPane();
        this.tabs.setFont(BaseTree.boldFont);
        String s = MessageLog.getMessageNoID("STG4041L");
        this.tabs.addTab(s, this.selector.getComponent());
        s = MessageLog.getMessageNoID("GUI8222L");
        this.tabs.addTab(s, whenPanel);
        s = MessageLog.getMessageNoID("STG4069L");
        this.tabs.addTab(s, this.optionsEditor.getComponent());
        s = MessageLog.getMessageNoID("STG4036L");
        this.tabs.addTab(s, this.alertEditor.getComponent());
        this.tabs.setSelectedIndex(this.DDI.tabIndex);
        this.tabs.addChangeListener(this);
        this.createHeaderPanel.add((Component)this.tabs, "Center");
        this.DDI.panel = this.createHeaderPanel;
        this.DDI.show();
        this.createHeaderPanel.gettingFocus();
        this.DDI.addObjectChangeListener(this, (short)0);
    }

    public void replace(CreateHeader newHeader) {
        ProbePing ping = (ProbePing)newHeader;
        this.createHeaderPanel.replace(ping);
        this.scheduleEditor.replace(ping);
        this.selector.replace(ping.pbComputers, ping.pbComputerGroups, ping.pbClusters, ping.pbAllComputers);
    }

    public void losingFocus() {
        this.createHeaderPanel.losingFocus();
    }

    public void gettingFocus() {
        this.createHeaderPanel.gettingFocus();
    }

    public void showTab(int tabIndex) {
        this.tabs.setSelectedIndex(tabIndex);
    }

    public CreateHeaderPanel getHeaderPanel() {
        return this.createHeaderPanel;
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        ProbePing ping = (ProbePing)response.responseData;
        this.DDI.oldCreateHeader = (CreateHeader)ping.clone();
        this.create(ping);
    }

    public void stateChanged(ChangeEvent event) {
        this.DDI.tabIndex = this.tabs.getSelectedIndex();
    }

    public void changeOccurred(int changeType, NameList name) {
        if (changeType == 100) {
            this.selector.invalidateGroups(name.nlInfo);
        } else if (changeType == 1) {
            this.selector.addGroup(name);
        }
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return "mopi5";
            }
            case 1: {
                return "mopi10";
            }
            case 2: {
                return "mopi15";
            }
            case 3: {
                return "mopi20";
            }
        }
        return null;
    }
}

