/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class PingOptionsEditor
extends JPanel {
    private static final int VALUE_OPTION = 0;
    private static final int UNITS_OPTION = 1;
    private JPanel optionsPanel;
    private int value;
    private int units;
    private JComboBox intervalValue;
    private JComboBox intervalUnits;
    private static final String[] valueChoices = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99"};
    private String[] unitChoices = new String[]{MessageLog.getMessageNoID("STG4070L"), MessageLog.getMessageNoID("GUI5034L"), MessageLog.getMessageNoID("GUI5035L"), MessageLog.getMessageNoID("GUI5036L")};

    public PingOptionsEditor(String options) {
        String[] optionArray = this.parseOptions(options);
        this.value = Util.isEmpty(optionArray[0]) ? 0 : Integer.parseInt(optionArray[0]);
        this.units = Util.isEmpty(optionArray[1]) ? 2 : Integer.parseInt(optionArray[1]);
    }

    private String[] parseOptions(String options) {
        String[] parms = new String[8];
        if (!Util.isEmpty(options)) {
            int p = 0;
            int i = -1;
            while (i < options.length()) {
                int j;
                if ((j = options.indexOf(32, ++i)) == -1) {
                    j = options.length();
                }
                parms[p++] = options.substring(i, j);
                i = j;
            }
        }
        return parms;
    }

    public Component getComponent() {
        if (this.optionsPanel != null) {
            return this.optionsPanel;
        }
        this.intervalValue = new TComboBox(valueChoices);
        this.intervalValue.setSelectedIndex(this.value);
        this.intervalUnits = new TComboBox(this.unitChoices);
        this.intervalUnits.setSelectedIndex(this.units);
        String labelText = MessageLog.getMessageNoID("STG4068L");
        JLabel label = new JLabel(labelText);
        GuiUtil.setAccessibleLabel(label, this.intervalUnits, "MNEMONIC_INTERVALUNITS", labelText, "DESCRIPTION_INTERVALUNITS");
        GuiUtil.setAccessibleDescription(this.intervalValue, "DESCRIPTION_INTERVALVALUEUNITS");
        JPanel panel = GuiUtil.getBorderedPanel();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(4, 0, 4, 16);
        constraints.anchor = 17;
        constraints.gridwidth = 0;
        panel.add((Component)label, constraints);
        constraints.gridwidth = 1;
        panel.add((Component)this.intervalValue, constraints);
        constraints.gridwidth = 0;
        panel.add((Component)this.intervalUnits, constraints);
        GuiUtil.completePanel(panel);
        this.setPanelSize(panel);
        this.setLayout(new BoxLayout(this, 1));
        this.add(panel);
        this.optionsPanel = this;
        return this;
    }

    private void setPanelSize(JPanel panel) {
        int maxWidth = (int)panel.getMaximumSize().getWidth();
        int minHeight = (int)panel.getMinimumSize().getHeight();
        panel.setMaximumSize(new Dimension(maxWidth, minHeight));
    }

    public String getData() {
        StringBuffer buffer = new StringBuffer(16);
        this.value = this.intervalValue.getSelectedIndex();
        buffer.append(this.value);
        buffer.append(' ');
        this.units = this.intervalUnits.getSelectedIndex();
        buffer.append(this.units);
        return buffer.toString();
    }
}

