/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.gui.DiskReportingTreeLabel;
import org.eclipse.aperi.TStorm.gui.ReportingTreeLabel;
import org.eclipse.aperi.TStorm.gui.ReportingTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportSelector {
    private GuiReportReq grr;
    private JTree sourceTree;
    private JTree selectedTree;
    private NameList rootName;
    private TreeSelector selector;
    private TreeSelectorNode selectedNode;
    private short reportType;
    static final String systemWideTitle = MessageLog.getMessageNoID("STG1002L");

    public ReportSelector(GuiReportReq grr, short reportType) {
        this.grr = grr;
        this.reportType = reportType;
    }

    public JPanel build() {
        if (this.selector == null) {
            this.buildSourceTree();
            this.buildSelectedTree();
            this.selector = new ReportTreeSelector(this.sourceTree, this.selectedTree);
            this.selector.disableMultipleSelection();
        }
        return this.selector;
    }

    public boolean getData() {
        boolean hasSelection = false;
        NameList element = this.selector.getNameList();
        if (element == null) {
            this.grr.reportType = 0;
            this.grr.reportSubtype = 0;
        } else {
            this.grr.reportType = element.nlID;
            this.grr.reportSubtype = element.nlID2;
            if (element instanceof AlertNameList) {
                AlertNameList castElement = (AlertNameList)element;
                this.grr.dbmsType = castElement.nlSubProductID;
            } else {
                this.grr.dbmsType = (byte)-1;
            }
            if (element.nlID3 != -1 && element.nlID3 != -2) {
                hasSelection = true;
            }
        }
        return hasSelection;
    }

    private void buildSourceTree() {
        TreeSelectorNode root = this.newRoot();
        ReportingTreeLabel tree = new ReportingTreeLabel(false);
        TreeExpansionEvent event = new TreeExpansionEvent(this, new TreePath(tree));
        tree.expand(event);
        this.copyChildren(root, tree);
        DiskReportingTreeLabel ktree = new DiskReportingTreeLabel(false);
        event = new TreeExpansionEvent(this, new TreePath(ktree));
        ktree.expand(event);
        this.copyChildren(root, ktree);
        this.sourceTree = new JTree(root, true);
        this.sourceTree.getSelectionModel().setSelectionMode(1);
    }

    private void copyChildren(TreeSelectorNode toNode, BaseTreeNode fromNode) {
        Enumeration<TreeNode> buzzer = fromNode.children();
        while (buzzer.hasMoreElements()) {
            TreeSelectorNode newNode;
            BaseTreeNode childNode = (BaseTreeNode)buzzer.nextElement();
            AlertNameList name = new AlertNameList();
            name.nlName = childNode.toString();
            if (name.nlName.equals(systemWideTitle)) {
                name.nlName = MessageLog.getMessageNoID("STG1029L");
            }
            if (childNode.getAllowsChildren()) {
                newNode = new TreeSelectorNode((NameList)name, false, false, true);
                newNode.setButtonFlag(false);
            } else {
                newNode = new TreeSelectorNode((NameList)name, true, false, false);
            }
            if (childNode instanceof ReportingTreeNode && !childNode.getAllowsChildren()) {
                ReportingTreeNode rptNode = (ReportingTreeNode)childNode;
                name.nlID = rptNode.reportType;
                name.nlID2 = rptNode.reportSubtype;
                name.nlID3 = rptNode.selectionServices;
                name.nlSubProductID = rptNode.dbmsType;
            }
            newNode.setSortKey(childNode.batchSortNumber);
            toNode.add(newNode);
            if (this.grr.reportType == name.nlID && this.grr.reportSubtype == name.nlID2 && this.grr.dbmsType == name.nlSubProductID) {
                this.selectedNode = newNode;
            }
            this.copyChildren(newNode, childNode);
        }
    }

    private void buildSelectedTree() {
        NameList name = new NameList();
        name.nlName = "";
        TreeSelectorNode root = new TreeSelectorNode(name, false, true, "STG4041L");
        if (this.grr.reportType > 0) {
            TreeNode[] path = this.selectedNode.getPath();
            TreeSelectorNode parent = root;
            for (int i = 1; i < path.length - 1; ++i) {
                TreeSelectorNode oldNode = (TreeSelectorNode)path[i];
                name = new NameList();
                name.nlName = ((NameList)oldNode.getUserObject()).nlName;
                TreeSelectorNode newNode = new TreeSelectorNode(name, false, false, true);
                newNode.setSortKey(oldNode.hiOrderSortKey);
                parent.add(newNode);
                parent = newNode;
            }
            parent.add(this.selectedNode);
        }
        this.selectedTree = new JTree(root, true);
        this.selectedTree.getSelectionModel().setSelectionMode(1);
    }

    public void replace() {
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = new NameList();
            this.rootName.nlName = "";
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    public void removeSelection() {
        this.selector.removeSelection();
    }

    static class ReportTreeSelector
    extends TreeSelector
    implements GuiRequestor {
        short devType;

        public ReportTreeSelector(JTree sourceTree, JTree selectedTree) {
            super(sourceTree, selectedTree);
        }

        public void handleResponse(short status, Response response) {
            if (status > 4) {
                super.removeSelection();
            }
        }

        public int getSelectedReportType() {
            boolean hasSelection = false;
            NameList element = this.getNameList();
            int reportType = 0;
            if (element != null) {
                reportType = element.nlID;
            }
            return reportType;
        }
    }
}

