/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.gui.ReportColumnSelector;
import org.eclipse.aperi.TStorm.gui.ReportPrefsManager;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionTableDialog;
import org.eclipse.aperi.TStorm.gui.rptfilter.ReportFilterDialog;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.ReportPrefs;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.gui.DateSelector;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportingSelectionDriver
extends JPanel
implements ActionListener,
ItemListener {
    private static final char GENERATE = 'G';
    private static final char USE_TIME_RANGE = 'T';
    private static final char SELECTION = 'S';
    private static final char FILTER = 'F';
    private ReportingSelectionTableDialog rowSelector;
    private ReportColumnSelector columnSelector;
    private ReportDataAdjuster adjuster;
    ReportingDDI ddi;
    GuiReportReq grr;
    int selectionServices;
    JButton generateButton;
    JButton selectionButton;
    JButton filterButton;
    JTextField numberRows;
    JCheckBox useTimeRange;
    JComboBox diskArrayChoices;
    DateSelector startDate;
    DateSelector endDate;
    String beforeText;
    String afterText;
    String report;
    Object[] userName = new Object[]{MessageLog.getMessageNoID("STG2019L")};
    Object[] objectName;
    Object[] errorName;
    int userType;
    boolean usersFirst;
    boolean usersLast;
    boolean usingTimes;
    private static final IntToString[] diskArrayCompViews = new IntToString[]{new IntToString(74, "STG4197L"), new IntToString(75, "STG4198L"), new IntToString(76, "STG1004L")};
    private static final IntToString[] diskArrayDiskViews = new IntToString[]{new IntToString(12, "STG1017L"), new IntToString(73, "STG4199L")};
    private static final int TOP_MARGIN = 4;
    private static final int LEFT_MARGIN = 6;

    public ReportingSelectionDriver(ReportingDDI ddi, GuiReportReq grr, int selectionServices, Object[] objectName) {
        String helpID;
        this.ddi = ddi;
        this.grr = grr;
        this.selectionServices = selectionServices;
        this.objectName = objectName;
        this.columnSelector = null;
        this.rowSelector = null;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPanel(), "North");
        if (this.adjuster instanceof CustomReportDataAdjuster) {
            CustomReportDataAdjuster customAdjuster = this.makeCustomAdjuster();
            this.columnSelector = ReportColumnSelector.createInstance(grr, customAdjuster);
            this.add(this.columnSelector.getPanel(), "Center");
            this.add(Box.createVerticalStrut(10), "South");
        }
        if ((helpID = this.adjuster.getHelpID()) != null && this.ddi != null) {
            this.ddi.helpID = helpID;
        }
    }

    private JPanel getPanel() {
        GridBagConstraints gbcIndent = new GridBagConstraints();
        GridBagConstraints gbcPlop = new GridBagConstraints();
        GridBagConstraints gbcLast = new GridBagConstraints();
        Insets insetB = new Insets(0, 0, 0, 4);
        Insets insetC = new Insets(0, 0, 0, 0);
        Insets insetD = new Insets(0, 0, 0, 4);
        gbcIndent.anchor = 17;
        gbcIndent.insets = insetD;
        gbcPlop.anchor = 17;
        gbcPlop.insets = insetB;
        gbcLast.gridwidth = 0;
        gbcLast.insets = insetC;
        JPanel panel = new JPanel();
        panel.setBorder(GuiUtil.getBorder(MessageLog.getMessageNoID("STG5009L")));
        panel.setLayout(new BorderLayout());
        this.adjuster = this.makeAdjuster();
        if (this.adjuster == null) {
            return null;
        }
        JPanel generatePanel = GuiUtil.getPanel();
        this.generateButton = new JButton(MessageLog.getMessageNoID("STG5053L"));
        GuiUtil.setAccessible(this.generateButton, this.generateButton.getText(), this.generateButton.getText());
        GridBagConstraints c = new GridBagConstraints();
        c.insets.bottom = 6;
        c.gridheight = 0;
        c.anchor = 17;
        c.weightx = 1.0;
        generatePanel.add((Component)this.generateButton, c);
        String s = MessageLog.getMessageNoID("STG3263L");
        this.selectionButton = new JButton(s);
        this.rowSelector = new ReportingSelectionTableDialog(this, this.grr, this.objectName);
        this.selectionButton.setEnabled(this.rowSelector.mainPanel != null);
        c.weightx = 0.0;
        if (this.adjuster instanceof CustomReportDataAdjuster) {
            c.insets.right = 3;
            generatePanel.add((Component)this.selectionButton, c);
            s = MessageLog.getMessageNoID("STG3264L");
            this.filterButton = new JButton(s);
            c.insets.right = 10;
            c.gridwidth = 0;
            generatePanel.add((Component)this.filterButton, c);
            if (this.selectionServices == 4) {
                this.selectionButton.setEnabled(false);
            }
            this.setFilterButtonIcon();
        } else {
            c.insets.right = 10;
            c.gridwidth = 0;
            generatePanel.add((Component)this.selectionButton, c);
        }
        if (this.ddi == null) {
            this.generateButton.setEnabled(false);
        }
        this.setSelectionButtonIcon();
        panel.add((Component)generatePanel, "North");
        if (this.selectionServices == 2) {
            JPanel timePanel = GuiUtil.getPanel();
            s = MessageLog.getMessageNoID("STG4081L");
            this.useTimeRange = new JCheckBox(s);
            GuiUtil.setAccessible(this.useTimeRange, s, s);
            long millis = System.currentTimeMillis();
            this.startDate = new DateSelector(millis);
            this.endDate = new DateSelector(millis);
            if (this.grr.startTime > 0L) {
                this.startDate.setDate(this.grr.startTime);
                this.endDate.setDate(this.grr.endTime);
                this.usingTimes = true;
            }
            this.useTimeRange.setSelected(this.usingTimes);
            this.startDate.setEnabled(this.usingTimes);
            this.endDate.setEnabled(this.usingTimes);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(4, 6, 0, 0);
            gbc.gridwidth = 0;
            gbc.anchor = 17;
            timePanel.add((Component)this.useTimeRange, gbc);
            JLabel l = new JLabel(MessageLog.getMessageNoID("STG4082L"));
            gbc.gridwidth = 1;
            timePanel.add((Component)l, gbc);
            gbc.gridwidth = 0;
            timePanel.add((Component)this.startDate, gbc);
            l = new JLabel(MessageLog.getMessageNoID("STG4083L"));
            gbc.gridwidth = 1;
            timePanel.add((Component)l, gbc);
            gbc.gridwidth = 0;
            timePanel.add((Component)this.endDate, gbc);
            GuiUtil.completePanel(timePanel);
            panel.add((Component)timePanel, "Center");
        }
        if (this.selectionServices == 3) {
            panel.add((Component)this.getDiskArrayChoices(), "Center");
        } else if (this.selectionServices < 1 && this.selectionServices != 4) {
            JPanel rowsPanel = GuiUtil.getPanel();
            this.beforeText = MessageLog.getMessageNoID("STG5055L");
            switch (this.grr.reportSubtype) {
                case 8: {
                    this.afterText = "STG4142L";
                    break;
                }
                case 9: {
                    this.afterText = "STG4143L";
                    break;
                }
                case 10: {
                    this.afterText = "STG4137L";
                    break;
                }
                case 11: {
                    this.afterText = "STG4138L";
                    break;
                }
                case 12: {
                    this.afterText = "STG4139L";
                    break;
                }
                case 13: {
                    this.afterText = "STG4140L";
                    break;
                }
                case 14: {
                    this.afterText = "STG4141L";
                    break;
                }
                case 6: {
                    this.afterText = "STG4144L";
                    break;
                }
                case 82: {
                    this.afterText = "STG4244L";
                    break;
                }
                default: {
                    this.afterText = "STG5056L";
                }
            }
            this.afterText = " " + MessageLog.getMessageNoID(this.afterText);
            JLabel beforeLabel = new JLabel(this.beforeText);
            this.numberRows = new JTextField(5);
            JLabel afterLabel = new JLabel(this.afterText);
            JLabel filler2 = new JLabel(" ");
            GuiUtil.setAccessibleLabel(beforeLabel, this.numberRows, "MNEMONIC_BEFORELABEL", "NAME_BEFORELABEL", "DESCRIPTION_BEFORELABEL");
            SizeLimitedDocument doc5 = new SizeLimitedDocument(5, true);
            this.numberRows.setDocument(doc5);
            if (this.grr.profile == 0) {
                ReportPrefs prefs = ReportPrefsManager.getOne(this.grr.reportType);
                switch (this.grr.reportSubtype) {
                    case 8: {
                        this.grr.rowsToReturn = prefs.rpDirMaxRows;
                        break;
                    }
                    case 9: {
                        this.grr.rowsToReturn = prefs.rpDirGrpMaxRows;
                        break;
                    }
                    case 10: {
                        this.grr.rowsToReturn = prefs.rpFSMaxRows;
                        break;
                    }
                    case 11: {
                        this.grr.rowsToReturn = prefs.rpFSGrpMaxRows;
                        break;
                    }
                    case 12: {
                        this.grr.rowsToReturn = prefs.rpComputerMaxRows;
                        break;
                    }
                    case 13: {
                        this.grr.rowsToReturn = prefs.rpCompGrpMaxRows;
                        break;
                    }
                    case 14: {
                        this.grr.rowsToReturn = prefs.rpDomMaxRows;
                        break;
                    }
                    case 15: {
                        this.grr.rowsToReturn = prefs.rpNetMaxRows;
                        break;
                    }
                    case 16: {
                        this.grr.rowsToReturn = prefs.rpQuotaMaxRows;
                    }
                }
            }
            if (this.grr.rowsToReturn != 0 && this.grr.rowsToReturn != Integer.MAX_VALUE) {
                this.numberRows.setText(Integer.toString(this.grr.rowsToReturn));
            }
            rowsPanel.add((Component)beforeLabel, gbcIndent);
            rowsPanel.add((Component)this.numberRows, gbcPlop);
            rowsPanel.add((Component)afterLabel, gbcPlop);
            rowsPanel.add((Component)filler2, gbcLast);
            GuiUtil.completePanel(rowsPanel);
            panel.add((Component)rowsPanel, "South");
        }
        this.addListeners();
        return panel;
    }

    private JComponent getDiskArrayChoices() {
        IntToString[] reportSubtypeToMsgID;
        JPanel diskPanel = GuiUtil.getPanel();
        this.diskArrayChoices = new TComboBox();
        if (this.grr.reportSubtype == 12 || this.grr.reportSubtype == 73) {
            this.setComboBox(this.diskArrayChoices, diskArrayCompViews, 75);
            reportSubtypeToMsgID = diskArrayDiskViews;
        } else {
            this.setComboBox(this.diskArrayChoices, diskArrayDiskViews, 12);
            reportSubtypeToMsgID = diskArrayCompViews;
        }
        this.grr.bySubtype = ((IntToString)this.diskArrayChoices.getSelectedItem()).value;
        String byObject = null;
        for (int i = 0; i < reportSubtypeToMsgID.length; ++i) {
            IntToString element = reportSubtypeToMsgID[i];
            if (element.value != this.grr.reportSubtype) continue;
            byObject = MessageLog.getMessageNoID(element.toString());
            break;
        }
        JLabel l = new JLabel(MessageLog.getMessageNoID("STG4200L", byObject));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 6, 0, 0);
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        diskPanel.add((Component)l, gbc);
        diskPanel.add((Component)this.diskArrayChoices, gbc);
        this.diskArrayChoices.addItemListener(this);
        GuiUtil.completePanel(diskPanel);
        return diskPanel;
    }

    private void setComboBox(JComboBox comboBox, IntToString[] valueList, int defaultValue) {
        int i;
        valueList = (IntToString[])valueList.clone();
        for (i = 0; i < valueList.length; ++i) {
            valueList[i] = (IntToString)valueList[i].clone();
        }
        IntToString.resolveNames(valueList);
        if (this.grr.bySubtype <= 0) {
            this.grr.bySubtype = defaultValue;
        }
        comboBox.removeAllItems();
        for (i = 0; i < valueList.length; ++i) {
            comboBox.addItem(valueList[i]);
            if (valueList[i].value != this.grr.bySubtype) continue;
            comboBox.setSelectedIndex(i);
        }
    }

    private void addListeners() {
        this.addButtonListener(this.generateButton, 'G');
        this.addButtonListener(this.useTimeRange, 'T');
        this.addButtonListener(this.selectionButton, 'S');
        this.addButtonListener(this.filterButton, 'F');
    }

    private void addButtonListener(AbstractButton button, char action) {
        if (button != null) {
            button.setActionCommand(ReportingSelectionDriver.charToString(action));
            button.addActionListener(this);
        }
    }

    public void getData() throws GeneralException {
        String value;
        if (this.columnSelector != null) {
            this.columnSelector.setSelectedColumns();
        }
        this.grr.rowsToReturn = Integer.MAX_VALUE;
        if (this.numberRows != null && (value = this.numberRows.getText()).length() > 0) {
            this.grr.rowsToReturn = Integer.parseInt(value);
        }
        if (this.useTimeRange != null) {
            if (this.useTimeRange.isSelected()) {
                this.grr.startTime = this.startDate.getStartOfDay();
                this.grr.endTime = this.endDate.getEndOfDay();
                if (this.grr.startTime >= this.grr.endTime) {
                    String s = MessageLog.getMessageNoTS("STG4084E", null);
                    throw new GeneralException(s);
                }
            } else {
                this.grr.startTime = 0L;
                this.grr.endTime = 0L;
            }
        }
    }

    public void setPrefs() {
        try {
            this.getData();
        }
        catch (GeneralException ignored) {
            // empty catch block
        }
        ReportPrefs prefs = ReportPrefsManager.getOne(this.grr.reportType);
        prefs.rpProfileID = this.grr.profile;
        switch (this.grr.reportSubtype) {
            case 8: {
                prefs.rpDirMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 9: {
                prefs.rpDirGrpMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 10: {
                prefs.rpFSMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 11: {
                prefs.rpFSGrpMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 12: {
                prefs.rpComputerMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 13: {
                prefs.rpCompGrpMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 14: {
                prefs.rpDomMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 15: {
                prefs.rpNetMaxRows = this.grr.rowsToReturn;
                break;
            }
            case 16: {
                prefs.rpQuotaMaxRows = this.grr.rowsToReturn;
            }
        }
        ReportPrefsManager.cacheOne(prefs);
    }

    public void actionPerformed(ActionEvent event) {
        char action = event.getActionCommand().charAt(0);
        switch (action) {
            case 'G': {
                try {
                    this.getData();
                }
                catch (GeneralException e) {
                    GuiUtil.displayException(e);
                    return;
                }
                this.ddi.addFirstReport(this.grr);
                break;
            }
            case 'T': {
                boolean state = this.useTimeRange.isSelected();
                this.startDate.setEnabled(state);
                this.endDate.setEnabled(state);
                break;
            }
            case 'S': {
                this.rowSelector.show();
                break;
            }
            case 'F': {
                CustomReportDataAdjuster localAdjuster = this.makeCustomAdjuster();
                ReportFilterDialog dialog = new ReportFilterDialog(this.grr, localAdjuster);
                dialog.show();
                this.setFilterButtonIcon();
            }
        }
    }

    public void itemStateChanged(ItemEvent event) {
        IntToString choice = (IntToString)this.diskArrayChoices.getSelectedItem();
        if (this.grr.bySubtype == choice.value) {
            return;
        }
        this.grr.bySubtype = choice.value;
        this.grr.columnFilters = null;
        this.grr.selectedColumns = null;
        CustomReportDataAdjuster customAdjuster = this.makeCustomAdjuster();
        this.columnSelector.refresh(customAdjuster);
        this.setFilterButtonIcon();
    }

    private ReportDataAdjuster makeAdjuster() {
        ReportDataAdjuster result = null;
        try {
            result = ReportDataAdjuster.makeAdjuster(this.grr);
        }
        catch (GeneralException e) {
            String s = e.getMessage().substring(15);
            GuiUtil.displayErrorMessage(s);
        }
        return result;
    }

    private CustomReportDataAdjuster makeCustomAdjuster() {
        CustomReportDataAdjuster result = null;
        try {
            result = ReportDataAdjuster.makeCustomAdjuster(this.grr);
        }
        catch (GeneralException e) {
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    public void disableRowSelectionTableButton() {
        this.selectionButton.setEnabled(false);
    }

    void setSelectionButtonIcon() {
        if (this.selectionButton != null && this.selectionButton.isEnabled()) {
            if (this.rowSelector == null) {
                return;
            }
            ImageIcon buttonIcon = null;
            if (this.rowSelector.selectionChanged()) {
                buttonIcon = IconFactory.getStateUreachableIcon();
            }
            this.selectionButton.setIcon(buttonIcon);
            this.selectionButton.repaint();
        }
    }

    private void setFilterButtonIcon() {
        if (this.filterButton != null) {
            ImageIcon buttonIcon = null;
            if (this.grr.columnFilters != null) {
                buttonIcon = IconFactory.getStateUreachableIcon();
            }
            this.filterButton.setIcon(buttonIcon);
            this.filterButton.repaint();
        }
    }

    public static String charToString(char c) {
        char[] array = new char[]{c};
        return new String(array);
    }
}

