/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.gui.ResourceSettingsEditor;
import org.eclipse.aperi.TStorm.gui.SettingsDDI;
import org.eclipse.aperi.TStorm.gui.SettingsEditor;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public class ResourceHistorySettingsEditor
extends ResourceSettingsEditor
implements SettingsEditor,
ActionListener {
    private static final int DAYS = 0;
    private static final int WEEKS = 1;
    private static final int MONTHS = 2;
    private static final int FIELDS_PER_GROUP = 3;
    private static final int FILESYSTEM = 0;
    private static final int PING = 1;
    private static final int UPTIME = 2;
    private static final int DISK = 3;
    private static final int N_GROUPS = 4;
    private static final int TOTAL_FIELDS = 12;
    private static final String[] groupLabels = new String[]{"STG1006L", "STG3147L", "STG2002L", "STG1004L"};
    private static final String[] dailyLabels = new String[]{"STG3243L", "STG3244L", "STG3244L", "STG3243L"};
    private static final char NO_HISTORY = 'N';
    private static final char DEFAULTS = 'D';
    private JComponent panel;
    private static final String[] moreTrailingIDs = new String[]{"STG3091L", "STG3092L", "STG3093L"};

    public ResourceHistorySettingsEditor(SettingsDDI pDDI) {
        this.ddi = pDDI;
    }

    protected void fillSettingsFromValues(Settings settings) {
        int index = 0;
        settings.seFSDailyHist = this.values[index++];
        settings.seFSWeeklyHist = this.values[index++];
        settings.seFSMonthlyHist = this.values[index++];
        settings.sePingDailyHist = this.values[index++];
        settings.sePingWeeklyHist = this.values[index++];
        settings.sePingMonthlyHist = this.values[index++];
        settings.seCompDailyHist = this.values[index++];
        settings.seCompWeeklyHist = this.values[index++];
        settings.seCompMonthlyHist = this.values[index++];
        settings.seDiskDailyHist = this.values[index++];
        settings.seDiskWeeklyHist = this.values[index++];
        settings.seDiskMonthlyHist = this.values[index++];
    }

    protected void fillValuesFromSettings(Settings settings) {
        int index = 0;
        this.values[index++] = settings.seFSDailyHist;
        this.values[index++] = settings.seFSWeeklyHist;
        this.values[index++] = settings.seFSMonthlyHist;
        this.values[index++] = settings.sePingDailyHist;
        this.values[index++] = settings.sePingWeeklyHist;
        this.values[index++] = settings.sePingMonthlyHist;
        this.values[index++] = settings.seCompDailyHist;
        this.values[index++] = settings.seCompWeeklyHist;
        this.values[index++] = settings.seCompMonthlyHist;
        this.values[index++] = settings.seDiskDailyHist;
        this.values[index++] = settings.seDiskWeeklyHist;
        this.values[index++] = settings.seDiskMonthlyHist;
    }

    private JLabel restOfLine(int base, int which, GridBagConstraints c, int group) {
        int index = base + which;
        String s = MessageLog.getMessageNoID(moreTrailingIDs[which]);
        JLabel label = new JLabel(s);
        label.setForeground(Color.black);
        label.setEnabled(false);
        this.leadingLabels[index] = label;
        c.insets.left = 3;
        this.panel.add((Component)label, c);
        TTextField field = TTextField.newTTextField(null, 3, 5, true);
        String labelText = label.getText();
        if (labelText != null) {
            if (labelText.equalsIgnoreCase("Number of days to keep:")) {
                GuiUtil.setAccessible(field, MessageLog.getMessageNoID("STG3091L"), MessageLog.getMessageNoID("STG3091L"));
            } else if (labelText.equalsIgnoreCase("Number of weeks to keep:")) {
                GuiUtil.setAccessible(field, MessageLog.getMessageNoID("STG3092L"), MessageLog.getMessageNoID("STG3091L"));
            } else if (labelText.equalsIgnoreCase("Number of months to keep:")) {
                GuiUtil.setAccessible(field, MessageLog.getMessageNoID("STG3093L"), MessageLog.getMessageNoID("STG3091L"));
            }
        }
        field.setEnabled(false);
        this.fields[index] = field;
        this.panel.add((Component)field, c);
        label = new JLabel("");
        c.gridwidth = 0;
        return label;
    }

    private Container makeGroup(int which) {
        this.panel = new JPanel(new GridBagLayout());
        this.panel.setBorder(GuiUtil.getBorder());
        String s = Util.getString(groupLabels[which]);
        JLabel label = new JLabel(s);
        label.setFont(BaseTree.boldFont);
        GridBagConstraints c = new GridBagConstraints();
        c.insets.top = 4;
        c.insets.left = 6;
        c.anchor = 17;
        c.gridwidth = 0;
        this.panel.add((Component)label, c);
        s = Util.getString(dailyLabels[which]);
        JCheckBox checkBox = new JCheckBox(s);
        GuiUtil.setAccessible(checkBox, s, s);
        int base = 0;
        base = which * 3;
        this.checkBoxes[base + 0] = checkBox;
        c.insets.bottom = 0;
        c.insets.left = 23;
        c.gridwidth = 1;
        this.panel.add((Component)checkBox, c);
        label = this.restOfLine(base, 0, c, which);
        this.panel.add((Component)label, c);
        s = MessageLog.getMessageNoID("STG3088L");
        checkBox = new JCheckBox(s);
        GuiUtil.setAccessible(checkBox, s, s);
        this.checkBoxes[base + 1] = checkBox;
        c.insets.top = 0;
        c.insets.left = 23;
        c.gridwidth = 1;
        this.panel.add((Component)checkBox, c);
        label = this.restOfLine(base, 1, c, which);
        this.panel.add((Component)label, c);
        s = MessageLog.getMessageNoID("STG3089L");
        checkBox = new JCheckBox(s);
        GuiUtil.setAccessible(checkBox, s, s);
        this.checkBoxes[base + 2] = checkBox;
        c.insets.left = 23;
        c.gridheight = 0;
        c.insets.bottom = 4;
        c.gridwidth = 1;
        this.panel.add((Component)checkBox, c);
        label = this.restOfLine(base, 2, c, which);
        c.weightx = 1.0;
        this.panel.add((Component)label, c);
        return this.panel;
    }

    public JComponent getComponent(Settings settings) {
        this.checkBoxes = new JCheckBox[12];
        this.fields = new JTextField[12];
        this.leadingLabels = new JLabel[12];
        String title = MessageLog.getMessageNoID("STG3245T");
        JLabel label = new JLabel(title);
        label.setFont(BaseTree.boldFont);
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 16;
        c.insets.left = 4;
        c.insets.top = 4;
        c.weightx = 0.5;
        panel.add((Component)label, c);
        String s = MessageLog.getMessageNoID("STG3246L");
        JButton noHistoryButton = new JButton(s);
        GuiUtil.setAccessible(noHistoryButton, noHistoryButton.getText(), noHistoryButton.getText());
        Container subPanel = new JPanel(new BorderLayout());
        subPanel.add((Component)noHistoryButton, "West");
        subPanel.add(Box.createHorizontalStrut(10), "Center");
        s = MessageLog.getMessageNoID("STG3247L");
        JButton defaultsButton = new JButton(s);
        GuiUtil.setAccessible(defaultsButton, defaultsButton.getText(), defaultsButton.getText());
        subPanel.add((Component)defaultsButton, "East");
        c.anchor = 12;
        c.insets.right = 4;
        c.gridwidth = 0;
        panel.add((Component)subPanel, c);
        c.anchor = 11;
        c.fill = 2;
        c.insets.left = 4;
        c.insets.top = 4;
        c.weightx = 0.0;
        subPanel = this.makeGroup(0);
        c.insets.right = 0;
        c.gridwidth = 1;
        panel.add((Component)subPanel, c);
        subPanel = this.makeGroup(3);
        c.insets.right = 4;
        c.gridwidth = 0;
        panel.add((Component)subPanel, c);
        subPanel = this.makeGroup(1);
        c.insets.right = 0;
        c.gridwidth = 1;
        panel.add((Component)subPanel, c);
        subPanel = this.makeGroup(2);
        c.insets.right = 4;
        c.gridwidth = 0;
        panel.add((Component)subPanel, c);
        c.weighty = 1.0;
        panel.add(Box.createVerticalStrut(1), c);
        this.panel = null;
        this.values = new short[12];
        for (int i = 0; i < this.checkBoxes.length; ++i) {
            this.checkBoxes[i].addChangeListener(this);
        }
        this.pushSettingsOntoPanel(settings);
        char[] charArray = new char[]{'N'};
        s = new String(charArray);
        noHistoryButton.setActionCommand(s);
        noHistoryButton.addActionListener(this);
        charArray[0] = 68;
        s = new String(charArray);
        defaultsButton.setActionCommand(s);
        defaultsButton.addActionListener(this);
        return panel;
    }

    public void actionPerformed(ActionEvent event) {
        char cmd = event.getActionCommand().charAt(0);
        switch (cmd) {
            case 'N': {
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = 0;
                }
                this.pushValuesOntoPanel();
                break;
            }
            case 'D': {
                Settings settings = new Settings(true);
                this.pushSettingsOntoPanel(settings);
            }
        }
    }
}

