/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.gui.ReportingTableDDI;
import org.eclipse.aperi.TStorm.gui.ReportingTreeLabel;
import org.eclipse.aperi.TStorm.gui.ReportingTreeNode;
import org.eclipse.aperi.TStorm.gui.UnTabbedReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiSavedReportReq;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiDelete;
import org.eclipse.aperi.gui.GuiRename;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.NameListTreeCellRenderer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class SavedReportNode
extends ReportingTreeNode
implements ActionListener,
GuiRequestor {
    private NameList name;
    private String actionCmd;
    private static final String GENERATE = "G";
    private static final String DELETE = "D";
    private static final String RENAME = "R";
    public JPopupMenu menu = null;

    public SavedReportNode(NameList name) {
        this.name = name;
        this.setUserObject(name);
        this.setAllowsChildren(false);
    }

    public void select(TreeSelectionEvent ignored) {
        this.generateReport();
    }

    public JPopupMenu getPopupMenuForButtons() {
        this.showPopupMenu(null);
        return this.menu;
    }

    public void showPopupMenu(MouseEvent event) {
        this.menu = this.getPopupMenu();
        this.addMenuItem(this.menu, "STG5053L", GENERATE, true, "REGENERATE_REPORT");
        this.addMenuItem(this.menu, "GUI0106L", DELETE, this.name.nlID > 299, null);
        this.addMenuItem(this.menu, "GUI0047L", RENAME, this.name.nlID > 299, null);
        if (event != null) {
            this.showPopupMenu(this.menu, event);
        }
    }

    private void addMenuItem(JPopupMenu menu, String msgID, String cmd, boolean enabled, String resourceID) {
        String s = resourceID == null ? MessageLog.getMessageNoID(msgID) : Util.getString(resourceID);
        JMenuItem item = new JMenuItem(s);
        item.setActionCommand(cmd);
        item.addActionListener(this);
        item.setEnabled(enabled);
        item.setName(s);
        menu.add(item);
    }

    public void render(DefaultTreeCellRenderer renderer, BaseTree tree, boolean selected, boolean expanded, boolean isLeaf, int row, boolean hasFocus) {
        renderer.setIcon(NameListTreeCellRenderer.iconForObject(this.name));
        renderer.setFont(BaseTree.plainFont);
    }

    public void actionPerformed(ActionEvent event) {
        this.actionCmd = event.getActionCommand();
        if (this.actionCmd == GENERATE) {
            this.generateReport();
        } else if (this.actionCmd == DELETE) {
            if (!GuiUtil.confirmDelete(BaseTree.pBaseTree, this.getDescription())) {
                return;
            }
            new GuiDelete().delete(this.name);
        } else if (this.actionCmd == RENAME) {
            StringBuffer nameBuf = new StringBuffer(65);
            nameBuf.append(GuiUtil.getUserName());
            nameBuf.append('.');
            nameBuf.append(this.name.nlName);
            NameList qualifiedName = (NameList)this.name.clone();
            qualifiedName.nlName = nameBuf.toString();
            new GuiRename(qualifiedName, this.getDescription()).rename();
        }
    }

    private String getDescription() {
        return MessageLog.getMessageNoID("STG4154L", this.name.nlName);
    }

    private void generateReport() {
        GuiSavedReportReq gsr = new GuiSavedReportReq();
        gsr.ID = this.name.nlID;
        gsr.enabled = true;
        SavedReportNode.doRequest(this, gsr);
    }

    public static void doRequest(GuiRequestor requestor, GuiSavedReportReq gsr) {
        Request r = new Request();
        r.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
        r.serviceName = RequestTypeManager.getInternalName(r.typeCode);
        r.subType = "org.eclipse.aperi.server.handler.gui.SavedReportHndlr";
        r.userName = GuiUtil.getUserName();
        r.flags = (byte)4;
        r.requestData = gsr;
        GuiClient.doRequest(requestor, r);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4 || response.responseData == null) {
            return;
        }
        GuiSavedReportReq gsr = (GuiSavedReportReq)response.responseData;
        this.selectionServices = ReportingTreeLabel.selectionServiceArray[gsr.grr.reportType];
        this.productCode = gsr.productCode;
        if (this.selectionServices == -1) {
            new ReportingTableDDI(gsr, (BaseTreeNode)this);
        } else if (this.selectionServices == -2) {
            new UnTabbedReportingDDI(gsr, (BaseTreeNode)this).reDisplay();
        } else {
            new ReportingDDI(gsr, (BaseTreeNode)this).reDisplay();
        }
    }
}

