/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.io.Serializable;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.aperi.TStorm.common.GroupDefinition;
import org.eclipse.aperi.TStorm.gui.FSSelector;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.TreeSelector;
import org.eclipse.aperi.gui.TreeSelectorNode;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class SubsystemArrayGroupSelector
implements TreeExpansionListener,
GuiRequestor {
    private TreeSelector selector;
    private JTree selectedTree;
    private JTree sourceTree;
    private NameList memberSelections;
    private NameList groupSelections;
    private NameList fabricSelections;
    private NameList rootName;
    private short memberType;
    private short groupType;
    private TreeSet memberSet = new TreeSet();
    private TreeSet excludeSet = new TreeSet();
    private JTree expansionTree;
    private String groupRootLabel;
    private String memberRootLabel;
    private String allMembersLabel;
    private String fabricRootLabel;
    private TreeSelectorNode sourceGroupLabel;
    private TreeSelectorNode sourceClusterLabel;
    private TreeSelectorNode sourceFabricLabel;
    private TreeSelectorNode expansionNode;
    private DefaultTreeModel expansionModel;
    public boolean allMembersSelected;
    private boolean groupExpanding = false;
    private boolean fabricExpanding = false;
    private static final int ROOT_ID = -5;
    private static final int GROUP_ID = -4;
    private static final int MEMBER_ID = -3;
    private static final int FABRIC_ID = -2;
    private static final int ALL_MEMBER_ID = Integer.MAX_VALUE;

    public SubsystemArrayGroupSelector(short pMemberType, NameList pMemberSelections, NameList pGroupSelections, NameList pFabricSelections, boolean pAllMembersSelected) {
        this.memberType = pMemberType;
        this.memberSelections = pMemberSelections;
        this.groupSelections = pGroupSelections;
        this.fabricSelections = pFabricSelections;
        this.allMembersSelected = pAllMembersSelected;
        this.groupType = (short)77;
        this.memberRootLabel = "STG4191L";
        this.groupRootLabel = "STG5500L";
        this.allMembersLabel = "STG5501L";
        this.fabricRootLabel = "FabricAlert_FabricTabTitle";
    }

    public JPanel getComponent() {
        if (this.selector != null) {
            return this.selector;
        }
        this.buildSourceTree();
        this.buildSelectedTree();
        this.selector = new TreeSelector(this.sourceTree, this.selectedTree);
        return this.selector;
    }

    public NameList[] getData() {
        NameList prevMember = null;
        NameList prevGroup = null;
        NameList prevFabric = null;
        NameList[] returnLists = new NameList[]{null, null, null};
        this.allMembersSelected = false;
        NameList selectedList = this.selector.getNameList();
        while (selectedList != null) {
            NameList cloan = (NameList)selectedList.clone();
            cloan.nlNext = null;
            if (cloan.nlInfo == this.groupType) {
                if (prevGroup == null) {
                    returnLists[1] = cloan;
                } else {
                    prevGroup.nlNext = cloan;
                }
                prevGroup = cloan;
            } else if (cloan.nlInfo == 13) {
                this.allMembersSelected = true;
            } else if (cloan.nlInfo == 114) {
                if (prevFabric == null) {
                    returnLists[2] = cloan;
                } else {
                    prevFabric.nlNext = cloan;
                }
                prevFabric = cloan;
            } else {
                if (prevMember == null) {
                    returnLists[0] = cloan;
                } else {
                    prevMember.nlNext = cloan;
                }
                prevMember = cloan;
            }
            selectedList = selectedList.nlNext;
        }
        return returnLists;
    }

    private void buildSourceTree() {
        TreeSelectorNode root = this.newRoot();
        this.sourceGroupLabel = this.addGroupLabel(root);
        this.sourceFabricLabel = this.addFabricLabel(root);
        this.addMemberLabel(root);
        this.sourceTree = new JTree(root, true);
        this.sourceTree.addTreeExpansionListener(this);
    }

    private TreeSelectorNode buildSelectedTreeStructure() {
        TreeSelectorNode groupLabel = null;
        TreeSelectorNode memberLabel = null;
        TreeSelectorNode excludeLabel = null;
        TreeSelectorNode fabricLabel = null;
        TreeSelectorNode root = this.newRoot();
        NameList name = this.fabricSelections;
        while (name != null) {
            if (fabricLabel == null) {
                fabricLabel = this.addFabricLabel(root);
            }
            fabricLabel.add(new TreeSelectorNode(name, true, false, true, true, null, false, false));
            name = name.nlNext;
        }
        name = this.groupSelections;
        while (name != null) {
            if (groupLabel == null) {
                groupLabel = this.addGroupLabel(root);
            }
            groupLabel.add(new TreeSelectorNode(name, true, false, true, true, null, false, false));
            name = name.nlNext;
        }
        this.fillSets(this.memberSelections, true, false);
        if (this.allMembersSelected || !this.memberSet.isEmpty()) {
            memberLabel = this.addMemberLabel(root);
            if (this.allMembersSelected) {
                this.addAllMembersNode(memberLabel, true);
            }
            this.addTreeSet(memberLabel, this.memberSet);
        }
        if (!this.excludeSet.isEmpty()) {
            excludeLabel = TreeSelector.makeExcludeRoot();
            root.add(excludeLabel);
            this.addTreeSet(excludeLabel, this.excludeSet);
        }
        return root;
    }

    private void buildSelectedTree() {
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        this.selectedTree = new JTree(root, true);
        this.selectedTree.addTreeExpansionListener(this);
    }

    public void replace(NameList pMemberSelections, NameList pGroupSelections, NameList pFabricSelections, boolean pAllMembersSelected) {
        this.memberSelections = pMemberSelections;
        this.groupSelections = pGroupSelections;
        this.fabricSelections = pFabricSelections;
        this.allMembersSelected = pAllMembersSelected;
        this.memberSet.clear();
        this.excludeSet.clear();
        TreeSelectorNode root = this.buildSelectedTreeStructure();
        DefaultTreeModel model = new DefaultTreeModel(root, true);
        this.selectedTree.setModel(model);
        this.selector.setUpExcludes();
    }

    private void fillSets(NameList memberList, boolean memberSelectable, boolean memberExcludeable) {
        TreeSelectorNode member = null;
        while (memberList != null) {
            boolean excludeable;
            boolean selectable;
            TreeSet set;
            if ((memberList.nlState & 1) != 0) {
                set = this.excludeSet;
                selectable = false;
                excludeable = true;
            } else {
                set = this.memberSet;
                selectable = memberSelectable;
                excludeable = memberExcludeable;
            }
            member = new TreeSelectorNode(memberList, selectable, excludeable, false, false, null, false, false);
            if (this.groupExpanding) {
                member.setButtonFlag(false);
            }
            set.add(member);
            memberList = memberList.nlNext;
        }
    }

    private void addTreeSet(TreeSelectorNode parent, TreeSet set) {
        for (TreeSelectorNode child : set) {
            parent.add(child);
        }
    }

    public void invalidateGroups(short groupType) {
        FSSelector.invalidateGroups(this.selector, this.selectedTree, groupType);
    }

    public void addGroup(NameList name) {
        if (!this.sourceGroupLabel.childrenFetched) {
            return;
        }
        NameList toAdd = (NameList)name.clone();
        TreeSelectorNode newNode = new TreeSelectorNode(toAdd, true, false, true, true, null);
        DefaultTreeModel model = (DefaultTreeModel)this.sourceTree.getModel();
        this.selector.addChild(model, this.sourceGroupLabel, newNode);
    }

    public void treeExpanded(TreeExpansionEvent e) {
        TreePath path = e.getPath();
        this.expansionNode = (TreeSelectorNode)path.getLastPathComponent();
        this.fabricExpanding = false;
        this.groupExpanding = false;
        if (this.expansionNode.childrenFetched) {
            return;
        }
        NameList name = this.expansionNode.getNameList();
        this.expansionTree = (JTree)e.getSource();
        this.expansionModel = (DefaultTreeModel)this.expansionTree.getModel();
        if (this.expansionTree == this.sourceTree) {
            if (name.nlID == -4) {
                this.sendRequest(this.groupType, -1);
            } else if (name.nlID == -3) {
                this.sendRequest(this.memberType, -1);
            } else if (name.nlID == -2) {
                this.sendRequest((short)114, -1);
            }
        } else if (name.nlInfo == this.groupType) {
            this.sendRequest(this.memberType, name.nlID);
            this.groupExpanding = true;
        } else if (name.nlInfo == 114) {
            this.fabricExpanding = true;
            this.sendRequest(name.nlInfo, name.nlID);
        } else if (name.nlInfo == 13) {
            this.sendRequest(this.memberType, -1);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
    }

    protected GuiListReq makeListRequestData(short resourceType, int groupID) {
        GuiListReq requestData = new GuiListReq();
        requestData.listRequested = 10000 + resourceType;
        requestData.groupID = groupID;
        requestData.excludeNAS = false;
        requestData.excludeVS = false;
        requestData.getVersions = false;
        requestData.excludeVS = false;
        return requestData;
    }

    protected GroupDefinition makeGroupRequestData(short resourceType, int groupID) {
        GroupDefinition requestData = new GroupDefinition();
        requestData.groupType = resourceType;
        requestData.ID = groupID;
        return requestData;
    }

    private void sendRequest(short resourceType, int groupID) {
        Request request;
        if (resourceType == 99) {
            GroupDefinition lData = this.makeGroupRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GroupDefHndlr.Definition", lData);
        } else {
            GuiListReq gData = this.makeListRequestData(resourceType, groupID);
            request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", gData);
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short status, Response response) {
        if (status > 4) {
            return;
        }
        Serializable obj = response.responseData;
        NameList nameList = null;
        if (obj instanceof GroupDefinition) {
            GroupDefinition gdef = (GroupDefinition)response.responseData;
            nameList = gdef.members;
        } else {
            nameList = (NameList)response.responseData;
        }
        if (nameList == null) {
            return;
        }
        this.expansionNode.childrenFetched = true;
        this.expansionNode.removeAllChildren();
        if (nameList.nlInfo == this.groupType) {
            while (nameList != null) {
                TreeSelectorNode group = new TreeSelectorNode(nameList, true, false, false, true, null, false, false);
                this.expansionNode.add(group);
                nameList = nameList.nlNext;
            }
        } else {
            boolean exclude;
            boolean select = this.expansionTree == this.sourceTree;
            boolean bl = exclude = !select;
            if (select) {
                this.addAllMembersNode(this.expansionNode, false);
            }
            this.memberSet.clear();
            this.fillSets(nameList, select, exclude);
            this.addTreeSet(this.expansionNode, this.memberSet);
        }
        this.expansionModel.nodeStructureChanged(this.expansionNode);
        if (this.expansionTree == this.selectedTree) {
            this.selector.pruneExcluded(this.expansionNode);
        } else {
            this.selector.pruneSelected(this.expansionNode, this.expansionNode.hiOrderSortKey);
        }
    }

    private TreeSelectorNode newRoot() {
        if (this.rootName == null) {
            this.rootName = this.newNameList("", -5, -1);
        }
        return new TreeSelectorNode(this.rootName, false, false, true);
    }

    private TreeSelectorNode addGroupLabel(TreeSelectorNode root) {
        return this.addLabelNode(this.groupRootLabel, -4, root);
    }

    private TreeSelectorNode addMemberLabel(TreeSelectorNode root) {
        return this.addLabelNode(this.memberRootLabel, -3, root);
    }

    private TreeSelectorNode addFabricLabel(TreeSelectorNode root) {
        return this.addLabelNode(this.fabricRootLabel, -2, root);
    }

    private TreeSelectorNode addLabelNode(String labelMsgID, int id, TreeSelectorNode root) {
        String label = Util.getString(labelMsgID);
        NameList name = this.newNameList(label, id, -1);
        TreeSelectorNode labelNode = new TreeSelectorNode(name, false, false, true);
        labelNode.setButtonFlag(false);
        labelNode.setSortKey(id);
        root.add(labelNode);
        return labelNode;
    }

    private void addAllMembersNode(TreeSelectorNode root, boolean expandable) {
        String label = MessageLog.getMessageNoID(this.allMembersLabel);
        NameList name = this.newNameList(label, Integer.MAX_VALUE, 13);
        TreeSelectorNode node = new TreeSelectorNode(name, true, false, expandable, true, null);
        node.setSortKey(-1);
        root.add(node);
    }

    private void addAllMembersNode(TreeSelectorNode root, boolean expandable, boolean newnls) {
        String label = Util.getString(this.allMembersLabel);
        NameList name = this.newNameList(label, Integer.MAX_VALUE, 13);
        TreeSelectorNode node = new TreeSelectorNode(name, true, false, expandable, true, null);
        node.setSortKey(-1);
        root.add(node);
    }

    private NameList newNameList(String name, int id, int type) {
        NameList nameList = new NameList();
        nameList.nlName = name;
        nameList.nlID = id;
        nameList.nlInfo = (short)type;
        return nameList;
    }
}

