/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.JTabbedPane;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.AlertCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.SwitchAlertEditor;
import org.eclipse.aperi.TStorm.gui.SwitchAlertSelector;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class SwitchAlertCreateOrEdit
extends AlertCreateOrEdit {
    private SwitchAlertSelector switchSelector;
    private static final int ALERT_TAB = 0;
    private static final int SWITCH_TAB = 1;
    private AlertHeader alertHeader = null;
    public Object[] switch_list;
    public Object[] switch_group;

    public SwitchAlertCreateOrEdit(CreateOrEditDDI pDdi) {
        super(pDdi);
    }

    protected void makeTabbedPane(AlertHeader switchAlert) {
        this.alertEditor = switchAlert.alert == null ? new SwitchAlertEditor(this) : new SwitchAlertEditor(this, switchAlert);
        this.switchSelector = switchAlert == null ? new SwitchAlertSelector(121, (SwitchAlertEditor)this.alertEditor) : new SwitchAlertSelector(121, (SwitchAlertEditor)this.alertEditor, switchAlert);
        ((SwitchAlertEditor)this.alertEditor).setCreateHeaderPanel(this.createHeaderPanel);
        ((SwitchAlertEditor)this.alertEditor).setSelector(this.switchSelector);
        this.switchSelector.setAlertEditor((SwitchAlertEditor)this.alertEditor);
        this.tabbedPane = new JTabbedPane();
        String title = MessageLog.getMessageNoID("STG4036L");
        this.tabbedPane.addTab(title, this.alertEditor.getComponent());
        title = Util.getString("FabricAlert_SwitchTabTitle");
        this.tabbedPane.addTab(title, this.switchSelector.getComponent());
        if (((SwitchAlertEditor)this.alertEditor).getConditionValue() == 107) {
            this.tabbedPane.setEnabledAt(1, false);
        }
    }

    public CreateHeader getData() {
        AlertHeader swAlertHeader = (AlertHeader)super.getData();
        NameList[] switchLists = this.switchSelector.getData();
        swAlertHeader.alertElements = switchLists[0];
        swAlertHeader.alertGroups = switchLists[1];
        swAlertHeader.allObjects = this.switchSelector.allMembersSelected;
        return swAlertHeader;
    }

    public void replace(CreateHeader newHeader) {
        super.replace(newHeader);
        AlertHeader swAlert = (AlertHeader)newHeader;
        this.switchSelector.replace(swAlert.alertElements, swAlert.alertGroups, swAlert.allObjects);
    }

    public void changeOccurred(int changeType, NameList name) {
        if (changeType == 100) {
            this.switchSelector.invalidateGroups(name.nlInfo);
        }
        if (changeType != 1) {
            return;
        }
        if (name.nlInfo == 120) {
            this.switchSelector.addGroup(name);
        }
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return FabricGuiUtil.FHELP_ALERT_SWITCH;
            }
            case 1: {
                return FabricGuiUtil.FHELP_ALERT_SELECT;
            }
        }
        return null;
    }
}

