/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import javax.swing.JTabbedPane;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.gui.AlertCreateOrEdit;
import org.eclipse.aperi.TStorm.gui.TapeLibraryAlertEditor;
import org.eclipse.aperi.TStorm.gui.TapeLibraryGroupSelector;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.xmsg.MessageLog;

public class TapeLibraryAlertCreateOrEdit
extends AlertCreateOrEdit {
    private TapeLibraryGroupSelector tapeLibrarySelector;
    private static final int ALERT_TAB = 0;
    private static final int TAPE_LIBRARY_TAB = 1;

    public TapeLibraryAlertCreateOrEdit(CreateOrEditDDI pDdi) {
        super(pDdi);
    }

    protected void makeTabbedPane(AlertHeader compAlert) {
        this.tapeLibrarySelector = new TapeLibraryGroupSelector(compAlert.alertElements, compAlert.alertElements2, compAlert.alertElements3, compAlert.allObjects, compAlert.allElements1, compAlert.allElements2);
        this.alertEditor = compAlert.alert == null ? new TapeLibraryAlertEditor() : new TapeLibraryAlertEditor(compAlert.alert);
        this.tabbedPane = new JTabbedPane();
        String title = MessageLog.getMessageNoID("STG4036L");
        this.tabbedPane.addTab(title, this.alertEditor.getComponent());
        title = Util.getString("TapeLibraryAlert_TapeLibraryTabTitle");
        this.tabbedPane.addTab(title, this.tapeLibrarySelector.getComponent());
    }

    public CreateHeader getData() {
        AlertHeader compAlert = (AlertHeader)super.getData();
        NameList[] compLists = this.tapeLibrarySelector.getData();
        compAlert.alertElements = compLists[0];
        compAlert.alertGroups = compLists[1];
        compAlert.alertClusters = compLists[2];
        compAlert.allObjects = this.tapeLibrarySelector.allTapeLibrarySelected;
        compAlert.allElements1 = this.tapeLibrarySelector.allZonesSelected;
        compAlert.allElements2 = this.tapeLibrarySelector.allZoneSetsSelected;
        return compAlert;
    }

    public void replace(CreateHeader newHeader) {
        super.replace(newHeader);
        AlertHeader compAlert = (AlertHeader)newHeader;
        this.tapeLibrarySelector.replace(compAlert.alertElements, compAlert.alertElements2, compAlert.alertElements3, compAlert.allObjects, compAlert.allElements1, compAlert.allElements2);
    }

    public void changeOccurred(int changeType, NameList name) {
        if (changeType == 100) {
            this.tapeLibrarySelector.invalidateGroups(name.nlInfo);
        }
        if (changeType != 1) {
            return;
        }
        if (name.nlInfo == 0) {
            this.tapeLibrarySelector.addGroup(name);
        }
    }

    public String getHelpID(int tab) {
        switch (tab) {
            case 0: {
                return "alcom5";
            }
            case 1: {
                return "alcom10";
            }
        }
        return null;
    }
}

